/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience;

import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.iqtextparser.NodeParser;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNodeUtil;
import com.sas.iquery.metadata.expr.iqtextparser.ParserUtil;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.physical.AccessPathToRelationalData;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.OMAResourceFactory;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryFactory;
import com.sas.iquery.metadata.physical.inmemory.InMemoryQueryTable;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.metadata.physical.oma.OMASASWorkspaceServer;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleTableQuery {
    private static final Logger _logger = LogManager.getLogger(SimpleTableQuery.class);
    private static final String RESOLUTION_TEMPLATE_WITH_TABLES = "<XMLSelect search=\"ServerContext[@Name='{SERVER_NAME}']\"/> <Templates>   <ServerContext ClassIdentifier=\"\" ><DataPackages search=\"@Name='{CLIENT_SASLIBRARY_NAMES}'\"/><UsingComponents search=\"@ClassIdentifier='440196d4-90f0-11d0-9f41-00a024bb830c' OR @ClassIdentifier='620963ee-32bf-4128-bf5f-4b0df8ff90eb'\"/></ServerContext>   <SASLibrary><Tables search=\"@Name='{TABLE_NAMES}'\"/><UsingPackages/></SASLibrary>   <DatabaseSchema><Tables search=\"@Name='{TABLE_NAMES}'\"/></DatabaseSchema>   <PhysicalTable><Columns/><PropertySets/></PhysicalTable>   <Column/></Templates>";
    static final Properties p = null;
    private final String originalInterval = System.getProperty("SASQueryServices.sasSubmitInterval");
    private final DataSelection _ds;
    private final AccessPathInfo _path;
    private Map<String, Column> _colMap = new LinkedHashMap<String, Column>();
    private Map<Column, DataItem> _diMap = new IdentityHashMap<Column, DataItem>();
    private Map<String, FilterItem> _fiMap = new LinkedHashMap<String, FilterItem>();
    QueryConnector _queryConnector = null;

    public SimpleTableQuery(@Nonnull SessionContextInterface session, @Nonnull String serverName, @Nonnull String libname, @Nonnull String tableName) throws Exception {
        this._path = new AccessPathInfo();
        this._path.wsServerName = serverName;
        this._path.schemaName = libname;
        this._path.tableName = tableName;
        IntelligentQueryMetadataServiceInterface iqService = IntelligentQueryMetadataServiceFactory.newService();
        Locale defaultComputationalLocale = LocaleUtilities.getDefaultComputationalLocale(session);
        this._ds = DataSelectionFactory.newDataSelection(session, iqService, defaultComputationalLocale);
        RetrievalPolicy policy = new RetrievalPolicy();
        policy.getConnectionConfiguration().setConnectionLifetime(1);
        policy.setPolicyValue(1);
        this._queryConnector = new QueryConnector();
        this._queryConnector.setRetrievalPolicy(policy);
        this._queryConnector.setComputationalLocale(defaultComputationalLocale);
        this.initializeDataSelection(serverName, libname, tableName, session, this._queryConnector);
        System.setProperty("SASQueryServices.sasSubmitInterval", "10");
    }

    public double tableN(@Nonnull String whereClause, @Nonnull String returnColumnName, int position) throws Exception {
        try {
            this.updateQuery(Arrays.asList(returnColumnName), whereClause);
            return this.retrieveNumericResult(position);
        }
        catch (Exception e) {
            _logger.error("An exception was thrown trying to get the numeric value for the column \"" + returnColumnName + "\" and filter \"" + whereClause + "\"", (Throwable)e);
            throw e;
        }
    }

    public String tableC(@Nonnull String whereClause, @Nonnull String returnColumnName, int position) throws Exception {
        try {
            this.updateQuery(Arrays.asList(returnColumnName), whereClause);
            return this.retrieveStringResult(position);
        }
        catch (Exception e) {
            _logger.error("An exception was thrown trying to get the character value for the column \"" + returnColumnName + "\" and filter \"" + whereClause + "\"", (Throwable)e);
            throw e;
        }
    }

    public ResultSet tableMap(@Nonnull String whereClause, @Nonnull List<String> returnColumnName) throws Exception {
        ResultSetInterface rsi = null;
        try {
            this.updateQuery(returnColumnName, whereClause);
            rsi = this.retrieveResultSet();
            return (ResultSet)rsi.getResultSet();
        }
        catch (Exception e) {
            if (rsi != null) {
                this._queryConnector.closeResult(rsi);
            }
            _logger.error("An exception was thrown trying to get values for the columns \"" + Arrays.toString(returnColumnName.toArray()) + "\" and filter \"" + whereClause + "\"", (Throwable)e);
            throw e;
        }
    }

    private double retrieveNumericResult(int position) throws Exception {
        double returnValue = Double.NaN;
        ResultSetInterface resultSet = null;
        try {
            resultSet = this._queryConnector.retrieveQueryResult(this._ds);
            ResultSet rs = (ResultSet)resultSet.getResultSet();
            boolean hasData = false;
            if (rs.next()) {
                returnValue = rs.getDouble(1);
                if (rs.wasNull()) {
                    returnValue = Double.NaN;
                }
                hasData = true;
            }
            if (position != 1 && hasData) {
                while (rs.next()) {
                    returnValue = rs.getDouble(1);
                    if (!rs.wasNull()) continue;
                    returnValue = Double.NaN;
                }
            }
        }
        catch (Exception e) {
            String iqQuery = this._queryConnector.getPhysicalQuery(this._ds);
            _logger.error("Qn exception was thrown trying to process query \"" + iqQuery + "\"", (Throwable)e);
            throw e;
        }
        finally {
            if (resultSet != null) {
                this._queryConnector.closeResult(resultSet);
            }
        }
        return returnValue;
    }

    private String retrieveStringResult(int position) throws Exception {
        String returnValue = "";
        ResultSetInterface resultSet = null;
        try {
            resultSet = this._queryConnector.retrieveQueryResult(this._ds);
            ResultSet rs = (ResultSet)resultSet.getResultSet();
            boolean hasData = false;
            if (rs.next()) {
                returnValue = rs.getString(1);
                if (rs.wasNull()) {
                    returnValue = "";
                }
                hasData = true;
            }
            if (position != 1 && hasData) {
                while (rs.next()) {
                    returnValue = rs.getString(1);
                    if (!rs.wasNull()) continue;
                    returnValue = "";
                }
            }
        }
        catch (Exception e) {
            String iqQuery = this._queryConnector.getPhysicalQuery(this._ds);
            _logger.error("Qn exception was thrown trying to process query \"" + iqQuery + "\"", (Throwable)e);
            throw e;
        }
        finally {
            if (resultSet != null) {
                this._queryConnector.closeResult(resultSet);
            }
        }
        return returnValue;
    }

    private ResultSetInterface retrieveResultSet() throws Exception {
        try {
            return this._queryConnector.retrieveQueryResult(this._ds);
        }
        catch (DataRetrievalException e) {
            String iqQuery = this._queryConnector.getPhysicalQuery(this._ds);
            _logger.error("Qn exception was thrown trying to process query \"" + iqQuery + "\"", (Throwable)e);
            throw e;
        }
    }

    private AccessPathInfo getWorkspaceServerAndLibsByName(String outputServerName, String libname, String tableName, SessionContextInterface session, MetadataServerInterface metadataServer) throws MetadataException, RemoteException, ServiceException, MdException {
        Root objServer;
        List<Root> serverLibTable = this.runQueriesToGetOmrObjects(outputServerName, libname, tableName, metadataServer);
        if (serverLibTable.size() >= 1 && (objServer = serverLibTable.get(0)) instanceof ServerContext) {
            ServerContext context = (ServerContext)objServer;
            this._path.workspaceServer = (OMASASWorkspaceServer)OMAResourceFactory.getOMAServerObject(context, session, metadataServer, true);
            List<com.sas.metadata.remote.SASLibrary> omrLibraries = AssociationListUtil.filteredSnapshot(context.getDataPackages(), com.sas.metadata.remote.SASLibrary.class);
            if (!omrLibraries.isEmpty()) {
                com.sas.metadata.remote.SASLibrary jomaLibrary = omrLibraries.get(0);
                this._path.schema = (SASLibrary)((Object)OMAResourceFactory.getReposObject((CMetadata)jomaLibrary, session, metadataServer));
                List<PhysicalTable> tables = AssociationListUtil.filteredSnapshot(jomaLibrary.getTables(), PhysicalTable.class);
                for (PhysicalTable pt : tables) {
                    if (!tableName.equalsIgnoreCase(pt.getName())) continue;
                    this._path.table = (Table)((Object)OMAResourceFactory.getReposObject((CMetadata)pt, session, metadataServer));
                    break;
                }
            }
        }
        return this._path;
    }

    private List<Root> runQueriesToGetOmrObjects(String outputServerName, String libname, String tableName, MetadataServerInterface metadataServer) throws RemoteException, ServiceException {
        String outTemplate = RESOLUTION_TEMPLATE_WITH_TABLES;
        outTemplate = outTemplate.replaceFirst("\\{SERVER_NAME\\}", outputServerName);
        outTemplate = outTemplate.replaceFirst("\\{CLIENT_SASLIBRARY_NAMES\\}", libname);
        outTemplate = outTemplate.replaceAll("\\{TABLE_NAMES\\}", tableName);
        int omrFlags = 8580;
        Filter filter = new Filter();
        filter.setOMRFlags(omrFlags);
        filter.setOMRTemplate(outTemplate);
        filter.setType("Root");
        filter.setFilterComponent(null);
        List smartObjects = metadataServer.search((FilterInterface)filter);
        return this.unwrapOMRSmartObjects(smartObjects);
    }

    private List<Root> unwrapOMRSmartObjects(List<MetadataInterface> smartObjects) throws RemoteException {
        ArrayList<Root> outList = new ArrayList<Root>();
        if (smartObjects != null) {
            for (MetadataInterface smartObject : smartObjects) {
                Object reposEntity = smartObject.getRepositoryEntity();
                if (!(reposEntity instanceof Root)) continue;
                outList.add((Root)reposEntity);
            }
        }
        return outList;
    }

    private void initializeDataSelection(@Nonnull String serverName, @Nonnull String libname, @Nonnull String tableName, @Nonnull SessionContextInterface session, QueryConnector queryConnector) throws Exception {
        UserContextInterface user = session.getUserContext();
        ServerInterface server = user.getAuthServer();
        if (!(server instanceof MetadataServerInterface)) {
            throw new MetadataException("The authentication server is not a SAS Metadata Server");
        }
        AccessPathInfo path = this.getWorkspaceServerAndLibsByName(serverName, libname, tableName, session, (MetadataServerInterface)server);
        SASLibrary library = path.schema;
        SASWorkspaceServer outputWorkspaceServer = path.workspaceServer;
        Table outTable = path.table;
        Schema outSchema = library;
        if (library == null) {
            InMemorySASLibrary inMemorySASLibrary = InMemoryFactory.getInstance().newPreassignedLibrary(libname, null, null, null, session, this._ds.getMetadataService(), outputWorkspaceServer);
            library = inMemorySASLibrary;
            outSchema = inMemorySASLibrary;
        }
        if (outTable == null) {
            String queryText = "select * from " + libname + "." + tableName;
            InMemoryQueryTable queryTable = InMemoryFactory.getInstance().newSimpleQueryTable(tableName, this._ds, queryText, Collections.singletonList(library), outputWorkspaceServer);
            queryTable.setQueryConnector(queryConnector);
            queryTable.prepare();
            outTable = queryTable;
            outSchema = queryTable.getSchema();
        }
        DataSourceTable newDataSource = this._ds.newDataSourceTable(new AccessPathToRelationalData(outputWorkspaceServer, outSchema), outTable);
        this._ds.addDataSource(newDataSource);
        newDataSource.setIntraModelID(path.wsServerName + "_" + path.schemaName + "_" + path.tableName);
        List<Column> columns1 = newDataSource.getColumns();
        this._colMap = new LinkedHashMap<String, Column>();
        for (Column column : columns1) {
            this._colMap.put(column.getSasName().toLowerCase(), column);
        }
        Governing outObs = this._ds.newGoverning();
        outObs.setOutputObservations(1);
        this._ds.addBusinessRule(outObs);
    }

    private void updateQuery(List<String> returnColumnName, String whereClause) throws MetadataException {
        ArrayList<SelectedItem> selectedItems = new ArrayList<SelectedItem>();
        for (String cName : returnColumnName) {
            Column outputColumn = this._colMap.get(cName.toLowerCase());
            if (outputColumn != null) {
                DataItem di = this._diMap.get(outputColumn);
                if (di == null) {
                    di = ((AbstractBusinessModel)((Object)this._ds)).newDataItem(outputColumn, p);
                    di.setSortDirection(DataItemActionType.SORT_DESCENDING);
                    di.setUsage(DataItemActionType.USAGE_DETAIL);
                    this._ds.addBusinessItem(di);
                    this._diMap.put(outputColumn, di);
                }
                selectedItems.add(new SelectedItem(di, Role.COLUMN));
                continue;
            }
            String m = "Could not find the output column named '" + returnColumnName + "' in the list of data columns " + this._colMap.keySet() + " on table \"" + this._path.tableName + "\"";
            if (returnColumnName.size() == 1) {
                throw new MetadataException(m);
            }
            _logger.info(m);
        }
        this._ds.setSelectedItems(selectedItems);
        FilterItem filter = this._fiMap.get(whereClause);
        if (filter == null) {
            NodeParser parser = ParserUtil.newParser();
            ParsedNode exprnode = parser.parsePredicate(whereClause, false, false, false, false);
            ParsedNode[] nodes = new ParsedNode[]{exprnode};
            DataSourceTable dsTable = (DataSourceTable)this._ds.getDataSourceByID(this._path.wsServerName + "_" + this._path.schemaName + "_" + this._path.tableName);
            ParsedNodeUtil.replaceResources(nodes, this._ds.getBusinessModel(), dsTable, parser);
            ParsedNode newNode = nodes[0];
            ExpressionInterface expr = ParserUtil.newExpressionInterface(newNode, this._ds, ResourceScope.PHYSICAL_SCOPE);
            filter = this._ds.newFilterItem();
            ConditionalExpressionAdapter expAdapter = new ConditionalExpressionAdapter();
            expAdapter.setExpression(expr);
            filter.setExpression(expAdapter);
            this._ds.addBusinessItem(filter);
            this._fiMap.put(whereClause, filter);
        }
        this._ds.setFilters(Collections.singletonList(filter));
    }

    public void dispose() throws Exception {
        this._colMap.clear();
        this._diMap.clear();
        this._fiMap.clear();
        if (this._queryConnector != null) {
            this._queryConnector.close(this._ds.getSession());
        }
        this._ds.dispose();
        if (this.originalInterval != null) {
            System.setProperty("SASQueryServices.sasSubmitInterval", this.originalInterval);
        } else {
            System.clearProperty("SASQueryServices.sasSubmitInterval");
        }
    }

    static {
        Properties p = new Properties();
        p.put("INIT_CAP", "0");
        p.put("REPLACE_UNDERSCORES", "0");
        p.put("USE_LABELS", "0");
    }

    private class AccessPathInfo {
        public String wsServerName = null;
        public String schemaName = null;
        public String tableName = null;
        public SASWorkspaceServer workspaceServer = null;
        public SASLibrary schema = null;
        public Table table = null;

        private AccessPathInfo() {
        }
    }
}

