/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.QueryConnectorInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.convenience.ElasticItem;
import com.sas.iquery.dataretrieval.convenience.GroupedFilterDataProvider;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalSASFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.SessionContextInterface;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class RelationalGroupedFilterDataProviderImpl
implements GroupedFilterDataProvider {
    BusinessGroup _thisGroup = null;
    DataSelection _dataSelection = null;
    List<ElasticItem> _elasticItems = new ArrayList<ElasticItem>();
    List<ElasticItem> _resultSetElasticItems = new ArrayList<ElasticItem>();
    RetrievalPolicy _retrievalPolicy = new RetrievalPolicy();
    Map<FilterItem, ElasticItem> _filterMap = new LinkedHashMap<FilterItem, ElasticItem>();
    boolean _fullValueSet = true;
    private static final Logger _logger = LogManager.getLogger(RelationalGroupedFilterDataProviderImpl.class);

    public RelationalGroupedFilterDataProviderImpl(DataSelection ds, BusinessGroup group) throws MetadataException, IntelligentQueryException, ExecutionException, SQLException {
        if (group.getType() != BusinessGroup.Type.ELASTIC_FILTER) {
            MessageFormatter e = null;
            throw new MetadataException(e);
        }
        this._thisGroup = group;
        this._dataSelection = ds;
        this._retrievalPolicy.setPolicyValue(0);
        List<BusinessModelObject> groupItems = group.getItems();
        for (BusinessModelObject groupItem : groupItems) {
            FilterItem filterItem = (FilterItem)groupItem;
            ElasticItem elasticItem = new ElasticItem(filterItem);
            this._elasticItems.add(elasticItem);
            this._filterMap.put(filterItem, elasticItem);
        }
        this.buildQueryAll();
        for (ElasticItem elasticItem : this._elasticItems) {
            this.makeIncludedItemsDistinct(elasticItem);
            elasticItem.getOriginalIncludedItems().putAll(elasticItem.getIncludedItems());
        }
        this._fullValueSet = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildQuery(ElasticItem elasticItem, int i) throws MetadataException, IntelligentQueryException, ExecutionException, SQLException {
        DataSelection newDataSelection = (DataSelection)((Object)((ExplicitJoinPathSupport)((Object)DataSelectionFactory.newDataSelection(this._dataSelection))));
        newDataSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        newDataSelection.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        newDataSelection.setID("newDS" + i);
        this.generateSelectedItems(newDataSelection, elasticItem);
        List<FilterItem> filtersToApply = this.applyElasticFilters(newDataSelection, elasticItem);
        filtersToApply.addAll(this._dataSelection.getEffectiveFilters());
        newDataSelection.setFilters(filtersToApply);
        ((ExplicitJoinPathSupport)((Object)newDataSelection)).setExplicitJoinPath(this._dataSelection.getEffectiveJoinPath());
        elasticItem.getQueryList().add(newDataSelection);
        SessionContextInterface session = this._dataSelection.getSession();
        QueryConnectorInterface queryConnector = IQDataServices.newQueryConnector(session, -1, -1);
        Map<String, ResultSetInterface> results = null;
        try {
            results = queryConnector.retrieveQueryResultMap(elasticItem.getQueryList(), this._retrievalPolicy);
            this.populateElasticItemWithResults(results, newDataSelection, elasticItem);
        }
        finally {
            IQDataServices.closeQueryConnector(queryConnector, session, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildQueryAll() throws MetadataException, IntelligentQueryException, ExecutionException, SQLException {
        this._resultSetElasticItems.clear();
        ArrayList<DataSelection> queryList = new ArrayList<DataSelection>();
        DataSelection newDataSelection = (DataSelection)((Object)((ExplicitJoinPathSupport)((Object)DataSelectionFactory.newDataSelection(this._dataSelection))));
        newDataSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        newDataSelection.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        newDataSelection.setID("newDS");
        this.generateSelectedItemsAll(newDataSelection);
        List<FilterItem> filtersToApply = this.applyElasticFilters(newDataSelection);
        filtersToApply.addAll(this._dataSelection.getEffectiveFilters());
        newDataSelection.setFilters(filtersToApply);
        ((ExplicitJoinPathSupport)((Object)newDataSelection)).setExplicitJoinPath(this._dataSelection.getEffectiveJoinPath());
        queryList.add(newDataSelection);
        SessionContextInterface session = this._dataSelection.getSession();
        QueryConnectorInterface queryConnector = IQDataServices.newQueryConnector(session, -1, -1);
        Map<String, ResultSetInterface> results = null;
        try {
            results = queryConnector.retrieveQueryResultMap(queryList, this._retrievalPolicy);
            this.populateAllElasticItemsWithResults(results, newDataSelection);
        }
        finally {
            IQDataServices.closeQueryConnector(queryConnector, session, results);
        }
    }

    private List<FilterItem> applyElasticFilters(DataSelection newDataSelection, ElasticItem thisElasticItem) throws MetadataException {
        ArrayList<FilterItem> elasticFiltersToApply = new ArrayList<FilterItem>();
        if (this._fullValueSet) {
            return elasticFiltersToApply;
        }
        for (ElasticItem elasticItem : this._elasticItems) {
            elasticFiltersToApply.add(elasticItem.getThisFilter());
        }
        return elasticFiltersToApply;
    }

    private List<FilterItem> applyElasticFilters(DataSelection newDataSelection) throws MetadataException {
        ArrayList<FilterItem> elasticFiltersToApply = new ArrayList<FilterItem>();
        if (this._fullValueSet) {
            return elasticFiltersToApply;
        }
        for (ElasticItem elasticItem : this._elasticItems) {
            elasticFiltersToApply.add(elasticItem.getThisFilter());
        }
        return elasticFiltersToApply;
    }

    private void generateSelectedItems(DataSelection newDataSelection, ElasticItem elasticItem) throws MetadataException {
        List<SelectedItem> oldSelectedItems = this._dataSelection.getSelectedItems();
        QualifiedColumn filterColumn = elasticItem.getFilterColumn();
        this.generateNewDataItem(filterColumn, elasticItem.getFilterDataItem(), newDataSelection);
        for (SelectedItem oldSelectedItem : oldSelectedItems) {
            if (oldSelectedItem.getItem().getUsage() == DataItemActionType.USAGE_CATEGORY) continue;
            this.generateNewDataItem(oldSelectedItem.getItem(), newDataSelection);
        }
    }

    private void generateSelectedItemsAll(DataSelection newDataSelection) throws MetadataException {
        List<SelectedItem> originalSelectedItems = this._dataSelection.getSelectedItems();
        ArrayList<DataItem> originalDataItems = new ArrayList<DataItem>();
        for (SelectedItem originalSelectedItem : originalSelectedItems) {
            originalDataItems.add(((DataItemReference)originalSelectedItem.getItem()).getBaseDataItem());
        }
        ArrayList<DataItem> originalDataItemsMinusElastic = new ArrayList<DataItem>();
        originalDataItemsMinusElastic.addAll(originalDataItems);
        for (ElasticItem elasticItem : this._elasticItems) {
            if (elasticItem.isFilterActive()) continue;
            QualifiedColumn filterColumn = elasticItem.getFilterColumn();
            this.generateNewDataItem(filterColumn, elasticItem.getFilterDataItem(), newDataSelection);
            this._resultSetElasticItems.add(elasticItem);
            originalDataItemsMinusElastic.remove(elasticItem._filterDataItem);
        }
        for (DataItem remainingDataItem : originalDataItemsMinusElastic) {
            this.generateNewDataItem(remainingDataItem, newDataSelection);
        }
    }

    private void generateNewDataItem(DataItem oldItem, DataSelection newDataSelection) throws MetadataException {
        RootDataItem newItem = newDataSelection.newDataItem();
        newDataSelection.addBusinessItem(newItem);
        DataItemReference newDir = null;
        newItem.setExpression(oldItem.getExpression());
        newItem.setLabel(oldItem.getLabel());
        if (oldItem.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
            newItem.setAggregationType(oldItem.getAggregationType());
        }
        newItem.setUsage(oldItem.getUsage());
        newItem.setFormat(oldItem.getFormat());
        newDir = newDataSelection.newDataItemReference(newItem);
        newDir.setResultSetID(oldItem.getResultSetID());
        newDataSelection.addBusinessItem(newDir);
        newDataSelection.addResultItem(newDir, Role.HIDDEN);
        SelectedItem selectedItem = new SelectedItem(newDir, Role.HIDDEN);
    }

    private void populateElasticItemWithResults(Map results, DataSelection dataSelection, ElasticItem elasticItem) throws ExecutionException, SQLException {
        ResultSetInterface rs = (ResultSetInterface)results.get(dataSelection.getID());
        int row = 0;
        try {
            ResultSet jrs = (ResultSet)rs.getResultSet();
            ResultSetMetaData md = jrs.getMetaData();
            int columnCount = md.getColumnCount();
            jrs.beforeFirst();
            while (jrs.next()) {
                ++row;
                String string = jrs.getString(1);
                elasticItem.getIncludedItems().put(string, string);
            }
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
    }

    private void populateAllElasticItemsWithResults(Map results, DataSelection dataSelection) throws ExecutionException, SQLException {
        ResultSetInterface rs = (ResultSetInterface)results.get(dataSelection.getID());
        int row = 0;
        try {
            ResultSet jrs = (ResultSet)rs.getResultSet();
            ResultSetMetaData md = jrs.getMetaData();
            int columnCount = md.getColumnCount();
            jrs.beforeFirst();
            while (jrs.next()) {
                ++row;
                for (int count = 1; count <= columnCount; ++count) {
                    String string = jrs.getString(count);
                    this._resultSetElasticItems.get(count - 1).getIncludedItems().put(string, string);
                }
            }
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
    }

    private void processExcludedItems(ElasticItem elasticItem) {
        HashMap<String, String> originalItemsMinusIncluded = new HashMap<String, String>();
        originalItemsMinusIncluded.putAll(elasticItem.getOriginalIncludedItems());
        block0: for (Map.Entry<String, String> e : elasticItem.getIncludedItems().entrySet()) {
            String includedItem = e.getValue();
            for (Map.Entry<String, String> e2 : elasticItem.getOriginalIncludedItems().entrySet()) {
                String originalItem = e2.getValue();
                if (originalItem.trim().compareTo(includedItem.trim()) != 0) continue;
                originalItemsMinusIncluded.remove(originalItem);
                continue block0;
            }
        }
        elasticItem.getExcludedItems().putAll(originalItemsMinusIncluded);
    }

    private void generateNewDataItem(QualifiedColumn qualifiedColumn, DataItem filterDataItem, DataSelection dataSelection) {
        try {
            RootDataItem item = dataSelection.newDataItem();
            item.setExpression(qualifiedColumn);
            item.setUsage(filterDataItem.getUsage());
            dataSelection.addBusinessItem(item);
            DataItemReference dir = dataSelection.newDataItemReference(item);
            dir.setResultSetID(qualifiedColumn.getSasName());
            dataSelection.addBusinessItem(dir);
            dataSelection.addResultItem(dir, Role.COLUMN);
            SelectedItem selectedItem = new SelectedItem(dir, Role.COLUMN);
        }
        catch (MetadataException e) {
            _logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getExcludedValues(FilterItem filterItem) {
        ElasticItem elasticItem = this._filterMap.get(filterItem);
        return elasticItem.getExcludedItems();
    }

    @Override
    public String getFilterLabel(FilterItem filterItem) {
        ElasticItem elasticItem = this._filterMap.get(filterItem);
        return elasticItem.getFilterLabel();
    }

    @Override
    public List<FilterItem> getGroupedFilters(BusinessGroup group) {
        return null;
    }

    public BusinessGroup getGroups(Level level) {
        return null;
    }

    @Override
    public Map<String, String> getIncludedValues(FilterItem filterItem) {
        ElasticItem elasticItem = this._filterMap.get(filterItem);
        return elasticItem.getIncludedItems();
    }

    public List<Level> getLevelsInGroup(BusinessGroup group) {
        return null;
    }

    @Override
    public void refresh(FilterItem filter) throws MetadataException, ExecutionException, IntelligentQueryException, SQLException, GenerationException {
        ElasticItem selectedElasticItem = this._filterMap.get(filter);
        this.processValuesFromActiveFilter(filter, selectedElasticItem);
        ArrayList<ElasticItem> passiveElasticItems = new ArrayList<ElasticItem>();
        passiveElasticItems.addAll(this._elasticItems);
        passiveElasticItems.remove(selectedElasticItem);
        int i = 0;
        for (ElasticItem thisElasticItem : passiveElasticItems) {
            ++i;
            thisElasticItem.getIncludedItems().clear();
            thisElasticItem.getExcludedItems().clear();
            thisElasticItem.getQueryList().clear();
            thisElasticItem.setFilterActive(false);
        }
        this.buildQueryAll();
        for (ElasticItem thisElasticItem : passiveElasticItems) {
            this.makeIncludedItemsDistinct(thisElasticItem);
            this.processExcludedItems(thisElasticItem);
        }
    }

    private void makeIncludedItemsDistinct(ElasticItem thisElasticItem) {
        LinkedHashSet<String> distinctIncludedItems = new LinkedHashSet<String>(thisElasticItem.getIncludedItems().values());
        thisElasticItem.getIncludedItems().clear();
        for (String distinctIncludedItem : distinctIncludedItems) {
            thisElasticItem.getIncludedItems().put(distinctIncludedItem, distinctIncludedItem);
        }
    }

    private void processValuesFromActiveFilter(FilterItem filter, ElasticItem selectedElasticItem) throws GenerationException, MetadataException {
        selectedElasticItem.getIncludedItems().clear();
        selectedElasticItem.getExcludedItems().clear();
        selectedElasticItem.getQueryList().clear();
        selectedElasticItem.setFilterActive(true);
        SQLExpressionAbstract sqlExpression = new RelationalSASFactory().createSQLExpression();
        sqlExpression.setDataSelection(this._dataSelection);
        sqlExpression.setDataSelectionProcessor(new RelationalDataSelectionProcessor(this._dataSelection));
        sqlExpression.setExecuteMacroExpressions(false);
        sqlExpression.setUseAltSyntaxForRelDate(false);
        List<Prompt> pl = filter.getResources(Prompt.class, 0);
        for (Prompt p : pl) {
            if (!ExpressionUtil.returnsSpecialValuesALL(p, this._dataSelection)) {
                List<String> pSelectedValues = sqlExpression.extractString(p, false);
                ArrayList<String> singleQuotedIncludedValues = new ArrayList<String>();
                singleQuotedIncludedValues.addAll(pSelectedValues);
                for (String singleQuotedValue : singleQuotedIncludedValues) {
                    String includedItemWithoutQuotes = singleQuotedValue.substring(1, singleQuotedValue.length() - 1);
                    selectedElasticItem.getIncludedItems().put(includedItemWithoutQuotes, includedItemWithoutQuotes);
                }
                continue;
            }
            selectedElasticItem.getIncludedItems().putAll(selectedElasticItem.getOriginalIncludedItems());
        }
        this.processExcludedItems(selectedElasticItem);
    }

    @Override
    public void reset() throws MetadataException, ExecutionException, IntelligentQueryException, SQLException, GenerationException {
        int i = 0;
        for (ElasticItem thisElasticItem : this._elasticItems) {
            ++i;
            thisElasticItem.getIncludedItems().clear();
            thisElasticItem.getExcludedItems().clear();
            thisElasticItem.getQueryList().clear();
            thisElasticItem.setFilterActive(false);
            thisElasticItem.getOriginalIncludedItems().clear();
        }
        this.buildQueryAll();
        for (ElasticItem elasticItem : this._elasticItems) {
            this.makeIncludedItemsDistinct(elasticItem);
            elasticItem.getOriginalIncludedItems().putAll(elasticItem.getIncludedItems());
        }
    }

    @Override
    public String getCurrentLevelLabel(FilterItem filter) {
        return null;
    }

    public List<String> getLevels(FilterItem filter) {
        return null;
    }

    public void refresh(List<FilterItem> filterList) throws MetadataException, ExecutionException, IntelligentQueryException, SQLException, GenerationException {
    }

    @Override
    public void dispose() {
    }

    @Override
    public List<String> getLevelLabels(FilterItem filter) {
        return null;
    }

    @Override
    public void setCurrentLevel(FilterItem filterItem, String level) {
    }
}

