/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import java.util.LinkedHashMap;
import java.util.Map;

@SASScope
final class FindAllPromptValuesListenersVisitor
implements PromptValuesVisitorInterface {
    private Map<PromptValuesInterface, PromptValueChangeListener[]> promptValuesToVisitorMap = new LinkedHashMap<PromptValuesInterface, PromptValueChangeListener[]>();

    public void accept(PromptValuesInterface promptValues) {
        PromptValueChangeListener[] listeners = promptValues.getPromptValueChangeListeners();
        this.promptValuesToVisitorMap.put(promptValues, listeners);
    }

    public boolean shouldContinue() {
        return true;
    }

    public Map<PromptValuesInterface, PromptValueChangeListener[]> getPromptValuesToListenerMap() {
        return this.promptValuesToVisitorMap;
    }

    public void removeAllListeners() {
        for (Map.Entry<PromptValuesInterface, PromptValueChangeListener[]> entry : this.promptValuesToVisitorMap.entrySet()) {
            PromptValuesInterface promptValues = entry.getKey();
            PromptValueChangeListener[] listeners = entry.getValue();
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                promptValues.removePromptValueChangeListener(listeners[i]);
            }
        }
    }

    public void restoreAllListeners() {
        for (Map.Entry<PromptValuesInterface, PromptValueChangeListener[]> entry : this.promptValuesToVisitorMap.entrySet()) {
            PromptValuesInterface promptValues = entry.getKey();
            PromptValueChangeListener[] listeners = entry.getValue();
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (this.hasPromptValueChangeListener(promptValues.getPromptValueChangeListeners(), listeners[i])) continue;
                promptValues.addPromptValueChangeListener(listeners[i]);
            }
        }
    }

    private boolean hasPromptValueChangeListener(PromptValueChangeListener[] listeners, PromptValueChangeListener listener) {
        int n = listeners.length;
        for (int i = 0; i < n; ++i) {
            if (listeners[i] != listener) continue;
            return true;
        }
        return false;
    }
}

