/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.Filter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@SASScope
public class ElasticItem {
    FilterItem _thisFilter;
    Map<String, String> _originalIncludedItems = new HashMap<String, String>();
    Map<String, String> _selectedItems = new HashMap<String, String>();
    Map<String, String> _includedItems = new HashMap<String, String>();
    Map<String, String> _excludedItems = new HashMap<String, String>();
    List<DataSelection> _queryList = new ArrayList<DataSelection>();
    QualifiedColumn _filterColumn = null;
    DataItem _filterDataItem = null;
    String _filterLabel = null;
    String _level = null;
    Filter _filter = new Filter();
    String _hierarchyName = null;
    String _dimensionName = null;
    boolean _filterActive = false;

    public ElasticItem(FilterItem filterItem) throws MetadataException {
        this._thisFilter = filterItem;
        this._filterLabel = filterItem.getLabel();
        boolean filterHasDataItems = false;
        List<DataItem> dataItemsForThisFilter = filterItem.getDataItems(0);
        for (DataItem filterDataItem : dataItemsForThisFilter) {
            filterHasDataItems = true;
            if (filterDataItem.getUsage() != DataItemActionType.USAGE_CATEGORY) {
                MessageFormatter e = null;
                throw new MetadataException(e);
            }
            this._filterDataItem = filterDataItem;
            List<QualifiedColumn> qualifiedColumnList = filterDataItem.getResources(QualifiedColumn.class, 0);
            Iterator<QualifiedColumn> iterator = qualifiedColumnList.iterator();
            while (iterator.hasNext()) {
                QualifiedColumn filterColumn;
                this._filterColumn = filterColumn = iterator.next();
            }
        }
        if (!filterHasDataItems) {
            List<QualifiedColumn> filterColumnList = filterItem.getResources(QualifiedColumn.class, 0);
            Iterator<QualifiedColumn> iterator = filterColumnList.iterator();
            while (iterator.hasNext()) {
                QualifiedColumn filterColumn;
                this._filterColumn = filterColumn = iterator.next();
            }
        }
    }

    public String getLevel() {
        return this._level;
    }

    public void setLevel(String level) {
        this._level = level;
    }

    public Filter getFilter() {
        return this._filter;
    }

    public void setHierarchyName(String hierarchyName) {
        this._hierarchyName = hierarchyName;
    }

    public void setDimensionName(String dimensionName) {
        this._dimensionName = dimensionName;
    }

    public String getHierarchyName() {
        return this._hierarchyName;
    }

    public String getDimensionName() {
        return this._dimensionName;
    }

    public FilterItem getThisFilter() {
        return this._thisFilter;
    }

    public DataItem getFilterDataItem() {
        return this._filterDataItem;
    }

    public String getFilterLabel() {
        return this._filterLabel;
    }

    public QualifiedColumn getFilterColumn() {
        return this._filterColumn;
    }

    public Map<String, String> getOriginalIncludedItems() {
        return this._originalIncludedItems;
    }

    public Map<String, String> getSelectedItems() {
        return this._selectedItems;
    }

    public Map<String, String> getIncludedItems() {
        return this._includedItems;
    }

    public Map<String, String> getExcludedItems() {
        return this._excludedItems;
    }

    public List<DataSelection> getQueryList() {
        return this._queryList;
    }

    public boolean isFilterActive() {
        return this._filterActive;
    }

    public void setFilterActive(boolean b) {
        this._filterActive = b;
    }
}

