/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval.convenience;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.convenience.FindAllPromptValuesListenersVisitor;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.PropertyChangeListenee;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.ModelItemWithIdentity;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.SlicerFilterExpression;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public final class ByGroupCreator {
    public static final String ENTITYATTRIBUTE_DATAITEM_ID = "ByGroupDataItem";
    private static final Logger _logger = LogManager.getLogger(ByGroupCreator.class);

    public static final List<FilterItem> addByGroupToBusinessQuery(BusinessQuery inputBQ, List<? extends DataItem> byGroupList) throws MetadataException {
        List<FilterItem> filterList = inputBQ.getInputStructure().isOLAP() ? ByGroupCreator.addOLAPByGroupFilters(inputBQ, byGroupList) : ByGroupCreator.addRelationalByGroupFilters(inputBQ, byGroupList);
        return filterList;
    }

    private static List<FilterItem> addOLAPByGroupFilters(BusinessQuery inputBQ, List<? extends DataItem> byGroupList) throws MetadataException, InvalidIDException {
        BusinessModel dataItemSource = inputBQ.getBusinessModel();
        List<FilterItem> filterList = inputBQ.getFilters();
        for (DataItem dataItem : byGroupList) {
            FilterItem filter = dataItemSource.newFilterItem();
            String key = ByGroupCreator.generateKey(dataItem, false);
            filter.setIntraModelID(key);
            ConstantExpression rightSide = new ConstantExpression();
            rightSide.setExpressionType(dataItem.getExpressionType());
            rightSide.setValue(".");
            SlicerFilterExpression memberFilterExpr = new SlicerFilterExpression();
            memberFilterExpr.setWhatToCompare(dataItem);
            ArrayList<ConstantExpression> member = new ArrayList<ConstantExpression>();
            member.add(rightSide);
            memberFilterExpr.setMemberNames(member);
            filter.setExpression(memberFilterExpr);
            dataItemSource.addBusinessItem(filter);
            filterList.add(filter);
            rightSide.removeListener(memberFilterExpr);
        }
        inputBQ.setFilters(filterList);
        return filterList;
    }

    public static final void updateSingleOLAPByGroupElement(DataSelection dataSelection, DataItem dataItem, String value) throws MetadataException {
        if (dataSelection.getInputStructure().isOLAP()) {
            List<FilterItem> filters = dataSelection.getFilters();
            if (filters.isEmpty()) {
                ByGroupCreator.createSingleOLAPByGroupElement(dataSelection, dataItem, value);
                return;
            }
            FilterItem filter = filters.get(0);
            BusinessModel dataItemSource = dataSelection.getBusinessModel();
            ExpressionInterface expr = filter.getExpression();
            if (expr instanceof SlicerFilterExpression) {
                int type = 2;
                ExpressionInterface exprS = StringExpressionUtil.getInstance().newExpression(dataItemSource, value, type);
                ArrayList<ExpressionInterface> member = new ArrayList<ExpressionInterface>();
                member.add(exprS);
                ((SlicerFilterExpression)expr).setMemberNames(member);
            } else {
                SlicerFilterExpression memberFilterExpr = new SlicerFilterExpression();
                memberFilterExpr.setWhatToCompare(dataItem);
                int type = 2;
                ExpressionInterface exprS = StringExpressionUtil.getInstance().newExpression(dataItemSource, value, type);
                ArrayList<ExpressionInterface> member = new ArrayList<ExpressionInterface>();
                member.add(exprS);
                memberFilterExpr.setMemberNames(member);
                filter.setExpression(memberFilterExpr);
            }
        } else if (dataSelection.getInputStructure().isRelational()) {
            throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupCreator.createByGroupElement.noRelationUse.txt", new Object[0]));
        }
    }

    public static final void createSingleOLAPByGroupElement(DataSelection dataSelection, DataItem dataItem, String value) throws MetadataException {
        if (dataSelection.getInputStructure().isOLAP()) {
            BusinessModel dataItemSource = dataSelection.getBusinessModel();
            FilterItem filter = dataItemSource.newFilterItem();
            String key = ByGroupCreator.generateKey(dataItem, false);
            filter.setIntraModelID(key);
            SlicerFilterExpression memberFilterExpr = new SlicerFilterExpression();
            memberFilterExpr.setWhatToCompare(dataItem);
            int type = 2;
            ExpressionInterface expr = StringExpressionUtil.getInstance().newExpression(dataItemSource, value, type);
            ArrayList<ExpressionInterface> member = new ArrayList<ExpressionInterface>();
            member.add(expr);
            memberFilterExpr.setMemberNames(member);
            filter.setExpression(memberFilterExpr);
            dataItemSource.addBusinessItem(filter);
            List<FilterItem> filterList = dataSelection.getFilters();
            filterList.add(filter);
            dataSelection.setFilters(filterList);
        } else if (dataSelection.getInputStructure().isRelational()) {
            throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupCreator.createByGroupElement.noRelationUse.txt", new Object[0]));
        }
    }

    private static List<FilterItem> addRelationalByGroupFilters(BusinessQuery inputBQ, List<? extends DataItem> byGroupList) throws MetadataException {
        BusinessModel dataItemSource = inputBQ.getBusinessModel();
        List filterList = inputBQ.getFilters();
        for (DataItem dataItem : byGroupList) {
            boolean isCharValue;
            String key;
            int formatType = 0;
            List<SelectedItem> siList = inputBQ.getSelectedItems();
            for (SelectedItem si : siList) {
                DataItem di = si.getItem();
                if (!dataItem.equals(di)) continue;
                formatType = si.getFormatType();
                break;
            }
            if (dataItemSource.getBusinessItemByID(key = ByGroupCreator.generateKey(dataItem, false)) != null) {
                key = dataItemSource.generateIntraModelID(key);
            }
            int typeWithoutFF = dataItem.getExpressionTypeIgnoringFormattingForced();
            boolean isFormattedOutput = GenerationUtil.isOutputDataFormatted(inputBQ, dataItem, formatType, false);
            boolean isFormattedAsRef = GenerationUtil.useFormattedValueForReference(dataItem);
            ConstantExpression rightSide = new ConstantExpression();
            boolean bl = isCharValue = isFormattedAsRef || typeWithoutFF == 3;
            if (isCharValue) {
                rightSide.setExpressionType(3);
                rightSide.setValue(" ");
            } else {
                rightSide.setExpressionType(typeWithoutFF);
                rightSide.setValue(".");
            }
            boolean isGroupedByFormatted = false;
            try {
                isGroupedByFormatted = GenerationUtil.useFormattedValueForGrouping(dataItem);
            }
            catch (GenerationException e) {
                throw new MetadataException(e);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("ByGroupCreate> " + GenerationUtil.toString(dataItem) + "... isFF(Output)=" + isFormattedOutput + ", isFF(Reference)=" + isFormattedAsRef + ", isFF(ByGroup)=" + isGroupedByFormatted + ", rs=[" + rightSide + "]");
            }
            SimpleConditionalExpression_Comparison comparisonExpression = new SimpleConditionalExpression_Comparison();
            comparisonExpression.setLeftExpression(dataItem);
            comparisonExpression.setFormattingForcedOverridden(true);
            comparisonExpression.setFormattingForcedOverrideValue(isFormattedAsRef);
            comparisonExpression.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            comparisonExpression.setRightExpression(rightSide);
            FilterItem filter = dataItemSource.newFilterItem();
            filter.setIntraModelID(key);
            filter.setExpression(comparisonExpression);
            dataItemSource.addBusinessItem(filter);
            filterList.add(filter);
            rightSide.removeListener(comparisonExpression);
        }
        filterList = ByGroupCreator.traverseFilter(dataItemSource, filterList);
        inputBQ.setFilters(filterList);
        return filterList;
    }

    private static final List traverseFilter(BusinessModel dataItemSource, List inputFilter) throws MetadataException {
        ArrayList<FilterItem> returnList = new ArrayList<FilterItem>();
        if (inputFilter.size() > 0) {
            int currentIndex = 0;
            returnList.add(ByGroupCreator.newSimpleOrCompoundFilter(dataItemSource, currentIndex, inputFilter));
        }
        return returnList;
    }

    private static final FilterItem newSimpleOrCompoundFilter(BusinessModel dataItemSource, int currentIndex, List inputFilter) throws MetadataException {
        FilterItem currentFilterItem = (FilterItem)inputFilter.get(currentIndex);
        if (++currentIndex < inputFilter.size()) {
            CompoundFilter compoundFilter = dataItemSource.newCompoundFilter();
            compoundFilter.setLeftFilter(currentFilterItem);
            compoundFilter.setRelationType(ConditionalRelationType.AND);
            compoundFilter.setRightFilter(ByGroupCreator.newSimpleOrCompoundFilter(dataItemSource, currentIndex, inputFilter));
            compoundFilter.setIntraModelID("ByGroupDataItem_" + compoundFilter.getIntraModelID());
            dataItemSource.addBusinessItem(compoundFilter);
            currentFilterItem = compoundFilter;
        }
        return currentFilterItem;
    }

    public static final void setByGroupValues(BusinessQuery businessQuery, Map byGroupValueMap) throws MetadataException {
        List<FilterItem> filters = businessQuery.getEffectiveFilters();
        for (Map.Entry entry : byGroupValueMap.entrySet()) {
            Object item = entry.getKey();
            Object slicer = entry.getValue();
            if (_logger.isDebugEnabled()) {
                _logger.debug("SetByGroupValues: item=" + item + ", slicer=" + slicer);
                if (item instanceof ModelItemWithIdentity) {
                    _logger.debug("      item is " + ((ModelItemWithIdentity)item).getIdentityString());
                }
                if (slicer instanceof ModelItemWithIdentity) {
                    _logger.debug("    slicer is " + ((ModelItemWithIdentity)slicer).getIdentityString());
                }
            }
            if (item == null) {
                throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupCreator.setByGroupValues.NullItem.txt", new Object[0]));
            }
            Object value = entry.getValue();
            if (value == null) {
                throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupCreator.setByGroupValues.NullValue.fmt.txt", item.toString()));
            }
            String newkey = null;
            String oldkey = null;
            if (item instanceof String) {
                newkey = ByGroupCreator.generateKey((String)item, false);
                oldkey = ByGroupCreator.generateKey((String)item, true);
            } else if (item instanceof DataItem) {
                newkey = ByGroupCreator.generateKey((DataItem)item, false);
                oldkey = ByGroupCreator.generateKey((DataItem)item, true);
            } else {
                throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupCreator.setByGroupValues.GenerateKey.fmt.txt", item.toString()));
            }
            try {
                FilterItem byGroupFilter = ByGroupCreator.getFilter(filters, newkey);
                if (byGroupFilter != null) {
                    List memberNames;
                    MemberFilterExpression memberExpr;
                    ExpressionInterface byGroupValueExpr = null;
                    ExpressionInterface whatToCompare = null;
                    ExpressionInterface byGroupExpr = byGroupFilter.getExpression();
                    if (byGroupExpr instanceof SimpleConditionalExpression_Comparison) {
                        byGroupValueExpr = ((SimpleConditionalExpression_Comparison)byGroupExpr).getRightExpression();
                        whatToCompare = ((SimpleConditionalExpression_Comparison)byGroupExpr).getLeftExpression();
                    } else if (byGroupExpr instanceof SlicerFilterExpression) {
                        memberExpr = (SlicerFilterExpression)byGroupExpr;
                        memberNames = memberExpr.getMemberNames();
                        if (!memberNames.isEmpty()) {
                            byGroupValueExpr = memberNames.get(0);
                        }
                        whatToCompare = memberExpr.getWhatToCompare();
                    } else if (byGroupExpr instanceof MemberFilterExpression && !(byGroupExpr instanceof BusinessGroupMemberFilterExpression) && MDXGenerationUtil.isOldByGroupExpression(byGroupExpr, businessQuery, byGroupFilter.getID(), byGroupFilter)) {
                        memberExpr = (MemberFilterExpression)byGroupExpr;
                        memberNames = memberExpr.getMemberNames(true);
                        if (!memberNames.isEmpty()) {
                            byGroupValueExpr = (ExpressionInterface)memberNames.get(0);
                        }
                        whatToCompare = memberExpr.getWhatToCompare();
                    }
                    if (byGroupValueExpr == null || !(byGroupValueExpr instanceof ConstantExpression)) continue;
                    ConstantExpression byGroupValue = (ConstantExpression)byGroupValueExpr;
                    List<PropertyChangeListener> listeners = byGroupValue.getListeners();
                    ByGroupCreator.removeListener(byGroupValue, listeners);
                    int byGroupValueType = byGroupValue.getExpressionType();
                    String byGroupValueText = ByGroupCreator.getByGroupValue(value, businessQuery, byGroupValueType);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Setting By Group Value on " + byGroupFilter + ": ByGroupValueType=" + byGroupValueType + ", old GroupValueText=[" + byGroupValue.getValue() + "], new GroupValueText=[" + byGroupValueText + "], from value [" + value + "](" + value.getClass().getSimpleName() + ")");
                        _logger.debug("   comparing to " + GenerationUtil.toString((DataItem)whatToCompare));
                    }
                    byGroupValue.setValue(byGroupValueText);
                    ByGroupCreator.addListener(byGroupValue, listeners);
                    continue;
                }
                PromptValuesInterface pValues = businessQuery.getPromptValues();
                PromptDefinitionInterface pDefinition = pValues.getPromptDefinition(oldkey, true);
                if (pDefinition == null) continue;
                String byGroupValue = null;
                if (value instanceof String && ByGroupCreator.isOldByGroupFilter(filters, oldkey)) {
                    byGroupValue = ((String)value).trim();
                } else {
                    int sqlType = pDefinition.getPromptDataType().getExpressionUsage();
                    byGroupValue = ByGroupCreator.getByGroupValue(value, businessQuery, ExpressionUtil.getExprType(sqlType));
                }
                FindAllPromptValuesListenersVisitor visitor = new FindAllPromptValuesListenersVisitor();
                pValues.acceptPromptValuesVisitor((PromptValuesVisitorInterface)visitor);
                visitor.removeAllListeners();
                pValues.setPromptValue(pDefinition, byGroupValue);
                visitor.restoreAllListeners();
            }
            catch (InvalidPromptValueException e) {
                throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("ByGroupCreator.setByGroupValues.SetValue.fmt.txt", item.toString(), value.toString()), (Throwable)e);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
    }

    private static void removeListener(PropertyChangeListenee item, List listener) {
        if (listener != null && listener.size() > 0) {
            Iterator it = listener.iterator();
            while (it.hasNext()) {
                item.removeListener((PropertyChangeListener)it.next());
            }
        }
    }

    private static void addListener(PropertyChangeListenee item, List listener) {
        if (listener != null && listener.size() > 0) {
            Iterator it = listener.iterator();
            while (it.hasNext()) {
                item.addListener((PropertyChangeListener)it.next());
            }
        }
    }

    public static final void dumpByGroupValues(BusinessQuery businessQuery) {
        if (_logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\n****************************************************************************************************");
            buffer.append("\n*** Dump of ByGroup Values:");
            buffer.append("\n*** ");
            Map byGroupMap = ByGroupCreator.getByGroupFilterMap(businessQuery);
            if (byGroupMap.isEmpty()) {
                buffer.append("\n*** No ByGroup filters defined");
            } else {
                for (Map.Entry entry : byGroupMap.entrySet()) {
                    Object item = entry.getKey();
                    Object value = entry.getValue();
                    buffer.append("\n*** " + item + " = " + value);
                }
            }
            buffer.append("\n*** ");
            buffer.append("\n****************************************************************************************************");
            _logger.debug(buffer.toString());
        }
    }

    private static final String generateKey(DataItem dataItem, boolean generateOldKey) throws MetadataException {
        while (dataItem instanceof DataItemReference) {
            dataItem = ((DataItemReference)dataItem).getBaseDataItem();
        }
        return ByGroupCreator.generateKey(dataItem.getID(), generateOldKey);
    }

    private static final String generateKey(String dataItemID, boolean generateOldKey) {
        String id = null;
        id = generateOldKey ? ENTITYATTRIBUTE_DATAITEM_ID + dataItemID : "ByGroupDataItem_" + dataItemID.replace('.', '_');
        return id;
    }

    public static Map getByGroupFilterMap(BusinessQuery businessQuery) {
        HashMap byGroupFilters = new HashMap();
        List<FilterItem> allFilters = businessQuery.getEffectiveFilters();
        for (FilterItem filterItem : allFilters) {
            boolean isByGroup = ByGroupCreator.isByGroupFilter(filterItem, ENTITYATTRIBUTE_DATAITEM_ID, null);
            Map filterMap = null;
            if (isByGroup) {
                filterMap = ByGroupCreator.getByGroupFilterMap(filterItem);
            } else {
                ArrayList oldByGroupFilters = new ArrayList();
                boolean hasByGroups = ByGroupCreator.getFilterItems(businessQuery, filterItem.getExpression(), oldByGroupFilters);
                if (hasByGroups) {
                    filterMap = ByGroupCreator.getByGroupFilterMap(oldByGroupFilters);
                }
            }
            if (filterMap == null) continue;
            byGroupFilters.putAll(filterMap);
        }
        return byGroupFilters;
    }

    private static Map getByGroupFilterMap(FilterItem filter) {
        HashMap<DataItem, String> result = new HashMap<DataItem, String>();
        if (filter instanceof CompoundFilter) {
            CompoundFilter cpFilter = (CompoundFilter)filter;
            Map leftMap = ByGroupCreator.getByGroupFilterMap(cpFilter.getLeftFilter());
            Map rightMap = ByGroupCreator.getByGroupFilterMap(cpFilter.getRightFilter());
            result.putAll(leftMap);
            result.putAll(rightMap);
        } else if (filter.getIntraModelID().startsWith(ENTITYATTRIBUTE_DATAITEM_ID)) {
            List<DataItem> di = filter.getResources(DataItem.class, 0);
            List<ConstantExpression> ce = filter.getResources(ConstantExpression.class, 0);
            if (!di.isEmpty() && !ce.isEmpty()) {
                DataItem item = di.get(0);
                ConstantExpression value = ce.get(0);
                result.put(item, value.getValue());
            }
        }
        return result;
    }

    private static Map getByGroupFilterMap(List filters) {
        HashMap result = new HashMap();
        Iterator filterIterator = filters.iterator();
        while (filterIterator.hasNext()) {
            Object element1 = filterIterator.next();
            Object element2 = null;
            if (filterIterator.hasNext()) {
                element2 = filterIterator.next();
            }
            if (element1 instanceof DataItem) {
                result.put(element1, element2);
                continue;
            }
            result.put(element2, element1);
        }
        return result;
    }

    public static boolean isByGroupFilter(BusinessQuery businessQuery, FilterItem filter) {
        boolean isByGroup = ByGroupCreator.isByGroupFilter(filter, ENTITYATTRIBUTE_DATAITEM_ID, null);
        if (!isByGroup) {
            ArrayList filterList = new ArrayList();
            isByGroup = ByGroupCreator.getFilterItems(businessQuery, filter.getExpression(), filterList);
        }
        return isByGroup;
    }

    private static boolean getFilterItems(BusinessQuery businessQuery, ExpressionInterface expression, List filterItems) {
        boolean isByGroup;
        block6: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    isByGroup = false;
                                    if (!(expression instanceof CompoundConditionalExpression)) break block7;
                                    CompoundConditionalExpression conditional = (CompoundConditionalExpression)expression;
                                    ExpressionInterface left = conditional.getLeftExpression();
                                    ExpressionInterface right = conditional.getRightExpression();
                                    boolean isLeftByGroup = ByGroupCreator.getFilterItems(businessQuery, left, filterItems);
                                    boolean isRightByGroup = ByGroupCreator.getFilterItems(businessQuery, right, filterItems);
                                    isByGroup = isLeftByGroup || isRightByGroup;
                                    break block6;
                                }
                                if (!(expression instanceof SimpleConditionalExpression_Comparison)) break block8;
                                SimpleConditionalExpression_Comparison comparison = (SimpleConditionalExpression_Comparison)expression;
                                ExpressionInterface left = comparison.getLeftExpression();
                                ExpressionInterface right = comparison.getRightExpression();
                                boolean isLeftByGroup = ByGroupCreator.getFilterItems(businessQuery, left, filterItems);
                                boolean isRightByGroup = ByGroupCreator.getFilterItems(businessQuery, right, filterItems);
                                isByGroup = isLeftByGroup || isRightByGroup;
                                break block6;
                            }
                            if (!(expression instanceof SlicerFilterExpression)) break block9;
                            SlicerFilterExpression filter = (SlicerFilterExpression)expression;
                            List<ExpressionInterface> memberNames = filter.getMemberNames();
                            Iterator<ExpressionInterface> iter = memberNames.iterator();
                            while (iter.hasNext()) {
                                if (!ByGroupCreator.getFilterItems(businessQuery, iter.next(), filterItems)) continue;
                                isByGroup = true;
                                break block6;
                            }
                            break block6;
                        }
                        if (!(expression instanceof ConditionalExpressionAdapter)) break block10;
                        ConditionalExpressionAdapter cea = (ConditionalExpressionAdapter)expression;
                        isByGroup = ByGroupCreator.getFilterItems(businessQuery, cea.getExpression(), filterItems);
                        break block6;
                    }
                    if (!(expression instanceof FunctionCall)) break block11;
                    FunctionCall function = (FunctionCall)expression;
                    List<ExpressionInterface> args = function.getArguments();
                    for (ExpressionInterface element : args) {
                        if (!(element instanceof ExpressionInterface)) continue;
                        isByGroup = ByGroupCreator.getFilterItems(businessQuery, element, filterItems);
                    }
                    break block6;
                }
                if (!(expression instanceof Prompt)) break block12;
                Prompt prompt = (Prompt)expression;
                PromptDefinitionInterface pDefinition = prompt.getPromptDefinition();
                String promptName = pDefinition.getPromptName();
                if (!promptName.startsWith(ENTITYATTRIBUTE_DATAITEM_ID) || !pDefinition.isHidden()) break block6;
                isByGroup = true;
                filterItems.add(pDefinition);
                break block6;
            }
            if (expression instanceof DataItem) {
                filterItems.add(expression);
            } else if (expression instanceof MultipleConditionalExpression) {
                MultipleConditionalExpression conditional = (MultipleConditionalExpression)expression;
                for (int i = 0; i < conditional.getExpressionCount(); ++i) {
                    ExpressionInterface expr = conditional.getExpression(i);
                    boolean isExprByGroup = ByGroupCreator.getFilterItems(businessQuery, expr, filterItems);
                    isByGroup = isByGroup || isExprByGroup;
                }
            }
        }
        return isByGroup;
    }

    private static boolean isOldByGroupFilter(List FilterItems, String key) {
        for (FilterItem filterItem : FilterItems) {
            Prompt prompt;
            PromptDefinitionInterface pDefinition;
            ExpressionInterface rightExpression;
            Iterator<ExpressionInterface> argsIterator;
            FunctionCall function;
            List<ExpressionInterface> args;
            SimpleConditionalExpression_Comparison comparison;
            ExpressionInterface leftExpression;
            ExpressionInterface expression = filterItem.getExpression();
            if (!(expression instanceof SimpleConditionalExpression_Comparison) || !((leftExpression = (comparison = (SimpleConditionalExpression_Comparison)expression).getLeftExpression()) instanceof FunctionCall) || (args = (function = (FunctionCall)leftExpression).getArguments()) == null || !(argsIterator = args.iterator()).hasNext() || !(argsIterator.next() instanceof DataItem) || function.getFunction() == null || !FunctionNameID.LEFT.equals(function.getFunction().getFunctionNameID()) || !((rightExpression = comparison.getRightExpression()) instanceof Prompt) || (pDefinition = (prompt = (Prompt)rightExpression).getPromptDefinition()) == null || !pDefinition.isHidden() || !pDefinition.getPromptName().equals(key)) continue;
            return true;
        }
        return false;
    }

    public static DataItem returnBaseDataItem(DataItem resultItem) {
        while (resultItem instanceof DataItemReference) {
            resultItem = ((DataItemReference)resultItem).getBaseDataItem();
        }
        return resultItem;
    }

    private static String getByGroupValue(Object value, BusinessQuery businessQuery, int expressionType) throws MetadataException {
        String result = null;
        if (value instanceof Date) {
            AbstractTimeValueExpression abstractTimeValue = AbstractTimeValueExpression.newValue((Date)value, expressionType);
            result = abstractTimeValue.generateQueryText((DataSelection)businessQuery, ConnectionType.IOM);
        } else {
            result = value instanceof MissingValues ? MissingValues.toQueryString((MissingValues)((MissingValues)value)) : value.toString();
        }
        return result;
    }

    private static FilterItem getFilter(List<? extends FilterItem> filters, String key) {
        FilterItem result = null;
        ArrayList filterList = new ArrayList();
        for (FilterItem filterItem : filters) {
            if (!ByGroupCreator.isByGroupFilter(filterItem, key, filterList)) continue;
            result = (FilterItem)filterList.get(0);
            break;
        }
        return result;
    }

    private static boolean isByGroupFilter(FilterItem filter, String key, List<? super FilterItem> byGroupFilters) {
        boolean isByGroupFilter = false;
        String intraModelID = filter.getIntraModelID();
        if (intraModelID.startsWith(key)) {
            isByGroupFilter = true;
            if (byGroupFilters != null) {
                byGroupFilters.add(filter);
            }
        } else if (filter instanceof CompoundFilter) {
            CompoundFilter cpFilter = (CompoundFilter)filter;
            boolean isLeftByGroup = ByGroupCreator.isByGroupFilter(cpFilter.getLeftFilter(), key, byGroupFilters);
            boolean isRightByGroup = ByGroupCreator.isByGroupFilter(cpFilter.getRightFilter(), key, byGroupFilters);
            isByGroupFilter = isLeftByGroup || isRightByGroup;
        }
        return isByGroupFilter;
    }
}

