/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryContainer;
import com.sas.iquery.dataretrieval.QueryExecutor;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataretrieval.StrategySelector;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.execution.OverrideMLSLookupsInterface;
import com.sas.iquery.execution.OverrideStpNamesInterface;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.ResultSetUpdateInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.util.DataSelectionUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.services.connection.ConnectionInterface;
import com.sas.util.LocalizableString;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public class SimpleQueryConnector
implements OverrideLocaleInterface,
OverrideMLSLookupsInterface,
OverrideStpNamesInterface {
    StrategySelector _strategySelector = new StrategySelector();
    QueryExecutor _queryExecutor = new QueryExecutor();
    RetrievalPolicy _retrievalPolicy = new RetrievalPolicy();
    Locale _computationLocale = null;
    private StpNames _stpNames = null;
    private Map<String, MLSLookup> _mlsLookups = null;
    private boolean _mlsEnabled = false;
    private static final Logger _logger = LogManager.getLogger(SimpleQueryConnector.class);
    private static final Logger _perfGELogger = LogManager.getLogger((String)"com.sas.iquery.perf.GenExecution");
    private ConnectionInterface _connection = null;
    private IWorkspace _workspace = null;

    @SASScope
    public SimpleQueryConnector() {
    }

    public RetrievalPolicy getRetrievalPolicy() {
        return this._retrievalPolicy;
    }

    public void setRetrievalPolicy(RetrievalPolicy policy) {
        this._retrievalPolicy = policy;
    }

    @Nonnull
    public Map<String, ResultSetInterface> retrieveQueryResultMap(List<? extends BusinessQuery> queries, RetrievalPolicy retrievalPolicy) throws DataRetrievalException {
        Preconditions.ensureNonNull(queries, _logger);
        Preconditions.ensureNonNullTypedElements(queries, BusinessQuery.class, _logger);
        HashSet<String> uniqueIdSet = new HashSet<String>();
        for (BusinessQuery businessQuery : queries) {
            if (businessQuery.getID() == null) {
                throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("QueryConnector.validateInputList.NoID.txt", new Object[0]));
            }
            if (uniqueIdSet.add(businessQuery.getID())) continue;
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("QueryConnector.validateInputList.NotUniqieID.txt", new Object[0]));
        }
        LinkedHashMap<String, ResultSetInterface> returnMap = new LinkedHashMap<String, ResultSetInterface>();
        try {
            for (BusinessQuery businessQuery : queries) {
                ResultSetInterface rs = this.generateAndExecuteQuery(businessQuery, retrievalPolicy);
                returnMap.put(businessQuery.getID(), rs);
            }
        }
        catch (DataRetrievalException dataRetrievalException) {
            throw dataRetrievalException;
        }
        catch (IQueryServicesException iQueryServicesException) {
            _logger.debug("An exception occurred while attempting to access data.  The following exception was thrown: ", (Throwable)iQueryServicesException);
            DataRetrievalException dataRetrievalException = new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("QueryConnector.retrieveQueryResultMap.ProcessIQI.txt", new Object[0]), (Throwable)iQueryServicesException);
            dataRetrievalException.initCause(iQueryServicesException);
            throw dataRetrievalException;
        }
        return returnMap;
    }

    private ResultSetInterface generateAndExecuteQuery(BusinessQuery bq, RetrievalPolicy retrievalPolicy) throws DataRetrievalException, ExecutionException {
        long start = 0L;
        if (_perfGELogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogGenerationExecutionPerformance("> Generating and Executing query (" + bq.getClass().getSimpleName() + ") w/ ID=" + (bq instanceof DataSelection ? ((DataSelection)bq).getID() : "unknown"));
            start = System.currentTimeMillis();
        }
        ResultSetInterface rs = this.processIQI(bq, retrievalPolicy);
        if (_perfGELogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogGenerationExecutionPerformance("< done gen/executing (" + (end - start) + "ms)");
        }
        return rs;
    }

    @Nonnull
    public ResultSetInterface retrieveQueryResult(@Nonnull BusinessQuery query) throws DataRetrievalException {
        try {
            RetrievalPolicy rp = this.getRetrievalPolicy();
            return this.generateAndExecuteQuery(query, rp);
        }
        catch (IQueryServicesException e) {
            _logger.debug("An exception occurred while attempting to access data.  The following exception was thrown: ", (Throwable)e);
            DataRetrievalException e2 = new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("QueryConnector.retrieveQueryResultMap.ProcessIQI.txt", new Object[0]), (Throwable)e);
            e2.initCause(e);
            throw e2;
        }
    }

    @Nonnull
    public Map<String, ResultSetInterface> retrieveQueryResultMap(List<? extends BusinessQuery> queries) throws DataRetrievalException {
        RetrievalPolicy rp = this.getRetrievalPolicy();
        Map<String, ResultSetInterface> returnMap = this.retrieveQueryResultMap(queries, rp);
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    protected ResultSetInterface processIQI(BusinessQuery iqi, RetrievalPolicy retrievalPolicy) throws DataRetrievalException, ExecutionException {
        try (QueryContainer queryContainer = this.newQueryContainer(iqi, retrievalPolicy);){
            StrategyInterface strategy = this._strategySelector.getStrategy(queryContainer);
            queryContainer.setStrategy(strategy);
            this._queryExecutor.execute(queryContainer);
            ResultSetInterface rsi = queryContainer.getResultSet();
            if (rsi instanceof ResultSetUpdateInterface) {
                ResultSetUpdateInterface updateResultSet = (ResultSetUpdateInterface)((Object)rsi);
                List<DataItem> resultItems = iqi.getEffectiveResultItems();
                for (DataItem item : resultItems) {
                    String rsid = item.getResultSetID();
                    LocalizableString labels = item.getLabels();
                    LocalizableString descs = item.getDescriptions();
                    updateResultSet.setLabels(rsid, labels);
                    updateResultSet.setDescriptions(rsid, descs);
                }
                Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(iqi, this);
                updateResultSet.setComputationalLocale(effectiveComputationLocale);
                StpNames stpNames = queryContainer.getStpNames();
                updateResultSet.setStpNames(stpNames);
            }
            ResultSetInterface resultSetInterface = rsi;
            return resultSetInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPhysicalQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        try (QueryContainer queryContainer = this.newQueryContainer(businessQuery, this.getRetrievalPolicy());){
            String physicalQuery;
            StrategyInterface strategy = this._strategySelector.getStrategy(queryContainer);
            queryContainer.setStrategy(strategy);
            StrategyInterface strategy2 = queryContainer.getStrategy();
            String string = physicalQuery = strategy2.getPhysicalQuery(businessQuery);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResultSetStructure(BusinessQuery businessQuery) throws IntelligentQueryException {
        try (QueryContainer queryContainer = this.newQueryContainer(businessQuery, this.getRetrievalPolicy());){
            StrategyInterface strategy = this._strategySelector.getStrategy(queryContainer);
            queryContainer.setStrategy(strategy);
            String string = strategy.getResultSetStructure(businessQuery, this.getRetrievalPolicy());
            return string;
        }
    }

    protected QueryContainer newQueryContainer(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws DataRetrievalException {
        QueryContainer queryContainer = new QueryContainer(retrievalPolicy);
        queryContainer.setBusinessQuery(businessQuery);
        queryContainer.setComputationalLocale(this.getComputationalLocale());
        queryContainer.setStpNames(this.getStpNames());
        Map<String, MLSLookup> mlsLookups = this.getMLSLookups();
        if (mlsLookups != null && mlsLookups.size() == 0) {
            try {
                mlsLookups = DataSelectionUtilities.buildMLSLookups(mlsLookups, businessQuery);
            }
            catch (MetadataException e) {
                throw new DataRetrievalException(e);
            }
        }
        queryContainer.setMLSLookups(mlsLookups);
        queryContainer.setConnection(this.getConnection());
        queryContainer.setWorkspace(this.getWorkspace());
        return queryContainer;
    }

    @Override
    public Locale getComputationalLocale() {
        return this._computationLocale;
    }

    @Override
    public void setComputationalLocale(Locale overrideComputationalLocale) {
        this._computationLocale = overrideComputationalLocale;
    }

    @Override
    public StpNames getStpNames() {
        return this._stpNames;
    }

    @Override
    public void setStpNames(StpNames stpNames) {
        this._stpNames = stpNames;
    }

    @Override
    public Map<String, MLSLookup> getMLSLookups() {
        if (this._mlsEnabled) {
            return this._mlsLookups;
        }
        return null;
    }

    @Override
    public void setMLSLookups(Map<String, MLSLookup> mlsLookupsByColumnName) {
        this._mlsLookups = mlsLookupsByColumnName;
    }

    public void setMultipleLanguageSupportEnabled(boolean enabled) {
        if (this._mlsEnabled != enabled) {
            this._mlsEnabled = enabled;
            if (enabled && this._mlsLookups == null) {
                this._mlsLookups = new LinkedHashMap<String, MLSLookup>();
            } else if (!enabled && this._mlsLookups != null) {
                this._mlsLookups = null;
            }
        }
    }

    public boolean isMultipleLanguageSupportEnabled() {
        return this._mlsEnabled;
    }

    @SASScope(value="sas")
    public void setConnection(ConnectionInterface connection) {
        this._connection = connection;
    }

    @SASScope(value="sas")
    public ConnectionInterface getConnection() {
        return this._connection;
    }

    @SASScope(value="sas")
    public void setWorkspace(IWorkspace workspace) {
        this._workspace = workspace;
    }

    @SASScope(value="sas")
    public IWorkspace getWorkspace() {
        return this._workspace;
    }
}

