/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.ResultSetEvent;
import com.sas.iquery.dataretrieval.ResultSetEventBroadcaster;
import com.sas.iquery.dataretrieval.ResultSetListener;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.execution.relational.offline.CachedTabularResultSet;
import com.sas.iquery.execution2.AbstractResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.MultiDimResultSet;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.TabularResultSet;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ResultSetManager
implements ResultSetListener {
    final List<MultiDimResultSet> _olapResults = new ArrayList<MultiDimResultSet>();
    final List<TabularResultSet> _basicTabularResults = new ArrayList<TabularResultSet>();
    final List<TabularResultSet> _offlineTabularResults = new ArrayList<TabularResultSet>();
    private static final Logger _logger = LogManager.getLogger(ResultSetManager.class);

    public void closeAll(int options) throws ExecutionException {
        if ((options & 8) != 0) {
            this.closeAllResults(this._olapResults);
            this._olapResults.clear();
            _logger.debug("Closed all OLAP result sets");
        }
        if ((options & 1) != 0) {
            this.closeAllResults(this._basicTabularResults);
            this._basicTabularResults.clear();
            _logger.debug("Closed all basic tabular result sets");
        }
        if ((options & 2) != 0) {
            this.closeAllResults(this._offlineTabularResults);
            this._offlineTabularResults.clear();
            _logger.debug("Closed all offline tabular result sets");
        }
    }

    private void closeAllResults(Collection<? extends ResultSetInterface> resultSets) throws ExecutionException {
        LinkedHashSet<? extends ResultSetInterface> closing = new LinkedHashSet<ResultSetInterface>(resultSets);
        while (closing.size() > 0) {
            for (ResultSetInterface resultSetInterface : closing) {
                this.removeFromCache(resultSetInterface, "closeAll()");
                resultSetInterface.close();
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("Closed result set " + resultSetInterface);
            }
            closing.clear();
            closing.addAll(resultSets);
        }
    }

    public void remember(BusinessQuery bquery, ResultSetInterface rsi, RetrievalPolicy retrievalPolicy) throws DataRetrievalException {
        if (retrievalPolicy.getConnectionConfiguration().getConnectionLifetime() == 0) {
            return;
        }
        Preconditions.ensureNonNull(bquery, "bquery");
        if (!(bquery instanceof BusinessModel)) {
            return;
        }
        try {
            int type;
            if (rsi instanceof ResultSetEventBroadcaster) {
                ((ResultSetEventBroadcaster)((Object)rsi)).addResultSetListener(this);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Added resultset listener " + rsi);
                }
            }
            if ((type = rsi.getType()) == 0) {
                this._olapResults.add((MultiDimResultSet)rsi);
            } else if (type == 1) {
                if (rsi instanceof CachedTabularResultSet) {
                    this._offlineTabularResults.add((TabularResultSet)rsi);
                } else {
                    this._basicTabularResults.add((TabularResultSet)rsi);
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("Remembered result set " + rsi);
            }
        }
        catch (ExecutionException e) {
            throw new DataRetrievalException(e);
        }
    }

    private Collection<? extends ResultSetInterface> getCollectionFor(ResultSetInterface rsi) throws ExecutionException {
        int type = rsi.getType();
        List<AbstractResultSet> collectionForType = null;
        if (type == 0) {
            collectionForType = this._olapResults;
        } else if (type == 1) {
            collectionForType = rsi instanceof CachedTabularResultSet ? this._offlineTabularResults : this._basicTabularResults;
        }
        return collectionForType;
    }

    public Collection<ResultSetInterface> allResultSets() {
        ArrayList<ResultSetInterface> allResults = new ArrayList<ResultSetInterface>();
        allResults.addAll(this._olapResults);
        allResults.addAll(this._basicTabularResults);
        allResults.addAll(this._offlineTabularResults);
        return allResults;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("\n olap: ");
        sb.append(this._olapResults.toString());
        sb.append("\n basic tabular: ");
        sb.append(this._basicTabularResults.toString());
        sb.append("\n offline tabular: ");
        sb.append(this._offlineTabularResults.toString());
        sb.append("]");
        return sb.toString();
    }

    public void closeResult(ResultSetInterface result) throws DataRetrievalException {
        if (result instanceof ResultSetEventBroadcaster) {
            ((ResultSetEventBroadcaster)((Object)result)).removeResultSetListener(this);
        }
        DataRetrievalException inError = null;
        try {
            result.close();
        }
        catch (ExecutionException e) {
            inError = new DataRetrievalException(e);
            throw inError;
        }
        finally {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Preparing to remove resultset from cahce. ");
            }
            try {
                this.removeFromCache(result, "closeResult()");
            }
            catch (ExecutionException e) {
                if (inError != null) {
                    throw inError;
                }
                throw new DataRetrievalException(e);
            }
        }
    }

    private void removeFromCache(ResultSetInterface result, String tag) throws ExecutionException {
        Collection<? extends ResultSetInterface> managedResultSets = this.getCollectionFor(result);
        if (managedResultSets != null) {
            managedResultSets.remove(result);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Removed resultset from cache: " + tag);
            }
        }
    }

    @Override
    public void notify(ResultSetEvent evt) throws ExecutionException {
        ResultSetInterface result = evt.getResultSet();
        ResultSetEvent.EventType type = evt.getEventType();
        switch (type) {
            case CLOSE: {
                if (result == null) break;
                if (result instanceof ResultSetEventBroadcaster) {
                    ((ResultSetEventBroadcaster)((Object)result)).removeResultSetListener(this);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Removed resultset listener. ");
                    }
                }
                this.removeFromCache(result, "notify(CLOSE)");
            }
        }
    }
}

