/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.dataretrieval;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.QueryContainer;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;

@SASScope
public class QueryExecutor {
    private ExecutionContext _context;

    public void setExecutionContext(ExecutionContext context) {
        this._context = context;
    }

    public ExecutionContext getExecutionContext() {
        return this._context;
    }

    public void execute(QueryContainer queryContainer) throws DataRetrievalException {
        if (queryContainer.getResultSet() == null) {
            ResultSetInterface resultSet;
            if (queryContainer.getBusinessQuery() == null) {
                throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("QueryExecutor.execute.NoQueryContainer.txt", new Object[0]));
            }
            StrategyInterface strategy = queryContainer.getStrategy();
            if (strategy == null) {
                throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("QueryExecutor.execute.NoStrategy.txt", new Object[0]));
            }
            try {
                resultSet = strategy.retrieveResultSet(queryContainer.getBusinessQuery(), queryContainer.getRetrievalPolicy());
            }
            catch (DataRetrievalException e) {
                throw e;
            }
            catch (IntelligentQueryException e) {
                DataRetrievalException e2 = new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("QueryExecutor.execute.NoResultSet.txt", new Object[0]), (Throwable)e);
                e2.initCause(e);
                throw e2;
            }
            queryContainer.setResultSet(resultSet);
        }
    }
}

