/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.builder;

import com.sas.iquery.Builder;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import java.util.ArrayList;

public class RelationalFilterItemBuilder
implements Builder<FilterItem> {
    BusinessModel _businessModel;
    private ExpressionInterface _expression;
    private ConditionalExpression _cond;
    boolean _conditionIsNegated;

    RelationalFilterItemBuilder(BusinessModel businessModel, ExpressionInterface expression) {
        this._businessModel = businessModel;
        this._expression = expression;
    }

    public RelationalFilterItemBuilder contains(String string) {
        if (this._expression.getExpressionType() != 3) {
            throw new RuntimeException("The CONTAINS operator only applies to character based expressions");
        }
        this._cond = new SimpleConditionalExpression_Contains();
        ((SimpleConditionalExpression_Contains)this._cond).setWhatToCompare(this._expression);
        ConstantExpression cons = new ConstantExpression(string, 3);
        ((SimpleConditionalExpression_Contains)this._cond).setWhatToContain(cons);
        return this;
    }

    public RelationalFilterItemBuilder lessThan(ExpressionInterface rightExpression) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_LT);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(rightExpression);
        return this;
    }

    public RelationalFilterItemBuilder lessThan(String string) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(string, 3);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_LT);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder lessThan(Number number) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(number.toString(), 2);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_LT);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder lessThanOrEquals(ExpressionInterface rightExpression) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_LE);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(rightExpression);
        return this;
    }

    public RelationalFilterItemBuilder lessThanOrEquals(String string) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(string, 3);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_LE);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder lessThanOrEquals(Number number) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(number.toString(), 2);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_LE);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder greaterThan(ExpressionInterface rightExpression) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_GT);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(rightExpression);
        return this;
    }

    public RelationalFilterItemBuilder greaterThan(String string) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(string, 3);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_GT);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder greaterThan(Number number) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(number.toString(), 2);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_GT);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder greaterThanOrEqualTo(ExpressionInterface rightExpression) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_GE);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(rightExpression);
        return this;
    }

    public RelationalFilterItemBuilder greaterThanOrEqualTo(String string) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(string, 3);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_GE);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder greaterThanOrEqualTo(Number number) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(number.toString(), 2);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_GE);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder equal(ExpressionInterface rightExpression) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_EQ);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(rightExpression);
        return this;
    }

    public RelationalFilterItemBuilder equal(String string) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(string, 3);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_EQ);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder equal(Number number) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(number.toString(), 2);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_EQ);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder notEqual(ExpressionInterface rightExpression) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_NEQ);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(rightExpression);
        return this;
    }

    public RelationalFilterItemBuilder notEqual(String string) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(string, 3);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_NEQ);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder notEqual(Number number) {
        this._cond = new SimpleConditionalExpression_Comparison();
        ConstantExpression cons = new ConstantExpression(number.toString(), 2);
        ((SimpleConditionalExpression_Comparison)this._cond).setComparisonOperator(ComparisonOperator.COMPARE_NEQ);
        ((SimpleConditionalExpression_Comparison)this._cond).setLeftExpression(this._expression);
        ((SimpleConditionalExpression_Comparison)this._cond).setRightExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder between(Number i, Number j) {
        this._cond = new SimpleConditionalExpression_Between();
        ((SimpleConditionalExpression_Between)this._cond).setWhatToCompare(this._expression);
        ConstantExpression left = new ConstantExpression(i.toString(), 2);
        ConstantExpression right = new ConstantExpression(j.toString(), 2);
        ((SimpleConditionalExpression_Between)this._cond).setLeftExpression(left);
        ((SimpleConditionalExpression_Between)this._cond).setRightExpression(right);
        return this;
    }

    public RelationalFilterItemBuilder in(int exprType, String ... stringLiterals) {
        this._cond = new SimpleConditionalExpression_In();
        ((SimpleConditionalExpression_In)this._cond).setWhatToCompare(this._expression);
        ArrayList<ConstantExpression> values = new ArrayList<ConstantExpression>(stringLiterals.length);
        for (String s : stringLiterals) {
            ConstantExpression expr = new ConstantExpression();
            expr.setValue(s);
            expr.setExpressionType(exprType);
            values.add(expr);
        }
        ((SimpleConditionalExpression_In)this._cond).setComparisonList(values);
        return this;
    }

    public RelationalFilterItemBuilder in(String ... stringLiterals) {
        this._cond = new SimpleConditionalExpression_In();
        ((SimpleConditionalExpression_In)this._cond).setWhatToCompare(this._expression);
        ArrayList<ConstantExpression> values = new ArrayList<ConstantExpression>(stringLiterals.length);
        for (String s : stringLiterals) {
            ConstantExpression expr = new ConstantExpression();
            expr.setValue(s);
            expr.setExpressionType(3);
            values.add(expr);
        }
        ((SimpleConditionalExpression_In)this._cond).setComparisonList(values);
        return this;
    }

    public RelationalFilterItemBuilder in(Number ... numberLiterals) {
        this._cond = new SimpleConditionalExpression_In();
        ((SimpleConditionalExpression_In)this._cond).setWhatToCompare(this._expression);
        ArrayList<ConstantExpression> values = new ArrayList<ConstantExpression>(numberLiterals.length);
        for (Number n : numberLiterals) {
            ConstantExpression expr = new ConstantExpression();
            expr.setValue(n.toString());
            expr.setExpressionType(2);
            values.add(expr);
        }
        ((SimpleConditionalExpression_In)this._cond).setComparisonList(values);
        return this;
    }

    public RelationalFilterItemBuilder like(String string) {
        this._cond = new SimpleConditionalExpression_Like();
        ((SimpleConditionalExpression_Like)this._cond).setWhatToCompare(this._expression);
        ConstantExpression cons = new ConstantExpression(string, 3);
        ((SimpleConditionalExpression_Like)this._cond).setPatternExpression(cons);
        return this;
    }

    public RelationalFilterItemBuilder not() {
        this._conditionIsNegated = true;
        return this;
    }

    @Override
    public FilterItem build() throws MetadataException {
        FilterItem fi = this._businessModel.newFilterItem();
        if (this._cond == null) {
            this._cond = new ConditionalExpressionAdapter();
            ((ConditionalExpressionAdapter)this._cond).setExpression(this._expression);
        }
        this._cond.setIsNegated(this._conditionIsNegated);
        fi.setExpression(this._cond);
        this._businessModel.addBusinessItem(fi);
        return fi;
    }
}

