/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.builder;

import com.sas.iquery.Builder;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.ConditionalRelationType;

public class CompoundFilterBuilder
implements Builder<CompoundFilter> {
    private FilterItem _lhs;
    private FilterItem _rhs;
    boolean _isNegated;
    private BusinessModel _businessModel;
    private ConditionalRelationType _relationType;
    private boolean _isHidden;

    CompoundFilterBuilder(BusinessModel businessModel, FilterItem fi) {
        this._businessModel = businessModel;
        this._lhs = fi;
    }

    public CompoundFilterBuilder and(FilterItem rhs) {
        assert (this._rhs == null);
        this._rhs = rhs;
        this._relationType = ConditionalRelationType.AND;
        return this;
    }

    public CompoundFilterBuilder or(FilterItem rhs) {
        assert (this._rhs == null);
        this._rhs = rhs;
        this._relationType = ConditionalRelationType.OR;
        return this;
    }

    public CompoundFilterBuilder not() {
        this._isNegated = true;
        return this;
    }

    public CompoundFilterBuilder hide() {
        this._isHidden = true;
        return this;
    }

    @Override
    public CompoundFilter build() throws MetadataException {
        if (this._relationType == null) {
            throw new RuntimeException("compound filter builder not complete - conditional relation type not set");
        }
        CompoundFilter cf = this._businessModel.newCompoundFilter();
        cf.setLeftFilter(this._lhs);
        cf.setRightFilter(this._rhs);
        cf.setRelationType(this._relationType);
        cf.setIsNegated(this._isNegated);
        cf.setIsHidden(this._isHidden);
        this._businessModel.addBusinessItem(cf);
        return cf;
    }
}

