/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.RBMessageFormatter;
import com.sas.iquery.util.impl.ResourceMessageFormatter;
import com.sas.text.LocalizableException;
import com.sas.util.ChainedException;
import com.sas.util.LocalizableToStringInterface;
import com.sas.util.RBBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.StringTokenizer;

@SASScope(value="ALL")
@SubjectToChange
public class IQueryServicesException
extends Exception
implements LocalizableToStringInterface {
    private static final long serialVersionUID = 1L;
    @SASScope
    public static final int DETAILED_MSG_BASE_SUPPORT = 0;
    @SASScope
    public static final int DETAILED_MSG_INCLUDE_REASONS = 1;
    @SASScope
    public static final int DETAILED_MSG_INCLUDE_SAS_LOGS = 2;
    @SASScope
    public static final int DETAILED_MSG_INCLUDE_STACK_TRACE = 4;
    @SASScope
    public static final int DETAILED_MSG_ALL_SUPPORT = 7;
    private static final String NEWLINE = "\n";
    private static final String INDENTATION = "  ";
    @SASScope
    protected final List<Reason> _reasons;
    private MessageFormatter _formattedMessage = null;
    private String _sasLog;

    public IQueryServicesException(String message) {
        super(message);
        this._formattedMessage = null;
        this._reasons = Collections.emptyList();
    }

    @SASScope
    public IQueryServicesException(String message, List<Reason> reasons) {
        super(message);
        this._formattedMessage = null;
        this._reasons = reasons != null ? Collections.unmodifiableList(reasons) : Collections.emptyList();
    }

    @SASScope
    public IQueryServicesException(Throwable cause) {
        super(null, cause);
        this._formattedMessage = null;
        this._reasons = Collections.emptyList();
    }

    public IQueryServicesException(String message, Throwable cause) {
        super(message, cause);
        this._formattedMessage = null;
        this._reasons = Collections.emptyList();
    }

    @SASScope
    public IQueryServicesException(MessageFormatter message) {
        this._formattedMessage = message;
        this._reasons = Collections.emptyList();
    }

    @SASScope
    public IQueryServicesException(MessageFormatter message, List<Reason> reasons) {
        this._formattedMessage = message;
        List<Object> list = this._reasons = reasons != null ? Collections.unmodifiableList(reasons) : Collections.emptyList();
        if (this._formattedMessage == null && this._reasons.size() > 0) {
            this._formattedMessage = new ArrayMessageFormatter(this._reasons.toArray());
        }
    }

    @SASScope
    public IQueryServicesException(MessageFormatter message, Throwable cause) {
        super(null, cause);
        this._formattedMessage = message;
        this._reasons = Collections.emptyList();
    }

    @SASScope
    public static MessageFormatter newMessage(ClassLoader classLoader, String bundleName, String resourceName, Object[] args) {
        return new ResourceMessageFormatter(classLoader, bundleName, resourceName, args);
    }

    @SASScope
    public static MessageFormatter newMessage(String bundleName, String resourceName, Object[] args) {
        return new ResourceMessageFormatter(bundleName, resourceName, args);
    }

    @SASScope
    public static MessageFormatter newMessage(RBBase rb, String resourceName, Object[] args) {
        return new RBMessageFormatter(rb, resourceName, args);
    }

    @SASScope
    public void setMessage(MessageFormatter message) {
        this._formattedMessage = message;
    }

    @Override
    @SASScope
    public String getMessage() {
        return this.getMessage(null);
    }

    @SASScope
    public String getDetailMessage() {
        return IQueryServicesException.getDetailMessage(null, 0, this);
    }

    @SASScope
    public String getDetailMessage(Locale locale) {
        return IQueryServicesException.getDetailMessage(locale, 0, this);
    }

    @SASScope
    public String getDetailMessage(Locale locale, int flags) {
        return IQueryServicesException.getDetailMessage(locale, flags, this);
    }

    @SASScope
    public static String getDetailMessage(Locale locale, int flags, Throwable exception) {
        Throwable topException = exception;
        int action = flags;
        ArrayList<String> msgArray = new ArrayList<String>();
        Throwable rootException = ChainedException.getRootException((Throwable)topException);
        StringBuilder builder = new StringBuilder();
        boolean getTrace = false;
        if ((action & 4) != 0) {
            getTrace = true;
        }
        String rootExceptionMessage = IQueryServicesException.getMessage(rootException, locale);
        msgArray.add(rootExceptionMessage);
        String text = null;
        boolean isChainedException = true;
        if (topException == rootException) {
            isChainedException = false;
        } else {
            String topExceptionMessage = IQueryServicesException.getMessage(topException, locale);
            if (msgArray.contains(topExceptionMessage)) {
                isChainedException = false;
            } else {
                msgArray.add(topExceptionMessage);
                text = IQueryServicesException.toMessageString(topException, topExceptionMessage);
            }
        }
        StackTraceElement[] topTrace = null;
        if (isChainedException) {
            builder.append(NEWLINE + IQDataServicesResourceBundle.getStringResource("IQueryServicesException.TopException.txt") + NEWLINE).append("[ " + text + " ]" + NEWLINE);
            if (!getTrace) {
                builder.append(NEWLINE);
            } else {
                for (StackTraceElement element : topTrace = topException.getStackTrace()) {
                    builder.append("\tat " + element + NEWLINE);
                }
                builder.append(NEWLINE);
            }
            builder.append(IQueryServicesException.outputReasons(topException, locale, action));
            Throwable next = ChainedException.getTargetException((Throwable)topException);
            while (next != null && next != rootException) {
                String message = IQueryServicesException.getMessage(next, locale);
                if (!msgArray.contains(message)) {
                    msgArray.add(message);
                    builder.append("[ " + IQueryServicesException.toMessageString(next, message) + " ]" + NEWLINE).append(IQueryServicesException.outputReasons(next, locale, action));
                } else if (next instanceof IQueryServicesException && ((IQueryServicesException)next).getReasons().size() > 0) {
                    builder.append("[ " + IQueryServicesException.toMessageString(next, " ") + " ]" + NEWLINE).append(IQueryServicesException.outputReasons(next, locale, action));
                }
                next = ChainedException.getTargetException((Throwable)next);
            }
            if (msgArray.size() > 1) {
                builder.append(NEWLINE);
            }
            builder.append(IQDataServicesResourceBundle.getStringResource("IQueryServicesException.RootException.txt") + NEWLINE);
        }
        text = IQueryServicesException.toMessageString(rootException, rootExceptionMessage);
        builder.append("[ " + text + " ]" + NEWLINE);
        if (getTrace) {
            StackTraceElement[] nextTrace = rootException.getStackTrace();
            int m = nextTrace.length - 1;
            int n = 0;
            if (topTrace != null) {
                for (n = topTrace.length - 1; m >= 0 && n >= 0 && nextTrace[m].equals(topTrace[n]); --m, --n) {
                }
                int framesInCommon = nextTrace.length - 1 - m;
                for (int i = 0; i <= m; ++i) {
                    builder.append("\tat " + nextTrace[i] + NEWLINE);
                }
                if (framesInCommon != 0) {
                    builder.append("\t... " + framesInCommon + " " + IQDataServicesResourceBundle.getStringResource("IQueryServicesException.NextedMessage.txt") + NEWLINE);
                }
            } else {
                for (StackTraceElement element : nextTrace) {
                    builder.append("\tat " + element + NEWLINE);
                }
            }
            builder.append(NEWLINE);
        }
        builder.append(IQueryServicesException.outputReasons(rootException, locale, action));
        builder.append(IQueryServicesException.outputLog(action, rootException));
        String returnValue = builder.toString();
        return returnValue;
    }

    private static String toMessageString(Throwable throwable, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(throwable.getClass().getName());
        if (message != null) {
            buffer.append(": ").append(message);
        }
        return buffer.toString();
    }

    private static String outputReasons(Throwable exception, Locale locale, int action) {
        List<Reason> reasons;
        StringBuilder builder = new StringBuilder();
        if ((action & 1) != 0 && exception instanceof IQueryServicesException && !(reasons = ((IQueryServicesException)exception).getReasons()).isEmpty()) {
            builder.append(INDENTATION).append(IQDataServicesResourceBundle.getStringResource("IQueryServicesException.Reasons.txt")).append(NEWLINE);
            for (Reason reason : reasons) {
                String message = reason.getReasonString(locale);
                if (message == null) continue;
                builder.append(INDENTATION).append(" ").append(message).append(NEWLINE);
            }
            builder.append(NEWLINE);
        }
        return builder.toString();
    }

    private static String outputLog(int action, Throwable exception) {
        String saslog;
        StringBuilder builder = new StringBuilder();
        if ((action & 2) != 0 && exception instanceof IQueryServicesException && (saslog = ((IQueryServicesException)exception).getSASLog(true, true)) != null) {
            String logText = IQDataServicesResourceBundle.getStringResource("IQueryServicesException.SASLOG.txt");
            builder.append(INDENTATION).append(logText).append(NEWLINE);
            StringTokenizer st = new StringTokenizer(saslog, NEWLINE, false);
            while (st.hasMoreTokens()) {
                builder.append(INDENTATION).append(st.nextToken()).append(NEWLINE);
            }
            builder.append("   /* =================================== */").append(NEWLINE).append(NEWLINE);
        }
        return builder.toString();
    }

    static String getMessage(Throwable throwable, Locale locale) {
        String message = null;
        if (throwable instanceof IQueryServicesException) {
            message = ((IQueryServicesException)throwable).getMessage(locale);
        } else if (throwable instanceof IQueryServicesRuntimeException) {
            message = ((IQueryServicesRuntimeException)throwable).getMessage(locale);
        } else if (throwable instanceof LocalizableException) {
            message = locale == null ? ((LocalizableException)throwable).getMessage() : ((LocalizableException)throwable).getMessage(locale);
        } else if (throwable != null) {
            message = throwable.getLocalizedMessage();
        }
        return message;
    }

    @SASScope
    public String getMessage(Locale locale) {
        String message = null;
        if (this._formattedMessage != null) {
            try {
                message = this._formattedMessage.getMessage(locale);
            }
            catch (IllegalStateException ise) {
                message = this._formattedMessage.getMessageInfo() + ", " + ise.getLocalizedMessage();
            }
            catch (IllegalArgumentException iae) {
                message = this._formattedMessage.getMessageInfo() + ", " + iae.getLocalizedMessage();
            }
            catch (MissingResourceException mre) {
                message = this._formattedMessage.getMessageInfo() + ", " + mre.getLocalizedMessage();
            }
        } else {
            message = super.getMessage();
            if (message == null) {
                Throwable cause = this.getCause();
                message = IQueryServicesRuntimeException.toMessage(cause, locale);
            }
        }
        return message;
    }

    @Override
    @SASScope
    public String toString() {
        Locale userLocale = LocaleUtilities.getDefaultViewerLocale();
        if (userLocale != null) {
            return this.toString(userLocale);
        }
        return this.toString(null);
    }

    @SASScope
    public String toString(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        IQueryServicesRuntimeException.toStringBuffer(this, buffer, locale);
        return buffer.toString();
    }

    @SASScope
    public Throwable getRootException() {
        return ChainedException.getRootException((Throwable)this);
    }

    @SASScope
    public Throwable getTargetException() {
        return ChainedException.getTargetException((Throwable)this);
    }

    @Override
    @SASScope
    public synchronized Throwable initCause(Throwable cause) {
        Throwable currCause = this.getCause();
        if (currCause == null || cause != currCause) {
            return super.initCause(cause);
        }
        return this;
    }

    public List<Reason> getReasons() {
        return this._reasons;
    }

    @Deprecated
    public Reason getFirstReason() {
        Reason outReason = null;
        if (!this._reasons.isEmpty()) {
            outReason = this._reasons.get(0);
        }
        return outReason;
    }

    public boolean hasReasonWithCodes(int reasonCode, int subreasonCode) {
        for (Reason reason : this._reasons) {
            if (reason.getReason() != reasonCode || reason.getSubReason() != subreasonCode) continue;
            return true;
        }
        return false;
    }

    @SASScope
    public void setSASLog(String sasLog) {
        if (sasLog == null) {
            return;
        }
        if (this._sasLog != null) {
            throw new IllegalStateException(IQDataServicesResourceBundle.getStringResource("IQueryServicesException.setSASLog.txt"));
        }
        this._sasLog = sasLog;
    }

    public String getSASLog() {
        return this.getSASLog(false, false);
    }

    public String getSASLog(boolean searchCauses, boolean combineLogs) {
        String returnedLog;
        String rootLog = null;
        if (searchCauses) {
            Throwable walk = this.getTargetException();
            while (walk != null && walk != this && !(walk instanceof IQueryServicesException)) {
                walk = ChainedException.getTargetException((Throwable)walk);
            }
            if (walk != this && walk instanceof IQueryServicesException) {
                rootLog = ((IQueryServicesException)walk).getSASLog(searchCauses, combineLogs);
            }
        }
        if (rootLog != null) {
            if (combineLogs) {
                StringBuffer combined = new StringBuffer();
                combined.append(rootLog);
                if (this._sasLog != null && combined.indexOf(this._sasLog) == -1) {
                    if (!rootLog.endsWith(NEWLINE)) {
                        combined.append(NEWLINE);
                    }
                    combined.append(this._sasLog);
                }
                returnedLog = combined.toString();
            } else {
                returnedLog = rootLog;
            }
        } else {
            returnedLog = this._sasLog;
        }
        return returnedLog;
    }
}

