/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.profile;

import com.sas.batch.metadata.profile.RB;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.text.Message;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProfileUtil {
    private static final String PROFILE_FILENAME = "metaProfile.xml";
    private static final String PROFILE_FILENAME_ALTERNATE = "metadataConfig.xml";

    ProfileUtil() {
    }

    static Login getLogin(MdObjectStore store, String userID) throws MdException, RemoteException {
        if (userID == null) {
            return null;
        }
        MdFactory factory = store.getFactory();
        int flags = 396;
        String search = "<XMLSelect search = \"*[@UserID='" + userID + "']\"/>";
        String template = "<Templates><Login><Domain/></Login></Templates>";
        String reposId = factory.getOMIUtil().getFoundationReposID();
        List logins = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposId, "Login", flags, search + "<Templates><Login><Domain/></Login></Templates>");
        if (logins == null || logins.isEmpty()) {
            return null;
        }
        return (Login)logins.get(0);
    }

    static List<File> getMetaProfiles(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.DirectoryDoesNotExist.fmt.txt", (Object)dir.getAbsolutePath()));
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"UpdateMetadataProfile.InvalidDirectory.fmt.txt", (Object)dir.getAbsolutePath()));
        }
        ArrayList<File> profiles = new ArrayList<File>();
        FilenameFilter nameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return ProfileUtil.PROFILE_FILENAME.equalsIgnoreCase(name) || ProfileUtil.PROFILE_FILENAME_ALTERNATE.equalsIgnoreCase(name);
            }
        };
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File dir) {
                return dir.isDirectory();
            }
        };
        profiles.addAll(ProfileUtil.getProfiles(dir, nameFilter));
        File[] subdirs = dir.listFiles(dirFilter);
        if (subdirs != null) {
            for (File subdir : subdirs) {
                profiles.addAll(ProfileUtil.getProfiles(subdir, nameFilter));
            }
        }
        return profiles;
    }

    private static List<File> getProfiles(File dir, FilenameFilter nameFilter) {
        ArrayList<File> profiles = new ArrayList<File>(5);
        File[] files = dir.listFiles(nameFilter);
        if (files != null) {
            for (File file : files) {
                profiles.add(file);
            }
        }
        return profiles;
    }

    static File saveOriginalProfile(File originalProfile) throws IOException {
        String originalName = originalProfile.getAbsolutePath();
        int index = originalName.lastIndexOf(".xml");
        if (index > -1) {
            originalName = originalName.substring(0, index);
        }
        File newProfile = null;
        int count = 1;
        boolean uniqueNameFound = false;
        while (!uniqueNameFound) {
            String newName = originalName + "_old" + count + ".xml";
            newProfile = new File(newName);
            if (!newProfile.exists()) {
                uniqueNameFound = true;
            }
            ++count;
        }
        if (!originalProfile.renameTo(newProfile)) {
            FileUtils.copyFile((File)originalProfile, newProfile);
        }
        return newProfile;
    }

    static void writeDocumentContents(File profile, Document doc) throws Exception {
        ProfileUtil.writeDocumentContents(profile, doc, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeDocumentContents(File profile, Document doc, String encoding) throws Exception {
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(profile), encoding));){
            StreamResult result = new StreamResult(writer);
            transformer.setOutputProperty("encoding", encoding);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            transformer.transform(source, result);
        }
    }

    static Element createChildElement(String childName, Node parentNode, Document doc) {
        Element childElement = ProfileUtil.getChildElementByName(childName, parentNode);
        if (childElement == null) {
            childElement = doc.createElement(childName);
            parentNode.appendChild(childElement);
        }
        return childElement;
    }

    private static Element getChildElementByName(String childName, Node parentNode) {
        NodeList nodes = parentNode.getChildNodes();
        if (nodes != null) {
            for (int index = 0; index < nodes.getLength(); ++index) {
                Node child = nodes.item(index);
                if (!childName.equalsIgnoreCase(child.getNodeName()) || !(child instanceof Element)) continue;
                return (Element)child;
            }
        }
        return null;
    }
}

