/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.listobjects;

import com.sas.batch.localsvc.FilterOptions;
import com.sas.batch.localsvc.LocalServicesBatchUtility2;
import com.sas.batch.metadata.listobjects.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.ResponsibilityDetails;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFactory;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SortOrder;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ListObjects
extends LocalServicesBatchUtility2 {
    public static final String OPTION_FORMAT = "format";
    public static final String OPTION_SORT = "sort";
    public static final String OPTION_NODISPLAYNAME = "noDisplayName";
    public static final int NOTFOUND = 1;
    private String format = "list";
    private FilterOptions filterOptions;
    private SortOrder[] sortOrder = SortOrder.getDefaultOrder();
    private boolean noDisplayName = false;
    private static String NEWLINE = "\n";
    private static DateFormat ISO8601Local = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public ListObjects() {
        ISO8601Local.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.utilityName = "sas-list-objects";
        this.filterOptions = new FilterOptions();
    }

    public void setFormat(String format) {
        if (!("list".equalsIgnoreCase(format) || "csv".equalsIgnoreCase(format) || "xml".equalsIgnoreCase(format) || "rc".equalsIgnoreCase(format))) {
            throw new IllegalArgumentException(RB.getStringResource("ListObjects.InvalidFormat.log"));
        }
        this.format = format;
    }

    public void setFilterOptions(FilterOptions fOptions) {
        this.filterOptions = fOptions;
    }

    public FilterOptions getFilterOptions() {
        if (this.filterOptions == null) {
            this.filterOptions = new FilterOptions();
        }
        return this.filterOptions;
    }

    public void setSortList(String[] sort) {
        LinkedHashSet<SortOrder> sortSet = new LinkedHashSet<SortOrder>();
        if (sort != null && sort.length > 0) {
            for (int i = 0; i < sort.length; ++i) {
                SortOrder so = SortOrder.getSortOrder((String)sort[i]);
                if (so == null) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ListObjects.InvalidSortCriteria.fmt.log", (Object)sort[i]));
                }
                sortSet.add(so);
            }
            if (sortSet.size() > 0) {
                this.sortOrder = sortSet.toArray(new SortOrder[sortSet.size()]);
            }
        }
    }

    public boolean isNoDisplayName() {
        return this.noDisplayName;
    }

    public void setNoDisplayName(boolean noDisplayName) {
        this.noDisplayName = noDisplayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        try {
            this.initialize();
            Search search = SearchFactory.createSearch((ServerInterface)this.metadataServer);
            boolean includesTypeFilter = false;
            for (SearchFilter filter : this.filterOptions.getFilters()) {
                search.addFilter(filter);
                if (!(filter instanceof PublicTypeFilter)) continue;
                includesTypeFilter = true;
            }
            if (!includesTypeFilter) {
                search.addFilter(this.getDefaultTypeFilter());
            }
            if (this.filterOptions.getFilterFolderTree() != null) {
                search.setFolderScope(new PathUrl(this.metadataServer.getRootFolder().getPathUrl(), this.filterOptions.getFilterFolderTree()), true);
            } else if (this.filterOptions.getFilterFolder() != null) {
                search.setFolderScope(new PathUrl(this.metadataServer.getRootFolder().getPathUrl(), this.filterOptions.getFilterFolder()), false);
            }
            ResultDetails resultDetails = search.getResultDetails();
            resultDetails.setSortOrder(this.sortOrder);
            List searchResults = search.search();
            if (this.format.equalsIgnoreCase("rc")) {
                this.returnCode = searchResults.size() <= 0 ? 1 : 0;
            } else if (searchResults.size() <= 0) {
                System.out.println(RB.getStringResource("ListObjects.NoObjectsFound.log"));
                this.returnCode = 1;
            } else {
                XMLStreamWriter xml = null;
                if (this.format.equalsIgnoreCase("csv")) {
                    System.out.println("Path,Name,TypeName,Type,Description,Created,CreatedBy,Modified,ModifiedBy");
                } else if (this.format.equalsIgnoreCase("xml")) {
                    xml = this.getXMLWriter();
                }
                for (PublicObjectInterface object : searchResults) {
                    if (this.format.equalsIgnoreCase("list")) {
                        String objectResultPath = "";
                        objectResultPath = this.noDisplayName ? this.getObjectPath(object) : this.getObjectPathWithDisplayName(object);
                        System.out.println(objectResultPath);
                        continue;
                    }
                    if (this.format.equalsIgnoreCase("csv")) {
                        this.printCSVOutput(object);
                        continue;
                    }
                    if (!this.format.equalsIgnoreCase("xml")) continue;
                    this.printXMLOutput(xml, object);
                }
                if (this.format.equalsIgnoreCase("list")) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"ListObjects.ObjectsFound.fmt.log", (Object)searchResults.size()));
                } else if (this.format.equalsIgnoreCase("xml")) {
                    this.closeXMLWriter(xml);
                }
                this.returnCode = 0;
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        ListObjects lister = new ListObjects();
        lister.executeBatch(args);
    }

    private String getObjectPath(PublicObjectInterface object) throws ServiceException, RemoteException {
        PathUrl url = object.getPathUrl();
        if (url == null) {
            PublicObjectContainerInterface parent;
            String type = null;
            TypeDescriptorInterface tdi = object.getTypeDescriptor();
            if (tdi != null && (type = tdi.getTypeName()).contains(".")) {
                type = type.substring(0, type.indexOf("."));
            }
            if ((parent = object.getContainer()) == null) {
                return type == null ? object.getName() : object.getName() + "(" + type + ")";
            }
            return type == null ? this.getObjectPath((PublicObjectInterface)parent) + "/" + object.getName() : this.getObjectPath((PublicObjectInterface)parent) + "/" + object.getName() + "(" + type + ")";
        }
        String path = url.getAbsolutePath();
        return path;
    }

    private String getObjectPathWithDisplayName(PublicObjectInterface object) throws ServiceException, RemoteException {
        String objectPath = null;
        String displayName = null;
        boolean showDisplayName = false;
        DetailsProcessorInterface details = (DetailsProcessorInterface)object.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
        if (details != null) {
            displayName = details.getDisplayName();
            if (!object.getName().equals(displayName) && displayName != null && !displayName.isEmpty()) {
                showDisplayName = true;
            }
        }
        objectPath = this.getObjectPath(object);
        if (showDisplayName) {
            objectPath = objectPath + " [" + displayName + "]";
        }
        return objectPath;
    }

    private void printCSVOutput(PublicObjectInterface object) throws ServiceException, RemoteException {
        TypeDescriptorInterface typeDescriptor = object.getTypeDescriptor();
        DetailsProcessorInterface details = (DetailsProcessorInterface)object.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
        StringBuffer line = new StringBuffer(200);
        this.addCSVElement(line, this.getObjectPath(object));
        if (details != null) {
            this.addCSVElement(line, details.getDisplayName());
        } else {
            this.addCSVElement(line, "");
        }
        if (typeDescriptor != null) {
            this.addCSVElement(line, typeDescriptor.getTypeName());
            this.addCSVElement(line, typeDescriptor.getLabel());
        } else {
            this.addCSVElement(line, "");
            this.addCSVElement(line, "");
        }
        if (details != null) {
            this.addCSVElement(line, details.getDescription());
            this.addCSVElement(line, DateFormat.getDateTimeInstance().format(details.getCreateDate()));
            ResponsibilityDetails createdBy = details.getCreatedByDetails();
            if (createdBy != null) {
                this.addCSVElement(line, createdBy.getName());
            } else {
                this.addCSVElement(line, "");
            }
            this.addCSVElement(line, DateFormat.getDateTimeInstance().format(details.getModifyDate()));
            ResponsibilityDetails modifiedBy = details.getModifiedByDetails();
            if (modifiedBy != null) {
                this.addCSVElement(line, modifiedBy.getName());
            } else {
                this.addCSVElement(line, "");
            }
        }
        System.out.println(line.toString());
    }

    private void addCSVElement(StringBuffer line, String element) {
        if (line.length() > 0) {
            line.append(",");
        }
        if (element == null) {
            return;
        }
        if (element.contains("\"")) {
            line.append("\"" + element.replaceAll("\"", "\"\"") + "\"");
        } else if (element.contains(",")) {
            line.append("\"" + element + "\"");
        } else {
            line.append(element);
        }
    }

    private XMLStreamWriter getXMLWriter() throws XMLStreamException {
        XMLOutputFactory xmlof = XMLOutputFactory.newInstance();
        XMLStreamWriter xml = xmlof.createXMLStreamWriter(System.out);
        xml.writeStartDocument();
        xml.writeCharacters(NEWLINE);
        xml.writeStartElement("Objects");
        xml.writeCharacters(NEWLINE);
        return xml;
    }

    private void printXMLOutput(XMLStreamWriter xml, PublicObjectInterface object) throws ServiceException, RemoteException, XMLStreamException {
        String metadataType;
        TypeDescriptorInterface typeDescriptor = object.getTypeDescriptor();
        DetailsProcessorInterface details = (DetailsProcessorInterface)object.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
        xml.writeStartElement("Object");
        xml.writeAttribute("Path", this.getObjectPath(object));
        if (details != null) {
            xml.writeAttribute("Name", details.getDisplayName());
        }
        if (typeDescriptor != null) {
            xml.writeAttribute("Type", typeDescriptor.getTypeName());
            xml.writeAttribute("TypeLabel", typeDescriptor.getLabel());
        }
        boolean nestedElement = false;
        if (details != null) {
            List keywords;
            xml.writeAttribute("Description", details.getDescription());
            xml.writeAttribute("Created", ISO8601Local.format(details.getCreateDate()));
            ResponsibilityDetails createdBy = details.getCreatedByDetails();
            if (createdBy != null) {
                xml.writeAttribute("CreatedBy", createdBy.getName());
            }
            xml.writeAttribute("Modified", ISO8601Local.format(details.getModifyDate()));
            ResponsibilityDetails modifiedBy = details.getModifiedByDetails();
            if (modifiedBy != null) {
                xml.writeAttribute("ModifiedBy", modifiedBy.getName());
            }
            if ((keywords = details.getKeywords()) != null && keywords.size() > 0) {
                for (String keyword : keywords) {
                    xml.writeCharacters(NEWLINE + "  ");
                    xml.writeStartElement("Keyword");
                    xml.writeAttribute("Text", keyword);
                    xml.writeEndElement();
                }
                nestedElement = true;
            }
            for (ResponsibilityDetails respDetails : details.getResponsibilities()) {
                xml.writeCharacters(NEWLINE + "  ");
                xml.writeStartElement("Responsibility");
                xml.writeAttribute("Role", respDetails.getRole());
                xml.writeAttribute("Name", respDetails.getName());
                xml.writeAttribute("DisplayName", respDetails.getUserName());
                xml.writeEndElement();
                nestedElement = true;
            }
        }
        if (typeDescriptor != null && ((metadataType = typeDescriptor.getMetadataType()).equals("SoftwareComponent") || metadataType.equals("ServerContext") || metadataType.equals("LogicalServer") || metadataType.equals("ServerComponent"))) {
            HashMap publicProperties = new HashMap();
            HashMap privateProperties = new HashMap();
            MdObjectStore store = ((OMIServer)this.metadataServer).getObjectStore();
            try {
                ConfigurablePropertiesUtil.getObjectProperties((MdObjectStore)store, (String)object.getIdentifier(), publicProperties, privateProperties);
                if (!publicProperties.isEmpty()) {
                    xml.writeCharacters(NEWLINE + "  ");
                    xml.writeStartElement("PublicProperties");
                    for (String name : publicProperties.keySet()) {
                        xml.writeCharacters(NEWLINE + "    ");
                        xml.writeStartElement("Property");
                        xml.writeAttribute("Name", name);
                        xml.writeAttribute("Value", (String)publicProperties.get(name));
                        xml.writeEndElement();
                    }
                    xml.writeCharacters(NEWLINE + "  ");
                    xml.writeEndElement();
                    nestedElement = true;
                }
                if (!privateProperties.isEmpty()) {
                    xml.writeCharacters(NEWLINE + "  ");
                    xml.writeStartElement("PrivateProperties");
                    for (String name : privateProperties.keySet()) {
                        xml.writeCharacters(NEWLINE + "    ");
                        xml.writeStartElement("Property");
                        xml.writeAttribute("Name", name);
                        xml.writeAttribute("Value", (String)privateProperties.get(name));
                        xml.writeEndElement();
                    }
                    xml.writeCharacters(NEWLINE + "  ");
                    xml.writeEndElement();
                    nestedElement = true;
                }
            }
            catch (MdException mdException) {
                // empty catch block
            }
        }
        if (nestedElement) {
            xml.writeCharacters(NEWLINE);
        }
        xml.writeEndElement();
        xml.writeCharacters("\n");
    }

    private void closeXMLWriter(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeEndElement();
        xml.writeEndDocument();
        xml.close();
    }

    private SearchFilter getDefaultTypeFilter() throws ServiceException, RemoteException {
        ArrayList<String> types = new ArrayList<String>(100);
        boolean folderScopedSearch = this.filterOptions.getFilterFolderTree() != null || this.filterOptions.getFilterFolder() != null;
        for (TypeDescriptorInterface typeDescriptor : this.metadataServer.getTypeDictionaryMap().values()) {
            String containerType = typeDescriptor.getContainerType();
            String isSearchAllowed = typeDescriptor.getPropertyValue("IsSearchAllowed");
            if ("false".equalsIgnoreCase(isSearchAllowed)) continue;
            if (containerType == null || containerType.length() <= 0) {
                if (folderScopedSearch) continue;
                types.add(typeDescriptor.getTypeName());
                continue;
            }
            if (!containerType.equals("Folder") && !containerType.startsWith("Folder.")) continue;
            types.add(typeDescriptor.getTypeName());
        }
        return new PublicTypeFilter(types);
    }

    protected Options getCommandLineOptions(boolean forTextHelp) {
        Options options = super.getCommandLineOptions(forTextHelp);
        this.filterOptions.addToOptions(options);
        Option option = new Option(OPTION_FORMAT, true, RB.getStringResource("ListObjects.Format.Desc.txt"));
        option.setArgName(RB.getStringResource("ListObjects.Format.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_SORT, true, RB.getStringResource("ListObjects.Sort.Desc.txt"));
        option.setArgName(RB.getStringResource("ListObjects.Sort.ArgName.txt"));
        option.setArgs(-2);
        options.addOption(option);
        option = new Option(OPTION_NODISPLAYNAME, false, RB.getStringResource("ListObjects.NoDisplayName.Desc.txt"));
        option.setRequired(false);
        options.addOption(option);
        return options;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String[] sort;
        if (!super.parse(args)) {
            return false;
        }
        this.filterOptions.parse(this.commandLine);
        if (this.commandLine.hasOption(OPTION_FORMAT)) {
            this.setFormat(this.commandLine.getOptionValue(OPTION_FORMAT));
        }
        if ((sort = this.commandLine.getOptionValues(OPTION_SORT)) != null && sort.length > 0) {
            this.setSortList(sort);
        }
        if (this.commandLine.hasOption(OPTION_NODISPLAYNAME)) {
            this.setNoDisplayName(true);
        }
        return true;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("ListObjects.HelpUsage.txt")});
    }
}

