/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.deleteobjects;

import com.sas.batch.metadata.deleteobjects.RB;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.Logger;

@SASScope
public class ConfigPropertiesInstaller {
    public static final String PROPERTY_KEY = "installed.object";
    public static final String OPTION_CONFIG_PRODUCT_ID = "configProductID";
    public static final String OPTION_CONFIG_PRODUCT_KEY = "configProductKey";
    private Logger logger;
    private MetadataServerInterface metadataServer;
    private String productID;

    public ConfigPropertiesInstaller(String productID, MetadataServerInterface metadataServer, Logger logger) {
        this.productID = productID;
        this.metadataServer = metadataServer;
        this.logger = logger;
    }

    private MdObjectStore createObjectStore() throws RemoteException {
        return ((OMIServer)this.metadataServer).getMdFactory().createObjectStore(null, "ConfigPropertiesInstaller");
    }

    public static Option getProductIDOption() {
        Option option = new Option(OPTION_CONFIG_PRODUCT_ID, true, RB.getStringResource("ConfigPropertiesInstaller.ProdID.Desc.txt"));
        option.setArgName(RB.getStringResource("ConfigPropertiesInstaller.ProdID.ArgName.txt"));
        return option;
    }

    public static Option getProductKeyOption() {
        Option option = new Option(OPTION_CONFIG_PRODUCT_KEY, true, RB.getStringResource("ConfigPropertiesInstaller.ProdKey.Desc.txt"));
        option.setArgName(RB.getStringResource("ConfigPropertiesInstaller.ProdKey.ArgName.txt"));
        return option;
    }

    public int addProperties(List<String> propertyValues) throws MdException, RemoteException {
        return this.addProperties(propertyValues, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addProperties(List<String> propertyValues, String productKey) throws MdException, RemoteException {
        int rc = 0;
        MdObjectStore store = null;
        try {
            this.logger.info(RB.getStringResource("ConfigPropertiesInstaller.SettingConfigProperties.txt"));
            if (this.productID.length() != 17) {
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ConfigPropertiesInstaller.SettingConfigProperties.fmt.txt", (Object)this.productID));
                int n = 4;
                return n;
            }
            store = this.createObjectStore();
            this.logger.info(RB.getStringResource("ConfigPropertiesInstaller.GetConfigProperties.txt"));
            HashMap publicProps = new HashMap();
            HashMap<String, String> privateProps = new HashMap<String, String>();
            ConfigurablePropertiesUtil.getObjectProperties((MdObjectStore)store, (String)this.productID, publicProps, privateProps);
            if (publicProps.size() == 0 && privateProps.size() == 0) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ConfigPropertiesInstaller.NoProperties.fmt.txt", (Object)this.productID));
            }
            String key = "installed.object." + (productKey == null ? "" : productKey + ".");
            int length = propertyValues.size();
            for (int index = 0; index < length; ++index) {
                String path = propertyValues.get(index);
                privateProps.put(key + String.valueOf(index + 1), path);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Adding property - " + key + ":" + path);
            }
            this.logger.info(RB.getStringResource("ConfigPropertiesInstaller.AddProperties.fmt.txt"));
            ConfigurablePropertiesUtil.setObjectProperties((MdObjectStore)store, (String)this.productID, publicProps, privateProps);
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
        return rc;
    }

    public int loadConfigurationProperties(List<String> propertyValues) throws MdException, RemoteException {
        return this.loadConfigurationProperties(propertyValues, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadConfigurationProperties(List<String> propertyValues, String productKey) throws MdException, RemoteException {
        if (propertyValues == null) {
            return 0;
        }
        MdObjectStore store = null;
        try {
            this.logger.info(RB.getStringResource("ConfigPropertiesInstaller.GettingConfigProperties.txt"));
            if (this.productID.length() != 17) {
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ConfigPropertiesInstaller.InvalidID.fmt.txt", (Object)this.productID));
                int n = 4;
                return n;
            }
            store = this.createObjectStore();
            this.logger.info(RB.getStringResource("ConfigPropertiesInstaller.GetConfigProperties.txt"));
            HashMap publicProps = new HashMap();
            HashMap privateProps = new HashMap();
            ConfigurablePropertiesUtil.getObjectProperties((MdObjectStore)store, (String)this.productID, publicProps, privateProps);
            if (privateProps.size() == 0) {
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ConfigPropertiesInstaller.NoProperties.fmt.txt", (Object)this.productID));
                int n = 4;
                return n;
            }
            ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
            String propKey = "installed.object." + (productKey == null ? "" : productKey + ".");
            for (String key : privateProps.keySet()) {
                if (!key.startsWith(propKey)) continue;
                int propIndex = this.getPropertyIndex(key);
                values.add(new PropertyValue((String)privateProps.get(key), propIndex));
            }
            Collections.sort(values, new PropertySorter());
            for (PropertyValue property : values) {
                propertyValues.add(property.getValue());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Found configuration property: " + property.getValue());
            }
            int n = 0;
            return n;
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
    }

    private int getPropertyIndex(String propertyKey) {
        int propertyIndex = -1;
        int index = propertyKey.lastIndexOf(46);
        if (index > -1) {
            String sIndex = propertyKey.substring(index + 1);
            try {
                propertyIndex = Integer.parseInt(sIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return propertyIndex;
    }

    class PropertyValue {
        private String _value = null;
        private int _index = -1;

        public PropertyValue(String value, int index) {
            this._value = value;
            this._index = index;
        }

        public String getValue() {
            return this._value;
        }

        public int getIndex() {
            return this._index;
        }
    }

    class PropertySorter
    implements Comparator<PropertyValue> {
        PropertySorter() {
        }

        @Override
        public int compare(PropertyValue value1, PropertyValue value2) {
            if (value1 == value2) {
                return 0;
            }
            if (value1 == null) {
                return -1;
            }
            if (value2 == null) {
                return 1;
            }
            return this.runCompare(value1, value2);
        }

        private int runCompare(PropertyValue value1, PropertyValue value2) {
            int index2;
            int index1 = value1.getIndex();
            if (index1 < (index2 = value2.getIndex())) {
                return -1;
            }
            if (index1 > index2) {
                return 1;
            }
            return 0;
        }
    }
}

