/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.ApplicationMetadataUtility;
import com.sas.batch.appmeta.MetadataBase;
import com.sas.batch.appmeta.RB;
import com.sas.batch.appmeta.TypeGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeDefinition
extends MetadataBase
implements LocalizableProperties {
    private boolean _allowsChildren;
    private String _applicablePermissions;
    private String _containerAssociation;
    private String _containerInformation;
    private String _containerType;
    private String _defaultIcon;
    private String _defaultLocation;
    private boolean _defaultUpdatesAllowed;
    private int _definitionVersion;
    private boolean _hasContentBacking;
    private boolean _isSearchAllowed;
    private String _javaClass;
    private String _localizerClass;
    private String _logicalTypeClass;
    private String _metadataType;
    private TypeGroup _parent;
    private String _reportTypeDescriptorClass;
    private int _supportedObjectVersionMin;
    private int _supportedObjectVersionMax;
    private String _template;
    private String _typeName;

    private TypeDefinition(ApplicationMetadataUtility context, TypeGroup parent) {
        super(context);
        this._parent = parent;
    }

    static TypeDefinition create(Element xml, TypeGroup parent) {
        TypeDefinition typeDefinition = new TypeDefinition(parent.getContext(), parent);
        typeDefinition.loadFromXML(xml);
        parent.add(typeDefinition);
        return typeDefinition;
    }

    String getTypeName() {
        return this._typeName;
    }

    void loadFromXML(Element xml) {
        String supportedObjectVersionMin;
        String supportedObjectVersionMax;
        String definitionVersion;
        this._desc = xml.getAttribute("Desc");
        if (xml.hasAttribute("AllowsChildren")) {
            this._allowsChildren = "true".equalsIgnoreCase(xml.getAttribute("AllowsChildren"));
        }
        this._applicablePermissions = xml.hasAttribute("ApplicablePermissions") ? xml.getAttribute("ApplicablePermissions") : "ReadMetadata,WriteMetadata";
        this._containerAssociation = xml.getAttribute("ContainerAssociation");
        this._containerType = xml.getAttribute("ContainerType");
        this._defaultIcon = xml.getAttribute("DefaultIcon");
        this._defaultLocation = xml.getAttribute("DefaultLocation");
        if (xml.hasAttribute("DefaultUpdatesAllowed")) {
            this._defaultUpdatesAllowed = "true".equalsIgnoreCase(xml.getAttribute("DefaultUpdatesAllowed"));
        }
        if (xml.hasAttribute("DefinitionVersion") && (definitionVersion = xml.getAttribute("DefinitionVersion")).length() > 0) {
            this._definitionVersion = Integer.parseInt(definitionVersion);
        }
        if (xml.hasAttribute("HasContentBacking")) {
            this._hasContentBacking = "true".equalsIgnoreCase(xml.getAttribute("HasContentBacking"));
        }
        this._isSearchAllowed = xml.hasAttribute("IsSearchAllowed") ? "true".equalsIgnoreCase(xml.getAttribute("IsSearchAllowed")) : true;
        this._javaClass = xml.getAttribute("JavaClass");
        this._localizerClass = xml.getAttribute("LocalizerClass");
        this._logicalTypeClass = xml.getAttribute("LogicalTypeClass");
        this._metadataType = xml.getAttribute("MetadataType");
        this._name = xml.getAttribute("Name");
        this._reportTypeDescriptorClass = xml.getAttribute("ReportTypeDescriptorClass");
        if (xml.hasAttribute("SupportedObjectVersionMax") && (supportedObjectVersionMax = xml.getAttribute("SupportedObjectVersionMax")).length() > 0) {
            this._supportedObjectVersionMax = Integer.parseInt(supportedObjectVersionMax);
        }
        if (xml.hasAttribute("SupportedObjectVersionMin") && (supportedObjectVersionMin = xml.getAttribute("SupportedObjectVersionMin")).length() > 0) {
            this._supportedObjectVersionMin = Integer.parseInt(supportedObjectVersionMin);
        }
        this._typeName = xml.getAttribute("TypeName");
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("Template")) {
                try {
                    this._template = this._context.getEmbeddedXML(element);
                }
                catch (Exception e) {
                    this._context.getLogger().warn(RB.getStringResource("TypeDefinition.TemplateParseError.log"));
                    this._context.getLogger().warn(e.getLocalizedMessage());
                    this._context.declareWarning();
                }
                continue;
            }
            if (!tagName.equals("ContainerInformation")) continue;
            try {
                this._containerInformation = this._context.getEmbeddedXML(element);
                continue;
            }
            catch (Exception e) {
                this._context.getLogger().warn(RB.getStringResource("TypeDefinition.ContainerInformationParseError.log"));
                this._context.getLogger().warn(e.getLocalizedMessage());
                this._context.declareWarning();
            }
        }
    }

    void mergeToMetadata(OMIServer server) throws RemoteException, MdException, AppMetaException {
        Property prop;
        MdObjectStore store = server.getObjectStore();
        MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
        com.sas.metadata.remote.TypeDefinition typeDefinition = null;
        if (this._typeName.length() > 0) {
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "TypeDefinition", 392, "<XMLSelect search=\"TypeDefinition[@TypeName='" + this._typeName + "']\"/>");
            if (objects.size() == 1) {
                typeDefinition = (com.sas.metadata.remote.TypeDefinition)objects.get(0);
            } else if (objects.size() > 1) {
                this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"TypeDefinition.MultipleTypeDefinitionsFound.fmt.log", (Object)this._typeName));
                for (Object obj : objects) {
                    com.sas.metadata.remote.TypeDefinition typeDef = (com.sas.metadata.remote.TypeDefinition)obj;
                    if (typeDefinition == null) {
                        typeDefinition = typeDef;
                        continue;
                    }
                    this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"TypeDefinition.TypeDefinitionDeleted.fmt.log", (Object)typeDef.getName(), (Object)typeDef.getId()));
                    typeDef.delete();
                }
            }
            if (typeDefinition != null && !typeDefinition.getName().equals(this._name)) {
                typeDefinition.setName(this._name);
            }
        }
        String foundationId = omiUtil.getFoundationReposID().substring(9);
        if (typeDefinition == null) {
            typeDefinition = (com.sas.metadata.remote.TypeDefinition)store.getFactory().createComplexMetadataObject(store, this._name, "TypeDefinition", foundationId);
            this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"TypeDefinition.TypeDefinitionCreate.fmt.log", (Object)this._name));
        } else {
            this._context.getLogger().info(Message.format((ResourceBundle)RB.getResources(), (String)"TypeDefinition.TypeDefinitionUpdated.fmt.log", (Object)this._name, (Object)typeDefinition.getId()));
            for (Property prop2 : (Property[])typeDefinition.getProperties().toArray((Object[])new Property[0])) {
                prop2.delete();
            }
            for (TextStore text : (TextStore[])typeDefinition.getNotes().toArray((Object[])new TextStore[0])) {
                text.delete();
            }
        }
        typeDefinition.setPublicType("TypeDefinition");
        typeDefinition.setUsageVersion(1000000.0);
        typeDefinition.setDesc(this._desc);
        typeDefinition.setAllowsChildren(this._allowsChildren ? 1 : 0);
        typeDefinition.setApplicablePermissions(this._applicablePermissions);
        typeDefinition.setContainerAssociation(this._containerAssociation);
        typeDefinition.setContainerType(this._containerType);
        typeDefinition.setDefaultIcon(this._defaultIcon);
        typeDefinition.setDefaultLocation(this._defaultLocation);
        typeDefinition.setDefaultUpdatesAllowed(this._defaultUpdatesAllowed ? 1 : 0);
        typeDefinition.setDefinitionVersion((double)this._definitionVersion);
        typeDefinition.setJavaClass(this._javaClass);
        typeDefinition.setMetadataType(this._metadataType);
        typeDefinition.setSupportedObjectVersionMax((double)this._supportedObjectVersionMax);
        typeDefinition.setSupportedObjectVersionMin((double)this._supportedObjectVersionMin);
        typeDefinition.setTypeName(this._typeName);
        if (!this._isSearchAllowed) {
            prop = (Property)store.getFactory().createComplexMetadataObject(store, "Is Search Allowed", "Property", foundationId);
            prop.setPropertyName("IsSearchAllowed");
            prop.setDefaultValue("false");
            prop.setSQLType(4);
            typeDefinition.getProperties().add((Object)prop);
        }
        if (this._localizerClass != null && this._localizerClass.length() > 0) {
            prop = (Property)store.getFactory().createComplexMetadataObject(store, "Localizer Class", "Property", foundationId);
            prop.setPropertyName("LocalizerClass");
            prop.setDefaultValue(this._localizerClass);
            prop.setSQLType(12);
            typeDefinition.getProperties().add((Object)prop);
        }
        if (this._logicalTypeClass != null && this._logicalTypeClass.length() > 0) {
            prop = (Property)store.getFactory().createComplexMetadataObject(store, "Logical Type Class", "Property", foundationId);
            prop.setPropertyName("LogicalTypeClass");
            prop.setDefaultValue(this._logicalTypeClass);
            prop.setSQLType(12);
            typeDefinition.getProperties().add((Object)prop);
        }
        if (this._hasContentBacking) {
            prop = (Property)store.getFactory().createComplexMetadataObject(store, "HasContentBacking", "Property", foundationId);
            prop.setPropertyName("HasContentBacking");
            prop.setDefaultValue("1");
            prop.setSQLType(4);
            typeDefinition.getProperties().add((Object)prop);
        }
        if (this._reportTypeDescriptorClass != null && this._reportTypeDescriptorClass.length() > 0) {
            prop = (Property)store.getFactory().createComplexMetadataObject(store, "Report Type Descriptor Class", "Property", foundationId);
            prop.setPropertyName("ReportTypeDescriptorClass");
            prop.setDefaultValue(this._reportTypeDescriptorClass);
            prop.setSQLType(12);
            typeDefinition.getProperties().add((Object)prop);
        }
        if (this._template != null && this._template.length() > 0) {
            TextStore template = (TextStore)store.getFactory().createComplexMetadataObject(store, "Public Object Template", "TextStore", foundationId);
            template.setTextType("XML");
            template.setTextRole("PublicObjectTemplate");
            template.setStoredText(this._template);
            typeDefinition.getNotes().add((Object)template);
        }
        if (this._containerInformation != null && this._containerInformation.length() > 0) {
            TextStore containerInformation = (TextStore)store.getFactory().createComplexMetadataObject(store, "Container Information", "TextStore", foundationId);
            containerInformation.setTextType("XML");
            containerInformation.setTextRole("ContainerInformation");
            containerInformation.setStoredText(this._containerInformation);
            typeDefinition.getNotes().add((Object)containerInformation);
        }
        FolderInterface folder = this._parent.getFolder();
        Tree newFolderObject = (Tree)folder.getRepositoryEntity();
        typeDefinition.getTrees().set(0, (Object)newFolderObject);
        this._jomaObject = typeDefinition;
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Name", this._name);
        list.addProperty("Desc", this._desc);
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsProperty("Name")) {
            this._name = map.getProperty("Name");
        }
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
    }
}

