/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.ConfigurableObject;
import com.sas.batch.appmeta.Configuration;
import com.sas.batch.appmeta.Services;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Service
extends ConfigurableObject
implements MultiLocaleProperties {
    private String _classIdentifier;
    private boolean _isSecured = false;
    private int _major = -1;
    private int _minor = -1;
    private int _objectType = -1;
    private String _path = null;
    private String _serviceType;
    private final String DEFAULT_SERVICE_TYPE = "Java";
    private String _softwareVersion;
    private String _action;
    private Services _parent = null;
    private final String CONFIG_KEY = "Config";

    private Service(Services parent) {
        super(parent.getApplication().getContext());
        this._parent = parent;
    }

    static Service create(Services parent) {
        Service svc = new Service(parent);
        return svc;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        String objectType;
        String minorVersion;
        String majorVersion;
        if (xml.hasAttribute("Name")) {
            this._name = xml.getAttribute("Name");
        }
        if (xml.hasAttribute("ClassIdentifier")) {
            this._classIdentifier = xml.getAttribute("ClassIdentifier");
        }
        if (xml.hasAttribute("_Action")) {
            this._action = xml.getAttribute("_Action");
        }
        if (xml.hasAttribute("Desc")) {
            this._desc = xml.getAttribute("Desc");
        }
        this._isSecured = Boolean.parseBoolean(xml.getAttribute("IsSecured"));
        if (xml.hasAttribute("Major") && (majorVersion = xml.getAttribute("Major")).length() > 0) {
            this._major = Integer.parseInt(majorVersion);
        }
        if (xml.hasAttribute("Minor") && (minorVersion = xml.getAttribute("Minor")).length() > 0) {
            this._minor = Integer.parseInt(minorVersion);
        }
        if (xml.hasAttribute("ObjectType") && (objectType = xml.getAttribute("ObjectType")).length() > 0) {
            this._objectType = Integer.parseInt(objectType);
        }
        if (xml.hasAttribute("Path")) {
            this._path = xml.getAttribute("Path");
        }
        if (xml.hasAttribute("ServiceType")) {
            this._serviceType = xml.getAttribute("ServiceType");
        }
        if (xml.hasAttribute("SoftwareVersion")) {
            this._softwareVersion = xml.getAttribute("SoftwareVersion");
        }
        NodeList nodes = xml.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            String tagName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals("Configuration")) continue;
            this._configuration = Configuration.create(this);
            this._configuration.loadFromXML(element);
        }
        this.loadKeywordsFromXML(xml);
    }

    void mergeToMetadata() throws MdException {
        try {
            SoftwareComponent applicationComponent = (SoftwareComponent)this._parent.getApplication().getJomaObject();
            for (Object item : applicationComponent.getDeployedComponents()) {
                Root member = (Root)item;
                if (!member.getName().equals(this._name) || !(member instanceof DeployedComponent) || !((DeployedComponent)member).getClassIdentifier().equals(this._classIdentifier)) continue;
                this._jomaObject = member;
                break;
            }
            if ("Delete".equals(this._action)) {
                if (this._jomaObject != null) {
                    this.deleteContainedObjects();
                    this._jomaObject.delete();
                }
                return;
            }
            DeployedComponent service = (DeployedComponent)this._jomaObject;
            HashMap<String, Property> serviceProperties = new HashMap<String, Property>(6);
            MdObjectStore store = (MdObjectStore)applicationComponent.getObjectStore();
            String reposId = applicationComponent.getId().substring(0, 8);
            if (this._jomaObject == null) {
                service = (DeployedComponent)store.getFactory().createComplexMetadataObject(store, this._name, "DeployedComponent", reposId);
                service.getTrees().add((Object)this._parent.getServicesTree(true));
            } else {
                if ("Create".equals(this._action)) {
                    return;
                }
                ArrayList properties = new ArrayList(service.getProperties());
                for (Property property : properties) {
                    if (serviceProperties.containsKey(property.getPropertyName())) {
                        property.delete();
                        continue;
                    }
                    serviceProperties.put(property.getPropertyName(), property);
                }
            }
            service.setDesc(this._desc);
            service.setClassIdentifier(this._classIdentifier);
            if (this._major >= 0) {
                service.setMajor(this._major);
            }
            if (this._minor >= 0) {
                service.setMinor(this._minor);
            }
            service.setSoftwareVersion(this._softwareVersion);
            service.setDescriptiveComponent((SoftwareComponent)this._parent.getApplication().getJomaObject());
            this._jomaObject = service;
            Property isSecuredProperty = (Property)serviceProperties.get("IsSecured");
            if (isSecuredProperty == null) {
                isSecuredProperty = (Property)store.getFactory().createComplexMetadataObject(store, "IsSecured", "Property", reposId);
                isSecuredProperty.setPropertyName("IsSecured");
                isSecuredProperty.setAssociatedObject((Root)service);
            }
            isSecuredProperty.setSQLType(12);
            isSecuredProperty.setDefaultValue(String.valueOf(this._isSecured));
            Property objectTypeProperty = (Property)serviceProperties.get("ObjectType");
            if (this._objectType >= 0) {
                if (objectTypeProperty == null) {
                    objectTypeProperty = (Property)store.getFactory().createComplexMetadataObject(store, "ObjectType", "Property", reposId);
                    objectTypeProperty.setPropertyName("ObjectType");
                    objectTypeProperty.setAssociatedObject((Root)service);
                }
                objectTypeProperty.setSQLType(12);
                objectTypeProperty.setDefaultValue(Integer.toString(this._objectType));
            } else if (objectTypeProperty != null) {
                objectTypeProperty.delete();
                serviceProperties.remove("ObjectType");
            }
            Property pathProperty = (Property)serviceProperties.get("Path");
            if (this._path != null) {
                if (pathProperty == null) {
                    pathProperty = (Property)store.getFactory().createComplexMetadataObject(store, "Path", "Property", reposId);
                    pathProperty.setPropertyName("Path");
                    pathProperty.setAssociatedObject((Root)service);
                }
                pathProperty.setSQLType(12);
                pathProperty.setDefaultValue(this._path);
            } else if (pathProperty != null) {
                pathProperty.delete();
                serviceProperties.remove("Path");
            }
            Property serviceTypeProperty = (Property)serviceProperties.get("ServiceType");
            if (this._serviceType != null) {
                if (serviceTypeProperty == null) {
                    serviceTypeProperty = (Property)store.getFactory().createComplexMetadataObject(store, "Service Type", "Property", reposId);
                    serviceTypeProperty.setPropertyName("ServiceType");
                    serviceTypeProperty.setAssociatedObject((Root)service);
                }
                serviceTypeProperty.setSQLType(12);
                serviceTypeProperty.setDefaultValue(this._serviceType);
            } else if (serviceTypeProperty != null) {
                serviceTypeProperty.delete();
                serviceProperties.remove("ServiceType");
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        if (this._configuration != null) {
            this._configuration.mergeToMetadata();
        }
        this.mergeKeywordMetadata();
    }

    void loadFromMetadata(DeployedComponent component, Element parent) throws MdException {
        this._jomaObject = component;
        Element service = parent.getOwnerDocument().createElement("Service");
        parent.appendChild(service);
        try {
            this._name = component.getName();
            this._classIdentifier = component.getClassIdentifier();
            this._desc = component.getDesc();
            this._major = component.getMajor();
            this._minor = component.getMinor();
            this._softwareVersion = component.getSoftwareVersion();
            for (Object item : component.getProperties()) {
                Property property = (Property)item;
                String propertyName = property.getPropertyName();
                if ("IsSecured".equals(propertyName)) {
                    this._isSecured = Boolean.parseBoolean(property.getDefaultValue());
                    continue;
                }
                if ("ObjectType".equals(propertyName)) {
                    try {
                        this._objectType = Integer.parseInt(property.getDefaultValue());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("Path".equals(propertyName)) {
                    this._path = property.getDefaultValue();
                    continue;
                }
                if (!"ServiceType".equals(propertyName)) continue;
                this._serviceType = property.getDefaultValue();
            }
            if (this._name != null) {
                service.setAttribute("Name", this._name);
            }
            if (this._desc != null) {
                service.setAttribute("Desc", this._desc);
            }
            if (this._classIdentifier != null) {
                service.setAttribute("ClassIdentifier", this._classIdentifier);
            }
            if (this._isSecured) {
                service.setAttribute("IsSecured", "true");
            }
            if (this._major >= 0) {
                service.setAttribute("Major", Integer.toString(this._major));
            }
            if (this._minor >= 0) {
                service.setAttribute("Minor", Integer.toString(this._minor));
            }
            if (this._objectType >= 0) {
                service.setAttribute("ObjectType", Integer.toString(this._objectType));
            }
            if (this._path != null) {
                service.setAttribute("Path", this._path);
            }
            if (this._serviceType != null) {
                service.setAttribute("ServiceType", this._serviceType);
            } else {
                service.setAttribute("ServiceType", "Java");
            }
            if (this._softwareVersion != null) {
                service.setAttribute("SoftwareVersion", this._softwareVersion);
            }
            this.loadKeywordsFromMetadata(service);
            for (Object item : this._jomaObject.getPropertySets()) {
                PropertySet set = (PropertySet)item;
                if (!set.getName().equals("Application Configuration")) continue;
                this._configuration = Configuration.create(this);
                this._configuration.loadFromMetadata(set, service);
                break;
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Desc", this._desc);
        if (this._configuration != null) {
            list.addProperty("Config", this._configuration.getLocalizableProperties());
        }
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
        if (this._configuration != null && map.containsNestedProperty("Config")) {
            this._configuration.setLocalizableProperties(map.getNestedProperties("Config"));
        }
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        if (this._configuration != null) {
            this._configuration.beginLocalization();
        }
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        if (this._configuration != null && map.containsNestedProperty("Config")) {
            this._configuration.setLocalizableProperties(locale, map.getNestedProperties("Config"));
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        if (this._configuration != null) {
            this._configuration.endLocalization();
        }
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        if (this._configuration != null) {
            list.addProperty("Config", this._configuration.getLocalizableProperties(locale));
        }
        return list;
    }

    public Collection<Locale> getLocales() throws UnexpectedLocalizationException {
        if (this._configuration != null) {
            return this._configuration.getLocales();
        }
        return null;
    }
}

