/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.MetadataBase;
import com.sas.batch.appmeta.RB;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Element;

final class Login
extends MetadataBase {
    MetadataBase _parent = null;
    String _userId = null;
    String _password = null;
    String _authenticationDomain = null;

    Login(MetadataBase parent) {
        super(parent.getContext());
        this._parent = parent;
    }

    static Login create(MetadataBase parent, String name, Element xml) throws AppMetaException {
        Login login = new Login(parent);
        login.loadFromXML(xml);
        login._name = name + "@" + login._authenticationDomain;
        return login;
    }

    private void loadFromXML(Element xml) throws AppMetaException {
        this._userId = xml.getAttribute("UserId");
        if (this._userId.trim().length() == 0) {
            throw new AppMetaException("Login for UserGroup \"" + this._parent.getName() + "\" has blank or missing USerId.");
        }
        this._password = xml.getAttribute("Password");
        this._authenticationDomain = xml.getAttribute("AuthenticationDomain");
        if (!Names.validateOMRObjectName((String)this._authenticationDomain, (boolean)false) || this._authenticationDomain.contains("'") || this._authenticationDomain.contains("\"")) {
            throw new AppMetaException("\"" + this._authenticationDomain + "\" is an invalid authentication domain name.");
        }
    }

    void mergeToMetadata() throws MdException {
        com.sas.metadata.remote.Login login;
        try {
            AuthenticationDomain domain;
            Identity identity;
            Identity parentObject = (Identity)this._parent.getJomaObject();
            for (com.sas.metadata.remote.Login existingLogin : parentObject.getLogins()) {
                AuthenticationDomain domain2 = existingLogin.getDomain();
                if (domain2 == null || !this._authenticationDomain.equalsIgnoreCase(domain2.getName())) continue;
                this._jomaObject = existingLogin;
                break;
            }
            if (this._jomaObject != null) {
                return;
            }
            MdObjectStore store = (MdObjectStore)parentObject.getObjectStore();
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            List logins = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "Login", 8584, "<XMLSelect search=\"*[@UserId='" + StringEscapeUtils.escapeXml((String)this._userId) + "']\"/>");
            if (!(logins.size() <= 0 || (identity = ((com.sas.metadata.remote.Login)logins.get(0)).getAssociatedIdentity()) != null && identity.getName().equalsIgnoreCase(this._parent.getName()))) {
                this._context.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"Login.LoginAreadyDefined.fmt.log", (Object)this._userId, (Object)this._parent.getName()));
                this._context.declareWarning();
                return;
            }
            String reposId = parentObject.getId().substring(0, 8);
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "AuthenticationDomain", 392, "<XMLSelect search=\"*[@Name='" + StringEscapeUtils.escapeXml((String)this._authenticationDomain) + "']\"/>");
            if (objects.size() > 0) {
                domain = (AuthenticationDomain)objects.get(0);
            } else {
                domain = (AuthenticationDomain)store.getFactory().createComplexMetadataObject(store, this._authenticationDomain, "AuthenticationDomain", reposId);
                domain.setPublicType("AuthenticationDomain");
                domain.setUsageVersion(1000000.0);
            }
            login = (com.sas.metadata.remote.Login)store.getFactory().createComplexMetadataObject(store, this._name, "Login", reposId);
            login.setPublicType("Login");
            login.setUsageVersion(1000000.0);
            login.setUserID(this._userId);
            login.setPassword(this._password);
            login.setDomain(domain);
            login.setAssociatedIdentity(parentObject);
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        this._jomaObject = login;
    }
}

