/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.HubIntegration;
import com.sas.batch.appmeta.MetadataBase;
import com.sas.batch.appmeta.RB;
import com.sas.batch.appmeta.XMLNamespaceFilter;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SectionedPropertyList;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class HubDirective
extends MetadataBase
implements MultiLocaleProperties {
    private HubIntegration parent = null;
    private String action = null;
    private Element element = null;
    private SectionedPropertyList multiLocaleResources = null;
    private Set<Locale> locales = null;
    static final String HUB_DIRECTIVE_TEXT_ROLE = "HubDirective";
    static final String HUB_DIRECTIVE_ELEMENT = "HubDirective";
    static final String RESOURCES_ELEMENT = "LocalizationResources";

    private HubDirective(HubIntegration parent) {
        super(parent.getApplication().getContext());
        this.parent = parent;
    }

    static HubDirective create(HubIntegration parent) {
        HubDirective directive = new HubDirective(parent);
        return directive;
    }

    HubIntegration getParent() {
        return this.parent;
    }

    void loadFromXML(Element xml) {
        try {
            this.action = xml.getAttribute("_Action");
            this._name = xml.getAttribute("Name");
            this._desc = xml.getAttribute("Desc");
            this.element = xml;
            this._context.stripNamespace(this.element);
        }
        catch (Exception e) {
            this._context.getLogger().warn(RB.getStringResource("HubDirective.ParseError.log"));
            this._context.getLogger().warn(e.getLocalizedMessage());
            this._context.declareWarning();
        }
    }

    void loadFromMetadata(TextStore note, Element parent) throws MdException {
        String xml = null;
        try {
            this._name = note.getName();
            this._desc = note.getDesc();
            xml = note.getStoredText();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            SAXSource source = new SAXSource(new XMLNamespaceFilter("http://www.sas.com/xml/schema/namespace/ApplicationMetadata-9.4M3"), new InputSource(new StringReader(xml)));
            DOMResult result = new DOMResult(parent);
            transformer.transform(source, result);
            this.element = (Element)parent.getLastChild();
            if (!this.element.getNodeName().equals("HubDirective")) {
                this._context.getLogger().error("XML in for HubDirective \"" + this._name + "\" is not a hub directive.  Removing this directive.");
                this._context.declareError();
                this.element.removeChild(this.element);
                this.element = null;
            }
            if (!this._name.equals(this.element.getAttribute("Name"))) {
                this._context.getLogger().warn("XML name for HubDirective \"" + this._name + "\" does not match metadata.");
                this._context.declareWarning();
                this.element.setAttribute("Name", this._name);
            }
            if (!this._desc.equals(this.element.getAttribute("Desc"))) {
                this._context.getLogger().warn("XML desc for HubDirective \"" + this._name + "\" does not match metadata.");
                this._context.declareWarning();
                this.element.setAttribute("Desc", this._desc);
            }
        }
        catch (Exception e) {
            this._context.getLogger().warn(RB.getStringResource("HubDirective.TransformError.log"));
            this._context.getLogger().warn(e.getLocalizedMessage());
            this._context.declareWarning();
        }
        NodeList childNodes = this.element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(RESOURCES_ELEMENT)) continue;
            this.element.removeChild(child);
            break;
        }
    }

    void mergeToMetadata() throws MdException {
        try {
            SoftwareComponent applicationObject = (SoftwareComponent)this.parent.getApplication().getJomaObject();
            AssociationList notes = applicationObject.getNotes();
            for (TextStore note : notes) {
                if (!note.getTextRole().equals("HubDirective") || !note.getName().equals(this._name)) continue;
                this._jomaObject = note;
                break;
            }
            if ("Delete".equals(this.action)) {
                if (this._jomaObject != null) {
                    this._jomaObject.delete();
                }
                return;
            }
            TextStore note = (TextStore)this._jomaObject;
            if (note == null) {
                MdObjectStore store = (MdObjectStore)applicationObject.getObjectStore();
                String reposId = applicationObject.getId().substring(0, 8);
                note = (TextStore)store.getFactory().createComplexMetadataObject(store, this._name, "TextStore", reposId);
                applicationObject.getNotes().add((Object)note);
                this._jomaObject = note;
            } else if ("Create".equals(this.action)) {
                return;
            }
            note.setDesc(this._desc);
            note.setTextRole("HubDirective");
            note.setTextType("XML");
            note.setStoredText(this._context.getEmbeddedXML(this.element).replace("\r", ""));
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (Exception e) {
            this._context.getLogger().warn(RB.getStringResource("HubDirective.ParseError.log"));
            this._context.getLogger().warn(e.getLocalizedMessage());
            this._context.declareWarning();
        }
    }

    public PropertyList getLocalizableProperties() {
        PropertyList list = new PropertyList();
        if (this._desc != null && this._desc.length() > 0) {
            list.addProperty("Desc", this._desc);
        }
        this.scanForLocalizedResources(this.element, null, list);
        return list;
    }

    private void scanForLocalizedResources(Element node, String keyPrefix, PropertyList list) {
        if (keyPrefix == null) {
            keyPrefix = "";
        } else {
            if (keyPrefix.length() > 0) {
                keyPrefix = keyPrefix + ".";
            }
            keyPrefix = keyPrefix + node.getNodeName();
            if (node.hasAttribute("Name")) {
                keyPrefix = keyPrefix + "." + node.getAttribute("Name");
            } else if (node.hasAttribute("name")) {
                keyPrefix = keyPrefix + "." + node.getAttribute("name");
            }
            HashMap<String, String> resourceKeys = new HashMap<String, String>();
            HashMap<String, String> resourceValues = new HashMap<String, String>();
            NamedNodeMap attributes = node.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node child = attributes.item(i);
                if (child.getNodeType() != 2) continue;
                String nodeName = child.getNodeName();
                if (nodeName.endsWith(".key")) {
                    resourceKeys.put(nodeName.substring(0, nodeName.length() - 4), child.getNodeValue());
                    continue;
                }
                if (!nodeName.endsWith(".loc")) continue;
                resourceValues.put(nodeName.substring(0, nodeName.length() - 4), child.getNodeValue());
            }
            for (String key : resourceValues.keySet()) {
                if (resourceKeys.containsKey(key)) continue;
                resourceKeys.put(key, keyPrefix + "." + key);
                node.setAttribute(key + ".key", keyPrefix + "." + key);
            }
            for (String key : resourceKeys.keySet()) {
                String value = (String)resourceValues.get(key);
                if (value == null) {
                    value = "";
                }
                list.addProperty((String)resourceKeys.get(key), (String)resourceValues.get(key));
            }
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            this.scanForLocalizedResources((Element)child, keyPrefix, list);
        }
    }

    public void setLocalizableProperties(PropertyMap map) {
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
    }

    public void beginLocalization() {
        this.multiLocaleResources = new SectionedPropertyList("Localization resources for Hub directive " + this._name);
        this.multiLocaleResources.addSection("", this.getLocalizableProperties());
        this.locales = new HashSet<Locale>();
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        PropertyList list = new PropertyList();
        Iterator iter = map.getPropertyIterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            list.addProperty(key, map.getProperty(key));
        }
        this.multiLocaleResources.addSection(locale.toString(), list);
        this.locales.add(locale);
    }

    public void endLocalization() {
        StringWriter writer = new StringWriter();
        try {
            this.multiLocaleResources.save((Writer)writer);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        Element resourcesElement = this.element.getOwnerDocument().createElement(RESOURCES_ELEMENT);
        String text = ((Object)writer).toString();
        resourcesElement.appendChild(this.element.getOwnerDocument().createCDATASection(((Object)writer).toString()));
        this.element.appendChild(resourcesElement);
    }

    public PropertyList getLocalizableProperties(Locale locale) {
        throw new UnsupportedOperationException();
    }

    public Collection<Locale> getLocales() {
        return this.locales;
    }
}

