/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.Application;
import com.sas.batch.appmeta.ApplicationMetadataUtility;
import com.sas.batch.appmeta.Capability;
import com.sas.batch.appmeta.RB;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.metadata.remote.AccessControl;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.ApplicationAction;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class CapabilityCategory
implements LocalizableProperties {
    private Application _application = null;
    private CapabilityCategory _parent = null;
    private String _name = null;
    private String _originalName = null;
    private String _desc = null;
    private String _categoryName = null;
    private String _action = null;
    private Tree _jomaObject = null;
    private List<CapabilityCategory> _subCategories = new CopyOnWriteArrayList<CapabilityCategory>();
    private List<Capability> _capabilities = new CopyOnWriteArrayList<Capability>();
    private Map<String, ApplicationAction> _existingCapabilityObjects = null;

    private CapabilityCategory() {
    }

    static CapabilityCategory create(Application app, CapabilityCategory parent) {
        CapabilityCategory category = new CapabilityCategory();
        category._application = app;
        category._parent = parent;
        return category;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        if (xml.getTagName().equals("Capabilities")) {
            this._name = "ApplicationActions";
        } else {
            this._originalName = this._name = xml.getAttribute("Name");
            if (this._name.trim().length() == 0) {
                throw new AppMetaException("Category has blank Name attribute.");
            }
            this._desc = xml.getAttribute("Desc");
            this._categoryName = xml.hasAttribute("CategoryName") ? xml.getAttribute("CategoryName") : this._name;
        }
        this._action = xml.getAttribute("_Action");
        NodeList nodes = xml.getChildNodes();
        if ("Delete".equals(this._action) && nodes.getLength() > 0) {
            if (xml.getTagName().equals("Capabilities")) {
                throw new AppMetaException("Capabilities cannot contain elements when _Action='Delete' is specified.");
            }
            throw new AppMetaException("Category \"" + this._name + "\" cannot contain elements when _Action='Delete' is specified.");
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName.equals("Capability")) {
                Capability capability = Capability.create(this);
                capability.loadFromXML(element);
                this._capabilities.add(capability);
                if (this._application.addCapability(capability)) continue;
                this._application.getContext().getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"CapabilityCategory.DupCapability.fmt.log", (Object)capability.getId()));
                this._application.getContext().declareWarning();
                continue;
            }
            if (!tagName.equals("Category")) continue;
            CapabilityCategory category = CapabilityCategory.create(this._application, this);
            category.loadFromXML(element);
            this._subCategories.add(category);
        }
    }

    void loadFromMetadata(Tree tree, Element parent) throws MdException {
        this._jomaObject = tree;
        this.getObjectAttributes();
        Element cat = null;
        try {
            if (this._parent == null) {
                cat = parent.getOwnerDocument().createElement("Capabilities");
            } else {
                cat = parent.getOwnerDocument().createElement("Category");
                cat.setAttribute("Name", this._name);
                cat.setAttribute("Desc", this._desc);
                Iterator categoryNameProperty = this.findCategoryNameProperty(tree);
                this._categoryName = categoryNameProperty != null ? categoryNameProperty.getDefaultValue() : this._name;
                cat.setAttribute("CategoryName", this._categoryName);
            }
            for (Object item : tree.getSubTrees()) {
                Tree subtree = (Tree)item;
                CapabilityCategory subcat = CapabilityCategory.create(this._application, this);
                subcat.loadFromMetadata(subtree, cat);
                this._subCategories.add(subcat);
            }
            for (Object item : tree.getMembers()) {
                if (!(item instanceof ApplicationAction)) continue;
                ApplicationAction action = (ApplicationAction)item;
                Capability cap = Capability.create(this);
                cap.loadFromMetadata(action, cat);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        parent.appendChild(cat);
    }

    void getObjectAttributes() {
        try {
            this._name = this._jomaObject.getName();
            this._desc = this._jomaObject.getDesc();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    Application getApplication() {
        return this._application;
    }

    CapabilityCategory getParent() {
        return this._parent;
    }

    String getName() {
        return this._name;
    }

    String getDesc() {
        return this._desc;
    }

    Tree getJomaObject() {
        return this._jomaObject;
    }

    List<CapabilityCategory> getSubCategories() {
        return this._subCategories;
    }

    List<Capability> getCapabilities() {
        return this._capabilities;
    }

    Map<String, ApplicationAction> getExistingCapabilityObjects() {
        return this._existingCapabilityObjects;
    }

    void mergeToMetadata() throws MdException {
        try {
            if (this._parent == null) {
                this._desc = this._application.getName() != null ? "Capability definitions for " + this._application.getName() : null;
                AssociationList trees = ((SoftwareComponent)this._application.getJomaObject()).getSoftwareTrees();
                for (Tree tree : trees) {
                    if (!tree.getName().equals("ApplicationActions")) continue;
                    this._jomaObject = tree;
                    if (this._desc == null || this._jomaObject.getDesc().equals(this._desc)) break;
                    this._jomaObject.setDesc(this._desc);
                    break;
                }
                if ("Delete".equals(this._action)) {
                    if (this._jomaObject != null) {
                        this.deleteMetadata(this._jomaObject);
                    }
                    this._application.removeAllCapabilities();
                    return;
                }
                if (this._jomaObject == null) {
                    this.createInMetadata();
                } else {
                    this.loadExistingCapabilityObjects();
                }
            } else {
                for (Tree tree : this._parent.getJomaObject().getSubTrees()) {
                    Property categoryName = this.findCategoryNameProperty(tree);
                    if (categoryName != null) {
                        if (!categoryName.getDefaultValue().equals(this._categoryName)) continue;
                        this._jomaObject = tree;
                        break;
                    }
                    String treeName = tree.getName();
                    if (!treeName.equals(this._name) && !treeName.equals(this._originalName)) continue;
                    this._jomaObject = tree;
                    break;
                }
                if ("Delete".equals(this._action)) {
                    if (this._jomaObject != null) {
                        this.deleteMetadata(this._jomaObject);
                    }
                    this._parent.removeCategory(this);
                    return;
                }
                if (this._jomaObject == null) {
                    this.createInMetadata();
                } else if (!"Create".equals(this._action)) {
                    this.updateInMetadata();
                }
                this._existingCapabilityObjects = this._parent._existingCapabilityObjects;
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        for (CapabilityCategory category : this._subCategories) {
            category.mergeToMetadata();
        }
        for (Capability capability : this._capabilities) {
            capability.mergeToMetadata();
        }
    }

    private void deleteMetadata(Tree categoryObject) throws RemoteException, MdException {
        for (Tree subCategoryObject : new ArrayList(categoryObject.getSubTrees())) {
            this.deleteMetadata(subCategoryObject);
        }
        for (Root capabilityObject : new ArrayList(categoryObject.getMembers())) {
            for (AccessControl accessControl : new ArrayList(capabilityObject.getAccessControls())) {
                if (!(accessControl instanceof AccessControlEntry)) continue;
                accessControl.delete();
            }
            capabilityObject.delete();
        }
        for (Property property : new ArrayList(categoryObject.getProperties())) {
            property.delete();
        }
        for (AccessControl accessControl : new ArrayList(categoryObject.getAccessControls())) {
            if (!(accessControl instanceof AccessControlEntry)) continue;
            accessControl.delete();
        }
        categoryObject.delete();
    }

    void createInMetadata() throws RemoteException, MdException {
        MdObjectStore store = (MdObjectStore)this._application.getJomaObject().getObjectStore();
        this._jomaObject = (Tree)store.getFactory().createComplexMetadataObject(store, this._name, "Tree", this._application.getJomaObject().getId().substring(0, 8));
        if (this._parent == null) {
            this._jomaObject.getSoftwareComponents().add((Object)this._application.getJomaObject());
        } else {
            this._jomaObject.setParentTree(this._parent.getJomaObject());
        }
        if (this._desc != null) {
            this._jomaObject.setDesc(this._desc);
        }
        this._jomaObject.setTreeType("ApplicationActions");
        if (this._categoryName != null && this._categoryName.length() > 0) {
            this.createCategoryNameProperty();
        }
    }

    void updateInMetadata() throws RemoteException, MdException {
        Property categoryName;
        if (!this._jomaObject.getName().equals(this._name)) {
            this._jomaObject.setName(this._name);
        }
        if (!this._jomaObject.getDesc().equals(this._desc)) {
            this._jomaObject.setDesc(this._desc);
        }
        if (this._categoryName != null && this._categoryName.length() > 0 && (categoryName = this.findCategoryNameProperty(this._jomaObject)) == null) {
            this.createCategoryNameProperty();
        }
    }

    private Property findCategoryNameProperty(Tree category) throws RemoteException, MdException {
        AssociationList properties = category.getProperties();
        for (Property property : properties) {
            if (!property.getPropertyName().equals("CategoryName")) continue;
            return property;
        }
        return null;
    }

    private void createCategoryNameProperty() throws RemoteException {
        MdObjectStore store = (MdObjectStore)this._jomaObject.getObjectStore();
        Property property = (Property)store.getFactory().createComplexMetadataObject(store, "Category Name", "Property", this._jomaObject.getId().substring(0, 8));
        property.setAssociatedObject((Root)this._jomaObject);
        property.setPropertyName("CategoryName");
        property.setSQLType(12);
        property.setDefaultValue(this._categoryName);
    }

    private void loadExistingCapabilityObjects() throws MdException {
        this._existingCapabilityObjects = new HashMap<String, ApplicationAction>();
        this.loadExistingCapabilityObjects(this._jomaObject, this._existingCapabilityObjects);
    }

    private void loadExistingCapabilityObjects(Tree category, Map<String, ApplicationAction> capabilities) throws MdException {
        try {
            for (CMetadata member : category.getMembers()) {
                if (!(member instanceof ApplicationAction)) continue;
                ApplicationAction capability = (ApplicationAction)member;
                capabilities.put(capability.getActionIdentifier(), capability);
            }
            for (Tree subCategory : category.getSubTrees()) {
                this.loadExistingCapabilityObjects(subCategory, capabilities);
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void denyPublicExecute(ISecurityAdmin iSecAdmin) {
        String id;
        if (this._jomaObject == null) {
            return;
        }
        String[][] authorizations = new String[][]{{"IdentityGroup", "PUBLIC", "D", "Execute", ""}};
        ApplicationMetadataUtility context = this._application.getContext();
        try {
            id = this._jomaObject.getId();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        String capabilityURN = "omsobj:Tree/" + id;
        if (context.isDebug()) {
            context.getLogger().debug("Deny Execute on CapabilityCategory " + id + " to PUBLIC.");
        }
        try {
            iSecAdmin.SetAuthorizationsOnObj("", capabilityURN, 0, authorizations);
        }
        catch (Exception e) {
            context.getLogger().error(Message.format((ResourceBundle)RB.getResources(), (String)"CapabilityCategory.DenyFailed.fmt.log", (Object)id, (Object)this._name));
            context.getLogger().error("  " + e.getLocalizedMessage());
            context.declareError();
        }
    }

    void removeCategory(CapabilityCategory category) {
        this._subCategories.remove(category);
    }

    void removeCapability(Capability capability) {
        this._capabilities.remove(capability);
        this._application.removeCapabilities(capability);
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        if (this._parent != null) {
            list.addProperty("Name", this._name);
            list.addProperty("Desc", this._desc);
        }
        PropertyList catList = new PropertyList();
        for (CapabilityCategory category : this._subCategories) {
            catList.addProperty(category.getName(), category.getLocalizableProperties());
        }
        list.addProperty("Category", catList);
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        PropertyMap catMap;
        if (this._parent != null) {
            if (map.containsProperty("Name")) {
                this._name = map.getProperty("Name");
            }
            if (map.containsProperty("Desc")) {
                this._desc = map.getProperty("Desc");
            }
        }
        if ((catMap = map.getNestedProperties("Category")) != null) {
            for (CapabilityCategory category : this._subCategories) {
                String propertyName = category.getName();
                if (!catMap.containsNestedProperty(propertyName)) continue;
                category.setLocalizableProperties(catMap.getNestedProperties(propertyName));
            }
        }
    }
}

