/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.CapabilityCategory;
import com.sas.batch.appmeta.Role;
import com.sas.metadata.remote.AccessControl;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.ApplicationAction;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Permission;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.w3c.dom.Element;

final class Capability
implements LocalizableProperties {
    private CapabilityCategory _category = null;
    private String _id = null;
    private String _name = null;
    private String _desc = null;
    private String _type = null;
    private String _action = null;
    private ApplicationAction _jomaObject = null;

    private Capability() {
    }

    static Capability create(CapabilityCategory category) {
        Capability capability = new Capability();
        capability._category = category;
        return capability;
    }

    CapabilityCategory getCategory() {
        return this._category;
    }

    String getId() {
        return this._id;
    }

    String getName() {
        return this._name;
    }

    String getDesc() {
        return this._desc;
    }

    String getType() {
        return this._type;
    }

    ApplicationAction getJomaObject() {
        return this._jomaObject;
    }

    void loadFromXML(Element xml) throws AppMetaException {
        this._name = xml.getAttribute("Name");
        this._id = xml.getAttribute("CapabilityId");
        if (this._id.length() == 0) {
            this._id = this._name;
        }
        this._action = xml.getAttribute("_Action");
        this._desc = xml.getAttribute("Desc");
        this._type = xml.getAttribute("CapabilityType");
        if (this._type.length() == 0) {
            this._type = "Feature";
        }
        if (!("Delete".equals(this._action) || this._name != null && this._name.length() != 0)) {
            throw new AppMetaException("Name and CapabilityId must be specified for Capability elements.");
        }
    }

    private void getObjectAttributes() {
        try {
            this._name = this._jomaObject.getName();
            this._desc = this._jomaObject.getDesc();
            this._id = this._jomaObject.getActionIdentifier();
            this._type = this._jomaObject.getActionType();
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void loadFromMetadata(ApplicationAction action, Element parent) throws MdException {
        this._jomaObject = action;
        this.getObjectAttributes();
        Element cap = parent.getOwnerDocument().createElement("Capability");
        parent.appendChild(cap);
        cap.setAttribute("Name", this._name);
        cap.setAttribute("Desc", this._desc);
        cap.setAttribute("CapabilityId", this._id);
        if (!"Feature".equals(this._type)) {
            cap.setAttribute("CapabilityType", this._type);
        }
        this._category.getApplication().addCapability(this);
        try {
            for (Object aceObject : action.getAccessControls()) {
                AccessControlEntry ace;
                Permission perm;
                if (!(aceObject instanceof AccessControlEntry) || !(perm = (Permission)(ace = (AccessControlEntry)aceObject).getPermissions().get(0)).getName().equals("Execute") || !perm.getType().equals("GRANT")) continue;
                for (Object identityObject : ace.getIdentities()) {
                    IdentityGroup roleObject;
                    if (!(identityObject instanceof IdentityGroup) || !(roleObject = (IdentityGroup)identityObject).getPublicType().equals("Role")) continue;
                    Role role = Role.createAssociatedRole(this._category.getApplication().getContext(), roleObject);
                    role.addCapability(this._id);
                }
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    void mergeToMetadata() throws MdException {
        try {
            if (this._category.getExistingCapabilityObjects() != null) {
                this._jomaObject = this._category.getExistingCapabilityObjects().get(this._id);
            }
            if ("Delete".equals(this._action)) {
                if (this._jomaObject != null) {
                    this.deleteMetadata();
                }
                this._category.removeCapability(this);
                return;
            }
            if (this._jomaObject == null) {
                MdObjectStore store = (MdObjectStore)this._category.getJomaObject().getObjectStore();
                this._jomaObject = (ApplicationAction)store.getFactory().createComplexMetadataObject(store, this._name, "ApplicationAction", this._category.getJomaObject().getId().substring(0, 8));
                this._jomaObject.getTrees().add((Object)this._category.getJomaObject());
            } else {
                if ("Create".equals(this._action)) {
                    return;
                }
                this._jomaObject.setName(this._name);
                if (this._jomaObject.getTrees().get(0) != this._category.getJomaObject()) {
                    this._jomaObject.getTrees().set(0, (Object)this._category.getJomaObject());
                }
            }
            this._jomaObject.setDesc(this._desc);
            this._jomaObject.setActionIdentifier(this._id);
            this._jomaObject.setActionType(this._type);
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        PropertyList list = new PropertyList();
        list.addProperty("Name", this._name);
        list.addProperty("Desc", this._desc);
        return list;
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        if (map.containsProperty("Name")) {
            this._name = map.getProperty("Name");
        }
        if (map.containsProperty("Desc")) {
            this._desc = map.getProperty("Desc");
        }
    }

    private void deleteMetadata() throws RemoteException, MdException {
        AssociationList accessControls = this._jomaObject.getAccessControls();
        for (AccessControl accessControl : new ArrayList(accessControls)) {
            if (!(accessControl instanceof AccessControlEntry)) continue;
            accessControl.delete();
        }
        this._jomaObject.delete();
    }
}

