/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.appmeta;

import com.sas.batch.appmeta.AppMetaException;
import com.sas.batch.appmeta.Application;
import com.sas.batch.appmeta.RB;
import com.sas.batch.appmeta.Role;
import com.sas.batch.appmeta.TypeDefinition;
import com.sas.batch.appmeta.TypeGroup;
import com.sas.batch.appmeta.UserGroup;
import com.sas.batch.localsvc.LocalServicesBatchUtility2;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIChildServer;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.storage.editableproperties.LocalizationUtil2;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.SectionedPropertyList;
import com.sas.storage.editableproperties.SectionedPropertyMap;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ApplicationMetadataUtility
extends LocalServicesBatchUtility2 {
    public static final int ERROR_APP_ALREADY_EXISTS = 9;
    public static final int ERROR_APP_NOT_FOUND = 10;
    public static final String OPTION_APPLICATIONID = "applicationId";
    public static final String OPTION_APPLICATIONNAME = "applicationName";
    public static final String OPTION_FOLDER = "folder";
    public static final String OPTION_LOCALIZE = "localize";
    public static final String OPTION_LOCPROP = "locprop";
    public static final String OPTION_NOEXECUTE = "noexecute";
    public static final String OPTION_EXTRACT = "extract";
    public static final String XML_NAMESPACE_PREFIX = "http://www.sas.com/xml/schema/namespace/ApplicationMetadata";
    public static final String CURRENT_XML_NAMESPACE = "http://www.sas.com/xml/schema/namespace/ApplicationMetadata-9.4M3";
    static final String ACTION_CREATE = "Create";
    static final String ACTION_DELETE = "Delete";
    static final String ACTION_UPDATE = "Update";
    private boolean locprop = false;
    private boolean localize = false;
    private boolean noExecute = false;
    private boolean extract = false;
    private String applicationId = null;
    private String applicationName = null;
    private String folder = null;
    private String sourceXML = null;
    private URL sourceXMLURL = null;
    private InputStream sourceXMLStream = null;
    private OutputStream extractXMLStream = null;
    protected Document sourceDocument = null;
    private Application application = null;
    private Map<String, UserGroup> groups = null;
    private Map<String, Role> roles = null;
    private TypeGroup rootTypeGroup = null;

    public void setApplicationId(String id) {
        this.applicationId = id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setLocalize(boolean localize) {
        this.localize = localize;
    }

    public boolean isLocalize() {
        return this.localize;
    }

    public void setLocprop(boolean locprop) {
        this.locprop = locprop;
    }

    public boolean isLocprop() {
        return this.locprop;
    }

    public void setNoExecute(boolean noexecute) {
        this.noExecute = noexecute;
    }

    public boolean isNoExecute() {
        return this.noExecute;
    }

    public void setExtract(boolean extract) {
        this.extract = extract;
    }

    public boolean isExtract() {
        return this.extract;
    }

    public void setSourceXML(String sourceXML) {
        this.sourceXML = sourceXML;
        this.sourceXMLURL = null;
        this.sourceXMLStream = null;
    }

    public String getSourceXML() {
        return this.sourceXML;
    }

    public void setSourceXMLURL(URL sourceXML) {
        this.sourceXML = null;
        this.sourceXMLURL = sourceXML;
        this.sourceXMLStream = null;
    }

    public void setSourceXMLStream(InputStream sourceXML) {
        this.sourceXML = null;
        this.sourceXMLURL = null;
        this.sourceXMLStream = sourceXML;
    }

    public void setExtractXMLStream(OutputStream stream) {
        this.sourceXML = null;
        this.extractXMLStream = stream;
    }

    public int execute() throws Exception {
        this.application = null;
        this.rootTypeGroup = null;
        this.groups = new LinkedHashMap<String, UserGroup>();
        this.roles = new LinkedHashMap<String, Role>();
        try {
            if (!this.locprop || this.extract) {
                this.initialize();
            }
            if (this.extract) {
                this.loadFromMetadata();
                this.generateXML();
                if (this.locprop) {
                    this.generateLocProps();
                }
            } else {
                this.loadSourceXML();
                if (this.locprop) {
                    this.generateLocProps();
                } else {
                    if (this.localize) {
                        this.localize();
                    }
                    this.mergeMetadata();
                }
            }
        }
        catch (Exception e) {
            if (this.returnCode < 8) {
                this.returnCode = 8;
            }
            throw e;
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        ApplicationMetadataUtility util = new ApplicationMetadataUtility();
        util.executeBatch(args);
    }

    Map<String, Role> getRoles() {
        return this.roles;
    }

    Map<String, UserGroup> getGroups() {
        return this.groups;
    }

    private void loadSourceXML() throws AppMetaException {
        try {
            if (this.sourceXML != null) {
                this.sourceXMLStream = new FileInputStream(this.sourceXML);
            } else if (this.sourceXMLURL != null) {
                this.sourceXMLStream = this.sourceXMLURL.openStream();
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            this.sourceDocument = docBuilder.parse(this.sourceXMLStream);
            Element root = this.sourceDocument.getDocumentElement();
            this.validateSourceDocument(root);
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String tagName = element.getTagName();
                if (tagName.equals("Application")) {
                    this.application = Application.create(this);
                    this.application.loadFromXML(element);
                    continue;
                }
                if (tagName.equals("Role")) {
                    Role role = Role.create(element, this);
                    this.roles.put(role.getName(), role);
                    continue;
                }
                if (tagName.equals("UserGroup")) {
                    UserGroup group = UserGroup.create(element, this);
                    this.groups.put(group.getName(), group);
                    continue;
                }
                if (tagName.equals("TypeGroup")) {
                    if (this.rootTypeGroup == null) {
                        this.rootTypeGroup = TypeGroup.createRootTypeGroup(this);
                    }
                    TypeGroup.create(element, this.rootTypeGroup);
                    continue;
                }
                if (!tagName.equals("TypeDefinition")) continue;
                if (this.rootTypeGroup == null) {
                    this.rootTypeGroup = TypeGroup.createRootTypeGroup(this);
                }
                TypeDefinition.create(element, this.rootTypeGroup);
            }
            if (this.sourceXML != null) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.LoadedXML.fmt.log", (Object)this.sourceXML));
            } else if (this.sourceXMLURL != null) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.LoadedXML.fmt.log", (Object)this.sourceXMLURL.toString()));
            } else {
                this.logger.info(RB.getStringResource("ApplicationMetadataUtility.LoadedXMLStream.log"));
            }
            if (this.application != null) {
                String productName = this.application.getProductName();
                if (productName.length() == 0) {
                    productName = this.application.getName();
                }
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.Product.fmt.log", (Object)productName));
            }
        }
        catch (ParserConfigurationException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.ParseSourceError.txt"), e);
        }
        catch (IOException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.SourceXMLError.txt"), e);
        }
        catch (SAXException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.ParseSourceError.txt"), e);
        }
        finally {
            if (this.sourceXMLStream != null) {
                try {
                    this.sourceXMLStream.close();
                    this.sourceXMLStream = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void validateSourceDocument(Element root) throws AppMetaException, IOException, SAXException {
        if (System.getProperty("java.vendor", "").startsWith("IBM")) {
            return;
        }
        String xmlns = root.getNamespaceURI();
        String schemaName = null;
        if (xmlns == null || xmlns.length() == 0) {
            schemaName = "appmeta.xsd";
        } else if (xmlns.startsWith(XML_NAMESPACE_PREFIX)) {
            schemaName = "ApplicationMetadata" + xmlns.substring(XML_NAMESPACE_PREFIX.length()) + ".xsd";
        } else {
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidXMLNamespace.fmt.log", (Object)xmlns));
        }
        URL schemaUrl = ApplicationMetadataUtility.class.getResource(schemaName);
        if (schemaUrl == null) {
            throw new AppMetaException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.UnsupportedXMLNamespace.fmt.log", (Object)xmlns));
        }
        Schema xmlSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
        Validator validator = xmlSchema.newValidator();
        try {
            validator.validate(new DOMSource(this.sourceDocument));
        }
        catch (SAXException e) {
            if (xmlns == null || xmlns.length() == 0) {
                this.logger.info(RB.getStringResource("ApplicationMetadataUtility.MissingXMLSchema.log"));
            }
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.ParseSourceError.txt"), e);
        }
    }

    private void generateLocProps() throws IOException {
        int extOffset;
        SectionedPropertyList resources = new SectionedPropertyList();
        PropertyList header = new PropertyList();
        header.addComment("Generated by ApplicationMetadataUtility");
        header.addProperty("Created", DateFormat.getDateTimeInstance().format(new Date()));
        resources.addSection("", header);
        if (this.application != null) {
            resources.addSection("Application", this.application.getLocalizableProperties());
        }
        for (String name : this.roles.keySet()) {
            resources.addSection("Role: " + name, this.roles.get(name).getLocalizableProperties());
        }
        for (String name : this.groups.keySet()) {
            resources.addSection("UserGroup: " + name, this.groups.get(name).getLocalizableProperties());
        }
        if (this.rootTypeGroup != null) {
            String sectionName;
            for (TypeGroup group : this.rootTypeGroup.getGroups()) {
                sectionName = "TypeGroup: " + group.getPath();
                resources.addSection(sectionName, group.getLocalizableProperties());
            }
            for (TypeDefinition typeDef : this.rootTypeGroup.getDefinitions()) {
                sectionName = "Type: " + typeDef.getTypeName();
                resources.addSection(sectionName, typeDef.getLocalizableProperties());
            }
        }
        String locpropFileName = (extOffset = this.sourceXML.lastIndexOf(46)) <= 0 ? this.sourceXML + ".locprop" : this.sourceXML.substring(0, extOffset) + ".locprop";
        FileWriter locpropFileWriter = new FileWriter(locpropFileName);
        resources.save((Writer)locpropFileWriter);
        ((Writer)locpropFileWriter).close();
        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.GeneratedLocprop.fmt.log", (Object)locpropFileName));
    }

    private void localize() throws IOException {
        Map allProperties;
        if (this.sourceXML != null) {
            int extOffset = this.sourceXML.lastIndexOf(46);
            String baseFileName = extOffset <= 0 ? this.sourceXML : this.sourceXML.substring(0, extOffset);
            File baseFile = new File(baseFileName);
            allProperties = LocalizationUtil2.getMultiLocaleProperties((Logger)this.logger, (File)baseFile);
        } else {
            allProperties = this.sourceXMLURL != null ? LocalizationUtil2.getMultiLocalePropertiesFromURL((Logger)this.logger, (URL)this.sourceXMLURL) : new HashMap();
        }
        Locale defaultLocale = LocalizationUtil2.getDefaultLocale(allProperties.keySet());
        if (defaultLocale != null) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.DefaultLocale.fmt.log", (Object)defaultLocale.toString()));
        } else {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.NoDefaultLocale.fmt.log", (Object)Locale.getDefault().toString()));
        }
        SectionedPropertyMap defaultLocaleProperties = (SectionedPropertyMap)allProperties.get(defaultLocale);
        if (this.application != null) {
            this.application.beginLocalization();
            if (defaultLocaleProperties != null) {
                if (defaultLocaleProperties.containsSection("Application")) {
                    this.application.setLocalizableProperties(defaultLocaleProperties.getSection("Application"));
                } else {
                    this.logger.warn(RB.getStringResource("ApplicationMetadataUtility.MissingApplicationLocProp.log"));
                }
            }
            for (Locale locale : allProperties.keySet()) {
                SectionedPropertyMap localeProperties;
                if (locale == defaultLocale || !(localeProperties = (SectionedPropertyMap)allProperties.get(locale)).containsSection("Application")) continue;
                this.application.setLocalizableProperties(locale, localeProperties.getSection("Application"));
            }
            this.application.endLocalization();
        }
        if (defaultLocaleProperties != null) {
            String sectionName;
            for (String name : this.roles.keySet()) {
                sectionName = "Role: " + name;
                if (defaultLocaleProperties.containsSection(sectionName)) {
                    this.roles.get(name).setLocalizableProperties(defaultLocaleProperties.getSection(sectionName));
                    continue;
                }
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.MissingRoleLocProp.fmt.log", (Object)name));
            }
            for (String name : this.groups.keySet()) {
                sectionName = "UserGroup: " + name;
                if (defaultLocaleProperties.containsSection(sectionName)) {
                    this.groups.get(name).setLocalizableProperties(defaultLocaleProperties.getSection(sectionName));
                    continue;
                }
                this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.MissingUserGroupLocProp.fmt.log", (Object)name));
            }
            if (this.rootTypeGroup != null) {
                for (TypeGroup group : this.rootTypeGroup.getGroups()) {
                    sectionName = "TypeGroup: " + group.getPath();
                    if (defaultLocaleProperties.containsSection(sectionName)) {
                        group.setLocalizableProperties(defaultLocaleProperties.getSection(sectionName));
                        continue;
                    }
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.MissingLocProp.fmt.log", (Object)sectionName));
                }
                for (TypeDefinition typeDef : this.rootTypeGroup.getDefinitions()) {
                    sectionName = "Type: " + typeDef.getTypeName();
                    if (defaultLocaleProperties.containsSection(sectionName)) {
                        typeDef.setLocalizableProperties(defaultLocaleProperties.getSection(sectionName));
                        continue;
                    }
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.MissingLocProp.fmt.log", (Object)sectionName));
                }
            }
        }
    }

    private void mergeMetadata() throws Exception {
        OMIChildServer childServer = (OMIChildServer)this.metadataServer.newChild(true);
        MdObjectStore store = childServer.getObjectStore();
        if (this.application != null) {
            if (this.applicationId == null) {
                this.application.createNewApplication((MetadataServerInterface)childServer);
            } else {
                this.application.updateExistingApplication((OMIServer)childServer);
            }
        } else if (this.applicationId != null || this.applicationName != null) {
            this.application = Application.create(this);
            this.application.loadFromMetadata((MetadataServerInterface)childServer);
        }
        for (String name : this.groups.keySet()) {
            UserGroup group = this.groups.get(name);
            group.mergeToMetadata(store);
            group.addExternalReferences();
        }
        for (String name : this.roles.keySet()) {
            Role role = this.roles.get(name);
            role.mergeToMetadata(store);
            role.addExternalReferences();
        }
        if (this.rootTypeGroup != null) {
            this.rootTypeGroup.mergeToMetadata((OMIServer)childServer);
        }
        boolean newCapabilities = this.application != null && this.application.getCapabilityCategories() != null && this.application.getCapabilityCategories().getJomaObject().isNewObject();
        int changed = store.getChangedObjects().size();
        int deleted = store.getDeletedObjects().size();
        if (!this.noExecute) {
            if (changed > 0 || deleted > 0) {
                childServer.flush();
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.Updated.fmt.log", (Object)changed));
                if (deleted > 0) {
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.Deleted.fmt.log", (Object)deleted));
                }
            } else {
                this.logger.info(RB.getStringResource("ApplicationMetadataUtility.NoUpdates.log"));
            }
            if (newCapabilities) {
                MdOMRConnection connection = ((OMIServer)this.metadataServer).getMdFactory().getConnection();
                ISecurityAdmin iSecAdmin = connection.MakeISecurityAdminConnection(connection.getCMRHandle());
                this.application.getCapabilityCategories().denyPublicExecute(iSecAdmin);
            }
        } else {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.WouldBeUpdated.fmt.log", (Object)changed, (Object)deleted));
        }
        this.grantCapabilitiesToRoles();
        if (this.application != null && this.applicationId == null) {
            this.applicationId = this.application.getJomaObject().getId();
            this.logger.info("Application SoftwareComponent: " + this.applicationId);
        }
        childServer.close();
    }

    private void grantCapabilitiesToRoles() throws MdException, ServiceException {
        ISecurityAdmin iSecAdmin;
        try {
            MdOMRConnection connection = ((OMIServer)this.metadataServer).getMdFactory().getConnection();
            iSecAdmin = connection.MakeISecurityAdminConnection(connection.getCMRHandle());
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        for (String name : this.roles.keySet()) {
            this.roles.get(name).grantCapabilities(iSecAdmin, this.application);
        }
    }

    void loadFromMetadata() throws AppMetaException, MissingOptionException, MdException, ServiceException, IllegalStateException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            this.sourceDocument = docBuilder.newDocument();
            Element root = this.sourceDocument.createElement("ApplicationMetadata");
            root.setAttribute("xmlns", CURRENT_XML_NAMESPACE);
            this.sourceDocument.appendChild(root);
            this.application = Application.create(this);
            this.application.loadFromMetadata(this.metadataServer);
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.Product.fmt.log", (Object)this.application.getProductName()));
        }
        catch (ParserConfigurationException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.ParseSourceError.txt"), e);
        }
    }

    void generateXML() throws AppMetaException {
        OutputStream stream = null;
        try {
            stream = this.extractXMLStream != null ? this.extractXMLStream : new FileOutputStream(this.sourceXML);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("standalone", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(this.sourceDocument);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            if (this.sourceXML != null) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.CreatedXML.fmt.log", (Object)this.sourceXML));
            } else {
                this.logger.info(RB.getStringResource("ApplicationMetadataUtility.CreatedXMLStream.log"));
            }
        }
        catch (IOException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.SourceXMLError.txt"), e);
        }
        catch (TransformerException e) {
            throw new AppMetaException(RB.getStringResource("ApplicationMetadataUtility.SourceXMLError.txt"), e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    String getEmbeddedXML(Node node) throws TransformerFactoryConfigurationError, TransformerException {
        Node nodeCopy = node.cloneNode(true);
        this.stripWhitespaceAndNamespace(nodeCopy);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(nodeCopy);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    void stripWhitespaceAndNamespace(Node node) {
        NodeList list;
        Pattern whitespaceOnly = Pattern.compile("\\s*");
        if (node.getNodeType() == 1 && node.getNamespaceURI() != null) {
            node.getOwnerDocument().renameNode(node, "", node.getLocalName());
        }
        if ((list = node.getChildNodes()).getLength() <= 1) {
            return;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() == 3) {
                Matcher m = whitespaceOnly.matcher(child.getTextContent());
                if (!m.matches()) continue;
                node.removeChild(child);
                --i;
                continue;
            }
            if (child.getNodeType() != 1) continue;
            this.stripWhitespaceAndNamespace(child);
        }
    }

    void stripNamespace(Element element) {
        if (element.getNamespaceURI() != null) {
            element.getOwnerDocument().renameNode(element, "", element.getLocalName());
        }
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 1) continue;
            this.stripNamespace((Element)child);
        }
    }

    FolderInterface makeFolder(MetadataServerInterface server, String folderPath) throws ServiceException {
        FolderInterface folder;
        try {
            RootFolderInterface rootFolder = server.getRootFolder();
            PathUrl folderUrl = new PathUrl(rootFolder.getPathUrl(), folderPath);
            folderUrl.setType("Folder");
            folder = (FolderInterface)server.getObjectByPath(folderUrl);
            if (folder != null) {
                return folder;
            }
            Pattern pattern = Pattern.compile("^(/(.*?/)*)([^/]+)/?$");
            Matcher matcher = pattern.matcher(folderPath);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidFolderPath.fmt.log", (Object)folderPath));
            }
            String parentFolderPath = matcher.group(1);
            String folderName = matcher.group(3);
            PathUrl parentFolderUrl = new PathUrl(rootFolder.getPathUrl(), parentFolderPath);
            FolderInterface parentFolder = (FolderInterface)server.getObjectByPath(parentFolderUrl);
            if (parentFolder == null) {
                parentFolder = this.makeFolder(server, parentFolderPath);
            }
            if ((folder = parentFolder.makeSubfolder(folderName)) != null) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.FolderCreated.fmt.log", (Object)folderPath));
            }
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e);
        }
        return folder;
    }

    MetadataServerInterface getMetadataServer() {
        return this.metadataServer;
    }

    void declareWarning() {
        if (this.returnCode < 4) {
            this.returnCode = 4;
        }
    }

    void declareError() {
        if (this.returnCode < 8) {
            this.returnCode = 8;
        }
    }

    void declareError(int returnCode) {
        if (this.returnCode < 8) {
            this.returnCode = returnCode;
        }
    }

    String[] getNonblankArgs() {
        int nargs = 0;
        String[] args = this.commandLine.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].length() <= 0) continue;
            ++nargs;
        }
        String[] newArgs = new String[nargs];
        nargs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].length() <= 0) continue;
            newArgs[nargs++] = args[i];
        }
        return newArgs;
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options options = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_APPLICATIONID, true, RB.getStringResource("ApplicationMetadataUtility.ApplicationId.Desc.txt"));
        option.setArgName(RB.getStringResource("ApplicationMetadataUtility.ApplicationId.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_APPLICATIONNAME, true, RB.getStringResource("ApplicationMetadataUtility.ApplicationName.Desc.txt"));
        option.setArgName(RB.getStringResource("ApplicationMetadataUtility.ApplicationName.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_FOLDER, true, RB.getStringResource("ApplicationMetadataUtility.Folder.Desc.txt"));
        option.setArgName(RB.getStringResource("ApplicationMetadataUtility.Folder.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_LOCALIZE, RB.getStringResource("ApplicationMetadataUtility.Localize.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_LOCPROP, RB.getStringResource("ApplicationMetadataUtility.Locprop.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_NOEXECUTE, RB.getStringResource("ApplicationMetadataUtility.Noexecute.Desc.txt"));
        options.addOption(option);
        option = new Option(OPTION_EXTRACT, RB.getStringResource("ApplicationMetadataUtility.Extract.Desc.txt"));
        options.addOption(option);
        return options;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String[] files;
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_APPLICATIONID)) {
            this.setApplicationId(this.commandLine.getOptionValue(OPTION_APPLICATIONID));
            if (!Pattern.matches("\\p{Alnum}{8}\\.\\p{Alnum}{8}", this.applicationId)) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidApplicationId.fmt.txt", (Object)this.applicationId));
            }
        }
        if (this.commandLine.hasOption(OPTION_APPLICATIONNAME)) {
            this.setApplicationName(this.commandLine.getOptionValue(OPTION_APPLICATIONNAME));
        }
        if (this.commandLine.hasOption(OPTION_FOLDER)) {
            this.setFolder(this.commandLine.getOptionValue(OPTION_FOLDER));
        }
        this.setLocalize(this.commandLine.hasOption(OPTION_LOCALIZE));
        this.setLocprop(this.commandLine.hasOption(OPTION_LOCPROP));
        this.setNoExecute(this.commandLine.hasOption(OPTION_NOEXECUTE));
        this.setExtract(this.commandLine.hasOption(OPTION_EXTRACT));
        if (this.locprop) {
            if (this.localize) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_LOCPROP, (Object)OPTION_LOCALIZE));
            }
            if (this.applicationId != null) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_LOCPROP, (Object)OPTION_APPLICATIONID));
            }
        }
        if (this.extract) {
            if (this.localize) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_EXTRACT, (Object)OPTION_LOCALIZE));
            }
            if (this.noExecute) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationMetadataUtility.InvalidOptionCombo.fmt.txt", (Object)OPTION_EXTRACT, (Object)OPTION_NOEXECUTE));
            }
        }
        if ((files = this.getNonblankArgs()) == null || files.length == 0) {
            throw new ParseException(RB.getStringResource("ApplicationMetadataUtility.NoSourceFile.txt"));
        }
        if (files.length > 1) {
            throw new ParseException(RB.getStringResource("ApplicationMetadataUtility.TooManySourceFiles.txt"));
        }
        this.setSourceXML(files[0]);
        return true;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("ApplicationMetadataUtility.HelpUsage.txt")});
    }

    public void resetForTest() {
        this.returnCode = 0;
        this.locprop = false;
        this.localize = false;
        this.noExecute = false;
        this.extract = false;
        this.applicationId = null;
        this.applicationName = null;
        this.sourceXML = null;
        this.sourceXMLURL = null;
        this.sourceXMLStream = null;
        this.extractXMLStream = null;
        this.sourceDocument = null;
        this.application = null;
        this.groups = null;
        this.roles = null;
        this.rootTypeGroup = null;
    }
}

