/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.mgmt;

import com.sas.batch.metadata.mgmt.AbstractMetadataMgmtUtility;
import com.sas.batch.metadata.mgmt.RB;
import com.sas.codepolicy.SASScope;
import com.sas.svcs.metadata.mgmt.client.Backup;
import com.sas.svcs.metadata.mgmt.client.MetadataBackupService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.Recovery;
import com.sas.svcs.metadata.mgmt.client.RecoveryOptions;
import com.sas.text.Message;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class RecoverUtility
extends AbstractMetadataMgmtUtility {
    public static final String OPTION_COMMENT = "comment";
    public static final String OPTION_INCLUDE_CONFIG = "includeConfig";
    public static final String OPTION_LIST = "list";
    public static final String OPTION_ROLLFORWARD = "rollForward";
    public static final String OPTION_TIME = "time";
    public static final String OPTION_IGNOREVERIFY = "ignoreVerify";
    private Date time;
    private String comment;
    private String backupName;
    private boolean includeConfig;
    private boolean list;
    private boolean rollForward;
    private boolean ignoreVerify;
    private final SimpleDateFormat displayDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final SimpleDateFormat parseDateFormat1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ'<<<'");
    private final SimpleDateFormat parseDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'<<<'");
    private final SimpleDateFormat parseDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'<<<'");
    private final SimpleDateFormat parseDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'<<<'");

    public RecoverUtility() {
        this.utilityName = "sas-recover-metadata";
    }

    public String getBackupName() {
        return this.backupName;
    }

    public void setBackupName(String backupName) {
        this.backupName = backupName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isIncludeConfig() {
        return this.includeConfig;
    }

    public void setIncludeConfig(boolean includeConfig) {
        this.includeConfig = includeConfig;
    }

    public boolean isList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public boolean isRollForward() {
        return this.rollForward;
    }

    public void setRollForward(boolean rollForward) {
        this.rollForward = rollForward;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public boolean isIgnoreVerify() {
        return this.ignoreVerify;
    }

    public void setIgnoreVerify(boolean ignoreVerify) {
        this.ignoreVerify = ignoreVerify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        try {
            Recovery recovery;
            this.initialize();
            MetadataBackupService backupService = (MetadataBackupService)this.applicationContext.getBean("MetadataBackupService");
            Backup recoveryBackup = null;
            if (this.backupName != null) {
                recoveryBackup = backupService.getBackupByName(this.backupName);
                if (recoveryBackup == null) {
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RecoverUtility.BackupNotFound.fmt.log", (Object)this.backupName));
                    this.returnCode = 8;
                }
            } else {
                List history = backupService.getHistory();
                for (Operation operation : history) {
                    Backup backup;
                    if (!(operation instanceof Backup) || this.time.before((backup = (Backup)operation).getStartedDate()) || recoveryBackup != null && !backup.getStartedDate().after(recoveryBackup.getStartedDate())) continue;
                    recoveryBackup = backup;
                }
                if (recoveryBackup == null) {
                    this.logger.error(RB.getStringResource("RecoverUtility.NoBackups.log"));
                    this.returnCode = 8;
                }
            }
            if (recoveryBackup == null) {
                int history = this.returnCode;
                return history;
            }
            if (!recoveryBackup.isAvailable()) {
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RecoverUtility.BackupNotAvailable.fmt.log", (Object)recoveryBackup.getName()));
                int history = this.returnCode = 8;
                return history;
            }
            if (this.list) {
                String comment = recoveryBackup.getComment();
                if (comment == null || comment.length() == 0) {
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"RecoverUtility.BackupSelected.fmt.log", (Object)recoveryBackup.getName()));
                } else {
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"RecoverUtility.BackupSelectedWithComment.fmt.log", (Object)recoveryBackup.getName(), (Object)comment));
                }
                int n = this.returnCode = 0;
                return n;
            }
            RecoveryOptions recoveryOptions = RecoveryOptions.newOptions((String)"");
            if (this.comment != null) {
                recoveryOptions.setComment(this.comment);
            } else {
                recoveryOptions.setComment(RB.getStringResource("RecoverUtility.DefaultComment.log"));
            }
            recoveryOptions.setPauseComment(RB.getStringResource("RecoverUtility.PauseComment.log"));
            recoveryOptions.setIncludeConfig(this.includeConfig);
            if (this.ignoreVerify) {
                recoveryOptions.setVerify(false);
            }
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"RecoverUtility.RecoveringFromBackup.fmt.log", (Object)recoveryBackup.getName()));
            if (this.rollForward) {
                if (this.time.after(recoveryBackup.getStartedDate())) {
                    Date now = new Date();
                    if (now.before(this.time)) {
                        this.time = now;
                    }
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"RecoverUtility.RollForward.fmt.log", (Object)this.displayDateFormat.format(this.time)));
                    recoveryOptions.setRollForward(this.time);
                } else {
                    this.logger.warn(RB.getStringResource("RecoverUtility.RollForwardIgnored.log"));
                    this.returnCode = 4;
                }
            }
            if ((recovery = backupService.recover(recoveryBackup, recoveryOptions)).getStatus() != Operation.Status.SUCCESS) {
                this.returnCode = 8;
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        RecoverUtility backup = new RecoverUtility();
        backup.executeBatch(args);
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options options = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_COMMENT, true, RB.getStringResource("RecoverUtility.Comment.Option.txt"));
        option.setArgName(RB.getStringResource("RecoverUtility.Comment.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_TIME, true, RB.getStringResource("RecoverUtility.Time.Option.txt"));
        option.setArgName(RB.getStringResource("RecoverUtility.Time.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_INCLUDE_CONFIG, RB.getStringResource("RecoverUtility.IncludeConfig.Option.txt"));
        options.addOption(option);
        option = new Option(OPTION_LIST, RB.getStringResource("RecoverUtility.List.Option.txt"));
        options.addOption(option);
        option = new Option(OPTION_ROLLFORWARD, RB.getStringResource("RecoverUtility.RollForward.Option.txt"));
        options.addOption(option);
        option = new Option(OPTION_IGNOREVERIFY, RB.getStringResource("RecoverUtility.IgnoreVerify.Option.txt"));
        options.addOption(option);
        return options;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_TIME)) {
            this.setTime(this.parseTimestamp(this.commandLine.getOptionValue(OPTION_TIME)));
        } else {
            this.setTime(null);
        }
        this.setComment(this.commandLine.getOptionValue(OPTION_COMMENT));
        this.setIncludeConfig(this.commandLine.hasOption(OPTION_INCLUDE_CONFIG));
        this.setList(this.commandLine.hasOption(OPTION_LIST));
        this.setRollForward(this.commandLine.hasOption(OPTION_ROLLFORWARD));
        this.setIgnoreVerify(this.commandLine.hasOption(OPTION_IGNOREVERIFY));
        String[] remainingArgs = this.commandLine.getArgs();
        if (remainingArgs.length > 1) {
            this.displayHelp();
            return false;
        }
        if (remainingArgs.length == 1) {
            this.setBackupName(remainingArgs[0]);
        }
        if (this.backupName == null && this.time == null) {
            throw new ParseException(RB.getStringResource("RecoverUtility.NameOrTimeRequired.log"));
        }
        return true;
    }

    private Date parseTimestamp(String value) throws ParseException {
        String delimitedValue = value + "<<<";
        try {
            return this.parseDateFormat1.parse(delimitedValue);
        }
        catch (java.text.ParseException parseException) {
            try {
                return this.parseDateFormat2.parse(delimitedValue);
            }
            catch (java.text.ParseException parseException2) {
                try {
                    return this.parseDateFormat3.parse(delimitedValue);
                }
                catch (java.text.ParseException parseException3) {
                    try {
                        return this.parseDateFormat4.parse(delimitedValue);
                    }
                    catch (java.text.ParseException parseException4) {
                        throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"RecoverUtility.InvalidTimestamp.fmt.log", (Object)value));
                    }
                }
            }
        }
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("RecoverUtility.HelpUsage1.txt"), RB.getStringResource("RecoverUtility.HelpUsage2.txt")});
    }
}

