/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.mgmt;

import com.sas.batch.metadata.mgmt.AbstractMetadataMgmtUtility;
import com.sas.batch.metadata.mgmt.RB;
import com.sas.codepolicy.SASScope;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.UpgradeResult;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;

@SASScope
public class PortMetadata
extends AbstractMetadataMgmtUtility {
    public PortMetadata() {
        this.utilityName = "sas-port-metadata";
        this.setLogDecorations(true);
        this.setLogTimestamps(true);
    }

    public int execute() throws Exception {
        try {
            this.initialize();
            MetadataRepositoryService repositoryService = (MetadataRepositoryService)this.applicationContext.getBean("MetadataRepositoryService");
            UpgradeResult result = repositoryService.portAllRepositories();
            if (result != null) {
                if (result.getStatus() == Operation.Status.SUCCESS) {
                    if (result.isWarningDetected()) {
                        this.logger.warn(RB.getStringResource("PortMetadata.Completed.Warning.log"));
                    } else {
                        this.logger.info(RB.getStringResource("PortMetadata.Completed.log"));
                    }
                    this.returnCode = 0;
                } else {
                    this.logger.error(RB.getStringResource("PortMetadata.Completed.Failure.log"));
                    this.returnCode = 8;
                }
            } else {
                this.logger.error(RB.getStringResource("PortMetadata.Completed.Failure.log"));
                this.returnCode = 8;
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        PortMetadata upgrade = new PortMetadata();
        upgrade.executeBatch(args);
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        String[] remainingArgs = this.commandLine.getArgs();
        if (remainingArgs.length > 0) {
            this.displayHelp();
            return false;
        }
        return true;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("PortMetadata.HelpUsage.txt")});
    }
}

