/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.mgmt;

import com.sas.batch.metadata.mgmt.AbstractMetadataMgmtUtility;
import com.sas.batch.metadata.mgmt.RB;
import com.sas.codepolicy.SASScope;
import com.sas.services.util.Names;
import com.sas.svcs.metadata.mgmt.client.CustomRepository;
import com.sas.svcs.metadata.mgmt.client.FoundationRepository;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.client.RepositoryCreationResult;
import com.sas.text.Message;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class CreateRepository
extends AbstractMetadataMgmtUtility {
    public static final String OPTION_DESC = "desc";
    public static final String OPTION_PATH = "path";
    public static final String OPTION_USER_ROOT_FOLDER = "userRoot";
    private String repositoryName;
    private String repositoryDesc;
    private String repositoryPath;
    private String userRootFolder;

    public CreateRepository() {
        this.utilityName = "sas-create-repository";
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        Names.validateOMRObjectName((String)repositoryName, (boolean)true);
        this.repositoryName = repositoryName;
    }

    public String getRepositoryDesc() {
        return this.repositoryDesc;
    }

    public void setRepositoryDesc(String repositoryDesc) {
        this.repositoryDesc = repositoryDesc;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public String getUserRootFolder() {
        return this.userRootFolder;
    }

    public void setUserRootFolder(String userRootFolder) {
        this.userRootFolder = userRootFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        try {
            this.initialize();
            MetadataRepositoryService repositoryService = (MetadataRepositoryService)this.applicationContext.getBean("MetadataRepositoryService");
            Repository foundation = repositoryService.getFoundationRepository();
            FoundationRepository repository = null;
            if (foundation == null) {
                repository = new FoundationRepository();
                if (this.repositoryName == null || this.repositoryName.length() == 0) {
                    this.repositoryName = "Foundation";
                }
                if (this.repositoryDesc == null) {
                    this.repositoryDesc = "Foundation repository";
                }
                if (this.userRootFolder != null) {
                    repository.setPathtoUsersRootFolder(this.userRootFolder);
                }
            } else {
                if (this.repositoryName == null || this.repositoryName.length() == 0) {
                    throw new IllegalArgumentException(RB.getStringResource("CreateRepository.NameMustBeSpecified.log"));
                }
                if (this.userRootFolder != null) {
                    throw new IllegalArgumentException(RB.getStringResource("CreateRepository.UserRootInvalid.log"));
                }
                repository = new CustomRepository();
            }
            repository.setName(this.repositoryName);
            if (this.repositoryDesc != null) {
                repository.setDescription(this.repositoryDesc);
            }
            if (this.repositoryPath != null && this.repositoryPath.length() > 0) {
                repository.setPath(this.repositoryPath);
            } else {
                repository.setPath("MetadataRepositories/" + Names.mapNameToFilesystem((String)repository.getName(), (int)0, null, null));
            }
            repository.setCreateRepositoryPath(true);
            RepositoryCreationResult result = repositoryService.createRepository((Repository)repository);
            if (result != null) {
                if (result.getStatus() == Operation.Status.ERROR) {
                    this.returnCode = 8;
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"CreateRepository.Created.Failure.fmt.log", (Object)this.repositoryName));
                } else {
                    this.returnCode = 0;
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"CreateRepository.Created.fmt.log", (Object)this.repositoryName));
                }
            } else {
                this.returnCode = 8;
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"CreateRepository.Created.Failure.fmt.log", (Object)this.repositoryName));
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        CreateRepository creator = new CreateRepository();
        creator.executeBatch(args);
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options options = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_DESC, true, RB.getStringResource("CreateRepository.Desc.Option.txt"));
        option.setArgName(RB.getStringResource("CreateRepository.Desc.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_PATH, true, RB.getStringResource("CreateRepository.Path.Option.txt"));
        option.setArgName(RB.getStringResource("CreateRepository.Path.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_USER_ROOT_FOLDER, true, RB.getStringResource("CreateRepository.UserRootFolder.Option.txt"));
        option.setArgName(RB.getStringResource("CreateRepository.UserRootFolder.ArgName.txt"));
        options.addOption(option);
        return options;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String[] remainingArgs;
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_DESC)) {
            this.setRepositoryDesc(this.commandLine.getOptionValue(OPTION_DESC));
        }
        if (this.commandLine.hasOption(OPTION_PATH)) {
            this.setRepositoryPath(this.commandLine.getOptionValue(OPTION_PATH));
        }
        if (this.commandLine.hasOption(OPTION_USER_ROOT_FOLDER)) {
            this.setUserRootFolder(this.commandLine.getOptionValue(OPTION_USER_ROOT_FOLDER));
        }
        if ((remainingArgs = this.commandLine.getArgs()).length > 1) {
            this.displayHelp();
            return false;
        }
        if (remainingArgs.length == 1) {
            this.setRepositoryName(remainingArgs[0]);
        }
        return true;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("CreateRepository.HelpUsage.txt")});
    }
}

