/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.mgmt;

import com.sas.batch.metadata.mgmt.AbstractMetadataMgmtUtility;
import com.sas.batch.metadata.mgmt.RB;
import com.sas.codepolicy.SASScope;
import com.sas.svcs.metadata.mgmt.client.Backup;
import com.sas.svcs.metadata.mgmt.client.BackupOptions;
import com.sas.svcs.metadata.mgmt.client.MetadataBackupService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.Recovery;
import com.sas.text.Message;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class BackupUtility
extends AbstractMetadataMgmtUtility {
    public static final String OPTION_BEFORE = "before";
    public static final String OPTION_COMMENT = "comment";
    public static final String OPTION_LIST = "list";
    public static final String OPTION_REORG = "reorg";
    public static final String OPTION_SINCE = "since";
    private Date since;
    private Date before;
    private boolean list;
    private String comment;
    private boolean reorg;
    private final SimpleDateFormat parseDateFormat1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ'<<<'");
    private final SimpleDateFormat parseDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'<<<'");
    private final SimpleDateFormat parseDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'<<<'");
    private final SimpleDateFormat parseDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'<<<'");

    public BackupUtility() {
        this.utilityName = "sas-backup-metadata";
    }

    public Date getBefore() {
        return this.before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public boolean isList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isReorg() {
        return this.reorg;
    }

    public void setReorg(boolean reorg) {
        this.reorg = reorg;
    }

    public Date getSince() {
        return this.since;
    }

    public void setSince(Date since) {
        this.since = since;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        try {
            this.initialize();
            MetadataBackupService backupService = (MetadataBackupService)this.applicationContext.getBean("MetadataBackupService");
            if (this.isList()) {
                List history = backupService.getHistory();
                int backupCount = 0;
                for (Operation operation : history) {
                    if (this.since != null && this.since.after(operation.getStartedDate()) || this.before != null && this.before.before(operation.getStartedDate())) continue;
                    if (operation instanceof Backup) {
                        if (!((Backup)operation).isAvailable()) continue;
                        System.out.print("Backup   ");
                        ++backupCount;
                    } else {
                        if (!(operation instanceof Recovery)) continue;
                        System.out.print("Recovery ");
                    }
                    System.out.print(operation.getName());
                    if (operation.getComment() != null && operation.getComment().length() > 0) {
                        System.out.print(" - ");
                        System.out.print(operation.getComment());
                    }
                    System.out.println();
                }
                if (backupCount == 0) {
                    if (this.since != null || this.before != null) {
                        System.out.println(RB.getStringResource("BackupUtility.NoBackupsInRange.log"));
                    } else {
                        System.out.println(RB.getStringResource("BackupUtility.NoBackups.log"));
                    }
                }
            } else {
                BackupOptions backupOptions = new BackupOptions();
                if (this.comment != null) {
                    backupOptions.setComment(this.comment);
                } else {
                    backupOptions.setComment(RB.getStringResource("BackupUtility.DefaultComment.log"));
                }
                backupOptions.setReorganizeRepositories(this.reorg);
                Backup backup = backupService.backup(backupOptions);
                if (backup.getStatus() != Operation.Status.SUCCESS) {
                    this.returnCode = 8;
                }
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        BackupUtility backup = new BackupUtility();
        backup.executeBatch(args);
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options options = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_COMMENT, true, RB.getStringResource("BackupUtility.Comment.Option.txt"));
        option.setArgName(RB.getStringResource("BackupUtility.Comment.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_REORG, RB.getStringResource("BackupUtility.Reorg.Option.txt"));
        options.addOption(option);
        option = new Option(OPTION_LIST, RB.getStringResource("BackupUtility.List.Option.txt"));
        options.addOption(option);
        option = new Option(OPTION_SINCE, true, RB.getStringResource("BackupUtility.Since.Option.txt"));
        option.setArgName(RB.getStringResource("BackupUtility.Since.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_BEFORE, true, RB.getStringResource("BackupUtility.Before.Option.txt"));
        option.setArgName(RB.getStringResource("BackupUtility.Before.ArgName.txt"));
        options.addOption(option);
        return options;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String[] remainingArgs;
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_LIST)) {
            this.setList(true);
            if (this.commandLine.hasOption(OPTION_COMMENT)) {
                throw new ParseException(RB.getStringResource("BackupUtility.NoCommentWithList.log"));
            }
            if (this.commandLine.hasOption(OPTION_REORG)) {
                throw new ParseException(RB.getStringResource("BackupUtility.NoReorgWithList.log"));
            }
            if (this.commandLine.hasOption(OPTION_SINCE)) {
                this.setSince(this.parseTimestamp(this.commandLine.getOptionValue(OPTION_SINCE)));
            } else {
                this.setSince(null);
            }
            if (this.commandLine.hasOption(OPTION_BEFORE)) {
                this.setBefore(this.parseTimestamp(this.commandLine.getOptionValue(OPTION_BEFORE)));
            } else {
                this.setBefore(null);
            }
            if (this.getSince() != null && this.getBefore() != null && this.getBefore().before(this.getSince())) {
                throw new IllegalArgumentException(RB.getStringResource("BackupUtility.InvalidDateRange.txt"));
            }
        } else {
            this.setList(false);
            if (this.commandLine.hasOption(OPTION_SINCE) || this.commandLine.hasOption(OPTION_BEFORE)) {
                throw new ParseException(RB.getStringResource("BackupUtility.RangeOptionsOnlyForList.log"));
            }
            this.setComment(this.commandLine.getOptionValue(OPTION_COMMENT));
            this.setReorg(this.commandLine.hasOption(OPTION_REORG));
        }
        if ((remainingArgs = this.commandLine.getArgs()).length > 0) {
            this.displayHelp();
            return false;
        }
        return true;
    }

    private Date parseTimestamp(String value) throws ParseException {
        String delimitedValue = value + "<<<";
        try {
            return this.parseDateFormat1.parse(delimitedValue);
        }
        catch (java.text.ParseException parseException) {
            try {
                return this.parseDateFormat2.parse(delimitedValue);
            }
            catch (java.text.ParseException parseException2) {
                try {
                    return this.parseDateFormat3.parse(delimitedValue);
                }
                catch (java.text.ParseException parseException3) {
                    try {
                        return this.parseDateFormat4.parse(delimitedValue);
                    }
                    catch (java.text.ParseException parseException4) {
                        throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"BackupUtility.InvalidTimestamp.fmt.log", (Object)value));
                    }
                }
            }
        }
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("BackupUtility.HelpUsage1.txt"), RB.getStringResource("BackupUtility.HelpUsage2.txt")});
    }
}

