/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.mgmt;

import com.sas.batch.metadata.mgmt.AbstractMetadataMgmtUtility;
import com.sas.batch.metadata.mgmt.RB;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.svcs.metadata.mgmt.client.AnalysisResult;
import com.sas.svcs.metadata.mgmt.client.AnalysisToolDescriptor;
import com.sas.svcs.metadata.mgmt.client.AnalysisToolGroup;
import com.sas.svcs.metadata.mgmt.client.MetadataAnalysisService;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.MetadataServerService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.client.RepositoryDoesNotExistException;
import com.sas.svcs.metadata.mgmt.client.ServerState;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class AnalyzeMetadataUtility
extends AbstractMetadataMgmtUtility {
    public static final String OPTION_TOOL = "tool";
    public static final String OPTION_GROUP = "group";
    public static final String OPTION_REPAIR = "repair";
    private String tools = null;
    private String groups = null;
    private boolean repair = false;
    private List<Repository> repositories = null;
    private List<String> repositoryNames = null;
    private int analyzeWarnings = 0;
    private int analyzeErrors = 0;
    private int analyzeSteps = 0;
    private int repairsPerformed = 0;
    private ServerState serverStartState = null;
    private List<AnalysisToolDescriptor> supportedToolsList;
    private static MetadataAnalysisService analysisService;
    private static MetadataRepositoryService repositoryService;
    private static MetadataServerService serverService;

    public AnalyzeMetadataUtility() {
        this.utilityName = "sas-analyze-metadata";
        this.setLogDecorations(true);
        this.setLogTimestamps(true);
    }

    public String getTools() {
        return this.tools;
    }

    public void setTools(String tools) {
        this.tools = tools;
    }

    public String getToolGroups() {
        return this.groups;
    }

    public void setToolGroups(String groups) {
        this.groups = groups;
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories;
    }

    public void setRepair(boolean repair) {
        this.repair = repair;
    }

    public boolean isRepair() {
        return this.repair;
    }

    protected void initialize() throws ServiceException {
        super.initialize();
        analysisService = (MetadataAnalysisService)this.applicationContext.getBean("MetadataAnalysisService");
        repositoryService = (MetadataRepositoryService)this.applicationContext.getBean("MetadataRepositoryService");
        serverService = (MetadataServerService)this.applicationContext.getBean("MetadataServerService");
        this.serverStartState = serverService.getServerState();
        this.supportedToolsList = analysisService.getAnalysisTools();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        try {
            this.initialize();
            if (this.repositoryNames != null) {
                for (String reposName : this.repositoryNames) {
                    Repository repository = null;
                    try {
                        repository = repositoryService.getRepositoryByName(reposName);
                    }
                    catch (RepositoryDoesNotExistException e) {
                        this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.RepositoryDoesNotExist.fmt.txt", (Object)reposName));
                        this.returnCode = 8;
                        continue;
                    }
                    if (this.repositories == null) {
                        this.repositories = new ArrayList<Repository>(this.repositoryNames.size());
                    }
                    this.repositories.add(repository);
                }
                if (this.repositories == null) {
                    int n = this.returnCode = 8;
                    return n;
                }
            }
            if (this.groups == null && this.tools == null && this.repositories == null) {
                List results = this.isRepair() ? analysisService.repair() : analysisService.analyze();
                this.analyzeSteps = results.size();
                for (AnalysisResult result : results) {
                    this.trackResultStatus(result);
                }
                this.logSummaryResults();
                int n = this.returnCode;
                return n;
            }
            List<String> toolList = this.groups != null ? this.getToolsListByGroup(this.groups) : this.getToolsList(this.tools);
            if (this.repositories == null) {
                this.repositories = new ArrayList<Repository>(repositoryService.getRepositories());
            }
            try {
                this.pauseServerAdmin(serverService, this.serverStartState);
                this.logger.info(RB.getStringResource("AnalyzeMetadataUtility.PauseForAnalysis.Log.txt"));
                for (Repository repository : this.repositories) {
                    boolean toolAborted = false;
                    String abortedToolName = null;
                    String repositoryName = repository.getName();
                    Repository.Access access = repository.getEffectiveAccess();
                    if (access == Repository.Access.OFFLINE) {
                        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.NoAnalysisOffline.fmt.txt", (Object)repositoryName));
                        continue;
                    }
                    for (String toolId : toolList) {
                        AnalysisToolDescriptor tool = analysisService.getAnalysisTool(toolId);
                        if (tool == null) {
                            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.AnalyzeToolNotFound.fmt.txt", (Object)toolId));
                            this.returnCode = 8;
                            continue;
                        }
                        String toolName = tool.getName();
                        if (toolAborted) {
                            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.AnalyzeToolNotRun.Log.fmt.txt", (Object)toolName, (Object)repositoryName, abortedToolName));
                            continue;
                        }
                        ++this.analyzeSteps;
                        AnalysisResult result = null;
                        if (this.isRepair()) {
                            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.StartToolRepair.fmt.txt", (Object)toolName, (Object)repositoryName));
                            result = analysisService.repair(repository, toolId);
                        } else {
                            result = analysisService.analyze(repository, toolId);
                        }
                        this.trackResultStatus(result);
                        if (result.getStatus() != Operation.Status.FATAL) continue;
                        toolAborted = true;
                        abortedToolName = toolName;
                    }
                }
            }
            finally {
                this.returnServerToStartState(serverService, this.serverStartState);
                this.logger.info(RB.getStringResource("AnalyzeMetadataUtility.ResumeAfterAnalysis.Log.txt"));
            }
            this.logSummaryResults();
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.ErrorOccurred.fmt.txt", (Object)e.getMessage()));
            this.returnCode = 8;
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        AnalyzeMetadataUtility analyze = new AnalyzeMetadataUtility();
        analyze.executeBatch(args);
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options options = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_TOOL, true, RB.getStringResource("AnalyzeMetadataUtility.Tool.Option.txt"));
        option.setArgName(RB.getStringResource("AnalyzeMetadataUtility.Tool.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_GROUP, true, RB.getStringResource("AnalyzeMetadataUtility.Group.Option.txt"));
        option.setArgName(RB.getStringResource("AnalyzeMetadataUtility.Group.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_REPAIR, RB.getStringResource("AnalyzeMetadataUtility.Repair.Option.txt"));
        options.addOption(option);
        return options;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String[] remainingArgs;
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_TOOL)) {
            this.setTools(this.commandLine.getOptionValue(OPTION_TOOL));
        }
        if (this.commandLine.hasOption(OPTION_GROUP)) {
            this.setToolGroups(this.commandLine.getOptionValue(OPTION_GROUP));
        }
        if (this.commandLine.hasOption(OPTION_REPAIR)) {
            this.setRepair(true);
        }
        if ((remainingArgs = this.commandLine.getArgs()).length > 0) {
            this.repositoryNames = Arrays.asList(remainingArgs);
        }
        return true;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("AnalyzeMetadataUtility.HelpUsage.txt")});
    }

    private void pauseServerAdmin(MetadataServerService serverService, ServerState serverStartState) {
        ServerState startState;
        if (serverService != null && !ServerState.Access.ADMIN.equals((Object)serverStartState.getAccess()) && !(startState = serverService.getServerState()).getAccess().equals((Object)ServerState.Access.ADMIN)) {
            serverService.pauseAdmin(RB.getStringResource("AnalyzeMetadataUtility.PauseComment.txt"));
        }
    }

    private void returnServerToStartState(MetadataServerService serverService, ServerState serverStartState) {
        if (serverService != null && !ServerState.Access.ADMIN.equals((Object)serverStartState.getAccess())) {
            try {
                serverService.setServerState(serverStartState);
            }
            catch (IllegalArgumentException e) {
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.SettingServerState.Error.fmt.txt", (Object)e.getMessage()));
            }
        }
    }

    List<String> getToolsList(String tools) {
        ArrayList<String> toolList = new ArrayList<String>(this.supportedToolsList.size());
        if (tools == null) {
            for (AnalysisToolDescriptor toolDescriptor : this.supportedToolsList) {
                toolList.add(toolDescriptor.getId().toLowerCase());
            }
            return toolList;
        }
        String[] keys = tools.split("[,+ ]");
        block1: for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key.length() == 0) continue;
            for (AnalysisToolDescriptor toolDescriptor : this.supportedToolsList) {
                if (!key.equalsIgnoreCase(toolDescriptor.getId())) continue;
                toolList.add(toolDescriptor.getId().toLowerCase());
                continue block1;
            }
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.InvalidToolMnemonic.fmt.txt", (Object)key));
        }
        return toolList;
    }

    List<String> getToolsListByGroup(String groups) {
        ArrayList<String> toolList = new ArrayList<String>(this.supportedToolsList.size());
        if (groups == null) {
            for (AnalysisToolDescriptor toolDescriptor : this.supportedToolsList) {
                toolList.add(toolDescriptor.getId().toLowerCase());
            }
            return toolList;
        }
        String[] keys = groups.split("[,+ ]");
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key.length() == 0) continue;
            boolean keyFound = false;
            List toolGrps = analysisService.getAnalysisToolGroups();
            for (AnalysisToolGroup toolGrp : toolGrps) {
                if (!key.equalsIgnoreCase(toolGrp.getId())) continue;
                for (AnalysisToolDescriptor toolDescriptor : toolGrp.getMembers()) {
                    toolList.add(toolDescriptor.getId().toLowerCase());
                }
                keyFound = true;
            }
            if (keyFound) continue;
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.InvalidToolGroup.fmt.txt", (Object)key));
        }
        return toolList;
    }

    private void trackResultStatus(AnalysisResult result) {
        if (this.isRepair() && result.getStatus() == Operation.Status.SUCCESS && result.isRepairNeeded()) {
            ++this.repairsPerformed;
        }
        if (result.getStatus() == Operation.Status.ERROR) {
            this.returnCode |= 8;
            ++this.analyzeErrors;
        } else if (result.getStatus() == Operation.Status.FATAL) {
            this.returnCode |= 8;
            ++this.analyzeErrors;
        } else if (result.isWarningDetected()) {
            this.returnCode |= 4;
            ++this.analyzeWarnings;
        }
    }

    private void logSummaryResults() {
        this.logger.info(RB.getStringResource("AnalyzeMetadataUtility.AnalysisComplete.Msg.txt"));
        if (this.analyzeErrors > 0) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.AnalyzeErrors.fmt.txt", (Object)new Integer(this.analyzeErrors), (Object)new Integer(this.analyzeSteps)));
        }
        if (this.analyzeWarnings > 0) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.AnalyzeWarnings.fmt.txt", (Object)new Integer(this.analyzeWarnings), (Object)new Integer(this.analyzeSteps)));
        }
        if (this.isRepair()) {
            if (this.repairsPerformed > 0) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.RepairsComplete.fmt.txt", (Object)new Integer(this.repairsPerformed), (Object)new Integer(this.analyzeSteps)));
            } else {
                this.logger.info(RB.getStringResource("AnalyzeMetadataUtility.RepairsNotRequired.txt"));
            }
        } else if (this.analyzeErrors == 0 && this.analyzeWarnings == 0) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"AnalyzeMetadataUtility.AnalyzeSuccess.fmt.txt", (Object)new Integer(this.analyzeSteps)));
        }
    }
}

