/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.security.authentication.omr.client;

import com.sas.framework.services.remoting.EndpointLocator;
import com.sas.framework.services.remoting.ReachabilityChecker;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import com.sas.svcs.remoting.client.SASClientHttpServiceProxy;
import com.sas.svcs.remoting.client.SASClientTicketingProxy;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientHolder;
import com.sas.svcs.security.authentication.omr.client.OtpCallbackHandler;
import java.rmi.RemoteException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthenticationClientHelper {
    private static final Logger logger = LogManager.getLogger(AuthenticationClientHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void clearAuthentication() {
        AuthenticationClient client = AuthenticationClientHolder.get();
        if (null != client) {
            AuthenticationClient authenticationClient = client;
            synchronized (authenticationClient) {
                client.logout();
            }
        }
        AuthenticationClientHolder.set(null);
    }

    public static void setAuthentication(SessionContextInterface context) throws ServiceException, RemoteException, IllegalStateException {
        AuthenticationClientHelper.setAuthentication(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAuthentication(SessionContextInterface context, ServiceRegistryInterface serviceRegistry) throws ServiceException, RemoteException, IllegalStateException {
        if (null == context) {
            return;
        }
        UserContextInterface uci = context.getUserContext();
        if (null == uci) {
            return;
        }
        UserContextInterface userContextInterface = uci;
        synchronized (userContextInterface) {
            AuthenticationClient client = AuthenticationClientHolder.get();
            if (client == null) {
                AuthenticationClientHelper.resetAuthentication(context, serviceRegistry);
            }
        }
    }

    private static String getCasUrl(SessionContextInterface sessionContext, ServiceRegistryInterface serviceRegistry) throws ServiceException, RemoteException, IllegalStateException {
        if (null == serviceRegistry) {
            String registryUrl = EndpointLocator.getServiceRegistryUrl((UserContextInterface)sessionContext.getUserContext());
            SASClientTicketingProxy registryProxy = new SASClientTicketingProxy();
            registryProxy.setServiceInterface(ServiceRegistryInterface.class);
            registryProxy.setServiceUrl(registryUrl);
            registryProxy.afterPropertiesSet();
            serviceRegistry = (ServiceRegistryInterface)registryProxy.getObject();
        }
        SASClientHttpServiceProxy urlGeneratorProxy = new SASClientHttpServiceProxy(serviceRegistry, UrlGeneratorInterface.class);
        urlGeneratorProxy.afterPropertiesSet();
        UrlGeneratorInterface urlGenerator = (UrlGeneratorInterface)urlGeneratorProxy.getObject();
        String url = urlGenerator.generateInternalUrl("Logon Manager", "", "");
        if (!ReachabilityChecker.isReachable((String)url) && !ReachabilityChecker.isReachable((String)(url = urlGenerator.generateExternalUrl("Logon Manager", "", "")))) {
            return null;
        }
        return url;
    }

    private static void logon(SessionContextInterface sessionContext, AuthenticationClient client) throws ServiceException, RemoteException, IllegalStateException {
        OtpCallbackHandler handler = new OtpCallbackHandler(sessionContext.getUserContext().getAuthServer());
        try {
            client.logon((CallbackHandler)handler);
            AuthenticationClientHolder.set((AuthenticationClient)client);
        }
        catch (Throwable t) {
            logger.error("Error logging on to CAS with a generated OTP.", t);
        }
    }

    private static void resetAuthentication(SessionContextInterface sessionContext, ServiceRegistryInterface serviceRegistry) throws ServiceException, RemoteException, IllegalStateException {
        AuthenticationClientHelper.clearAuthentication();
        String casUrl = AuthenticationClientHelper.getCasUrl(sessionContext, serviceRegistry);
        if (null == casUrl) {
            logger.error("Unable to set CAS authentication client: no CAS url found");
            return;
        }
        AuthenticationClient client = new AuthenticationClient(casUrl);
        AuthenticationClientHelper.logon(sessionContext, client);
    }
}

