/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.util.internal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends FilterOutputStream {
    private volatile OutputStream branch;

    public TeeOutputStream(OutputStream out) {
        super(out);
    }

    public TeeOutputStream(OutputStream out, OutputStream branch) {
        this(out);
        this.branch = branch;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStream getBranchOutputStream() {
        return this.branch;
    }

    public void setBranchOutputStream(OutputStream branch) {
        if (branch == this.out) {
            throw new IllegalArgumentException("TeeOutputStream cannot set branch same as out");
        }
        this.branch = branch;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        OutputStream os = this.branch;
        if (os != null) {
            os.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        OutputStream os = this.branch;
        if (os != null) {
            os.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        OutputStream os = this.branch;
        if (os != null) {
            os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        OutputStream os = this.branch;
        if (os != null) {
            os.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "{outputStream=" + String.valueOf(this.out) + ", branchOutputStream=" + String.valueOf(this.branch) + "}";
    }
}

