/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.util.dataset;

import com.esri.arcgis.util.dataset.AGSRecord;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class DoubleConversion {
    public static NumberFormat getFormat(int n2, int n3, int n4, int n5, Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(n3);
        numberFormat.setMaximumIntegerDigits(n4);
        numberFormat.setMinimumIntegerDigits(n5);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    public static NumberFormat getStandardFormat(Locale locale) {
        return DoubleConversion.getFormat(20, 1, 20, 1, locale);
    }

    public static NumberFormat getScientificFormat(NumberFormat numberFormat, Locale locale) {
        boolean bl = AGSRecord.c;
        NumberFormat numberFormat2 = NumberFormat.getNumberInstance(locale);
        if (numberFormat2 instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat2;
            int n2 = numberFormat.getMaximumFractionDigits() + numberFormat.getMaximumIntegerDigits() + 2;
            int n3 = n2 - 7;
            if (n3 < 6) {
                n3 = 6;
            }
            StringBuffer stringBuffer = new StringBuffer("0.");
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuffer.append('#');
                if (!bl) continue;
            }
            stringBuffer.append("E0");
            decimalFormat.applyPattern(stringBuffer.toString());
        }
        return numberFormat2;
    }

    public static String doubleToString(double d2, int n2, int n3, int n4, int n5, Locale locale) {
        NumberFormat numberFormat = DoubleConversion.getFormat(n2, n3, n4, n5, locale);
        return numberFormat.format(d2);
    }

    public static String doubleToString(double d2, int n2, int n3, int n4, int n5) {
        return DoubleConversion.doubleToString(d2, n2, n3, n4, n5, Locale.getDefault());
    }

    public static String doubleToString(double d2) {
        return DoubleConversion.getStandardFormat(Locale.getDefault()).format(d2);
    }

    public static String doubleToString(boolean bl) {
        return String.valueOf(bl);
    }

    public static String doubleToString(long l2) {
        return String.valueOf(l2);
    }

    public static double stringToDouble(String string, double d2, NumberFormat numberFormat) {
        try {
            return DoubleConversion.stringToDouble(string, numberFormat);
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public static double stringToDouble(String string, double d2, Locale locale) {
        try {
            return DoubleConversion.stringToDouble(string, locale);
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public static double stringToDouble(String string) {
        double d2 = 0.0;
        return DoubleConversion.stringToDouble(string, d2, Locale.getDefault());
    }

    public static double stringToDouble(String string, double d2) {
        return DoubleConversion.stringToDouble(string, d2, Locale.getDefault());
    }

    public static double stringToDouble(String string, Locale locale) throws ParseException {
        NumberFormat numberFormat = DoubleConversion.getStandardFormat(locale);
        return DoubleConversion.stringToDouble(string, numberFormat);
    }

    public static double stringToDouble(String string, NumberFormat numberFormat) throws ParseException {
        return numberFormat.parse(string.toUpperCase()).doubleValue();
    }
}

