/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.system;

import com.esri.arcgis.interop.AutomationException;
import com.esri.arcgis.system.AOJException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ExceptionHandler {
    private static final long a = -2147418113L;
    private static final long b = -2147467263L;
    private static final long c = -2147024882L;
    private static final long d = -2147024809L;
    private static final long e = -2147467262L;
    private static final long f = -2147467261L;
    private static final long g = -2147024890L;
    private static final long h = -2147467260L;
    private static final long i = -2147467259L;
    private static final long j = -2147024891L;
    private static final int k = 4;
    private static final int l = 7;
    private static final int m = 8;
    private static final String n = "com.esri.arcgis.system.commonerrorbundle";

    public static final String getResourceBundleName() {
        return n;
    }

    public static AOJException handleArcObjectException(Throwable throwable) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(n);
            if (throwable instanceof AutomationException) {
                return ExceptionHandler.handleAutomationException((AutomationException)throwable);
            }
            if (throwable instanceof UnsatisfiedLinkError) {
                throw new UnsatisfiedLinkError(resourceBundle.getString("BIN_NOT_FOUND"));
            }
            if (throwable instanceof UnknownHostException) {
                return new AOJException(resourceBundle.getString("INTEROP_HOST_EXCP"), throwable);
            }
            if (throwable instanceof IOException) {
                return new AOJException(resourceBundle.getString("INTEROP_IO_EXCP"), throwable);
            }
            return new AOJException(resourceBundle.getString("UNEXPECTED"), throwable);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Printing error message in non-localized way. Missing Resource:com.esri.arcgis.system.commonerrorbundle");
            System.err.println("Unable to findcom.esri.arcgis.system.commonerrorbundlein CLASSPATH");
            missingResourceException.printStackTrace();
            return new AOJException(throwable);
        }
    }

    public static AOJException handleAutomationException(AutomationException automationException) {
        ResourceBundle resourceBundle;
        AOJException aOJException = null;
        try {
            resourceBundle = ResourceBundle.getBundle(n);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Printing error message in non-localized way. Missing Resource:com.esri.arcgis.system.commonerrorbundle");
            System.err.println("Unable to findcom.esri.arcgis.system.commonerrorbundlein CLASSPATH");
            missingResourceException.printStackTrace();
            aOJException = new AOJException(automationException.getMessage());
            aOJException.initCause(automationException);
            return aOJException;
        }
        aOJException = ExceptionHandler.b(automationException, resourceBundle);
        if (aOJException == null) {
            aOJException = ExceptionHandler.a(automationException, resourceBundle);
        }
        if (aOJException != null) {
            return aOJException;
        }
        return new AOJException(resourceBundle.getString("UNEXPECTED_INTEROP"), automationException);
    }

    public static int getErrorCode(long l2) {
        int n2 = (int)(0xFFFFL & l2);
        return n2;
    }

    public static int getFacility(long l2) {
        int n2 = (int)(l2 >>> 16 & 0x1FFFL);
        return n2;
    }

    private static AOJException a(AutomationException automationException, ResourceBundle resourceBundle) {
        long l2 = automationException.getCode();
        int n2 = ExceptionHandler.getFacility(l2);
        if (n2 == 8 || n2 == 7 || n2 == 0) {
            String string = automationException.getDescription();
            if (string != null && string.length() > 0) {
                return new AOJException(string, automationException);
            }
            return new AOJException(ExceptionHandler.getErrorDescription(l2), automationException);
        }
        return null;
    }

    private static native String getErrorDescription(long var0);

    private static AOJException b(AutomationException automationException, ResourceBundle resourceBundle) {
        long l2 = automationException.getCode();
        if (l2 == -2147418113L) {
            return new AOJException(resourceBundle.getString("CATASTROPHY"), automationException);
        }
        if (l2 == -2147467263L) {
            AOJException aOJException = new AOJException(resourceBundle.getString("NOT_IMPL"));
            aOJException.initCause(automationException);
            return aOJException;
        }
        if (l2 == -2147024882L) {
            OutOfMemoryError outOfMemoryError = new OutOfMemoryError(automationException.getMessage());
            outOfMemoryError.initCause(automationException);
            throw outOfMemoryError;
        }
        if (l2 == -2147024809L) {
            AOJException aOJException = new AOJException(resourceBundle.getString("INVALID_ARGS"));
            aOJException.initCause(automationException);
            return aOJException;
        }
        if (l2 == -2147467262L) {
            String string = resourceBundle.getString("NOINTERFACE");
            AOJException aOJException = new AOJException(string + automationException.getMessage());
            aOJException.initCause(automationException);
            return aOJException;
        }
        if (l2 == -2147467261L) {
            String string = resourceBundle.getString("NULL_POINTER");
            AOJException aOJException = new AOJException(string + automationException.getMessage());
            aOJException.initCause(automationException);
            return aOJException;
        }
        if (l2 == -2147024890L) {
            return new AOJException(resourceBundle.getString("INVALID_HANDLE"), automationException);
        }
        if (l2 == -2147467260L) {
            return new AOJException(resourceBundle.getString("ABORT"), automationException);
        }
        if (l2 == -2147467259L) {
            return new AOJException(resourceBundle.getString("UNSPECIFIED_ERROR"), automationException);
        }
        if (l2 == -2147024891L) {
            AOJException aOJException = new AOJException(resourceBundle.getString("ACCESS_DENIED"));
            aOJException.initCause(automationException);
            return aOJException;
        }
        return null;
    }
}

