/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.geoprocessing.tools.spatialanalysttools;

import com.esri.arcgis.geoprocessing.AbstractGPTool;
import com.esri.arcgis.geoprocessing.tools.spatialanalysttools.ZonalStatisticsAsTable;
import com.esri.arcgis.interop.Dispatch;

public class PointsSolarRadiation
extends AbstractGPTool {
    public PointsSolarRadiation() {
        int n2 = ZonalStatisticsAsTable.b;
        this.vals = new Object[21];
        this.vals[3] = new Double(0.0);
        this.vals[5] = new Integer(200);
        this.vals[7] = new Integer(14);
        this.vals[8] = new Double(0.5);
        this.vals[9] = "false";
        this.vals[10] = new Double(1.0);
        this.vals[11] = "FROM_DEM";
        this.vals[12] = new Integer(32);
        this.vals[13] = new Integer(8);
        this.vals[14] = new Integer(8);
        this.vals[15] = "UNIFORM_SKY";
        this.vals[16] = new Double(0.3);
        this.vals[17] = new Double(0.5);
        if (n2 != 0) {
            int n3 = Dispatch.I;
            Dispatch.I = ++n3;
        }
    }

    public PointsSolarRadiation(Object object, Object object2, Object object3) {
        this();
        this.vals[0] = object;
        this.vals[1] = object2;
        this.vals[2] = object3;
    }

    public Object getInSurfaceRaster() {
        return this.vals[0];
    }

    public void setInSurfaceRaster(Object object) {
        this.vals[0] = object;
    }

    public Object getInPointsFeatureOrTable() {
        return this.vals[1];
    }

    public void setInPointsFeatureOrTable(Object object) {
        this.vals[1] = object;
    }

    public Object getOutGlobalRadiationFeatures() {
        return this.vals[2];
    }

    public void setOutGlobalRadiationFeatures(Object object) {
        this.vals[2] = object;
    }

    public double getHeightOffset() {
        return this.vals[3] == null ? 0.0 : (Double)this.vals[3];
    }

    public void setHeightOffset(double d2) {
        this.vals[3] = new Double(d2);
    }

    public double getLatitude() {
        return this.vals[4] == null ? 0.0 : (Double)this.vals[4];
    }

    public void setLatitude(double d2) {
        this.vals[4] = new Double(d2);
    }

    public int getSkySize() {
        return this.vals[5] == null ? 0 : (Integer)this.vals[5];
    }

    public void setSkySize(int n2) {
        this.vals[5] = new Integer(n2);
    }

    public Object getTimeConfiguration() {
        return this.vals[6];
    }

    public void setTimeConfiguration(Object object) {
        this.vals[6] = object;
    }

    public int getDayInterval() {
        return this.vals[7] == null ? 0 : (Integer)this.vals[7];
    }

    public void setDayInterval(int n2) {
        this.vals[7] = new Integer(n2);
    }

    public double getHourInterval() {
        return this.vals[8] == null ? 0.0 : (Double)this.vals[8];
    }

    public void setHourInterval(double d2) {
        this.vals[8] = new Double(d2);
    }

    public String getEachInterval() {
        return this.vals[9] == null ? null : (String)this.vals[9];
    }

    public void setEachInterval(String string) {
        this.vals[9] = string;
    }

    public double getZFactor() {
        return this.vals[10] == null ? 0.0 : (Double)this.vals[10];
    }

    public void setZFactor(double d2) {
        this.vals[10] = new Double(d2);
    }

    public String getSlopeAspectInputType() {
        return this.vals[11] == null ? null : (String)this.vals[11];
    }

    public void setSlopeAspectInputType(String string) {
        this.vals[11] = string;
    }

    public int getCalculationDirections() {
        return this.vals[12] == null ? 0 : (Integer)this.vals[12];
    }

    public void setCalculationDirections(int n2) {
        this.vals[12] = new Integer(n2);
    }

    public int getZenithDivisions() {
        return this.vals[13] == null ? 0 : (Integer)this.vals[13];
    }

    public void setZenithDivisions(int n2) {
        this.vals[13] = new Integer(n2);
    }

    public int getAzimuthDivisions() {
        return this.vals[14] == null ? 0 : (Integer)this.vals[14];
    }

    public void setAzimuthDivisions(int n2) {
        this.vals[14] = new Integer(n2);
    }

    public String getDiffuseModelType() {
        return this.vals[15] == null ? null : (String)this.vals[15];
    }

    public void setDiffuseModelType(String string) {
        this.vals[15] = string;
    }

    public double getDiffuseProportion() {
        return this.vals[16] == null ? 0.0 : (Double)this.vals[16];
    }

    public void setDiffuseProportion(double d2) {
        this.vals[16] = new Double(d2);
    }

    public double getTransmittivity() {
        return this.vals[17] == null ? 0.0 : (Double)this.vals[17];
    }

    public void setTransmittivity(double d2) {
        this.vals[17] = new Double(d2);
    }

    public Object getOutDirectRadiationFeatures() {
        return this.vals[18];
    }

    public void setOutDirectRadiationFeatures(Object object) {
        this.vals[18] = object;
    }

    public Object getOutDiffuseRadiationFeatures() {
        return this.vals[19];
    }

    public void setOutDiffuseRadiationFeatures(Object object) {
        this.vals[19] = object;
    }

    public Object getOutDirectDurationFeatures() {
        return this.vals[20];
    }

    public void setOutDirectDurationFeatures(Object object) {
        this.vals[20] = object;
    }

    public String getToolName() {
        return "PointsSolarRadiation";
    }

    public String getToolboxName() {
        return "Spatial Analyst Tools";
    }

    public String getToolboxAlias() {
        return "sa";
    }
}

