/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.geoprocessing.tools.spatialanalysttools;

import com.esri.arcgis.geoprocessing.AbstractGPTool;
import com.esri.arcgis.geoprocessing.tools.spatialanalysttools.ZonalStatisticsAsTable;
import com.esri.arcgis.interop.Dispatch;

public class AreaSolarRadiation
extends AbstractGPTool {
    public AreaSolarRadiation() {
        int n2 = ZonalStatisticsAsTable.b;
        this.vals = new Object[19];
        this.vals[3] = new Integer(200);
        this.vals[5] = new Integer(14);
        this.vals[6] = new Double(0.5);
        this.vals[7] = "false";
        this.vals[8] = new Double(1.0);
        this.vals[9] = "FROM_DEM";
        this.vals[10] = new Integer(32);
        this.vals[11] = new Integer(8);
        this.vals[12] = new Integer(8);
        this.vals[13] = "UNIFORM_SKY";
        this.vals[14] = new Double(0.3);
        this.vals[15] = new Double(0.5);
        if (Dispatch.I != 0) {
            ZonalStatisticsAsTable.b = ++n2;
        }
    }

    public AreaSolarRadiation(Object object, Object object2) {
        this();
        this.vals[0] = object;
        this.vals[1] = object2;
    }

    public Object getInSurfaceRaster() {
        return this.vals[0];
    }

    public void setInSurfaceRaster(Object object) {
        this.vals[0] = object;
    }

    public Object getOutGlobalRadiationRaster() {
        return this.vals[1];
    }

    public void setOutGlobalRadiationRaster(Object object) {
        this.vals[1] = object;
    }

    public double getLatitude() {
        return this.vals[2] == null ? 0.0 : (Double)this.vals[2];
    }

    public void setLatitude(double d2) {
        this.vals[2] = new Double(d2);
    }

    public int getSkySize() {
        return this.vals[3] == null ? 0 : (Integer)this.vals[3];
    }

    public void setSkySize(int n2) {
        this.vals[3] = new Integer(n2);
    }

    public Object getTimeConfiguration() {
        return this.vals[4];
    }

    public void setTimeConfiguration(Object object) {
        this.vals[4] = object;
    }

    public int getDayInterval() {
        return this.vals[5] == null ? 0 : (Integer)this.vals[5];
    }

    public void setDayInterval(int n2) {
        this.vals[5] = new Integer(n2);
    }

    public double getHourInterval() {
        return this.vals[6] == null ? 0.0 : (Double)this.vals[6];
    }

    public void setHourInterval(double d2) {
        this.vals[6] = new Double(d2);
    }

    public String getEachInterval() {
        return this.vals[7] == null ? null : (String)this.vals[7];
    }

    public void setEachInterval(String string) {
        this.vals[7] = string;
    }

    public double getZFactor() {
        return this.vals[8] == null ? 0.0 : (Double)this.vals[8];
    }

    public void setZFactor(double d2) {
        this.vals[8] = new Double(d2);
    }

    public String getSlopeAspectInputType() {
        return this.vals[9] == null ? null : (String)this.vals[9];
    }

    public void setSlopeAspectInputType(String string) {
        this.vals[9] = string;
    }

    public int getCalculationDirections() {
        return this.vals[10] == null ? 0 : (Integer)this.vals[10];
    }

    public void setCalculationDirections(int n2) {
        this.vals[10] = new Integer(n2);
    }

    public int getZenithDivisions() {
        return this.vals[11] == null ? 0 : (Integer)this.vals[11];
    }

    public void setZenithDivisions(int n2) {
        this.vals[11] = new Integer(n2);
    }

    public int getAzimuthDivisions() {
        return this.vals[12] == null ? 0 : (Integer)this.vals[12];
    }

    public void setAzimuthDivisions(int n2) {
        this.vals[12] = new Integer(n2);
    }

    public String getDiffuseModelType() {
        return this.vals[13] == null ? null : (String)this.vals[13];
    }

    public void setDiffuseModelType(String string) {
        this.vals[13] = string;
    }

    public double getDiffuseProportion() {
        return this.vals[14] == null ? 0.0 : (Double)this.vals[14];
    }

    public void setDiffuseProportion(double d2) {
        this.vals[14] = new Double(d2);
    }

    public double getTransmittivity() {
        return this.vals[15] == null ? 0.0 : (Double)this.vals[15];
    }

    public void setTransmittivity(double d2) {
        this.vals[15] = new Double(d2);
    }

    public Object getOutDirectRadiationRaster() {
        return this.vals[16];
    }

    public void setOutDirectRadiationRaster(Object object) {
        this.vals[16] = object;
    }

    public Object getOutDiffuseRadiationRaster() {
        return this.vals[17];
    }

    public void setOutDiffuseRadiationRaster(Object object) {
        this.vals[17] = object;
    }

    public Object getOutDirectDurationRaster() {
        return this.vals[18];
    }

    public void setOutDirectDurationRaster(Object object) {
        this.vals[18] = object;
    }

    public String getToolName() {
        return "AreaSolarRadiation";
    }

    public String getToolboxName() {
        return "Spatial Analyst Tools";
    }

    public String getToolboxAlias() {
        return "sa";
    }
}

