/*
 * Decompiled with CFR 0.152.
 */
package com.esri.arcgis.geoprocessing.gen.params;

import com.esri.arcgis.geodatabase.IGPValue;
import com.esri.arcgis.geoprocessing.GPParameter;
import com.esri.arcgis.geoprocessing.gen.GPImporter;
import com.esri.arcgis.geoprocessing.gen.GenMethod;
import com.esri.arcgis.geoprocessing.gen.GenUtil;
import com.esri.arcgis.geoprocessing.gen.params.GPParamImporter;
import com.esri.arcgis.geoprocessing.gen.params.GPParamUtils;

public class GPLongImporter
implements GPParamImporter {
    public String getDataTypeName() {
        return "GPLong";
    }

    public void createDefaultConstructorStatement(GPImporter gPImporter, GenMethod genMethod, GPParameter gPParameter, int n2) throws Exception {
        if (gPParameter.getParameterType() == 2) {
            return;
        }
        IGPValue iGPValue = gPParameter.getValue();
        if (iGPValue == null) {
            return;
        }
        String string = iGPValue.getAsText();
        if (string != null && !"".equals(string.trim())) {
            string = string.trim();
            genMethod.statements.add("vals[" + n2 + "] = new Integer(" + string + ")" + ";" + " //" + gPParameter.getName());
        }
    }

    public void createRequiredParamsConstructorArgsAndStatement(GPImporter gPImporter, GenMethod genMethod, GPParameter gPParameter, int n2) throws Exception {
        if (gPParameter.getParameterType() != 0) {
            return;
        }
        String string = "int";
        String string2 = gPParameter.getName();
        String string3 = GenUtil.firstToLowerCase(GenUtil.removeSpecialChars(string2, GPImporter.removeChars));
        genMethod.params.put(string3, "int");
        genMethod.comments.add("@param " + string3 + " " + GPParamUtils.getParameterComment(gPImporter, gPParameter));
        genMethod.statements.add("vals[" + n2 + "] = new Integer(" + string3 + ")" + ";" + " //" + string2);
    }

    public void createMethods(GPImporter gPImporter, GPParameter gPParameter, int n2) throws Exception {
        String string = "int";
        String string2 = gPParameter.getName();
        GenMethod genMethod = GPParamUtils.createGetterMethodTemplate(gPImporter, gPParameter, "int");
        genMethod.statements.add("return vals[" + n2 + "] == null ? 0 : " + "((Integer)" + "vals" + "[" + n2 + "]).intValue()" + ";");
        gPImporter.gclass.methods.add(genMethod);
        if (gPParameter.getParameterType() == 2) {
            return;
        }
        GenMethod genMethod2 = GPParamUtils.createSetterMethodTemplate(gPImporter, gPParameter, "int");
        genMethod2.statements.add("vals[" + n2 + "] = new Integer(" + GenUtil.firstToLowerCase(GenUtil.removeSpecialChars(string2, GPImporter.removeChars)) + ")" + ";");
        gPImporter.gclass.methods.add(genMethod2);
    }
}

