/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.l10n.font;

import com.sas.nls.l10n.font.Messages;
import com.sas.nls.l10n.font.TTFontInfo;
import java.util.Collection;

final class TTMappingInfo
implements TTFontInfo {
    private final String fontFileName;
    private final String name;
    private final String familyName;
    private final String localizedName;
    private final String localizedFamilyName;
    private final boolean bold;
    private final boolean italic;
    private final int ttcIndex;
    private final Collection languages;
    private final Collection locales;

    TTMappingInfo(String fontFileName, String name, String familyName, String localizedName, String localizedFamilyName, int ttcIndex, boolean bold, boolean italic, Collection locales, Collection languages) {
        this.languages = languages;
        this.locales = locales;
        this.name = name;
        this.familyName = familyName;
        this.localizedName = Messages.getString(localizedName);
        this.localizedFamilyName = Messages.getString(localizedFamilyName);
        this.fontFileName = fontFileName;
        this.bold = bold;
        this.italic = italic;
        this.ttcIndex = ttcIndex;
    }

    @Override
    public String getFontFileName() {
        return this.fontFileName;
    }

    @Override
    public String getFontName() {
        return this.name;
    }

    @Override
    public String getFontFamilyName() {
        return this.familyName;
    }

    @Override
    public String getLocalizedFontName() {
        return this.localizedName;
    }

    @Override
    public String getLocalizedFontFamilyName() {
        return this.localizedFamilyName;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return this.italic;
    }

    @Override
    public int getTTCIndex() {
        return this.ttcIndex;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(this.fontFileName);
        buff.append("\t'").append(this.name).append("' '").append(this.familyName).append("' '");
        buff.append(this.localizedName).append("' '").append(this.localizedFamilyName).append("'");
        buff.append("\tIs bold:").append(this.bold);
        buff.append("\tIs Italic:").append(this.italic);
        buff.append("\tTTCIndex:").append(this.ttcIndex);
        return buff.toString();
    }

    Collection getLanguages() {
        return this.languages;
    }

    Collection getLocales() {
        return this.locales;
    }
}

