/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.l10n.font;

import com.sas.nls.l10n.font.TTMappingInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

class PropMappings {
    private static final String FILE_NAME = "ttfont.file.name.";
    private static final String DISPLAY_NAME = "ttfont.display.name.";
    private static final String FAMILY_NAME = "ttfont.display.family.name.";
    private static final String LOCALIZED_DISPLAY_NAME = "ttfont.localized.display.name.";
    private static final String LOCALIZED_FAMILY_NAME = "ttfont.localized.display.family.name.";
    private static final String BOLD = "ttfont.bold.";
    private static final String ITALIC = "ttfont.italic.";
    private static final String LOCALES = "ttfont.locales.";
    private static final String TTCINDEX = "ttfont.ttcIndex.";
    private static final String CONFIG_NAME = "fontdata.config";
    private static final TTMappingInfo[] NULL_MAPPINGS = new TTMappingInfo[0];
    private static final String BOLD_NAME = " Bold";
    private static final String ITALIC_NAME = " Italic";
    private final TTMappingInfo[] fontMappings = this.buildMappings();
    private final Map mapData = this.buildMapData();

    PropMappings() {
    }

    TTMappingInfo[] getFontMappings() {
        return this.fontMappings;
    }

    TTMappingInfo[] getMappingsForName(String name) {
        Set result;
        String nm = name.toLowerCase();
        if (!nm.endsWith(".ttf") && !nm.endsWith(".ttc") && (result = (Set)this.mapData.get(nm)) != null) {
            return result.toArray(new TTMappingInfo[result.size()]);
        }
        result = (Set)this.mapData.get(name);
        if (result != null) {
            return result.toArray(new TTMappingInfo[result.size()]);
        }
        return NULL_MAPPINGS;
    }

    private Map buildMapData() {
        HashMap map = new HashMap();
        for (int i = 0; i < this.fontMappings.length; ++i) {
            String fname = this.fontMappings[i].getFontFamilyName();
            this.addToMap(map, fname, this.fontMappings[i], true);
            String name = this.fontMappings[i].getFontFileName();
            this.addToMap(map, name, this.fontMappings[i], false);
            name = this.fontMappings[i].getFontName();
            this.addToMap(map, name, this.fontMappings[i], true);
            name = this.fontMappings[i].getLocalizedFontFamilyName();
            this.addToMap(map, name, this.fontMappings[i], true);
            name = this.fontMappings[i].getLocalizedFontName();
            this.addToMap(map, name, this.fontMappings[i], true);
        }
        return map;
    }

    private void addToMap(Map map, String fontName, TTMappingInfo info, boolean lowercase) {
        Set<TTMappingInfo> list;
        String name = fontName;
        int pos = name.indexOf(BOLD_NAME);
        if (pos == 0) {
            name = name.substring(BOLD_NAME.length());
        } else if (pos > 0) {
            name = name.substring(0, pos) + name.substring(pos + BOLD_NAME.length());
        }
        pos = name.indexOf(ITALIC_NAME);
        if (pos == 0) {
            name = name.substring(ITALIC_NAME.length());
        } else if (pos > 0) {
            name = name.substring(0, pos) + name.substring(pos + ITALIC_NAME.length());
        }
        String key = name;
        if (lowercase) {
            key = name.toLowerCase();
        }
        if ((list = (HashSet<TTMappingInfo>)map.get(key)) == null) {
            list = new HashSet<TTMappingInfo>();
            map.put(key, list);
        }
        list.add(info);
        if (!fontName.equals(name)) {
            key = fontName;
            if (lowercase) {
                key = fontName.toLowerCase();
            }
            if ((list = (Set)map.get(key)) == null) {
                list = new HashSet();
                map.put(key, list);
            }
            list.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TTMappingInfo[] buildMappings() {
        ArrayList<TTMappingInfo> mappings = new ArrayList<TTMappingInfo>();
        HashMap localeMap = new HashMap();
        HashMap languageMap = new HashMap();
        Properties config = new Properties();
        BufferedInputStream is = null;
        try {
            String key;
            String name;
            is = new BufferedInputStream(PropMappings.class.getResourceAsStream(CONFIG_NAME));
            config.load(is);
            int i = 0;
            while ((name = config.getProperty(key = FILE_NAME + i)) != null) {
                key = DISPLAY_NAME + i;
                String displayName = config.getProperty(key);
                key = FAMILY_NAME + i;
                String familyName = config.getProperty(key);
                key = LOCALIZED_DISPLAY_NAME + i;
                String localizedDisplayName = config.getProperty(key);
                key = LOCALIZED_FAMILY_NAME + i;
                String localizedFamilyName = config.getProperty(key);
                key = BOLD + i;
                String bold = config.getProperty(key);
                key = ITALIC + i;
                String italic = config.getProperty(key);
                key = LOCALES + i;
                String localeKey = config.getProperty(key);
                key = TTCINDEX + i;
                String indexStr = config.getProperty(key);
                int ttcIndex = -1;
                if (indexStr != null && indexStr.length() > 0) {
                    ttcIndex = Integer.parseInt(indexStr);
                }
                Collection locales = this.getLocales(localeMap, localeKey, config);
                Collection languages = this.getLanguages(languageMap, localeKey, locales);
                mappings.add(new TTMappingInfo(name, displayName, familyName, localizedDisplayName, localizedFamilyName, ttcIndex, Boolean.valueOf(bold), Boolean.valueOf(italic), locales, languages));
                ++i;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return mappings.toArray(new TTMappingInfo[mappings.size()]);
    }

    private Collection getLocales(Map localeMap, String localeKey, Properties config) {
        Collection result = (Collection)localeMap.get(localeKey);
        if (result != null) {
            return result;
        }
        String localeGroups = config.getProperty(localeKey);
        StringTokenizer tokenizer = new StringTokenizer(localeGroups, ", ", false);
        HashSet<String> locales = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String locKey = tokenizer.nextToken();
            String loccs = config.getProperty(locKey);
            StringTokenizer locTok = new StringTokenizer(loccs, ", ", false);
            while (locTok.hasMoreTokens()) {
                String loc = locTok.nextToken();
                locales.add(loc);
            }
        }
        result = Collections.unmodifiableCollection(locales);
        localeMap.put(localeKey, result);
        return result;
    }

    private Collection getLanguages(Map languageMap, String localeKey, Collection locales) {
        Collection result = (Collection)languageMap.get(localeKey);
        if (result != null) {
            return result;
        }
        HashSet<String> languages = new HashSet<String>();
        for (String localeName : locales) {
            String region;
            String lang;
            Locale locale;
            if (localeName.length() == 2) {
                locale = new Locale(localeName);
                languages.add(locale.getDisplayName(Locale.US));
                continue;
            }
            if (localeName.startsWith("zh")) {
                if (localeName.equalsIgnoreCase("zh_CN") || localeName.equals("zh_SG")) {
                    languages.add("Chinese (Simplified)");
                } else {
                    languages.add("Chinese (Traditional)");
                }
                lang = localeName.substring(0, 2);
                region = localeName.substring(3, 5);
                locale = new Locale(lang, region);
                languages.add(locale.getDisplayName(Locale.US));
                languages.add(locale.getDisplayLanguage(Locale.US));
                continue;
            }
            lang = localeName.substring(0, 2);
            region = localeName.substring(3, 5);
            locale = new Locale(lang, region);
            languages.add(locale.getDisplayLanguage(Locale.US));
        }
        result = Collections.unmodifiableCollection(languages);
        languageMap.put(localeKey, result);
        return result;
    }
}

