/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.l10n.font;

import com.sas.nls.l10n.font.PropMappings;
import com.sas.nls.l10n.font.TTFontInfo;
import com.sas.nls.l10n.font.TTMappingInfo;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LoadTTFont {
    private static final Pattern boldPattern = Pattern.compile("(.*)\\s[Bb][Oo][Ll][Dd](.*)");
    private static final Pattern italicPattern = Pattern.compile("(.*)\\s[Ii][Tt][Aa][Ll][Ii][Cc](.*)");
    private static final Pattern plainPattern = Pattern.compile("(.*)\\s[Pp][Ll][Aa][Ii][Nn](.*)");
    private static final Collection FONT_ROOT_PATH;
    private static final Map fontCache;
    private PropMappings pMappings;
    private static final String fontPath;

    LoadTTFont(PropMappings mappings) {
        this.pMappings = mappings;
    }

    Font loadFont(String name, int style, int size) {
        NameAndStyle nameAndStyle = this.setupNameAndStyle(name, style, size);
        Font font = this.loadTrueTypeFont(nameAndStyle);
        if (font != null) {
            return font;
        }
        return new Font(name, style, size);
    }

    Font loadFont(String text) {
        Font font;
        NameAndStyle nameAndStyle = this.setupNameAndStyle(text);
        if (nameAndStyle.fontName != null && (font = this.loadTrueTypeFont(nameAndStyle)) != null) {
            return font;
        }
        return new Font("Dialog", nameAndStyle.style, nameAndStyle.size);
    }

    Font loadFont(Map attributes) {
        NameAndStyle nameAndStyle = this.setupNameAndStyle(attributes);
        Font font = this.loadTrueTypeFont(nameAndStyle);
        if (font != null) {
            return font;
        }
        return new Font(attributes);
    }

    String getITextFileName(String name, int style) {
        NameAndStyle nameAndStyle = this.setupNameAndStyle(name, style, 12);
        TTFontInfo fontInfo = this.findFontInfoNoFilter(nameAndStyle.fontName, nameAndStyle.bold, nameAndStyle.italic);
        if (fontInfo == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(fontPath);
        buff.append("/");
        buff.append(fontInfo.getFontFileName());
        int index = fontInfo.getTTCIndex();
        if (index >= 0) {
            buff.append(",").append(index);
        }
        return buff.toString();
    }

    TTFontInfo findTrueTypeFontInfo(String name, int style) {
        NameAndStyle nameAndStyle = this.setupNameAndStyle(name, style, 12);
        return this.findFontInfo(nameAndStyle.fontName, nameAndStyle.bold, nameAndStyle.italic);
    }

    TTFontInfo findTrueTypeFontInfo(String name) {
        NameAndStyle nameAndStyle = this.setupNameAndStyle(name);
        return this.findFontInfo(nameAndStyle.fontName, nameAndStyle.bold, nameAndStyle.italic);
    }

    TTFontInfo findTrueTypeFontInfo(Map attributes) {
        NameAndStyle nameAndStyle = this.setupNameAndStyle(attributes);
        return this.findFontInfo(nameAndStyle.fontName, nameAndStyle.bold, nameAndStyle.italic);
    }

    private Font loadTrueTypeFont(NameAndStyle nameAndStyle) {
        TTFontInfo fontInfo = this.findFontInfo(nameAndStyle.fontName, nameAndStyle.bold, nameAndStyle.italic);
        if (fontInfo != null && fontInfo.getTTCIndex() <= 0) {
            String key = fontInfo.getFontFileName();
            if (fontCache.containsKey(key)) {
                return ((Font)fontCache.get(key)).deriveFont(nameAndStyle.style, nameAndStyle.size);
            }
            try {
                for (String path : FONT_ROOT_PATH) {
                    Font font;
                    StringBuffer buff = new StringBuffer(path);
                    if (!path.endsWith("/") && !path.endsWith("\\")) {
                        buff.append("/");
                    }
                    buff.append(fontInfo.getFontFileName());
                    File fontFile = new File(buff.toString());
                    if (!fontFile.exists() || (font = Font.createFont(0, fontFile)) == null) continue;
                    fontCache.put(fontInfo.getFontFileName(), font);
                    return font.deriveFont(nameAndStyle.style, nameAndStyle.size);
                }
            }
            catch (FontFormatException fontFormatException) {
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private NameAndStyle setupNameAndStyle(String name, int style, int size) {
        NameAndStyle result = new NameAndStyle();
        result.bold = (style & 1) != 0;
        result.italic = (style & 2) != 0;
        result.style = style;
        result.size = size;
        this.processName(name, result);
        return result;
    }

    private NameAndStyle setupNameAndStyle(String name) {
        NameAndStyle result = new NameAndStyle();
        StringTokenizer tokenizer = new StringTokenizer(name, ",", false);
        result.fontName = null;
        result.style = 0;
        result.size = 12;
        if (tokenizer.hasMoreTokens()) {
            result.fontName = tokenizer.nextToken().trim();
            this.processName(result.fontName, result);
            if (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                result.style |= Integer.parseInt(value);
                if ((result.style & 1) != 0) {
                    result.bold = true;
                }
                if ((result.style & 2) != 0) {
                    result.italic = true;
                }
                if (tokenizer.hasMoreTokens()) {
                    value = tokenizer.nextToken();
                    result.size = Integer.parseInt(value);
                }
            }
        }
        return result;
    }

    private NameAndStyle setupNameAndStyle(Map attributes) {
        Float value;
        Object object;
        NameAndStyle result = new NameAndStyle();
        result.style = 0;
        result.fontName = (String)attributes.get(TextAttribute.FONT);
        String family = (String)attributes.get(TextAttribute.FAMILY);
        if (family != null) {
            this.processName(family, result);
        }
        if ((object = attributes.get(TextAttribute.WEIGHT)) != null && object instanceof Float && (value = (Float)object).floatValue() >= TextAttribute.WEIGHT_MEDIUM.floatValue()) {
            result.style |= 1;
            result.bold = true;
        }
        if ((object = attributes.get(TextAttribute.POSTURE)) != null && object instanceof Float && (double)(value = (Float)object).floatValue() > 0.1) {
            result.style |= 2;
            result.italic = true;
        }
        result.size = 12;
        object = attributes.get(TextAttribute.SIZE);
        if (object != null && object instanceof Float) {
            value = (Float)object;
            result.size = value.intValue();
        }
        return result;
    }

    private void processName(String name, NameAndStyle result) {
        result.fontName = name;
        Matcher matcher = boldPattern.matcher(result.fontName);
        if (matcher.find()) {
            result.style |= 1;
            result.bold = true;
            result.fontName = matcher.group(1) + matcher.group(2);
        }
        if ((matcher = italicPattern.matcher(result.fontName)).find()) {
            result.style |= 2;
            result.italic = true;
            result.fontName = matcher.group(1) + matcher.group(2);
        }
        if ((matcher = plainPattern.matcher(result.fontName)).find()) {
            result.fontName = matcher.group(1) + matcher.group(2);
        }
    }

    private TTFontInfo findFontInfo(String name, boolean bold, boolean italic) {
        TTMappingInfo[] mappings = this.pMappings.getMappingsForName(name);
        if (mappings.length == 1 && mappings[0].getTTCIndex() <= 0) {
            return mappings[0];
        }
        TTMappingInfo plain = null;
        for (int i = 0; i < mappings.length; ++i) {
            if (mappings[i].getTTCIndex() > 0) continue;
            if (mappings[i].isBold() == bold && mappings[i].isItalic() == italic) {
                return mappings[i];
            }
            if (mappings[i].isBold() || mappings[i].isItalic()) continue;
            plain = mappings[i];
        }
        return plain;
    }

    private TTFontInfo findFontInfoNoFilter(String name, boolean bold, boolean italic) {
        TTMappingInfo[] mappings = this.pMappings.getMappingsForName(name);
        if (mappings.length == 1) {
            return mappings[0];
        }
        TTMappingInfo plain = null;
        for (int i = 0; i < mappings.length; ++i) {
            int index = mappings[i].getTTCIndex();
            if (index >= 0 && (index != 0 || !mappings[i].getFontFileName().equals(name)) && (index < 0 || mappings[i].getFontFileName().equals(name))) continue;
            if (mappings[i].isBold() == bold && mappings[i].isItalic() == italic) {
                return mappings[i];
            }
            if (mappings[i].isBold() || mappings[i].isItalic()) continue;
            plain = mappings[i];
        }
        return plain;
    }

    static {
        fontPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sas.fontpath");
            }
        });
        FONT_ROOT_PATH = new ArrayList();
        if (fontPath != null) {
            StringTokenizer tokenizer = new StringTokenizer(fontPath, File.pathSeparator, false);
            while (tokenizer.hasMoreTokens()) {
                FONT_ROOT_PATH.add(tokenizer.nextToken());
            }
        }
        fontCache = Collections.synchronizedMap(new WeakHashMap());
    }

    static class NameAndStyle {
        boolean bold = false;
        boolean italic = false;
        String fontName = "";
        int style = 0;
        int size = 12;

        NameAndStyle() {
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("NameAndStyle b:");
            buff.append(this.bold).append(" i:").append(this.italic);
            buff.append(" n:").append(this.fontName).append(" st:");
            buff.append(this.style).append(" sz:").append(this.size);
            return buff.toString();
        }
    }
}

