/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

public class TypesHelper {
    public static final String DESC_AND_VALUE = "%s(%d)";
    public static final String VALUE = "%d";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String UNKNOWN_VALUE = "unknownValue(%d)";
    public static final String KEYWORD_VALUE = "%s(%d)=%d";
    public static final String KEYWORD_DESC_VALUE = "%s(%d)=%s(%d)";
    public transient String key = null;
    public transient String value = null;
    public transient String pair = null;
    private static final String t_array = "ARRAY";
    private static final String t_bigint = "BIGINT";
    private static final String t_binary = "BINARY";
    private static final String t_bit = "BIT";
    private static final String t_blob = "BLOB";
    private static final String t_boolean = "BOOLEAN";
    private static final String t_char = "CHAR";
    private static final String t_clob = "CLOB";
    private static final String t_datalink = "DATALINK";
    private static final String t_date = "DATE";
    private static final String t_decimal = "DECIMAL";
    private static final String t_distinct = "DISTINCT";
    private static final String t_double = "DOUBLE";
    private static final String t_float = "FLOAT";
    private static final String t_integer = "INTEGER";
    private static final String t_java_object = "JAVA_OBJECT";
    private static final String t_longvarbinary = "LONGVARBINARY";
    private static final String t_longvarchar = "LONGVARCHAR";
    private static final String t_nchar = "NCHAR";
    private static final String t_nclob = "NCLOB";
    private static final String t_null = "NULL";
    private static final String t_numeric = "NUMERIC";
    private static final String t_nvarchar = "NVARCHAR";
    private static final String t_other = "OTHER";
    private static final String t_real = "REAL";
    private static final String t_ref = "REF";
    private static final String t_rowid = "ROWDID";
    private static final String t_smallint = "SMALLINT";
    private static final String t_time = "TIME";
    private static final String t_timestamp = "TIMESTAMP";
    private static final String t_tinyint = "TINYINT";
    private static final String t_varbinary = "VARBINARY";
    private static final String t_varchar = "VARCHAR";
    private static final String t_wlongvarchar = "WLONGVARCHAR";
    private static final String t_longnvarchar = "LONGNVARCHAR";
    private static final String t_unknown_sqlType = "UNKNOWN SQLType:";

    public static String getDeleteRule(short inVal) {
        String out = null;
        switch (inVal) {
            case 3: {
                out = "importedKeyNoAction";
                break;
            }
            case 0: {
                out = "importedKeyCascade";
                break;
            }
            case 2: {
                out = "importedKeySetNull";
                break;
            }
            case 1: {
                out = "importedKeyRestrict";
                break;
            }
            case 4: {
                out = "importedKeySetDefault";
                break;
            }
        }
        return out;
    }

    public static String getDeleteRuleDesc(short inVal) {
        String out = null;
        switch (inVal) {
            case 3: {
                out = "do not allow delete of parent key if it has been imported";
                break;
            }
            case 0: {
                out = "delete rows that import a deleted key";
                break;
            }
            case 2: {
                out = "change imported key to NULL if its primary key has been deleted";
                break;
            }
            case 1: {
                out = "same as importedKeyNoAction (for ODBC 2.x compatibility)";
                break;
            }
            case 4: {
                out = "change imported key to default if its parent key has been deleted";
                break;
            }
        }
        return out;
    }

    public static String getFetchDirection(int inBindDirection) {
        String outfetchDirection = null;
        String fd_ff = "FETCH_FORWARD";
        String fd_fr = "FETCH_REVERSE";
        String fd_fu = "FETCH_UNKNOWN";
        switch (inBindDirection) {
            case 1000: {
                outfetchDirection = "FETCH_FORWARD";
                break;
            }
            case 1001: {
                outfetchDirection = "FETCH_REVERSE";
                break;
            }
            case 1002: {
                outfetchDirection = "FETCH_UNKNOWN";
                break;
            }
        }
        return outfetchDirection;
    }

    public static String getFetchDirectionU(int inBindDirection) {
        String outfetchDirection = TypesHelper.getFetchDirection(inBindDirection);
        String fd_inv = "????";
        if (outfetchDirection == null) {
            outfetchDirection = "????";
        }
        return outfetchDirection;
    }

    public static String getFetchOrientation(int fetchOrientation) {
        String fa = "TKTS_FETCH_ABSOLUTE";
        String ff = "TKTS_FETCH_FIRST";
        String fl = "TKTS_FETCH_LAST";
        String fn = "TKTS_FETCH_NEXT";
        String fp = "TKTS_FETCH_PRIOR";
        String outString = null;
        switch (fetchOrientation) {
            case 5: {
                outString = "TKTS_FETCH_ABSOLUTE";
                break;
            }
            case 2: {
                outString = "TKTS_FETCH_FIRST";
                break;
            }
            case 3: {
                outString = "TKTS_FETCH_LAST";
                break;
            }
            case 1: {
                outString = "TKTS_FETCH_NEXT";
                break;
            }
            case 4: {
                outString = "TKTS_FETCH_PRIOR";
                break;
            }
        }
        return outString;
    }

    public static String getFetchOrientationU(int fetchOrientation) {
        String fu = "TKTS_FETCH_????";
        String outString = TypesHelper.getFetchOrientation(fetchOrientation);
        if (outString == null) {
            outString = "TKTS_FETCH_????";
        }
        return outString;
    }

    public static String getIndexType(short inVal) {
        String out = null;
        switch (inVal) {
            case 0: {
                out = "tableIndexStatistic";
                break;
            }
            case 1: {
                out = "tableIndexClustered";
                break;
            }
            case 2: {
                out = "tableIndexHashed";
                break;
            }
            case 3: {
                out = "tableIndexOther";
                break;
            }
        }
        return out;
    }

    public static String getParameterMode(int inVal) {
        String out = null;
        switch (inVal) {
            case 0: {
                out = "Unknown(0)";
                break;
            }
            case 1: {
                out = "In(1)";
                break;
            }
            case 2: {
                out = "InOut(2)";
                break;
            }
            case 4: {
                out = "Out(4)";
                break;
            }
            default: {
                String FORMAT = UNKNOWN_VALUE;
                out = String.format(UNKNOWN_VALUE, inVal);
            }
        }
        return out;
    }

    public static String getParameterNullable(int inVal) {
        String out = null;
        switch (inVal) {
            case 0: {
                out = "NoNulls(0)";
                break;
            }
            case 1: {
                out = "Nullable(1)";
                break;
            }
            case 2: {
                out = "NullableUnknown(2)";
                break;
            }
            default: {
                String FORMAT = UNKNOWN_VALUE;
                out = String.format(UNKNOWN_VALUE, inVal);
            }
        }
        return out;
    }

    public static String getResultSetType(int type) {
        String out = null;
        switch (type) {
            case 1003: {
                out = "TYPE_FORWARD_ONLY";
                break;
            }
            case 1004: {
                out = "TYPE_SCROLL_INSENSITIVE";
                break;
            }
            case 1005: {
                out = "TYPE_SCROLL_SENSITIVE";
                break;
            }
        }
        return out;
    }

    public static String getResultSetTypeU(int type) {
        String un = "TYPE_????";
        String outString = TypesHelper.getResultSetType(type);
        if (outString == null) {
            outString = "TYPE_????";
        }
        return outString;
    }

    public static String getResultSetTypeB(int type) {
        String outString = TypesHelper.getResultSetTypeU(type);
        String FORMAT = DESC_AND_VALUE;
        outString = String.format(DESC_AND_VALUE, outString, type);
        return outString;
    }

    public static String getResultSetConcurrency(int concurrency) {
        switch (concurrency) {
            case 1007: {
                return "CONCUR_READ_ONLY";
            }
            case 1008: {
                return "CONCUR_UPDATABLE";
            }
        }
        return null;
    }

    public static String getResultSetConcurrencyU(int type) {
        String un = "CONCUR_????";
        String outString = TypesHelper.getResultSetConcurrency(type);
        if (outString == null) {
            outString = "CONCUR_????";
        }
        return outString;
    }

    public static String getResultSetConcurrencyB(int type) {
        String outString = TypesHelper.getResultSetConcurrencyU(type);
        String FORMAT = DESC_AND_VALUE;
        outString = String.format(DESC_AND_VALUE, outString, type);
        return outString;
    }

    public static String getResultSetHoldability(int holdability) {
        String rsHoldability = null;
        switch (holdability) {
            case 1: {
                rsHoldability = "HOLD_CURSORS_OVER_COMMIT";
                break;
            }
            case 2: {
                rsHoldability = "CLOSE_CURSORS_AT_COMMIT";
                break;
            }
        }
        return rsHoldability;
    }

    public static String getResultSetHoldabilityU(int type) {
        String un = "CURSORS_HOLDABILITY_????";
        String outString = TypesHelper.getResultSetHoldability(type);
        if (outString == null) {
            outString = "CURSORS_HOLDABILITY_????";
        }
        return outString;
    }

    public static String getResultSetHoldabilityB(int type) {
        String outString = TypesHelper.getResultSetHoldabilityU(type);
        String FORMAT = DESC_AND_VALUE;
        outString = String.format(DESC_AND_VALUE, outString, type);
        return outString;
    }

    public static String getSearchable(short inValue) {
        String out = null;
        switch (inValue) {
            case 0: {
                out = "typePredNone ";
                break;
            }
            case 1: {
                out = "typePredChar WHERE Clause Not Supported";
                break;
            }
            case 2: {
                out = "typePredBasic";
                break;
            }
            case 3: {
                out = "typeSearchable";
                break;
            }
        }
        return out;
    }

    public static String getTransactionIsolationLevel(int level) {
        String transactionIsolationLevel = null;
        switch (level) {
            case 0: {
                transactionIsolationLevel = "TRANSACTION_NONE";
                break;
            }
            case 2: {
                transactionIsolationLevel = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 1: {
                transactionIsolationLevel = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 4: {
                transactionIsolationLevel = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                transactionIsolationLevel = "TRANSACTION_SERIALIZABLE";
                break;
            }
        }
        return transactionIsolationLevel;
    }

    public static String getNullability(int attr) {
        String out = null;
        switch (attr) {
            case 0: {
                out = "ATTRIBUTE_NO_NULLS";
                break;
            }
            case 1: {
                out = "ATTRIBUTE_NULLABLE";
                break;
            }
            case 2: {
                out = "ATTRIBUTE_NULLABLE_UNKNOWN";
                break;
            }
        }
        return out;
    }

    public static String getKey(int keyValue) {
        switch (keyValue) {
            case 0: {
                return "IMPORTED KEY CASCADE";
            }
            case 3: {
                return "IMPORTED KEY NO ACTION";
            }
            case 2: {
                return "IMPORTED KEY SET NULL";
            }
            case 4: {
                return "IMPORTED KEY SET DEFAULT";
            }
            case 1: {
                return "IMPORTED KEY RESTRICT";
            }
        }
        return null;
    }

    public static String getFunctionColumnType(int funcColValue) {
        switch (funcColValue) {
            case 0: {
                return "FUNCTION_COLUMN_UNKNOWN";
            }
            case 1: {
                return "FUNCTION_COLUMN_IN";
            }
            case 2: {
                return "FUNCTION_COLUMN_IN_OUT";
            }
            case 3: {
                return "FUNCTION_COLUMN_OUT";
            }
            case 4: {
                return "FUNCTION_RETURN";
            }
            case 5: {
                return "FUNCTION_COLUMN_RESULT";
            }
        }
        return null;
    }

    public static String getFunctionColumnNullability(int funcColValue) {
        switch (funcColValue) {
            case 0: {
                return "FUNCTION_NO_NULLS";
            }
            case 1: {
                return "FUNCTION_NULLABLE";
            }
            case 2: {
                return "FUNCTION_NULLABLE_UNKNOWN";
            }
        }
        return null;
    }

    public static String getFunctionType(int funcTypeValue) {
        switch (funcTypeValue) {
            case 0: {
                return "FUNCTION_RESULT_UNKNOWN";
            }
            case 1: {
                return "FUNCTION_NO_TABLE";
            }
            case 2: {
                return "FUNCTION_RETURNS_TABLE";
            }
        }
        return null;
    }

    public static String getDeferrability(short inVal) {
        String out = null;
        switch (inVal) {
            case 5: {
                out = "IMPORTED_KEY_INITIALLY_DEFERRED";
            }
            case 6: {
                out = "IMPORTED_KEY_INITIALLY_IMMEDIATE";
            }
            case 7: {
                out = "IMPORTED_KEY_NOT_DEFERRABLE";
            }
        }
        return out;
    }

    public static String getProcedureColumnType(int procColValue) {
        switch (procColValue) {
            case 0: {
                return "PROCEDURE_COLUMN_UNKNOWN";
            }
            case 1: {
                return "PROCEDURE_COLUMN_IN";
            }
            case 2: {
                return "PROCEDURE_COLUMN_IN_OUT";
            }
            case 4: {
                return "PROCEDURE_COLUMN_OUT";
            }
            case 5: {
                return "PROCEDURE_COLUMN_RETURN";
            }
            case 3: {
                return "PROCEDURE_COLUMN_RESULT";
            }
        }
        return null;
    }

    public static String getProcedureColumnNullability(int procColValue) {
        switch (procColValue) {
            case 0: {
                return "PROCEDURE_NO_NULLS";
            }
            case 1: {
                return "PROCEDURE_NULLABLE";
            }
            case 2: {
                return "PROCEDURE_NULLABLE_UNKNOWN";
            }
        }
        return null;
    }

    public static String getProcedureType(short procTypeValue) {
        String procedureType = null;
        switch (procTypeValue) {
            case 0: {
                procedureType = "PROCEDURE_RESULT_UNKNOWN";
            }
            case 1: {
                procedureType = "PROCEDURE_NO_RESULT";
            }
            case 2: {
                procedureType = "PROCEDURE_RETURNS_RESULT";
            }
        }
        return procedureType;
    }

    public static String getPseudoColumn(short pseudoColValue) {
        String pseudoColumn = null;
        switch (pseudoColValue) {
            case 0: {
                pseudoColumn = "VERSION_COLUMN_UNKNOWN";
            }
            case 1: {
                pseudoColumn = "VERSION_COLUMN_NOT_PSEUDO";
            }
            case 2: {
                pseudoColumn = "VERSION_COLUMN_PSEUDO";
            }
        }
        return pseudoColumn;
    }

    public static String getSQLTypeString(int sqlType) {
        String outString = null;
        switch (sqlType) {
            case 2003: {
                outString = t_null;
                break;
            }
            case -5: {
                outString = t_bigint;
                break;
            }
            case -2: {
                outString = t_binary;
                break;
            }
            case -7: {
                outString = t_bit;
                break;
            }
            case 2004: {
                outString = t_blob;
                break;
            }
            case 16: {
                outString = t_boolean;
                break;
            }
            case 1: {
                outString = t_char;
                break;
            }
            case 2005: {
                outString = t_clob;
                break;
            }
            case 70: {
                outString = t_datalink;
                break;
            }
            case 91: {
                outString = t_date;
                break;
            }
            case 3: {
                outString = t_decimal;
                break;
            }
            case 2001: {
                outString = t_distinct;
                break;
            }
            case 8: {
                outString = t_double;
                break;
            }
            case 6: {
                outString = t_float;
                break;
            }
            case 4: {
                outString = t_integer;
                break;
            }
            case 2000: {
                outString = t_java_object;
                break;
            }
            case -4: {
                outString = t_longvarbinary;
                break;
            }
            case -1: {
                outString = t_longvarchar;
                break;
            }
            case -15: {
                outString = t_nchar;
                break;
            }
            case 2011: {
                outString = t_nclob;
                break;
            }
            case 0: {
                outString = t_array;
                break;
            }
            case 2: {
                outString = t_numeric;
                break;
            }
            case -9: {
                outString = t_nvarchar;
                break;
            }
            case 1111: {
                outString = t_other;
                break;
            }
            case 7: {
                outString = t_real;
                break;
            }
            case 2006: {
                outString = t_ref;
                break;
            }
            case -8: {
                outString = t_rowid;
                break;
            }
            case 5: {
                outString = t_smallint;
                break;
            }
            case 92: {
                outString = t_time;
                break;
            }
            case 93: {
                outString = t_timestamp;
                break;
            }
            case -6: {
                outString = t_tinyint;
                break;
            }
            case -3: {
                outString = t_varbinary;
                break;
            }
            case 12: {
                outString = t_varchar;
                break;
            }
            case -10: {
                outString = t_wlongvarchar;
                break;
            }
            case -16: {
                outString = t_longnvarchar;
                break;
            }
            default: {
                outString = t_unknown_sqlType + sqlType;
            }
        }
        return outString;
    }

    public static String getSQLTypeStringAndNumber(int sqlType) {
        String out = TypesHelper.getSQLTypeString(sqlType);
        if (out != null) {
            Integer intObj = new Integer(sqlType);
            out = out + "(" + intObj + ")";
        }
        return out;
    }

    public static String getUpdateRule(short inVal) {
        String out = null;
        switch (inVal) {
            case 3: {
                out = "importedKeyNoAction";
                break;
            }
            case 0: {
                out = "importedKeyCascade";
                break;
            }
            case 2: {
                out = "importedKeySetNull";
                break;
            }
            case 4: {
                out = "importedKeySetDefault";
                break;
            }
            case 1: {
                out = "importedKeyRestrict";
                break;
            }
        }
        return out;
    }

    public static String getUpdateRuleDesc(short inVal) {
        String out = null;
        switch (inVal) {
            case 3: {
                out = "do not allow update of parent key if it has been imported";
                break;
            }
            case 0: {
                out = "change imported key to agree with parent key update";
                break;
            }
            case 2: {
                out = "change imported key to NULL if its parent key has been updated";
                break;
            }
            case 4: {
                out = "hange imported key to default values if its parent key has been updated";
                break;
            }
            case 1: {
                out = "ame as importedKeyNoAction (for ODBC 2.x compatibility)";
                break;
            }
        }
        return out;
    }

    public static String getGetConnAttrAsStr(int inAttr, int inVal) {
        String outStr;
        boolean valueEnumerated = true;
        String outVal = UNKNOWN;
        String outAttr = UNKNOWN;
        block0 : switch (inAttr) {
            case 102: {
                outAttr = "TKTS_ATTR_AUTOCOMMIT";
                switch (inVal) {
                    case 0: {
                        outVal = "OFF";
                        break block0;
                    }
                    case 1: {
                        outVal = "ON";
                        break block0;
                    }
                    case 2: {
                        outVal = "2PHASE";
                        break block0;
                    }
                }
                break;
            }
            case 20025: {
                outAttr = "TKTS_ATTR_COMPRESS";
                if (inVal == 1) {
                    outVal = "FAST";
                }
                if (inVal != 2) break;
                outVal = "BEST";
                break;
            }
            case 110: {
                outAttr = "TKTS_ATTR_TKTS_CURSORS";
                switch (inVal) {
                    case 0: {
                        outVal = "TKTS_CUR_USE_IF_NEEDED";
                        break block0;
                    }
                    case 1: {
                        outVal = "TKTS_CUR_USE_TKTS";
                        break block0;
                    }
                    case 2: {
                        outVal = "TKTS_CUR_USE_DRIVER";
                        break block0;
                    }
                }
                break;
            }
            case 108: {
                outAttr = "TKTS_ATTR_TXN_ISOLATION";
                outVal = "";
                if ((inVal & 1) > 0) {
                    outVal = outVal + "READ_UNCOMMITTED ";
                }
                if ((inVal & 2) > 0) {
                    outVal = outVal + "READ_COMMITTED ";
                }
                if ((inVal & 4) > 0) {
                    outVal = outVal + "REPEATABLE_READ ";
                }
                if ((inVal & 8) <= 0) break;
                outVal = outVal + "SERIALIZABLE";
                break;
            }
            case 101: {
                outAttr = "TKTS_ATTR_ACCESS_MODE";
                if (inVal == 1) {
                    outVal = "READ_ONLY";
                }
                if (inVal != 0) break;
                outVal = "READ_WRITE";
                break;
            }
            case 103: {
                outAttr = "TKTS_ATTR_LOGIN_TIMEOUT";
                valueEnumerated = false;
                break;
            }
            case 112: {
                outAttr = "TKTS_ATTR_PACKET_SIZE";
                valueEnumerated = false;
                break;
            }
            case 113: {
                outAttr = "TKTS_ATTR_CONNECTION_TIMEOUT";
                valueEnumerated = false;
                break;
            }
            case 10014: {
                outAttr = "TKTS_ATTR_METADATA_ID";
                valueEnumerated = false;
                break;
            }
            case 20407: {
                outAttr = "TKTS_ATTR_DBC_PACK";
                valueEnumerated = false;
                break;
            }
            case 20400: {
                outAttr = "TKTS_ATTR_SERVER_PREFETCH";
                valueEnumerated = false;
            }
        }
        if (valueEnumerated) {
            String FORMAT = KEYWORD_DESC_VALUE;
            outStr = String.format(KEYWORD_DESC_VALUE, outAttr, inAttr, outVal, inVal);
        } else {
            String FORMAT = KEYWORD_VALUE;
            outStr = String.format(KEYWORD_VALUE, outAttr, inAttr, inVal);
        }
        return outStr;
    }

    public static TypesHelper getGetStmtAttrAsStr(int inAttr, int inVal) {
        boolean valueEnumerated = true;
        TypesHelper outTH = new TypesHelper();
        String outVal = UNKNOWN;
        String outAttr = UNKNOWN;
        block0 : switch (inAttr) {
            case 7: {
                outAttr = "TKTS_ATTR_CONCURRENCY";
                switch (inVal) {
                    case 0: {
                        outVal = "UNSPECIFIED";
                        break block0;
                    }
                    case 1: {
                        outVal = "READ_ONLY";
                        break block0;
                    }
                    case 2: {
                        outVal = "LOCK";
                        break block0;
                    }
                    case 3: {
                        outVal = "ROWVER";
                        break block0;
                    }
                    case 4: {
                        outVal = "VALUE";
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                outAttr = "TKTS_ROWSET_SIZE";
                break;
            }
            case 13: {
                outAttr = "TKTS_GET_BOOKMARK";
                break;
            }
            case 4: {
                outAttr = "TKTS_ATTR_ASYNC_ENABLE";
                break;
            }
            case 6: {
                outAttr = "TKTS_ATTR_CURSOR_TYPE";
                switch (inVal) {
                    case 0: {
                        outVal = "FORWARD_ONLY";
                        break block0;
                    }
                    case 1: {
                        outVal = "KEYSET_DRIVEN";
                        break block0;
                    }
                    case 2: {
                        outVal = "DYNAMIC";
                        break block0;
                    }
                    case 3: {
                        outVal = "STATIC";
                        break block0;
                    }
                }
                break;
            }
            case 15: {
                outAttr = "TKTS_ATTR_ENABLE_AUTO_IPD";
                break;
            }
            case 16: {
                outAttr = "TKTS_ATTR_FETCH_BOOKMARK_PTR";
                break;
            }
            case 8: {
                outAttr = "TKTS_ATTR_KEYSET_SIZE";
                break;
            }
            case 3: {
                outAttr = "TKTS_ATTR_MAX_LENGTH";
                break;
            }
            case 1: {
                outAttr = "TKTS_ATTR_MAX_ROWS";
                break;
            }
            case 2: {
                outAttr = "TKTS_ATTR_NOSCAN";
                if (inVal == 0) {
                    outVal = "NOSCAN_OFF";
                    break;
                }
                if (inVal != 1) break;
                outVal = "NOSCAN_ON";
                break;
            }
            case 17: {
                outAttr = "TKTS_ATTR_PARAM_BIND_OFFSET_PTR";
                break;
            }
            case 18: {
                outAttr = "TKTS_ATTR_PARAM_BIND_TYPE";
                break;
            }
            case 19: {
                outAttr = "TKTS_ATTR_PARAM_OPERATION_PTR";
                break;
            }
            case 20: {
                outAttr = "TKTS_ATTR_PARAM_STATUS_PTR";
                break;
            }
            case 21: {
                outAttr = "TKTS_ATTR_PARAMS_PROCESSED_PTR";
                break;
            }
            case 22: {
                outAttr = "TKTS_ATTR_PARAMSET_SIZE";
                valueEnumerated = false;
                break;
            }
            case 0: {
                outAttr = "TKTS_ATTR_QUERY_TIMEOUT";
                valueEnumerated = false;
                break;
            }
            case 11: {
                outAttr = "TKTS_ATTR_RETRIEVE_DATA";
                break;
            }
            case 23: {
                outAttr = "TKTS_ATTR_ROW_BIND_OFFSET_PTR";
                break;
            }
            case 5: {
                outAttr = "TKTS_ATTR_ROW_BIND_TYPE";
                break;
            }
            case 14: {
                outAttr = "TKTS_ATTR_ROW_NUMBER";
                valueEnumerated = false;
                break;
            }
            case 24: {
                outAttr = "TKTS_ATTR_ROW_OPERATION_PTR";
                break;
            }
            case 25: {
                outAttr = "TKTS_ATTR_ROW_STATUS_PTR";
                break;
            }
            case 26: {
                outAttr = "TKTS_ATTR_ROWS_FETCHED_PTR";
                break;
            }
            case 27: {
                outAttr = "TKTS_ATTR_ROW_ARRAY_SIZE";
                valueEnumerated = false;
                break;
            }
            case 10: {
                outAttr = "TKTS_ATTR_SIMULATE_CURSOR";
                break;
            }
            case 12: {
                outAttr = "TKTS_ATTR_USE_BOOKMARKS";
                switch (inVal) {
                    case 0: {
                        outVal = "OFF";
                        break block0;
                    }
                    case 1: {
                        outVal = "ON";
                        break block0;
                    }
                    case 2: {
                        outVal = "VARIABLE";
                        break block0;
                    }
                }
                break;
            }
            case 10010: {
                outAttr = "TKTS_ATTR_APP_ROW_DESC";
                break;
            }
            case 10011: {
                outAttr = "TKTS_ATTR_APP_PARAM_DESC";
                break;
            }
            case 10012: {
                outAttr = "TKTS_ATTR_IMP_ROW_DESC";
                break;
            }
            case 10013: {
                outAttr = "TKTS_ATTR_IMP_PARAM_DESC";
                break;
            }
            case -1: {
                outAttr = "TKTS_ATTR_CURSOR_SCROLLABLE";
                if (inVal == 0) {
                    outVal = "NONSCROLLABLE";
                    break;
                }
                if (inVal != 1) break;
                outVal = "SCROLLABLE";
                break;
            }
            case -2: {
                outAttr = "TKTS_ATTR_CURSOR_SENSITIVITY";
                if (inVal == 0) {
                    outVal = "UNSPECIFIED";
                    break;
                }
                if (inVal == 1) {
                    outVal = "INSENSITIVE";
                    break;
                }
                if (inVal != 2) break;
                outVal = "SENSITIVE";
                break;
            }
            case 20311: {
                outAttr = "TKTS_ATTR_BM_HANDLE";
                valueEnumerated = false;
                break;
            }
            case 20312: {
                outAttr = "TKTS_ATTR_BM_NOCOPY";
                valueEnumerated = false;
                break;
            }
        }
        String format = DESC_AND_VALUE;
        outTH.key = String.format(format, outAttr, inAttr);
        if (valueEnumerated) {
            outTH.value = String.format(format, outVal, inVal);
        } else {
            format = VALUE;
            outTH.value = String.format(format, inVal);
        }
        outTH.pair = outTH.key + "=" + outTH.value;
        return outTH;
    }

    public static String getTktsStatus(int inStatus) {
        String outStatus;
        String tktsERROR = "TKTS_ERROR_VALUE";
        String tktsINVALID_HANDLE = "TKTS_INVALID_HANDLE_VALUE";
        String tktsNEED_DATA_VALUE = "TKTS_NEED_DATA_VALUE";
        String tktsNO_DATA_VALUE = "TKTS_NO_DATA_VALUE";
        String tktsNULL_DATA = "TKTS_NULL_DATA";
        String tktsSTILL_EXECUTING = "TKTS_STILL_EXECUTING_VALUE";
        String tktsSUCCESS = "SUCCESS";
        String tktsSUCCESS_WITH_INFO = "SUCCESS_WITH_INFO";
        String tktsUNKNOWN = "????";
        switch (inStatus) {
            case -2130708478: {
                outStatus = "TKTS_ERROR_VALUE";
                break;
            }
            case -2130708477: {
                outStatus = "TKTS_INVALID_HANDLE_VALUE";
                break;
            }
            case -2130708475: {
                outStatus = "TKTS_NEED_DATA_VALUE";
                break;
            }
            case -2130708476: {
                outStatus = "TKTS_NO_DATA_VALUE";
                break;
            }
            case -1: {
                outStatus = "TKTS_NULL_DATA";
                break;
            }
            case -2130708474: {
                outStatus = "TKTS_STILL_EXECUTING_VALUE";
                break;
            }
            case 0: {
                outStatus = "SUCCESS";
                break;
            }
            case -2130708479: {
                outStatus = "SUCCESS_WITH_INFO";
                break;
            }
            default: {
                outStatus = "????";
            }
        }
        String FORMAT = "%s(%s)";
        String outStr = String.format("%s(%s)", outStatus, inStatus);
        return outStr;
    }

    public static String getSignText(boolean isSigned) {
        if (isSigned) {
            return "SIGNED";
        }
        return "UNSIGNED";
    }
}

