/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class ByteExtractor {
    private static String thisClassName = ByteExtractor.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient ByteBuffer buffer = null;
    private transient int currentPosition;
    private static transient Calendar calendar = null;

    public ByteExtractor(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteExtractor(byte[] bytes, int offset, int length) {
        this.buffer = ByteBuffer.wrap(bytes, offset, length);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void resetBufferOrder() {
        if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    public void clean() {
        this.buffer.clear();
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public Calendar getCalendar() {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar;
    }

    public byte getByte() {
        this.buffer.position(this.currentPosition);
        byte value = this.buffer.get();
        ++this.currentPosition;
        return value;
    }

    public short getShort() {
        this.buffer.position(this.currentPosition);
        short value = this.buffer.getShort();
        this.currentPosition += 2;
        return value;
    }

    public char getChar() {
        this.buffer.position(this.currentPosition);
        char value = this.buffer.getChar();
        this.currentPosition += 2;
        return value;
    }

    public int getInt() {
        this.buffer.position(this.currentPosition);
        int value = this.buffer.getInt();
        this.currentPosition += 4;
        return value;
    }

    public long getLong() {
        this.buffer.position(this.currentPosition);
        long value = this.buffer.getLong();
        this.currentPosition += 8;
        return value;
    }

    public float getFloat() {
        this.buffer.position(this.currentPosition);
        float value = this.buffer.getFloat();
        this.currentPosition += 4;
        return value;
    }

    public double getDouble() {
        this.buffer.position(this.currentPosition);
        double value = this.buffer.getDouble();
        this.currentPosition += 8;
        return value;
    }

    public BigDecimal getBigDecimal() {
        BigDecimal bigDec = null;
        byte precision = 0;
        byte scale = 0;
        byte signal = 0;
        int dataLen = 0;
        byte len = this.getByte();
        switch (len) {
            case 0: {
                bigDec = BigDecimal.ZERO;
                break;
            }
            case 1: {
                precision = this.getByte();
                bigDec = BigDecimal.ZERO;
                break;
            }
            case 2: {
                precision = this.getByte();
                scale = this.getByte();
                bigDec = BigDecimal.ZERO;
                break;
            }
            default: {
                precision = this.getByte();
                scale = this.getByte();
                signal = this.getByte();
                dataLen = len - 3;
                byte[] rawValue = this.extractBigEndianByteArray(dataLen);
                BigInteger bigInt = new BigInteger(rawValue);
                MathContext mc = new MathContext(precision);
                if (scale > 0) {
                    bigDec = new BigDecimal(bigInt, (int)scale, mc);
                } else {
                    bigDec = new BigDecimal(bigInt, mc);
                    bigDec = bigDec.movePointLeft(scale);
                }
                if (signal != 0) break;
                bigDec = bigDec.negate();
            }
        }
        return bigDec;
    }

    public String getString(int length, int totalLength, Charset charset) {
        this.buffer.position(this.currentPosition);
        byte[] auxBuffer = this.buffer.array();
        byte[] outBuffer = new byte[totalLength];
        System.arraycopy(auxBuffer, this.currentPosition, outBuffer, 0, length);
        for (int i = length; i < totalLength; ++i) {
            outBuffer[i] = 32;
        }
        String value = new String(outBuffer, 0, totalLength, charset);
        this.currentPosition += length;
        this.buffer.position(this.currentPosition);
        return value;
    }

    public String getString(int length, Charset charset) {
        this.buffer.position(this.currentPosition);
        byte[] auxBuffer = this.buffer.array();
        String value = new String(auxBuffer, this.currentPosition, length, charset);
        this.currentPosition += length;
        this.buffer.position(this.currentPosition);
        return value;
    }

    public byte[] getByteArrayBE(int length, int totalLength) {
        byte[] bytes = new byte[totalLength];
        this.buffer.position(this.currentPosition);
        this.buffer.get(bytes, 0, length);
        this.currentPosition += length;
        return bytes;
    }

    public Date getDate() {
        String method = "getDate()";
        calendar = this.getCalendar();
        short year = this.getShort();
        byte month = this.getByte();
        byte day = this.getByte();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(5, day);
        calendar.set(2, month - 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long xTime = calendar.getTime().getTime();
        Date value = new Date(xTime);
        if (AbstractLogger.isTrace) {
            logger.trace(method, "DATE=[" + year + "/" + month + "/" + day + "]");
            logger.trace(method, "DATE=[" + value + "]");
        }
        return new Date(xTime);
    }

    public Time getTime() {
        String method = "getTime()";
        calendar = this.getCalendar();
        byte hour = this.getByte();
        byte minutes = this.getByte();
        byte seconds = this.getByte();
        calendar.clear();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        calendar.set(14, 0);
        long xTime = calendar.getTime().getTime();
        Time value = new Time(xTime);
        if (AbstractLogger.isTrace) {
            logger.trace(method, "TIME=[" + hour + ":" + minutes + ":" + seconds + "]");
            logger.trace(method, "TIME=[" + value + "]");
        }
        return value;
    }

    public Timestamp getTimestamp() {
        String method = "getTimestamp()";
        calendar = this.getCalendar();
        short year = this.getShort();
        byte month = this.getByte();
        byte day = this.getByte();
        byte hour = this.getByte();
        byte minutes = this.getByte();
        byte seconds = this.getByte();
        int fraction = this.getInt();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        long xTime = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(xTime);
        timestamp.setNanos(fraction);
        if (AbstractLogger.isTrace) {
            logger.trace(method, "TIMESTAMP=[" + year + "/" + month + "/" + day + " " + hour + ":" + minutes + ":" + seconds + "." + fraction + "]");
            logger.trace(method, "TIMESTAMP=[" + timestamp + "]");
        }
        return timestamp;
    }

    private byte[] extractBigEndianByteArray(int length) {
        byte[] bytes = new byte[length + 1];
        this.buffer.position(this.currentPosition);
        bytes[0] = 0;
        for (int i = length; i > 0; --i) {
            bytes[i] = this.buffer.get();
        }
        this.currentPosition += length;
        return bytes;
    }

    public String toString() {
        String out;
        if (this.buffer != null) {
            int l;
            int capacity = this.buffer.capacity();
            byte[] a = this.buffer.array();
            int p = this.buffer.position();
            int i = p - (l = 8);
            if (i < 0) {
                i = 0;
                l = p;
            }
            String b = UtilityFunctions.formatBytesHex(a, i, l);
            l = 10;
            i = p;
            if (i + p >= capacity) {
                l = capacity - p;
            }
            String c = UtilityFunctions.formatBytesHex(a, i, l);
            out = String.format("capacity: %d Position: %d \nbefore[%s]\ncurrent[%s]", capacity, p, b, c);
        } else {
            out = "buffer is null";
        }
        return out;
    }
}

