/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.util;

import com.sas.text.SASDateTimeFormat;
import com.sas.tkts.caching.UnpackInfo;
import com.sas.tkts.info.PackedParameterSetBuffer;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.types.ColumnFactory;
import com.sas.tkts.util.ByteExtractor;
import com.sas.tkts.util.CharSetUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class ByteArrayConverter {
    private static String thisClassName = ByteArrayConverter.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static final BigDecimal BIG_ZERO = BigDecimal.ZERO;
    private static Calendar calendar = null;
    static final double ADJUSTMENT_DAYS = 3653.0;
    static final long SECONDS_PER_DAY = 86400L;
    static final long Y4K_LEAPDAY = Date.valueOf("4000-02-29").getTime();
    static final long Y8K_LEAPDAY = Date.valueOf("8000-02-29").getTime();
    static final int TSPACK_IND_FLOAT = 4;
    static final int TSPACK_IND_DOUBLE = 8;
    static final int TSPACK_IND_ZERO = 32;
    static final int TSPACK_IND_UI8 = 33;
    static final int TSPACK_IND_UI16 = 34;
    static final int TSPACK_IND_UI32 = 35;
    static final int TSPACK_IND_I8 = 36;
    static final int TSPACK_IND_I16 = 37;
    static final int TSPACK_IND_I32 = 38;
    private static final String ACFE = "AbstractCachingFatalError.txt";

    public static synchronized Calendar getCalendar() {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar;
    }

    private static long getDateFromBaseDouble(ByteExtractor byteExtractor) {
        double doubleValue = byteExtractor.getDouble();
        long msSAS = SASDateTimeFormat.SASDateToJavaDate((double)doubleValue);
        return msSAS;
    }

    private static long getDateFromBaseLong(ByteExtractor byteExtractor, long indicator) {
        double doubleValue = ByteArrayConverter.unpackLong(byteExtractor, indicator);
        long msSAS = SASDateTimeFormat.SASDateToJavaDate((double)doubleValue);
        return msSAS;
    }

    private static long getTimeFromBaseDouble(ByteExtractor byteExtractor) {
        double doubleValue = byteExtractor.getDouble();
        long msSAS = SASDateTimeFormat.SASTimeToJavaDate((double)doubleValue);
        return msSAS;
    }

    private static long getTimeFromBaseLong(ByteExtractor byteExtractor, long indicator) {
        double doubleValue = ByteArrayConverter.unpackLong(byteExtractor, indicator);
        long msSAS = SASDateTimeFormat.SASTimeToJavaDate((double)doubleValue);
        return msSAS;
    }

    private static long getTimestampFromBaseDouble(ByteExtractor byteExtractor) {
        double doubleValue = byteExtractor.getDouble();
        long msSAS = SASDateTimeFormat.SASDateTimeToJavaDate((double)doubleValue);
        return msSAS;
    }

    private static long getTimestampFromBaseLong(ByteExtractor byteExtractor, long indicator) {
        double doubleValue = ByteArrayConverter.unpackLong(byteExtractor, indicator);
        long msSAS = SASDateTimeFormat.SASDateTimeToJavaDate((double)doubleValue);
        return msSAS;
    }

    public static AbstractColumn extractOrdinalColumnData(ByteExtractor byteExtractor, long indicator, int columnOrdinal, int sqlType, int nativeCType, Charset charset) throws SQLException {
        String method = "extractOrdinalColumnData";
        AbstractColumn ordinalAbsColumn = null;
        if (indicator <= 0L && (indicator == 0L || indicator == -1L || indicator <= -62L && indicator >= -89L)) {
            ordinalAbsColumn = ColumnFactory.createNullValueColumn(sqlType, indicator);
        } else {
            switch (sqlType) {
                case -7: 
                case -6: 
                case 16: {
                    byte byteValue = byteExtractor.getByte();
                    ordinalAbsColumn = ColumnFactory.createByteColumn(byteValue);
                    break;
                }
                case -2: {
                    int binLength = byteExtractor.getInt();
                    byte[] littleBytes = byteExtractor.getByteArrayBE(binLength, (int)indicator);
                    ordinalAbsColumn = ColumnFactory.createByteArrayColumn(littleBytes);
                    break;
                }
                case -3: {
                    int binLength = byteExtractor.getInt();
                    byte[] littleBytes = byteExtractor.getByteArrayBE(binLength, binLength);
                    ordinalAbsColumn = ColumnFactory.createByteArrayColumn(littleBytes);
                    break;
                }
                case -10: 
                case -4: 
                case -1: {
                    LocalizedErrorHandler.throwLocalizedException(ACFE, logger);
                    break;
                }
                case -8: 
                case 1: {
                    String stringValue = null;
                    if (indicator >= 0L) {
                        int charLen = byteExtractor.getInt();
                        stringValue = byteExtractor.getString(charLen, (int)indicator, charset);
                    }
                    ordinalAbsColumn = ColumnFactory.createStringColunn(stringValue);
                    break;
                }
                case -9: 
                case 12: {
                    String stringValue = null;
                    if (indicator >= 0L) {
                        int charLen = byteExtractor.getInt();
                        stringValue = byteExtractor.getString(charLen, charset);
                    }
                    ordinalAbsColumn = ColumnFactory.createStringColunn(stringValue);
                    break;
                }
                case 5: {
                    short shortValue = byteExtractor.getShort();
                    ordinalAbsColumn = ColumnFactory.createShortColumn(shortValue);
                    break;
                }
                case 4: {
                    int intValue = byteExtractor.getInt();
                    ordinalAbsColumn = ColumnFactory.createIntegerColumn(intValue);
                    break;
                }
                case -5: {
                    long longValue = byteExtractor.getLong();
                    ordinalAbsColumn = ColumnFactory.createLongColumn(longValue);
                    break;
                }
                case 6: 
                case 7: {
                    float floatValue = byteExtractor.getFloat();
                    ordinalAbsColumn = ColumnFactory.createFloatRealColumn(floatValue, sqlType);
                    break;
                }
                case 8: {
                    double doubleValue = byteExtractor.getDouble();
                    ordinalAbsColumn = ColumnFactory.createDoubleColumn(doubleValue);
                    break;
                }
                case 2: 
                case 3: {
                    if (nativeCType == 1) {
                        String stringValue = null;
                        if (indicator >= 0L) {
                            int charLen = byteExtractor.getInt();
                            stringValue = byteExtractor.getString(charLen, charset);
                        }
                        ordinalAbsColumn = ColumnFactory.createStringColunn(stringValue);
                        break;
                    }
                    BigDecimal bigDec = byteExtractor.getBigDecimal();
                    ordinalAbsColumn = ColumnFactory.createBigDecimalColumn(bigDec);
                    break;
                }
                case 91: {
                    Date date;
                    if (nativeCType == 19) {
                        Timestamp ts = byteExtractor.getTimestamp();
                        long ms = ts.getTime();
                        date = new Date(ms);
                        if (AbstractLogger.isTrace) {
                            logger.trace("extractOrdinalColumnData", "Date=[" + date + "]");
                        }
                    } else if (nativeCType == 6) {
                        date = new Date(ByteArrayConverter.getDateFromBaseDouble(byteExtractor));
                        if (AbstractLogger.isTrace) {
                            logger.trace("extractOrdinalColumnData", "Date(D)=[" + date + "]");
                        }
                    } else {
                        date = byteExtractor.getDate();
                    }
                    ordinalAbsColumn = ColumnFactory.createDateColumn(date);
                    break;
                }
                case 92: {
                    Time time;
                    if (nativeCType == 19) {
                        Timestamp ts = byteExtractor.getTimestamp();
                        long ms = ts.getTime();
                        time = new Time(ms);
                        if (AbstractLogger.isTrace) {
                            logger.trace("extractOrdinalColumnData", "Time=[" + time + "]");
                        }
                    } else if (nativeCType == 6) {
                        time = new Time(ByteArrayConverter.getTimeFromBaseDouble(byteExtractor));
                        if (AbstractLogger.isTrace) {
                            logger.trace("extractOrdinalColumnData", "Time(D)=[" + time + "]");
                        }
                    } else {
                        time = byteExtractor.getTime();
                    }
                    ordinalAbsColumn = ColumnFactory.createTimeColumn(time);
                    break;
                }
                case 93: {
                    Timestamp timestamp;
                    if (nativeCType == 6) {
                        timestamp = new Timestamp(ByteArrayConverter.getTimestampFromBaseDouble(byteExtractor));
                        if (AbstractLogger.isTrace) {
                            logger.trace("extractOrdinalColumnData", "Timestamp(D)=[" + timestamp + "]");
                        }
                    } else {
                        timestamp = byteExtractor.getTimestamp();
                        if (AbstractLogger.isTrace) {
                            logger.trace("extractOrdinalColumnData", "Timestamp=[" + timestamp + "]");
                        }
                    }
                    ordinalAbsColumn = ColumnFactory.createTimestampColumn(timestamp);
                    break;
                }
                default: {
                    if (AbstractLogger.isTrace) {
                        logger.trace("extractOrdinalColumnData", "INVALID DATA TYPE DETECTED while processing ordinal=[" + columnOrdinal + "] SQLType=[" + sqlType + "]");
                    }
                    String ei = "AbstractCachingDataTypeFatalError.txt";
                    LocalizedErrorHandler.throwLocalizedException("AbstractCachingDataTypeFatalError.txt", logger);
                }
            }
        }
        return ordinalAbsColumn;
    }

    public static void updateColumnData(ByteExtractor byteExtractor, AbstractColumn ac, long indicator, int columnOrdinal, int sqlType, int nativeCType, Charset charset) throws SQLException {
        String method = "updateColumnData";
        if (indicator <= 0L && (indicator == 0L || indicator == -1L || indicator <= -62L && indicator >= -89L)) {
            ac.setObject(null);
        } else {
            switch (sqlType) {
                case -7: 
                case -6: 
                case 16: {
                    byte byteValue = byteExtractor.getByte();
                    ac.setByte(byteValue);
                    break;
                }
                case -3: 
                case -2: {
                    int binLength = byteExtractor.getInt();
                    byte[] littleBytes = byteExtractor.getByteArrayBE(binLength, binLength);
                    ac.setBytes(littleBytes);
                    break;
                }
                case -10: 
                case -4: 
                case -1: {
                    LocalizedErrorHandler.throwLocalizedException(ACFE, logger);
                    break;
                }
                case -9: 
                case -8: 
                case 1: 
                case 12: {
                    String stringValue = null;
                    if (indicator >= 0L) {
                        int charLen = byteExtractor.getInt();
                        stringValue = byteExtractor.getString(charLen, charset);
                    }
                    ac.setString(stringValue);
                    break;
                }
                case 5: {
                    short shortValue = byteExtractor.getShort();
                    ac.setShort(shortValue);
                    break;
                }
                case 4: {
                    int intValue = byteExtractor.getInt();
                    ac.setInt(intValue);
                    break;
                }
                case -5: {
                    long longValue = byteExtractor.getLong();
                    ac.setLong(longValue);
                    break;
                }
                case 6: 
                case 7: {
                    float floatValue = byteExtractor.getFloat();
                    ac.setFloat(floatValue);
                    break;
                }
                case 8: {
                    double doubleValue = byteExtractor.getDouble();
                    ac.setDouble(doubleValue);
                    break;
                }
                case 2: 
                case 3: {
                    if (nativeCType == 1) {
                        String stringValue = null;
                        if (indicator >= 0L) {
                            int charLen = byteExtractor.getInt();
                            stringValue = byteExtractor.getString(charLen, charset);
                        }
                        ac.setString(stringValue);
                        break;
                    }
                    BigDecimal bigDec = byteExtractor.getBigDecimal();
                    ac.setObject(bigDec);
                    break;
                }
                case 91: {
                    Date date;
                    if (nativeCType == 19) {
                        Timestamp ts = byteExtractor.getTimestamp();
                        long ms = ts.getTime();
                        date = new Date(ms);
                    } else {
                        date = nativeCType == 6 ? new Date(ByteArrayConverter.getDateFromBaseDouble(byteExtractor)) : byteExtractor.getDate();
                    }
                    ac.setObject(date);
                    break;
                }
                case 92: {
                    Time time;
                    if (nativeCType == 19) {
                        Timestamp ts = byteExtractor.getTimestamp();
                        long ms = ts.getTime();
                        time = new Time(ms);
                    } else {
                        time = nativeCType == 6 ? new Time(ByteArrayConverter.getTimeFromBaseDouble(byteExtractor)) : byteExtractor.getTime();
                    }
                    ac.setObject(time);
                    break;
                }
                case 93: {
                    Timestamp timestamp = nativeCType == 6 ? new Timestamp(ByteArrayConverter.getTimestampFromBaseDouble(byteExtractor)) : byteExtractor.getTimestamp();
                    ac.setObject(timestamp);
                    break;
                }
                default: {
                    if (AbstractLogger.isTrace) {
                        logger.trace("updateColumnData", "INVALID DATA TYPE DETECTED while processing ordinal=[" + columnOrdinal + "] SQLType=[" + sqlType + "]");
                    }
                    String ei = "AbstractCachingDataTypeFatalError.txt";
                    LocalizedErrorHandler.throwLocalizedException("AbstractCachingDataTypeFatalError.txt", logger);
                }
            }
        }
    }

    private static int stringUnpackLength(ByteExtractor byteExtractor) {
        boolean m1 = true;
        int out = 0;
        int b0 = byteExtractor.getByte();
        if (b0 >= 0) {
            out = b0;
        } else {
            int b1 = byteExtractor.getByte();
            if (b1 >= 0) {
                int b = b0 &= 0x7F;
                out = b0 >>= 1;
                out <<= 8;
                out |= b1;
                if ((b &= 1) != 0) {
                    out |= 0x80;
                }
            } else {
                int b = b0 &= 0x7F;
                out = b0 >>= 1;
                out <<= 8;
                out |= (b1 &= 0x7F);
                if ((b &= 1) != 0) {
                    out |= 0x80;
                }
                out <<= 8;
                b0 = byteExtractor.getByte();
                if (b0 < 0) {
                    out += 256;
                }
                out += b0;
                out <<= 8;
                b1 = byteExtractor.getByte();
                if (b1 < 0) {
                    out += 256;
                }
                out += b1;
            }
        }
        return out;
    }

    private static long unpackLong(ByteExtractor byteExtractor, long indicator) {
        long out;
        switch ((int)indicator) {
            case 32: {
                out = 0L;
                break;
            }
            case 33: {
                out = byteExtractor.getByte();
                if (out >= 0L) break;
                out += 256L;
                break;
            }
            case 36: {
                out = byteExtractor.getByte();
                break;
            }
            case 34: {
                out = byteExtractor.getShort();
                if (out >= 0L) break;
                out += 65536L;
                break;
            }
            case 37: {
                out = byteExtractor.getShort();
                break;
            }
            case 35: {
                out = byteExtractor.getInt();
                if (out >= 0L) break;
                out += 0x100000000L;
                break;
            }
            case 38: {
                out = byteExtractor.getInt();
                break;
            }
            default: {
                out = -1L;
            }
        }
        return out;
    }

    public static AbstractColumn extractOrdinalColumnDataV1(ByteExtractor byteExtractor, long indicator, int columnOrdinal, UnpackInfo ui) throws SQLException {
        String method = "extractOrdinalColumnData";
        AbstractColumn ordinalAbsColumn = null;
        if (indicator <= 0L && (indicator == 0L || indicator == -1L || indicator <= -62L && indicator >= -89L)) {
            ordinalAbsColumn = ColumnFactory.createNullValueColumn(ui.cSqlType, indicator);
        } else {
            switch (ui.cSqlType) {
                case -7: 
                case -6: 
                case 16: {
                    byte byteValue = 0;
                    if (indicator != 32L) {
                        byteValue = byteExtractor.getByte();
                    }
                    ordinalAbsColumn = ColumnFactory.createByteColumn(byteValue);
                    break;
                }
                case -2: {
                    int binLength = ByteArrayConverter.stringUnpackLength(byteExtractor);
                    byte[] littleBytes = byteExtractor.getByteArrayBE(binLength, binLength);
                    ordinalAbsColumn = ColumnFactory.createByteArrayColumn(littleBytes);
                    break;
                }
                case -3: {
                    int binLength = ByteArrayConverter.stringUnpackLength(byteExtractor);
                    byte[] littleBytes = byteExtractor.getByteArrayBE(binLength, binLength);
                    ordinalAbsColumn = ColumnFactory.createByteArrayColumn(littleBytes);
                    break;
                }
                case -10: 
                case -4: 
                case -1: {
                    LocalizedErrorHandler.throwLocalizedException(ACFE, logger);
                    break;
                }
                case -8: 
                case 1: {
                    int charLen = ByteArrayConverter.stringUnpackLength(byteExtractor);
                    String value = byteExtractor.getString(charLen, ui.getCharset());
                    ordinalAbsColumn = ColumnFactory.createStringColunn(value);
                    break;
                }
                case -9: 
                case 12: {
                    int charLen = ByteArrayConverter.stringUnpackLength(byteExtractor);
                    String value = byteExtractor.getString(charLen, ui.getCharset());
                    ordinalAbsColumn = ColumnFactory.createStringColunn(value);
                    break;
                }
                case 5: {
                    short shortValue = indicator < 32L ? byteExtractor.getShort() : (short)ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ordinalAbsColumn = ColumnFactory.createShortColumn(shortValue);
                    break;
                }
                case 4: {
                    int intValue = indicator < 32L ? byteExtractor.getInt() : (int)ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ordinalAbsColumn = ColumnFactory.createIntegerColumn(intValue);
                    break;
                }
                case -5: {
                    long longValue = indicator < 32L ? byteExtractor.getLong() : ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ordinalAbsColumn = ColumnFactory.createLongColumn(longValue);
                    break;
                }
                case 6: 
                case 7: {
                    float floatValue = indicator < 32L ? byteExtractor.getFloat() : (float)ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ordinalAbsColumn = ColumnFactory.createFloatRealColumn(floatValue, ui.cSqlType);
                    break;
                }
                case 8: {
                    double doubleValue = indicator < 32L ? byteExtractor.getDouble() : (double)ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ordinalAbsColumn = ColumnFactory.createDoubleColumn(doubleValue);
                    break;
                }
                case 2: 
                case 3: {
                    if (ui.nativeCType == 1) {
                        String stringValue = null;
                        if (indicator >= 0L) {
                            int charLen = byteExtractor.getInt();
                            stringValue = byteExtractor.getString(charLen, ui.getCharset());
                        }
                        ordinalAbsColumn = ColumnFactory.createStringColunn(stringValue);
                        break;
                    }
                    BigDecimal bigDec = byteExtractor.getBigDecimal();
                    ordinalAbsColumn = ColumnFactory.createBigDecimalColumn(bigDec);
                    break;
                }
                case 91: {
                    Date date;
                    if (ui.nativeCType == 19) {
                        Timestamp ts = byteExtractor.getTimestamp();
                        long ms = ts.getTime();
                        date = new Date(ms);
                    } else if (ui.nativeCType == 6) {
                        long msSAS = indicator == 8L ? ByteArrayConverter.getDateFromBaseDouble(byteExtractor) : ByteArrayConverter.getDateFromBaseLong(byteExtractor, indicator);
                        date = new Date(msSAS);
                    } else {
                        date = byteExtractor.getDate();
                    }
                    ordinalAbsColumn = ColumnFactory.createDateColumn(date);
                    break;
                }
                case 92: {
                    Time time;
                    if (ui.nativeCType == 19) {
                        Timestamp ts = byteExtractor.getTimestamp();
                        long ms = ts.getTime();
                        time = new Time(ms);
                    } else if (ui.nativeCType == 6) {
                        long msSAS = indicator == 8L ? ByteArrayConverter.getTimeFromBaseDouble(byteExtractor) : ByteArrayConverter.getTimeFromBaseLong(byteExtractor, indicator);
                        time = new Time(msSAS);
                    } else {
                        time = byteExtractor.getTime();
                    }
                    ordinalAbsColumn = ColumnFactory.createTimeColumn(time);
                    break;
                }
                case 93: {
                    Timestamp timestamp;
                    if (ui.nativeCType == 6) {
                        long msSAS = indicator == 8L ? ByteArrayConverter.getTimestampFromBaseDouble(byteExtractor) : ByteArrayConverter.getTimestampFromBaseLong(byteExtractor, indicator);
                        timestamp = new Timestamp(msSAS);
                    } else {
                        timestamp = byteExtractor.getTimestamp();
                    }
                    ordinalAbsColumn = ColumnFactory.createTimestampColumn(timestamp);
                    break;
                }
                default: {
                    if (AbstractLogger.isTrace) {
                        logger.trace("extractOrdinalColumnData", "INVALID DATA TYPE DETECTED while processing ordinal=[" + columnOrdinal + "] SQLType=[" + ui.cSqlType + "]");
                    }
                    String ei = "AbstractCachingDataTypeFatalError.txt";
                    LocalizedErrorHandler.throwLocalizedException("AbstractCachingDataTypeFatalError.txt", logger);
                }
            }
        }
        return ordinalAbsColumn;
    }

    public static void updateColumnDataV1(ByteExtractor byteExtractor, AbstractColumn ac, long indicator, int columnOrdinal, UnpackInfo ui) throws SQLException {
        String method = "updateColumnDataV1";
        if (indicator <= 0L && (indicator == 0L || indicator == -1L || indicator <= -62L && indicator >= -89L)) {
            ac.setObject(null);
        } else {
            switch (ui.cSqlType) {
                case -7: 
                case -6: 
                case 16: {
                    byte byteValue = byteExtractor.getByte();
                    ac.setByte(byteValue);
                    break;
                }
                case -3: 
                case -2: {
                    int binLength = byteExtractor.getInt();
                    byte[] littleBytes = byteExtractor.getByteArrayBE(binLength, binLength);
                    ac.setBytes(littleBytes);
                    break;
                }
                case -4: {
                    int binLength = byteExtractor.getInt();
                    byte[] littleBytes = byteExtractor.getByteArrayBE(binLength, binLength);
                    ac.setBytes(littleBytes);
                    break;
                }
                case -9: 
                case -8: 
                case 1: 
                case 12: {
                    String stringValue = null;
                    if (indicator >= 0L) {
                        int charLen = ByteArrayConverter.stringUnpackLength(byteExtractor);
                        stringValue = byteExtractor.getString(charLen, ui.getCharset());
                    }
                    ac.setString(stringValue);
                    break;
                }
                case -10: 
                case -1: {
                    String stringValue = null;
                    if (indicator >= 0L) {
                        int charLen = ByteArrayConverter.stringUnpackLength(byteExtractor);
                        stringValue = byteExtractor.getString(charLen, ui.getCharset());
                    }
                    ac.setString(stringValue);
                    break;
                }
                case 5: {
                    short shortValue = indicator < 32L ? byteExtractor.getShort() : (short)ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ac.setShort(shortValue);
                    break;
                }
                case 4: {
                    int intValue = indicator < 32L ? byteExtractor.getInt() : (int)ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ac.setInt(intValue);
                    break;
                }
                case -5: {
                    long longValue = indicator < 32L ? byteExtractor.getLong() : ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ac.setLong(longValue);
                    break;
                }
                case 6: 
                case 7: {
                    float floatValue = indicator < 32L ? byteExtractor.getFloat() : (float)ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    ac.setFloat(floatValue);
                    break;
                }
                case 8: {
                    double doubleValue = indicator < 32L ? byteExtractor.getDouble() : (double)ByteArrayConverter.unpackLong(byteExtractor, indicator);
                    if (doubleValue == -128.0) {
                        System.out.println(indicator);
                    }
                    ac.setDouble(doubleValue);
                    break;
                }
                case 2: 
                case 3: {
                    if (ui.nativeCType == 1) {
                        String stringValue = null;
                        if (indicator >= 0L) {
                            int charLen = byteExtractor.getInt();
                            stringValue = byteExtractor.getString(charLen, ui.getCharset());
                        }
                        ac.setString(stringValue);
                        break;
                    }
                    BigDecimal bigDec = byteExtractor.getBigDecimal();
                    ac.setObject(bigDec);
                    break;
                }
                case 91: {
                    Date date;
                    if (ui.nativeCType == 19) {
                        Timestamp ts = byteExtractor.getTimestamp();
                        long ms = ts.getTime();
                        date = new Date(ms);
                    } else {
                        date = ui.nativeCType == 6 ? new Date(ByteArrayConverter.getDateFromBaseDouble(byteExtractor)) : byteExtractor.getDate();
                    }
                    ac.setObject(date);
                    break;
                }
                case 92: {
                    Time time;
                    if (ui.nativeCType == 19) {
                        Timestamp ts = byteExtractor.getTimestamp();
                        long ms = ts.getTime();
                        time = new Time(ms);
                    } else {
                        time = ui.nativeCType == 6 ? new Time(ByteArrayConverter.getTimeFromBaseDouble(byteExtractor)) : byteExtractor.getTime();
                    }
                    ac.setObject(time);
                    break;
                }
                case 93: {
                    Timestamp timestamp = ui.nativeCType == 6 ? new Timestamp(ByteArrayConverter.getTimestampFromBaseDouble(byteExtractor)) : byteExtractor.getTimestamp();
                    ac.setObject(timestamp);
                    break;
                }
                default: {
                    if (AbstractLogger.isTrace) {
                        logger.trace("updateColumnDataV1", "INVALID DATA TYPE DETECTED while processing ordinal=[" + columnOrdinal + "] SQLType=[" + ui.cSqlType + "]");
                    }
                    String ei = "AbstractCachingDataTypeFatalError.txt";
                    LocalizedErrorHandler.throwLocalizedException("AbstractCachingDataTypeFatalError.txt", logger);
                }
            }
        }
    }

    public static long getIndicatorValue(ByteExtractor byteExtractor) {
        long indicator = byteExtractor.getByte();
        if (indicator < 0L) {
            if (indicator == -8L) {
                indicator = byteExtractor.getShort();
            } else if (indicator == -6L) {
                indicator = byteExtractor.getInt();
            } else if (indicator == -9L) {
                indicator = byteExtractor.getLong();
            }
        }
        return indicator;
    }

    public static ByteBuffer allocateNewBuffer(int capacity) {
        ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
        newBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return newBuffer;
    }

    public static byte[] nullValue2ByteArray(int ordinal) {
        byte[] bytes = new byte[5];
        ByteArrayConverter.insertOrdinalAndIndicator(bytes, ordinal, -1L);
        return bytes;
    }

    public static ByteBuffer nullValue2BufferArray(int ordinal) {
        ByteBuffer buffer = ByteArrayConverter.allocateNewBuffer(5);
        ByteArrayConverter.insertOrdinalAndIndicator(buffer, ordinal, -1L);
        return buffer;
    }

    public static ByteBuffer date2ByteArray(int ordinal, Date date) {
        ByteBuffer byteBuffer = null;
        int capacity = 0;
        int indx = 5;
        if (date == null) {
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, -1L);
        } else {
            capacity = indx + 4;
            byteBuffer = ByteArrayConverter.allocateNewBuffer(capacity);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, 6L);
            calendar = ByteArrayConverter.getCalendar();
            calendar.setTime(date);
            short year = (short)calendar.get(1);
            byte month = (byte)(calendar.get(2) + 1);
            byte day = (byte)calendar.get(5);
            byteBuffer.putShort(year);
            byteBuffer.put(month);
            byteBuffer.put(day);
        }
        return byteBuffer;
    }

    public static ByteBuffer time2ByteArray(int ordinal, Time time) {
        ByteBuffer byteBuffer = null;
        int indx = 5;
        int capacity = 0;
        if (time == null) {
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, -1L);
        } else {
            capacity = indx + 3;
            byteBuffer = ByteArrayConverter.allocateNewBuffer(capacity);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, 6L);
            calendar = ByteArrayConverter.getCalendar();
            calendar.setTimeInMillis(time.getTime());
            byte hour = (byte)calendar.get(11);
            byte minute = (byte)calendar.get(12);
            byte second = (byte)calendar.get(13);
            byteBuffer.put(hour);
            byteBuffer.put(minute);
            byteBuffer.put(second);
        }
        return byteBuffer;
    }

    public static ByteBuffer timeStamp2ByteArray(int ordinal, Timestamp timeStamp) {
        ByteBuffer byteBuffer = null;
        int capacity = 0;
        int indx = 5;
        if (timeStamp == null) {
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, -1L);
        } else {
            capacity = indx + 11;
            byteBuffer = ByteArrayConverter.allocateNewBuffer(capacity);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, (long)capacity);
            calendar = ByteArrayConverter.getCalendar();
            calendar.setTimeInMillis(timeStamp.getTime());
            short year = (short)calendar.get(1);
            byte month = (byte)(calendar.get(2) + 1);
            byte day = (byte)calendar.get(5);
            byte hour = (byte)calendar.get(11);
            byte minute = (byte)calendar.get(12);
            byte second = (byte)calendar.get(13);
            int fraction = timeStamp.getNanos();
            byteBuffer.putShort(year);
            byteBuffer.put(month);
            byteBuffer.put(day);
            byteBuffer.put(hour);
            byteBuffer.put(minute);
            byteBuffer.put(second);
            byteBuffer.putInt(fraction);
        }
        return byteBuffer;
    }

    public static ByteBuffer bigDecimal2ByteArray(int ordinal, BigDecimal bigDecimal) {
        ByteBuffer byteBuffer = null;
        int capacity = 0;
        int indx = 5;
        if (bigDecimal == null) {
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, -1L);
        } else if (bigDecimal.compareTo(BIG_ZERO) == 0) {
            capacity = indx + 1;
            byteBuffer = ByteArrayConverter.allocateNewBuffer(capacity);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, 19L);
            byteBuffer.position(indx);
            byteBuffer.put((byte)0);
        } else {
            byte precision = (byte)bigDecimal.precision();
            byte scale = (byte)bigDecimal.scale();
            byte signum = (byte)bigDecimal.signum();
            BigInteger unscaledBigInt = bigDecimal.unscaledValue().abs();
            byte[] byteRepresentation = unscaledBigInt.toByteArray();
            byteRepresentation = ByteArrayConverter.removeTrailingZeros(byteRepresentation);
            precision = (byte)unscaledBigInt.toString().length();
            capacity = byteRepresentation.length + 9;
            byteBuffer = ByteArrayConverter.allocateNewBuffer(capacity);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, 19L);
            byteBuffer.put((byte)(byteRepresentation.length + 3));
            byteBuffer.put(precision);
            byteBuffer.put(scale);
            byteBuffer.put(signum == -1 ? (byte)0 : 1);
            for (int pos = byteRepresentation.length - 1; pos >= 0; --pos) {
                byteBuffer.put(byteRepresentation[pos]);
            }
        }
        return byteBuffer;
    }

    public static ByteBuffer string2ByteArray(int ordinal, String value) {
        ByteBuffer byteBuffer = null;
        int capacity = 0;
        int indx = 5;
        if (value == null) {
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, -1L);
        } else if (value.equals("")) {
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, 0L);
        } else {
            byte[] valueBytes = value.getBytes(CharSetUtil.getToServerCharset());
            int dataLength = valueBytes.length;
            short indicatorSizeInBytes = ByteArrayConverter.resolveIndicatorSizeInBytes(dataLength);
            indx = 4 + indicatorSizeInBytes;
            capacity = indx + dataLength + 4;
            byteBuffer = ByteArrayConverter.allocateNewBuffer(capacity);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, (long)dataLength);
            byteBuffer.position(indx);
            byteBuffer.putInt(dataLength);
            byteBuffer.put(valueBytes);
        }
        return byteBuffer;
    }

    public static ByteBuffer byteArray2ByteArray(int ordinal, byte[] value) {
        ByteBuffer byteBuffer = null;
        int indx = 5;
        int capacity = 0;
        if (value == null) {
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, -1L);
        } else if (value.length == 0) {
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, 0L);
        } else {
            int dataLength = value.length;
            short indicatorSizeInBytes = ByteArrayConverter.resolveIndicatorSizeInBytes(dataLength);
            indx = 4 + indicatorSizeInBytes;
            capacity = indx + dataLength + 4;
            byteBuffer = ByteArrayConverter.allocateNewBuffer(capacity);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, (long)dataLength);
            byteBuffer.putInt(dataLength);
            byteBuffer.put(value);
        }
        return byteBuffer;
    }

    public static ByteBuffer number2ByteArray(int ordinal, Number number) {
        ByteBuffer byteBuffer = null;
        if (number == null) {
            int indx = 5;
            byteBuffer = ByteArrayConverter.allocateNewBuffer(indx);
            ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, -1L);
        } else if (number instanceof Byte) {
            byteBuffer = ByteArrayConverter.number2ByteBuffer(ordinal, 1);
            byteBuffer.put(number.byteValue());
        } else if (number instanceof Short) {
            byteBuffer = ByteArrayConverter.number2ByteBuffer(ordinal, 2);
            byteBuffer.putShort(number.shortValue());
        } else if (number instanceof Integer) {
            byteBuffer = ByteArrayConverter.number2ByteBuffer(ordinal, 4);
            byteBuffer.putInt(number.intValue());
        } else if (number instanceof Float) {
            byteBuffer = ByteArrayConverter.number2ByteBuffer(ordinal, 4);
            byteBuffer.putFloat(number.floatValue());
        } else if (number instanceof Long) {
            byteBuffer = ByteArrayConverter.number2ByteBuffer(ordinal, 8);
            byteBuffer.putLong(number.longValue());
        } else if (number instanceof Double) {
            byteBuffer = ByteArrayConverter.number2ByteBuffer(ordinal, 8);
            byteBuffer.putDouble(number.doubleValue());
        }
        return byteBuffer;
    }

    public static void insertOrdinalAndIndicator(byte[] bytes, int ordinal, long indicatorValue) {
        ByteArrayConverter.insertNumericValueIntoByteArray(bytes, 0, (long)ordinal, 4);
        if (indicatorValue <= 127L) {
            bytes[4] = (byte)indicatorValue;
        } else if (indicatorValue > 127L && indicatorValue <= 32767L) {
            bytes[4] = -8;
            ByteArrayConverter.insertNumericValueIntoByteArray(bytes, 5, indicatorValue, 2);
        } else if (indicatorValue > 32767L && indicatorValue <= Integer.MAX_VALUE) {
            bytes[4] = -6;
            ByteArrayConverter.insertNumericValueIntoByteArray(bytes, 5, indicatorValue, 4);
        } else {
            bytes[4] = -9;
            ByteArrayConverter.insertNumericValueIntoByteArray(bytes, 5, indicatorValue, 8);
        }
    }

    public static void insertOrdinalAndIndicator(ByteBuffer byteBuffer, int ordinal, long indicatorValue) {
        ByteArrayConverter.insertNumericValueIntoByteArray(byteBuffer, 0, (long)ordinal, 4);
        byteBuffer.position(4);
        if (indicatorValue <= 127L) {
            byteBuffer.position(4);
            byteBuffer.put((byte)indicatorValue);
        } else if (indicatorValue > 127L && indicatorValue <= 32767L) {
            byteBuffer.put((byte)-8);
            ByteArrayConverter.insertNumericValueIntoByteArray(byteBuffer.array(), 5, indicatorValue, 2);
        } else if (indicatorValue > 32767L && indicatorValue <= Integer.MAX_VALUE) {
            byteBuffer.put((byte)-6);
            ByteArrayConverter.insertNumericValueIntoByteArray(byteBuffer.array(), 5, indicatorValue, 4);
        } else {
            byteBuffer.put((byte)-9);
            ByteArrayConverter.insertNumericValueIntoByteArray(byteBuffer.array(), 5, indicatorValue, 8);
        }
    }

    private static ByteBuffer number2ByteBuffer(int ordinal, int sizeOfType) {
        short indicatorSizeInBytes = ByteArrayConverter.resolveIndicatorSizeInBytes(sizeOfType);
        short indx = (short)(4 + indicatorSizeInBytes);
        ByteBuffer byteBuffer = ByteArrayConverter.allocateNewBuffer(sizeOfType + indx);
        ByteArrayConverter.insertOrdinalAndIndicator(byteBuffer, ordinal, (long)sizeOfType);
        return byteBuffer;
    }

    public static short resolveIndicatorSizeInBytes(long indicator) {
        int sizeInBytes = 0;
        sizeInBytes = indicator <= 127L ? 1 : (indicator <= 32767L ? 3 : (indicator <= Integer.MAX_VALUE ? 5 : 9));
        return (short)sizeInBytes;
    }

    private static void insertNumericValueIntoByteArray(byte[] bytes, int atPosition, long value, int size) {
        for (int i = 0; i < size; ++i) {
            bytes[atPosition++] = (byte)value;
            value >>= 8;
        }
    }

    private static void insertNumericValueIntoByteArray(ByteBuffer byteBuffer, int atPosition, long value, int size) {
        switch (size) {
            case 2: {
                byteBuffer.putShort(atPosition, (short)value);
                break;
            }
            case 4: {
                byteBuffer.putInt(atPosition, (int)value);
                break;
            }
            case 8: {
                byteBuffer.putLong(atPosition, value);
                break;
            }
            case 1: {
                byteBuffer.put((byte)value);
                break;
            }
            default: {
                byteBuffer.put((byte)value);
            }
        }
    }

    private static byte[] removeTrailingZeros(byte[] original) {
        int i;
        byte[] bytes = null;
        int trailingZeros = 0;
        for (i = 0; i < original.length && original[i] == 0; ++i) {
            ++trailingZeros;
        }
        if (trailingZeros > 0) {
            bytes = new byte[original.length - trailingZeros];
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = original[trailingZeros++];
            }
            return bytes;
        }
        return original;
    }

    public static byte[] buildPackedBuffer(ParameterInfo[] parameterInfoArray, boolean isPackType1) throws SQLException {
        ParameterInfo pi;
        int i;
        int estimate = 100;
        int arrayMax = parameterInfoArray.length;
        byte[] out = null;
        for (i = 0; i < arrayMax; ++i) {
            pi = parameterInfoArray[i];
            estimate += (int)pi.getDisplaySize();
        }
        PackedParameterSetBuffer packedData = PackedParameterSetBuffer.create(estimate, isPackType1);
        packedData.addColumnNumbers(parameterInfoArray);
        for (i = 0; i < arrayMax; ++i) {
            pi = parameterInfoArray[i];
            pi.addValueToParameterSet();
        }
        for (i = 0; i < arrayMax; ++i) {
            pi = parameterInfoArray[i];
            pi.addValueToPackedData(0, packedData);
        }
        out = packedData.buildPackedBuffer();
        return out;
    }
}

