/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.sql.Constants;
import com.sas.tkts.types.NumberColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class NumberColumnBigDecimal
extends NumberColumn {
    private BigDecimal data;

    public NumberColumnBigDecimal(BigDecimal value) {
        double d = 0.0;
        BigDecimal bd = new BigDecimal(d);
        dataClass = bd.getClass();
        this.data = value;
    }

    @Override
    public void cleanup() {
        this.data = null;
    }

    @Override
    public final NumberColumnBigDecimal clone() {
        NumberColumnBigDecimal out = new NumberColumnBigDecimal(this.data);
        return out;
    }

    @Override
    public Class getDataTypeClass() {
        return dataClass;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.data;
    }

    @Override
    public boolean getBoolean() {
        double d = 0.0;
        if (this.data != null) {
            d = this.data.doubleValue();
        }
        return this.booleanDouble(d);
    }

    @Override
    public byte getByte() {
        BigDecimal bdOut = this.getRangedValue(Constants.BD_MIN_VALUE_OF_BYTE, Constants.BD_MAX_VALUE_OF_BYTE);
        byte out = bdOut.byteValue();
        return out;
    }

    @Override
    public double getDouble() {
        BigDecimal bdOut = this.getRangedValue(Constants.BD_MIN_VALUE_OF_DOUBLE, Constants.BD_MAX_VALUE_OF_DOUBLE);
        byte trunType = this.getDataTruncationType();
        double out = trunType == 0 ? bdOut.doubleValue() : (trunType == 1 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
        return out;
    }

    @Override
    public float getFloat() {
        BigDecimal bdOut = this.getRangedValue(Constants.BD_MIN_VALUE_OF_FLOAT, Constants.BD_MAX_VALUE_OF_FLOAT);
        byte trunType = this.getDataTruncationType();
        float out = trunType == 0 ? bdOut.floatValue() : (trunType == 1 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
        return out;
    }

    @Override
    public int getInt() {
        BigDecimal bdOut = this.getRangedValue(Constants.BD_MIN_VALUE_OF_INTEGER, Constants.BD_MAX_VALUE_OF_INTEGER);
        int out = bdOut.intValue();
        return out;
    }

    @Override
    public long getLong() {
        BigDecimal bdOut = this.getRangedValue(Constants.BD_MIN_VALUE_OF_LONG, Constants.BD_MAX_VALUE_OF_LONG);
        long out = bdOut.longValue();
        return out;
    }

    @Override
    public Object getObject() throws SQLException {
        return this.data;
    }

    private BigDecimal getRangedValue(BigDecimal minAsBigDecimal, BigDecimal maxAsBigDecimal) {
        BigDecimal bdIn = this.data;
        if (bdIn == null) {
            BigDecimal bdOut = BigDecimal.ZERO;
            return bdOut;
        }
        int lowCompare = bdIn.compareTo(minAsBigDecimal);
        if (lowCompare == -1) {
            this.setDataTruncation((byte)-1);
            BigDecimal bdOut = minAsBigDecimal;
            return bdOut;
        }
        int highCompare = bdIn.compareTo(maxAsBigDecimal);
        if (highCompare == 1) {
            this.setDataTruncation((byte)1);
            BigDecimal bdOut = maxAsBigDecimal;
            return bdOut;
        }
        this.setDataTruncation((byte)0);
        return bdIn;
    }

    @Override
    public Object getRawData() throws SQLException {
        return this.data;
    }

    @Override
    public short getShort() {
        BigDecimal bdOut = this.getRangedValue(Constants.BD_MIN_VALUE_OF_SHORT, Constants.BD_MAX_VALUE_OF_SHORT);
        short out = bdOut.shortValue();
        return out;
    }

    @Override
    public int getSQLType() {
        return 2;
    }

    @Override
    public String getString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void setBigDecimal(BigDecimal value) {
        this.data = value;
    }

    @Override
    public void setByte(byte value) {
        this.data = new BigDecimal((long)value);
        this.setUpdated(true);
    }

    @Override
    public void setDouble(double value) {
        this.data = new BigDecimal(value);
        this.setUpdated(true);
    }

    @Override
    public void setFloat(float value) {
        this.data = new BigDecimal(value);
        this.setUpdated(true);
    }

    @Override
    public void setInt(int value) {
        this.data = new BigDecimal((long)value);
        this.setUpdated(true);
    }

    @Override
    public void setLong(long value) {
        this.data = new BigDecimal(value);
        this.setUpdated(true);
    }

    @Override
    public void setNull() {
        this.data = null;
        this.setUpdated(false);
    }

    @Override
    public void setObject(Object value) {
        Number inNumber = null;
        if (value == null) {
            this.data = null;
            this.setUpdated(false);
            return;
        }
        if (value instanceof BigDecimal) {
            this.data = (BigDecimal)value;
        } else if (value instanceof BigInteger) {
            BigInteger bi = (BigInteger)value;
            String s = bi.toString();
            this.data = new BigDecimal(s);
        } else {
            int sqlType = UtilityFunctions.getObjectSQLType(value);
            inNumber = (Number)ParameterInfoHelper.coerceObject(value, sqlType, false);
            String s = inNumber.toString();
            this.data = new BigDecimal(s);
        }
        this.setUpdated(true);
    }

    @Override
    public void setShort(short value) {
        this.data = new BigDecimal((long)value);
        this.setUpdated(true);
    }

    @Override
    public String toString() {
        String out = this.isNull() ? "NULL" : this.data.toString();
        return out;
    }
}

