/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.types;

import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;

public class DateColumn
extends AbstractColumn {
    private transient Date data;

    public DateColumn(Date date) {
        this.data = date;
    }

    @Override
    public String getString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    @Override
    public Date getDate() {
        Date out = null;
        if (this.data != null) {
            out = (Date)this.data.clone();
        }
        return out;
    }

    @Override
    public Date getDate(Calendar cal) {
        Date out = null;
        if (this.data != null) {
            out = (Date)this.data.clone();
            UtilityFunctions.applyCalendar(out, cal);
        }
        return out;
    }

    @Override
    public Timestamp getTimestamp() {
        if (this.data == null) {
            return null;
        }
        return new Timestamp(this.data.getTime());
    }

    @Override
    public Timestamp getTimestamp(Calendar newCal) {
        if (this.data == null) {
            return null;
        }
        long ms = this.data.getTime();
        Timestamp outTS = new Timestamp(ms);
        UtilityFunctions.applyCalendar(outTS, newCal);
        return outTS;
    }

    @Override
    public Object getObject() {
        Object outObj = this.data;
        if (outObj != null) {
            outObj = this.data.clone();
        }
        return outObj;
    }

    @Override
    public void setNull() {
        this.data = null;
        this.setUpdated(true);
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    public void setObject(Object value) {
        Date inDate = null;
        if (value != null && (inDate = (Date)ParameterInfoHelper.coerceObject(value, 91, false)) == value) {
            inDate = (Date)inDate.clone();
        }
        this.data = inDate;
        this.setUpdated(true);
    }

    @Override
    public void setDate(Date value) {
        this.data = value == null ? null : (Date)value.clone();
        this.setUpdated(true);
    }

    @Override
    public String toString() {
        String outStr = this.data == null ? "NULL: isUpdated:" + this.isUpdated() : "Date:" + this.getString() + " isUpdated:" + this.isUpdated();
        return outStr;
    }

    @Override
    public Object getRawData() {
        return this.data;
    }

    @Override
    public final DateColumn clone() {
        Date outDate = this.getDate();
        DateColumn out = new DateColumn(outDate);
        return out;
    }

    @Override
    public int getSQLType() {
        return 91;
    }

    @Override
    public Class getDataTypeClass() {
        return this.data.getClass();
    }

    @Override
    public void cleanup() {
        this.data = null;
    }
}

