/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.stats;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class StatisticItem {
    public static final double THOUSAND = Math.pow(10.0, 3.0);
    public static final double MILLION = Math.pow(10.0, 6.0);
    public static final double BILLION = Math.pow(10.0, 9.0);
    private transient String name;
    private transient String description;
    private transient Date creationDate = Calendar.getInstance().getTime();
    private transient long counter;
    private transient long summative;
    private transient long executionTime;
    private transient double percent;
    private transient long apiTotalRowsCount;
    private transient long apiTotalBytes;
    private transient boolean excludeFromTotal = false;

    public StatisticItem(String itemName, long executionTime) {
        this.name = itemName;
        this.executionTime = executionTime;
    }

    public StatisticItem(String itemName, String description, long executionTime) {
        this.description = description;
        this.name = itemName;
        this.executionTime = executionTime;
    }

    public StatisticItem(String itemName, long delta, long rowCount, long bytes) {
        this.name = itemName;
        this.apiTotalBytes = bytes;
        this.apiTotalRowsCount = rowCount;
        this.executionTime = delta;
    }

    public double convertToMilliSeconds(long nanoSeconds) {
        return this.getRoundedNumber((double)nanoSeconds / MILLION, 8);
    }

    public double convertToSeconds(long nanoSeconds) {
        return this.getRoundedNumber((double)nanoSeconds / BILLION, 8);
    }

    public double convertToMinutes(long nanoSeconds) {
        return this.getRoundedNumber((double)nanoSeconds / BILLION / 60.0, 8);
    }

    public synchronized void incrementSummative() {
        this.summative += this.executionTime;
        ++this.counter;
    }

    public synchronized void incrementPackSummative(long delta, long rowCount, long bytes) {
        this.executionTime = delta;
        this.apiTotalBytes += bytes;
        this.apiTotalRowsCount += rowCount;
        this.summative += delta;
        ++this.counter;
    }

    public synchronized CurrentValues getCurrentValues() {
        CurrentValues values = new CurrentValues(this.counter, this.summative);
        values.currentCounter = this.counter;
        values.currentSummative = this.summative;
        return values;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getCounter() {
        return this.counter;
    }

    public long getSummattive() {
        return this.summative;
    }

    public double getSummative(int measurement) {
        switch (measurement) {
            case 0: {
                return this.summative;
            }
            case 1: {
                return this.convertToMilliSeconds(this.summative);
            }
            case 2: {
                return this.convertToSeconds(this.summative);
            }
            case 3: {
                return this.convertToMinutes(this.summative);
            }
        }
        return this.summative;
    }

    public long getTotalBytes() {
        return this.apiTotalBytes;
    }

    public long getTotalRows() {
        return this.apiTotalRowsCount;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutionTime(long execTime) {
        this.executionTime = execTime;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public double getExecutionTime(int measurement) {
        switch (measurement) {
            case 0: {
                return this.executionTime;
            }
            case 1: {
                return this.convertToMilliSeconds(this.executionTime);
            }
            case 2: {
                return this.convertToSeconds(this.executionTime);
            }
            case 3: {
                return this.convertToMinutes(this.executionTime);
            }
        }
        return this.executionTime;
    }

    public void resetItem() {
        this.executionTime = 0L;
    }

    private double getRoundedNumber(double number, int scale) {
        String convString = Double.toString(number);
        BigDecimal rBD = new BigDecimal(convString);
        double out = rBD.doubleValue();
        return out;
    }

    private double getRoundedNumber(double number) {
        String convString = Double.toString(number);
        BigDecimal rBD = new BigDecimal(convString);
        double out = rBD.doubleValue();
        return out;
    }

    public double getAverage() {
        double out = this.summative;
        double tDbl = this.counter;
        if (this.counter > 0L) {
            out /= tDbl;
        }
        return out;
    }

    public void setPercent(double inPercent) {
        this.percent = inPercent;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setExcludeFromTotals(boolean inVal) {
        this.excludeFromTotal = inVal;
    }

    public boolean getExcludeFromTotals() {
        return this.excludeFromTotal;
    }

    public static class CurrentValues {
        public transient long currentCounter;
        public transient long currentSummative;

        protected CurrentValues(long cCounter, long cSummative) {
            this.currentCounter = cCounter;
            this.currentSummative = cSummative;
        }
    }
}

