/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.stats;

import com.sas.tkts.stats.StatisticItem;
import com.sas.tkts.stats.StatisticsBoard;
import java.math.BigDecimal;
import java.util.Vector;

public class GenericMonitor
extends Thread {
    private static StatisticsBoard statBoard = StatisticsBoard.getInstance();
    private static final double MILLION = Math.pow(10.0, 6.0);
    private static final double BILLION = Math.pow(10.0, 9.0);
    private transient String[] itemsName;
    private transient long interval = 2000L;
    private transient int numberOfClients;
    private static final transient byte[] lock = new byte[0];
    private transient boolean keepRunning = true;

    public GenericMonitor(String[] itemsName) {
        this.itemsName = (String[])itemsName.clone();
    }

    public void stopMonitor() {
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lastSummative = 0L;
        long lastCounter = 0L;
        long deltaSummative = 0L;
        long deltaCounter = 0L;
        Vector<StatisticItem> statItemVector = new Vector<StatisticItem>();
        do {
            try {
                GenericMonitor genericMonitor = this;
                synchronized (genericMonitor) {
                    this.wait(this.interval);
                }
                for (int i = 0; i < this.itemsName.length; ++i) {
                    StatisticItem item = statBoard.getStatisticItem(this.itemsName[i]);
                    if (item == null) continue;
                    statItemVector.add(item);
                }
                for (StatisticItem item : statItemVector) {
                    StatisticItem.CurrentValues currentValues = item.getCurrentValues();
                    if (currentValues.currentCounter <= 0L) continue;
                    double summMillis = (double)currentValues.currentSummative / MILLION;
                    double summSeconds = (double)currentValues.currentSummative / BILLION;
                    double throughput = (double)currentValues.currentCounter / summSeconds;
                    double responseTime = summMillis / (double)currentValues.currentCounter;
                    double littlesLaw = this.numberOfClients > 0 ? throughput * (responseTime / 1000.0) : 0.0;
                    double utilization = (double)this.numberOfClients * (responseTime / 1000.0);
                    double waitTime = responseTime * (utilization / (1.0 - utilization));
                    double lengthWaitingtLine = (double)this.numberOfClients * waitTime;
                    double timeInQueue = waitTime + responseTime;
                    summMillis = this.getRoundedNumber(summMillis);
                    responseTime = this.getRoundedNumber(responseTime);
                    throughput = this.getRoundedNumber(throughput);
                    littlesLaw = this.getRoundedNumber(littlesLaw);
                    utilization = this.getRoundedNumber(utilization);
                    waitTime = this.getRoundedNumber(waitTime);
                    lengthWaitingtLine = this.getRoundedNumber(lengthWaitingtLine);
                    timeInQueue = this.getRoundedNumber(timeInQueue);
                    System.out.println("TOTAL: StatItem [" + item.getName() + "] Cli [" + this.numberOfClients + "] Ins [" + currentValues.currentCounter + "] RespT [" + responseTime + "] ThrPut [" + throughput + "] LittlesL [" + littlesLaw + "] Util [" + this.getRoundedNumber(utilization * 100.0) + "] WaitT [" + waitTime + "] LenWLine [" + lengthWaitingtLine + "] TimeInQ [" + timeInQueue + "]");
                    deltaSummative = currentValues.currentSummative - lastSummative;
                    if (deltaSummative > 0L) {
                        deltaCounter = currentValues.currentCounter - lastCounter;
                        double deltaSummMillis = (double)deltaSummative / MILLION;
                        double deltaResponseTime = deltaSummMillis / (double)deltaCounter;
                        double deltaSummSeconds = (double)deltaSummative / BILLION;
                        double deltaThroughput = (double)deltaCounter / deltaSummSeconds;
                        double deltaLittlesLaw = this.numberOfClients > 0 ? deltaThroughput * (deltaResponseTime / 1000.0) : 0.0;
                        double deltaUtilization = (double)this.numberOfClients * (deltaResponseTime / 1000.0);
                        double deltaWaitTime = deltaResponseTime * (deltaUtilization / (1.0 - deltaUtilization));
                        double deltaLengthWaitingtLine = (double)this.numberOfClients * deltaWaitTime;
                        double deltaTimeInQueue = deltaWaitTime + deltaResponseTime;
                        deltaSummMillis = this.getRoundedNumber(deltaSummMillis);
                        deltaResponseTime = this.getRoundedNumber(deltaResponseTime);
                        deltaSummSeconds = this.getRoundedNumber(deltaSummSeconds);
                        deltaThroughput = this.getRoundedNumber(deltaThroughput);
                        deltaLittlesLaw = this.getRoundedNumber(deltaLittlesLaw);
                        deltaUtilization = this.getRoundedNumber(deltaUtilization);
                        deltaWaitTime = this.getRoundedNumber(deltaWaitTime);
                        deltaLengthWaitingtLine = this.getRoundedNumber(deltaLengthWaitingtLine);
                        deltaTimeInQueue = this.getRoundedNumber(deltaTimeInQueue);
                        System.out.println("DELTA: StatItem [" + item.getName() + "] Cli [" + this.numberOfClients + "] Ins [" + deltaCounter + "] RespT [" + deltaResponseTime + "] ThrPut [" + deltaThroughput + "] LittlesL [" + deltaLittlesLaw + "] Util [" + this.getRoundedNumber(deltaUtilization * 100.0) + "] WaitT [" + deltaWaitTime + "] LenWLine [" + deltaLengthWaitingtLine + "] TimeInQ [" + deltaTimeInQueue + "]");
                    }
                    lastCounter = currentValues.currentCounter;
                    lastSummative = currentValues.currentSummative;
                }
                statItemVector.clear();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.keepRunning);
    }

    private double getRoundedNumber(double number) {
        String convString = Double.toString(number);
        BigDecimal rBD = new BigDecimal(convString);
        double out = rBD.doubleValue();
        return out;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public int getNumberOfClients() {
        return this.numberOfClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementNumberOfClients() {
        byte[] byArray = lock;
        synchronized (lock) {
            ++this.numberOfClients;
            if (this.numberOfClients == 1) {
                this.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementNumberOfClients() {
        byte[] byArray = lock;
        synchronized (lock) {
            --this.numberOfClients;
            if (this.numberOfClients == 0) {
                this.keepRunning = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

