/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.StatementPoolManager;
import com.sas.tkts.sql.StatementPoolMonitorTask;
import java.util.Timer;
import java.util.TimerTask;

public class StatementPoolTimer {
    private static String thisClassName = StatementPoolTimer.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static StatementPoolTimer thisTimer;
    private static byte[] lock;
    private static int taskCount;
    private transient Timer poolMonitorTimer = new Timer("SPTimer", true);

    private StatementPoolTimer() {
    }

    public static synchronized StatementPoolTimer getInstance() {
        if (thisTimer == null) {
            thisTimer = new StatementPoolTimer();
        }
        return thisTimer;
    }

    public static int getActiveTasks() {
        return taskCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatementPoolMonitorTask createPoolMonitorTask(StatementPoolManager poolManager) {
        String method = "createPoolMonitorTask(poolManager)";
        long poolInterval = poolManager.getPoolMaintenanceInterval();
        if (AbstractLogger.isTrace) {
            logger.entry(method, "Interval=[" + poolInterval + "] seconds");
        }
        long longInterval = poolInterval * 1000L;
        StatementPoolMonitorTask timerTask = new StatementPoolMonitorTask(poolManager);
        this.poolMonitorTimer.schedule((TimerTask)timerTask, 1000L, longInterval);
        byte[] byArray = lock;
        synchronized (lock) {
            ++taskCount;
            // ** MonitorExit[var8_6] (shouldn't be in output)
            return timerTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPoolMonitorTask(StatementPoolMonitorTask monitorTask) {
        String method = "stopPoolMonitorTask";
        if (AbstractLogger.isTrace) {
            logger.entry(method);
        }
        monitorTask.terminate();
        byte[] byArray = lock;
        synchronized (lock) {
            --taskCount;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static {
        lock = new byte[0];
    }
}

