/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.stats.StatisticsBoard;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LocalizedMessageHandler {
    private static String CANNOT_WRITE = "Cannot write a message. Logger is null";
    private static ResourceBundle resBundle;
    private static ResourceBundle resBundleStats;
    private static StatisticsBoard statBoard;
    private static boolean logStatisticsOnConnectionClose;

    public static void errorCannotWrite() {
        System.err.println(CANNOT_WRITE);
    }

    public static synchronized void setupInfoLogging() {
        if (resBundle == null) {
            resBundle = ResourceBundle.getBundle("com.sas.tkts.LogInfoResources");
        }
    }

    public static synchronized void setupStatsLogging() {
        if (resBundleStats == null) {
            resBundleStats = ResourceBundle.getBundle("com.sas.tkts.LogStatsResources");
            CANNOT_WRITE = resBundleStats.getString("Logger.LoggerIsNull.txt");
        }
        if (statBoard == null) {
            statBoard = StatisticsBoard.getInstance();
        }
    }

    public static ResourceBundle getLoggerResourceBundle(AbstractLogger logger) {
        ResourceBundle myRB = (ResourceBundle)logger.getResourceBundle();
        if (myRB == null) {
            logger.setResourceBundle(resBundle);
            myRB = resBundle;
        }
        return myRB;
    }

    public static void logInfoMessage(String method, String message, AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        ResourceBundle myRB = LocalizedMessageHandler.getLoggerResourceBundle(logger);
        String logMessage = myRB.getString(message);
        logger.info(method, logMessage);
    }

    public static void logErrorMessage(String method, AbstractLogger logger, String messageKey, Object ... args) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        ResourceBundle myRB = LocalizedMessageHandler.getLoggerResourceBundle(logger);
        String messageFormat = myRB.getString(messageKey);
        String finalMessage = MessageFormat.format(messageFormat, args);
        logger.errorMethod(method, finalMessage);
        System.err.println(finalMessage);
    }

    public static void logInfoMessage(String method, AbstractLogger logger, String messageKey, Object ... args) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        ResourceBundle myRB = LocalizedMessageHandler.getLoggerResourceBundle(logger);
        String messageFormat = myRB.getString(messageKey);
        String finalMessage = MessageFormat.format(messageFormat, args);
        logger.info(method, finalMessage);
    }

    public static void logMessage(String method, String message, String[] args, AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        ResourceBundle myRB = LocalizedMessageHandler.getLoggerResourceBundle(logger);
        String logMessage = myRB.getString(message);
        logMessage = LocalizedMessageHandler.getLocalizedMessage(logMessage, args);
    }

    public static void logInfoMessage(String method, String message, String[] args, AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        ResourceBundle myRB = LocalizedMessageHandler.getLoggerResourceBundle(logger);
        String logMessage = myRB.getString(message);
        logMessage = LocalizedMessageHandler.getLocalizedMessage(logMessage, args);
        logger.info(method, logMessage);
    }

    public static void logStatisticMessage(String apiCall, long delta, AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        if (resBundleStats != null) {
            String logApiCall = resBundleStats.getString(apiCall);
            statBoard.recordStatistic(logApiCall, delta, logger);
        }
    }

    public static void logStatisticMessage(String apiCall, long delta, long rowCount, long bytes, AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        String logApiCall = resBundleStats.getString(apiCall);
        statBoard.recordStatistic(logApiCall, delta, rowCount, bytes, logger);
    }

    public static void logStatisticMessage(String apiCall, String description, long delta, AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        String logApiCall = resBundleStats.getString(apiCall);
        statBoard.recordStatistic(logApiCall, description, delta, logger);
    }

    public static void logFatalMessage(String method, Exception e, AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        logger.fatal(method, e);
    }

    public static void logFatalMessage(String method, ClassFormatError cfe, AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        logger.fatal(method, cfe);
    }

    public static void logOverallStatistics(AbstractLogger logger) {
        if (logger == null) {
            LocalizedMessageHandler.errorCannotWrite();
            return;
        }
        statBoard.logOverallStatistics(logger);
    }

    public static String getLocalizedMessage(String messageKey, Object[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = "<_?_>";
            }
        }
        return MessageFormat.format(messageKey, args);
    }

    public static String getStatsLocalizedMessage(String messageKey) {
        String out = resBundleStats == null ? "" : resBundleStats.getString(messageKey);
        return out;
    }

    public static void resetStatistics() {
        statBoard.resetStatistics();
    }

    public static void setLogStatisticsOnConnectionClose(boolean inValue) {
        LocalizedMessageHandler.setupStatsLogging();
        logStatisticsOnConnectionClose = inValue;
    }

    public static boolean getLogStatisticsOnConnectionClose() {
        return logStatisticsOnConnectionClose;
    }

    private static long getBytes(AbstractLogger logger, String apiCall) {
        String logApiCall;
        ResourceBundle myRB;
        long out = -1L;
        if (logger != null && (myRB = LocalizedMessageHandler.getLoggerResourceBundle(logger)) != null && (logApiCall = myRB.getString(apiCall)) != null) {
            out = statBoard.getBytes(logApiCall);
        }
        return out;
    }

    public static long getPackedBytes(AbstractLogger logger) {
        String apiCall = "StatementWrapper.apiPackData.txt";
        return LocalizedMessageHandler.getBytes(logger, "StatementWrapper.apiPackData.txt");
    }

    public static long getUnpackedBytes(AbstractLogger logger) {
        String apiCall = "StatementWrapper.apiUnpackData.txt";
        return LocalizedMessageHandler.getBytes(logger, "StatementWrapper.apiUnpackData.txt");
    }

    static {
        logStatisticsOnConnectionClose = false;
        LocalizedMessageHandler.setupInfoLogging();
        LocalizedMessageHandler.setupStatsLogging();
    }
}

