/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.iom.SASIOMDefs.LongLongSeqHolder;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHelper;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.tkts.FSEnums;
import com.sas.tkts.info.PackedParameterSetBuffer;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.iom.AbstractIOMWrapper;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSParameterMetaData;
import com.sas.tkts.sql.FSResultSet;
import com.sas.tkts.sql.FSResultSetMetaData;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.types.BlobFedSrv;
import com.sas.tkts.util.ByteExtractor;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.DataTypeConversions;
import com.sas.tkts.util.ParameterInfoHelper;
import com.sas.tkts.util.TimeRepresentation;
import com.sas.tkts.util.UtilityFunctions;
import com.sas.tkts.util.VendorSpecificErrorCode;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.LongHolder;

public class FSPreparedStatement
extends FSStatement
implements PreparedStatement {
    protected static final String INPUT_STREAM = "InputStream";
    protected static final String INPUT_BLOB = "Blob";
    protected static final String SET_BLOB = "setBlob";
    protected static final String SET_BINARY_STREAM = "setBinaryStream";
    protected static final String DISABLE_METHOD = "TKTSPreparedStatement.disMethodError.fmt";
    protected static final String SETTER_METHOD = "FSPreparedStatement.setter.fmt";
    protected static final String SETTER_METHOD1 = "FSPreparedStatement.setterOne.fmt";
    private static String thisClassName = FSPreparedStatement.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    protected transient boolean isDataAtExecution;
    protected transient Vector<Integer> globalRowCount;
    protected transient ParameterInfo[] _PIA = null;
    protected transient PackedParameterSetBuffer packedData = null;
    protected transient SQLWarning setSQLWarning;
    private transient boolean noLongParameters;
    private transient boolean isUsedByRowSet;
    private transient long[] columnLengthArray;
    private transient String[] columnNameArray;
    private transient int[] columnTypeArray;
    private transient Calendar statementCalendar = null;
    private transient ResultSetMetaData rsmd = null;

    protected FSPreparedStatement(FSConnection connection, String sqlStmt, int rSetType, int rSetConcurrency) throws SQLException {
        super(connection, rSetType, rSetConcurrency, -1);
        this.lastSqlStatement = sqlStmt;
        this.rsmd = null;
        int packedBufferSize = 0;
        int parameterCount = UtilityFunctions.countParameters(sqlStmt);
        if (parameterCount > 0) {
            this.currentBatchSize = 0;
            int newParameterSetSize = 100;
            this.setParameterSetSize(newParameterSetSize);
        }
        this.numberOfColumnsInResultSet = this.prepareWithNumberOfResultColumns(sqlStmt);
        this._PIA = this.describeParameters(1);
        this.noLongParameters = true;
        for (int i = 0; i < this._PIA.length; ++i) {
            ParameterInfo pi = this._PIA[i];
            if (!FSPreparedStatement.isLongVar(pi.getSQLType())) continue;
            this.noLongParameters = false;
        }
        if (this.numberOfColumnsInResultSet > 0) {
            this.isQueryStatement = true;
            this.createColumnInfoArray(this.numberOfColumnsInResultSet);
            if (this.prefetch && this.abnormalColumnCount == 0) {
                this.setAttribute(20400, 1);
            }
            this.bindColumns();
        } else {
            this.isQueryStatement = false;
            this.numberOfColumnsToBeBound = 0;
            this._COLUMN_INFO_ARRAY = null;
        }
        packedBufferSize = this.getApproximateBufferSize();
        this.packedData = PackedParameterSetBuffer.create(packedBufferSize, this.isPackType1);
        this.packedData.addColumnNumbers(this._PIA);
    }

    protected void clearPackedData() {
        if (this.packedData != null) {
            this.packedData.cleanUpPackedBuffer();
        }
    }

    protected void resizePackedData(int rows) {
        int newBufferSize;
        int oldBufferSize = 0;
        if (this.packedData != null) {
            oldBufferSize = this.packedData.getCapacity();
        }
        if ((newBufferSize = this.getApproximateBufferSize()) > oldBufferSize) {
            this.packedData = PackedParameterSetBuffer.create(newBufferSize, this.isPackType1);
        }
    }

    protected void clearAllParamSetArrays() {
        if (this._PIA == null) {
            return;
        }
        for (int i = 0; i < this._PIA.length; ++i) {
            ParameterInfo pi = this._PIA[i];
            pi.clearParamSetArray();
        }
    }

    protected SQLException createArrayTooLargeEx(long bytesNeeded) {
        String lMsg = null;
        String ei = "General.ArrayTooLarge.fmt";
        lMsg = this.getLocalizedError("General.ArrayTooLarge.fmt", String.valueOf(bytesNeeded));
        SQLFeatureNotSupportedException outEx = new SQLFeatureNotSupportedException(lMsg);
        return outEx;
    }

    private int getApproximateBufferSize() {
        int oneRowBufferSize = 0;
        int out = 64;
        if (this._PIA != null) {
            out += 4 + 4 * this._PIA.length;
            for (int i = 0; i < this._PIA.length; ++i) {
                oneRowBufferSize += (int)this._PIA[i].getDisplaySize();
            }
        }
        return out += oneRowBufferSize * this.previousBatchSize;
    }

    protected static boolean typeRequiresRebind(int oldSqlType, int newSqlType) {
        if (oldSqlType == newSqlType) {
            return false;
        }
        if (oldSqlType == 1 && FSPreparedStatement.isCharType(newSqlType)) {
            return false;
        }
        return oldSqlType != -15 || !FSPreparedStatement.isNCharType(newSqlType);
    }

    protected void addSetWarnings(SQLWarning warning) {
        if (warning != null) {
            if (this.setSQLWarning == null) {
                this.setSQLWarning = warning;
            } else {
                this.setSQLWarning.setNextWarning(warning);
            }
        }
    }

    protected SQLWarning clearSetWarnings() {
        SQLWarning outSW = this.setSQLWarning;
        this.setSQLWarning = null;
        return outSW;
    }

    @Override
    public synchronized void close() throws SQLException {
        String method = "close";
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        if (this.isStatementClosed) {
            return;
        }
        this.wasExecuted = false;
        if (this.isPooled) {
            this.clearParameters();
            this.clearBatch();
            this.clearWarnings();
            this.clearSetWarnings();
        } else {
            this.releaseOutgoingResources();
        }
        super.close();
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiClose.txt", System.nanoTime() - entryTime, logger);
        }
        if (AbstractLogger.isInfo) {
            String ei = "FSPreparedStatement.close.txt";
            LocalizedMessageHandler.logInfoMessage("close", "FSPreparedStatement.close.txt", logger);
        }
    }

    @Override
    public void releaseOutgoingResources() {
        if (this._PIA != null) {
            for (int i = 0; i < this._PIA.length; ++i) {
                this._PIA[i] = null;
            }
        }
        this._PIA = null;
        if (this.packedData != null) {
            this.packedData.cleanUpPackedBuffer();
            this.packedData = null;
        }
        if (this.globalRowCount != null && !this.globalRowCount.isEmpty()) {
            this.globalRowCount.removeAllElements();
        }
        this.globalRowCount = null;
        this.columnLengthArray = null;
        this.columnNameArray = null;
        this.columnTypeArray = null;
        this.statementCalendar = null;
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        String method = "clearParameters";
        this.closedCheck();
        if (this._PIA != null) {
            for (int x = 0; x < this._PIA.length; ++x) {
                this._PIA[x].setValue(null);
                this._PIA[x].setIsValueSet(false);
            }
        }
        if (AbstractLogger.isInfo) {
            String ei = "FSPreparedStatement.clearParams.txt";
            LocalizedMessageHandler.logInfoMessage("clearParameters", "FSPreparedStatement.clearParams.txt", logger);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        String method = "clearBatch";
        this.closedCheck();
        this.currentBatchSize = 0;
        for (int x = 0; x < this._PIA.length; ++x) {
            this._PIA[x].resetValue();
        }
        if (AbstractLogger.isInfo) {
            String ei = "FSPreparedStatement.clearBatch.txt";
            LocalizedMessageHandler.logInfoMessage("clearBatch", "FSPreparedStatement.clearBatch.txt", logger);
        }
    }

    public synchronized Calendar getCalendar() {
        if (this.statementCalendar == null) {
            this.statementCalendar = Calendar.getInstance();
        }
        return this.statementCalendar;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        String method = "getMetaData";
        ResultSetMetaData returnValue = null;
        this.closedCheck();
        if (this.rsmd != null) {
            returnValue = this.rsmd;
        } else if (this.numberOfColumnsInResultSet == 0) {
            returnValue = null;
        } else {
            this.columnNameArray = null;
            this.columnLengthArray = null;
            this.columnTypeArray = null;
            this.columnLengthArray = new long[this.numberOfColumnsInResultSet];
            this.columnNameArray = new String[this.numberOfColumnsInResultSet];
            this.columnTypeArray = new int[this.numberOfColumnsInResultSet];
            for (int ci = 0; ci < this.numberOfColumnsInResultSet; ++ci) {
                ParameterInfo ca = this._COLUMN_INFO_ARRAY[ci];
                this.columnLengthArray[ci] = ca.getDisplaySizeInCharacters();
                this.columnNameArray[ci] = ca.getName();
                this.columnTypeArray[ci] = ca.getSQLType();
            }
            this.rsmd = returnValue = new FSResultSetMetaData(this.statementWrapper, this.columnTypeArray, this.columnNameArray, this.columnLengthArray);
        }
        if (AbstractLogger.isInfo) {
            String ei = "FSPreparedStatement.getMetaData.txt";
            LocalizedMessageHandler.logInfoMessage("getMetaData", "FSPreparedStatement.getMetaData.txt", logger);
        }
        return returnValue;
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.closedCheck();
        return new FSParameterMetaData(this._PIA, this.fsConnection.getServerDataTypeInfo());
    }

    @Override
    public synchronized void setArray(int parameterIndex, Array value) throws SQLException {
        String method = "setArray(parameterIndex, array)";
        this.closedCheck();
        this.genFeatureNotSupportedException("setArray(parameterIndex, array)");
        throw this.nsEx;
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream theStream, int bytesNeeded) throws SQLException {
        String method = "setAsciiStream(parameterIndex, inputStream, int bytesNeeded)";
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(-1);
        if (bytesNeeded < 0) {
            String ei = "TKTSPreparedStatement.invalidStreamLengthError.txt";
            this.throwException("TKTSPreparedStatement.invalidStreamLengthError.txt", logger);
        }
        try {
            byte[] littleBytes;
            if (theStream != null && theStream.read(littleBytes = new byte[bytesNeeded], 0, littleBytes.length) != -1) {
                pi.setDataStreamLength(littleBytes.length);
                pi.setValue(new String(littleBytes));
            }
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("setAsciiStream(parameterIndex, inputStream, int bytesNeeded)", exception, this.statementWrapper, logger);
        }
        pi.setIsValueSet(true);
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream theStream, long bytesNeeded) throws SQLException {
        this.closedCheck();
        if (bytesNeeded > Integer.MAX_VALUE) {
            SQLException outEx = this.createArrayTooLargeEx(bytesNeeded);
            throw outEx;
        }
        int intBytesNeeded = (int)bytesNeeded;
        this.setAsciiStream(parameterIndex, theStream, intBytesNeeded);
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream theStream) throws SQLException, SQLFeatureNotSupportedException {
        String method = "setAsciiStream(parameterIndex, inputStream)";
        this.closedCheck();
        this.genFeatureNotSupportedException("setAsciiStream(parameterIndex, inputStream)");
        throw this.nsEx;
    }

    private void setBinaryStreamEntry(int parameterIndex, String inputType, int inputLength, int bytesNeeded) {
        String method = SET_BINARY_STREAM;
        String ei = "FSPreparedStatement.setGeneral.fmt";
        this.logInfoMessage(SET_BINARY_STREAM, "FSPreparedStatement.setGeneral.fmt", logger, String.valueOf(parameterIndex), String.valueOf(inputType), String.valueOf(inputLength), String.valueOf(bytesNeeded));
    }

    public void setBinaryStreamCommon(int parameterIndex, InputStream theStream, int bytesNeeded) throws SQLException {
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(-4);
        if (bytesNeeded < 0) {
            String ei = "TKTSPreparedStatement.invalidStreamLengthError.txt";
            this.throwException("TKTSPreparedStatement.invalidStreamLengthError.txt", logger);
        }
        try {
            if (theStream == null) {
                pi.setIsValueSet(true);
                pi.setValue(null);
            } else {
                byte[] littleBytes = new byte[bytesNeeded];
                if (theStream.read(littleBytes, 0, littleBytes.length) != -1) {
                    pi.setDataStreamLength(littleBytes.length);
                    pi.setValue(littleBytes);
                }
            }
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction(SET_BINARY_STREAM, exception, this.statementWrapper, logger);
        }
        pi.setIsValueSet(true);
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream theStream, int bytesNeeded) throws SQLException {
        this.setBinaryStreamCommon(parameterIndex, theStream, bytesNeeded);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream theStream, long bytesNeeded) throws SQLException {
        if (bytesNeeded > Integer.MAX_VALUE) {
            SQLException outEx = this.createArrayTooLargeEx(bytesNeeded);
            throw outEx;
        }
        int intBytesNeeded = (int)bytesNeeded;
        this.setBinaryStreamCommon(parameterIndex, theStream, intBytesNeeded);
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream theStream) throws SQLException {
        this.closedCheck();
        byte[] newValue = null;
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(-4);
        if (theStream == null) {
            pi.setIsValueSet(true);
            pi.setValue(null);
        } else {
            newValue = UtilityFunctions.streamToArray(SET_BINARY_STREAM, theStream);
            pi.setDataStreamLength(newValue.length);
            pi.setValue(newValue);
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int bytesNeeded) throws SQLException {
        String method = "setCharacterStream(parameterIndex, reader, int bytesNeeded";
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(-1);
        if (bytesNeeded < 0) {
            String ei = "TKTSPreparedStatement.invalidStreamLengthError.txt";
            this.throwException("TKTSPreparedStatement.invalidStreamLengthError.txt", logger);
        }
        char[] characters = null;
        try {
            if (reader != null && reader.read(characters = new char[bytesNeeded], 0, characters.length) != -1) {
                pi.setDataStreamLength(characters.length);
                pi.setValue(new String(characters));
            }
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("setCharacterStream(parameterIndex, reader, int bytesNeeded", exception, this.statementWrapper, logger);
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, long bytesNeeded) throws SQLException {
        this.closedCheck();
        if (bytesNeeded > Integer.MAX_VALUE) {
            SQLException outEx = this.createArrayTooLargeEx(bytesNeeded);
            throw outEx;
        }
        int intBytesNeeded = (int)bytesNeeded;
        this.setCharacterStream(parameterIndex, reader, intBytesNeeded);
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        String method = "setCharacterStream(parameterIndex, reader)";
        this.closedCheck();
        this.genFeatureNotSupportedException("setCharacterStream(parameterIndex, reader)");
        throw this.nsEx;
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        this.closedCheck();
        this.processBigDecimal(value, 2, 2, pi);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetBigDecimal.txt", System.nanoTime() - entryTime, logger);
        }
    }

    public void logBlobEntry(int pi, String inputType, int inputLength, long length) {
        String ei = "FSPreparedStatement.setGeneral.fmt";
        this.logInfoMessage(SET_BLOB, "FSPreparedStatement.setGeneral.fmt", logger, String.valueOf(pi), String.valueOf(inputType), String.valueOf(inputLength), String.valueOf(length));
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob blob) throws SQLException {
        long entryTime = 0L;
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        this.closedCheck();
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        if (blob == null) {
            pi.setIsValueSet(true);
            pi.setValue(null);
        } else {
            long blobLen = blob.length();
            if (blobLen > Integer.MAX_VALUE) {
                SQLException outSE = BlobFedSrv.invalidLengthSQLException(blobLen);
                throw outSE;
            }
            byte[] inBytes = blob.getBytes(1L, (int)blobLen);
            this.setBytes(parameterIndex, inBytes);
        }
        if (AbstractLogger.isMeasurements) {
            String ei = "FSPreparedStatement.apiSetBlob.txt";
            long elapsed = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetBlob.txt", elapsed, logger);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.closedCheck();
        byte[] newValue = null;
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(-4);
        if (inputStream == null) {
            pi.setIsValueSet(true);
            pi.setValue(null);
        } else {
            newValue = UtilityFunctions.streamToArray(SET_BLOB, inputStream);
            pi.setDataStreamLength(newValue.length);
            pi.setValue(newValue);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            SQLException outEx = this.createArrayTooLargeEx(length);
            throw outEx;
        }
        int bytesNeeded = (int)length;
        this.setBinaryStreamCommon(parameterIndex, inputStream, bytesNeeded);
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean isTrue) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(-7);
        if (isTrue) {
            pi.setValue(Constants.BYTE_ONE);
        } else {
            pi.setValue(Constants.BYTE_ZERO);
        }
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetBoolean.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte value) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(-6);
        Byte byteValue = value == 0 ? Constants.BYTE_ZERO : (value == 1 ? Constants.BYTE_ONE : new Byte(value));
        pi.setValue(byteValue);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetByte.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] littleBytes) throws SQLException {
        byte[] cloneBytes;
        int newLength;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        int sqlType = pi.getSQLType();
        if (!FSPreparedStatement.isBinaryType(sqlType)) {
            pi.validateParameterDataType(-3);
        }
        if (littleBytes == null) {
            newLength = 0;
            cloneBytes = null;
        } else {
            cloneBytes = (byte[])littleBytes.clone();
            newLength = littleBytes.length;
        }
        if (newLength >= 65520) {
            pi.validateParameterDataType(-4);
            this.noLongParameters = false;
        } else {
            pi.setDisplaySize(newLength);
        }
        pi.setValue(cloneBytes);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            String ei = "FSPreparedStatement.apiSetBytes.txt";
            long delta = System.nanoTime() - entryTime;
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetBytes.txt", delta, logger);
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob value) throws SQLException {
        String method = "setClob(parameterIndex, clob)";
        this.closedCheck();
        this.genFeatureNotSupportedException("setClob(parameterIndex, clob)");
        throw this.nsEx;
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader reader) throws SQLException {
        String method = "setClob(parameterIndex, reader)";
        this.closedCheck();
        this.genFeatureNotSupportedException(method);
        throw this.nsEx;
    }

    @Override
    public synchronized void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String method = "setClob(parameterIndex, reader, length)";
        this.closedCheck();
        this.genFeatureNotSupportedException("setClob(parameterIndex, reader, length)");
        throw this.nsEx;
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date dateValue) throws SQLException {
        this.setDate(parameterIndex, dateValue, null);
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date dateValue, Calendar calendar) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(91);
        TimeRepresentation dateRep = null;
        if (calendar == null) {
            calendar = this.getCalendar();
        }
        if (dateValue != null) {
            dateRep = new TimeRepresentation(dateValue, calendar);
        }
        pi.setValue(dateRep);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetDate.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double value) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(8);
        pi.setValue(new Double(value));
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetDouble.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float value) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        if (pi.getSQLType() == 8) {
            this.setDouble(parameterIndex, value);
        } else {
            pi.validateParameterDataType(6);
            pi.setValue(new Float(value));
        }
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetFloat.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setInt(int parameterIndex, int value) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(4);
        Integer intValue = value == 0 ? Constants.INTEGER_ZERO : (value == 1 ? Constants.INTEGER_ONE : new Integer(value));
        pi.setValue(intValue);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetInt.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setLong(int parameterIndex, long value) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(-5);
        Long longValue = value == 0L ? Constants.LONG_ZERO : (value == 1L ? Constants.LONG_ONE : new Long(value));
        pi.setValue(longValue);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetLong.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(sqlType);
        pi.setValue(null);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetNull.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        String method = "setNull(parameterIndex, sqlType, typeName)";
        this.closedCheck();
        this.genFeatureNotSupportedException("setNull(parameterIndex, sqlType, typeName)");
        throw this.nsEx;
    }

    protected synchronized void setObjectCommon(ParameterInfo pi, int index, Object value, int targetSqlType, int objectSqlType) throws SQLException {
        Object coercedObj;
        if (objectSqlType == 0) {
            UtilityFunctions.throwInvalidObjectException(value);
            objectSqlType = 1;
        }
        if (targetSqlType == 2005) {
            targetSqlType = -1;
        } else if (targetSqlType == 2004) {
            // empty if block
        }
        if (targetSqlType == objectSqlType) {
            coercedObj = value;
        } else {
            boolean missingMode = this.isMissingMode();
            coercedObj = null;
            boolean targetIsNumber = DataTypeConversions.targetIsNumber(targetSqlType);
            if (targetIsNumber) {
                DataTypeConversions dtc = null;
                if (value instanceof Number) {
                    dtc = new DataTypeConversions(value, pi.getOrdinal(), pi.getName(), false);
                } else if (value instanceof String) {
                    String sv;
                    Double mv;
                    if (missingMode && targetSqlType == 8 && (mv = ParameterInfoHelper.checkIfMissingValue(sv = (String)value)) != null) {
                        pi.setValue(mv);
                        pi.setIsValueSet(true);
                        return;
                    }
                    dtc = new DataTypeConversions(value, pi.getOrdinal(), pi.getName(), false);
                }
                if (dtc != null) {
                    DataTruncation dt;
                    switch (targetSqlType) {
                        case -7: 
                        case -6: {
                            coercedObj = dtc.getByte(true);
                            break;
                        }
                        case 5: {
                            coercedObj = dtc.getShort(true);
                            break;
                        }
                        case 4: {
                            coercedObj = dtc.getInt(true);
                            break;
                        }
                        case -5: {
                            coercedObj = dtc.getLong(true);
                            break;
                        }
                        case 6: 
                        case 7: {
                            coercedObj = Float.valueOf(dtc.getFloat(true));
                            break;
                        }
                        case 8: {
                            coercedObj = dtc.getDouble(true);
                            break;
                        }
                        case 16: {
                            long tLong = dtc.getLong(true);
                            if (tLong == 0L) {
                                coercedObj = Boolean.FALSE;
                                break;
                            }
                            coercedObj = Boolean.TRUE;
                            break;
                        }
                    }
                    if (coercedObj != null && (dt = dtc.getDataTruncation()) != null) {
                        throw dt;
                    }
                }
            }
            if (coercedObj == null) {
                coercedObj = ParameterInfoHelper.coerceObject(value, targetSqlType, missingMode);
            }
        }
        if (coercedObj == null) {
            DataTypeConversions.badTargetSqlTypeException(value, targetSqlType);
        }
        switch (targetSqlType) {
            case 91: {
                this.setDate(index, (Date)coercedObj);
                break;
            }
            case 92: {
                this.setTime(index, (Time)coercedObj);
                break;
            }
            case 93: {
                this.setTimestamp(index, (Timestamp)coercedObj);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(index, (String)coercedObj);
                break;
            }
            default: {
                pi.setValue(coercedObj);
                pi.setIsValueSet(true);
            }
        }
    }

    protected boolean processBigDecimal(Object inObj, int objSqlType, int targetSqlType, ParameterInfo pi) throws SQLException {
        BigDecimal inBD;
        if (targetSqlType != 2 && targetSqlType != 3) {
            return false;
        }
        if (objSqlType == 2 && inObj instanceof BigDecimal) {
            inBD = (BigDecimal)inObj;
        } else {
            boolean missingMode = this.isMissingMode();
            inBD = (BigDecimal)ParameterInfoHelper.coerceObject(inObj, 2, missingMode);
        }
        if (inBD == null) {
            String ei = "TKTSPreparedStatement.invalidObjectConversionError.txt";
            this.throwException("TKTSPreparedStatement.invalidObjectConversionError.txt", logger);
        }
        SQLWarning sw = pi.checkBigDecimal(inBD, this.fsConnection.getBdTransportMode(), this.fsConnection.getBdRoundingMode(), this.fsConnection.getBdWriteTrunc());
        this.addSetWarnings(sw);
        pi.setValue(inBD);
        pi.setIsValueSet(true);
        pi.setIsBigDecimal(true);
        return true;
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        if (value == null) {
            int objSqlType = pi.getSQLType();
            this.setNull(parameterIndex, objSqlType);
            pi.setIsValueSet(true);
            return;
        }
        int objSqlType = UtilityFunctions.getObjectSQLType(value);
        if (this.processBigDecimal(value, objSqlType, objSqlType, pi)) {
            return;
        }
        pi.validateParameterDataType(objSqlType);
        this.setObjectCommon(pi, parameterIndex, value, objSqlType, objSqlType);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetObject.txt", System.nanoTime() - entryTime, logger);
        }
    }

    protected Object correctInputObject(Object value) {
        if (value instanceof Boolean) {
            value = Boolean.TRUE.equals(value) ? Constants.BYTE_ONE : Constants.BYTE_ZERO;
        }
        return value;
    }

    protected int correctTargetSqlType(int targetSqlType) {
        if (targetSqlType == 16) {
            targetSqlType = -6;
        }
        return targetSqlType;
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        if (value == null) {
            this.setNull(parameterIndex, targetSqlType);
            pi.setIsValueSet(true);
            return;
        }
        int objSqlType = UtilityFunctions.getObjectSQLType(value);
        if (this.processBigDecimal(value, objSqlType, targetSqlType, pi)) {
            return;
        }
        value = this.correctInputObject(value);
        targetSqlType = this.correctTargetSqlType(targetSqlType);
        pi.validateParameterDataType(targetSqlType);
        this.setObjectCommon(pi, parameterIndex, value, targetSqlType, objSqlType);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetObject.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, int targetSqlType, int scale) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        if (value == null) {
            this.setNull(parameterIndex, targetSqlType);
            pi.setIsValueSet(true);
            return;
        }
        if (targetSqlType == 3 || targetSqlType == 2) {
            BigDecimal inBD = (BigDecimal)ParameterInfoHelper.coerceObject(value, 2, this.isMissingMode());
            if (inBD == null) {
                DataTypeConversions.badTargetSqlTypeException(value, targetSqlType);
            }
            FSEnums.BdRoundingMode rMode = this.fsConnection.getBdRoundingMode();
            RoundingMode rm = rMode.getMathRoundingMode();
            inBD = inBD.setScale(scale, rm);
            this.processBigDecimal(inBD, 2, 2, pi);
        } else {
            this.setObject(parameterIndex, value, targetSqlType);
        }
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetObject.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setRef(int parameterIndex, Ref value) throws SQLException {
        String method = "setRef(parameterIndex, ref)";
        this.genFeatureNotSupportedException("setRef(parameterIndex, ref)");
        throw this.nsEx;
    }

    @Override
    public synchronized void setShort(int parameterIndex, short value) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(5);
        Short shortValue = value == 0 ? Constants.SHORT_ZERO : (value == 1 ? Constants.SHORT_ONE : new Short(value));
        pi.setValue(shortValue);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetShort.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setString(int parameterIndex, String inValue) throws SQLException, DataTruncation {
        int validatedSqlType;
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        int sqlType = pi.getSQLType();
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                validatedSqlType = sqlType;
                break;
            }
            default: {
                validatedSqlType = 12;
            }
        }
        pi.validateParameterDataType(validatedSqlType);
        pi.adjustDisplaySize(inValue);
        pi.setValue(inValue);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetString.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setTime(int index, Time timeValue) throws SQLException {
        this.closedCheck();
        this.setTime(index, timeValue, null);
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time timeValue, Calendar calendar) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(92);
        TimeRepresentation timeRep = null;
        if (calendar == null) {
            calendar = this.getCalendar();
        }
        if (timeValue != null) {
            timeRep = new TimeRepresentation(timeValue, calendar);
        }
        pi.setValue(timeRep);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetTime.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int index, Timestamp timeStampValue) throws SQLException {
        this.closedCheck();
        this.setTimestamp(index, timeStampValue, null);
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp timeStampValue, Calendar calendar) throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        ParameterInfo pi = this.validateParameterIndex(parameterIndex);
        pi.validateParameterDataType(93);
        TimeRepresentation timeStampRep = null;
        if (calendar == null) {
            calendar = this.getCalendar();
        }
        if (timeStampValue != null) {
            timeStampRep = new TimeRepresentation(timeStampValue, calendar);
        }
        pi.setValue(timeStampRep);
        pi.setIsValueSet(true);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiSetTimestamp.txt", System.nanoTime() - entryTime, logger);
        }
    }

    @Override
    public synchronized void setUnicodeStream(int parameterIndex, InputStream value, int length) throws SQLException {
        String method = "setUnicodeStream(parameterIndex, inputStream, length)";
        this.closedCheck();
        this.genFeatureNotSupportedException("setUnicodeStream(parameterIndex, inputStream, length)");
        throw this.nsEx;
    }

    @Override
    public synchronized void setURL(int parameterIndex, URL url) throws SQLException {
        String method = "setURL(parameterIndex, url)";
        this.closedCheck();
        this.genFeatureNotSupportedException("setURL(parameterIndex, url)");
        throw this.nsEx;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        this.closedCheck();
        for (ParameterInfo pi : this._PIA) {
            int bd = pi.getBindDirection();
            if (bd != 1) {
                String ei = "TKTSPreparedStatement.batchableProcedureError.txt";
                this.throwException("TKTSPreparedStatement.batchableProcedureError.txt", logger);
                continue;
            }
            pi.addValueToParameterSet();
        }
        ++this.currentBatchSize;
    }

    public synchronized void packParametersValues(boolean clearValue) throws SQLException {
        ParameterInfo pi;
        int i;
        this.closedCheck();
        this.clearPackedData();
        this.clearAllParamSetArrays();
        this.packedData.addColumnNumbers(this._PIA);
        int MAX_PARMS = this._PIA.length;
        for (i = 0; i < MAX_PARMS; ++i) {
            pi = this._PIA[i];
            pi.addValueToParameterSet();
        }
        for (i = 0; i < MAX_PARMS; ++i) {
            pi = this._PIA[i];
            pi.addValueToPackedData(0, this.packedData);
        }
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        String ei = DISABLE_METHOD;
        this.throwException(DISABLE_METHOD, logger, "addBatch()");
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        long entryTime = 0L;
        if (AbstractLogger.isMeasurements) {
            entryTime = System.nanoTime();
        }
        this.closedCheck();
        this.clearWarnings();
        this.globalRowCount = new Vector();
        this.updateCounter = -1;
        this.checkParametersNullity();
        if (this.isPooled && this.globalResultSet != null) {
            this.globalResultSet.closeCursor();
        } else {
            this.closeGlobalResultSet();
        }
        boolean successPSS = this.setParameterSetSize(1);
        if (!successPSS) {
            this.recoverParameterSetFailure();
        }
        this.packParametersValues(true);
        this.processStatementExecution(1, false);
        this.createWarnings(this.clearSetWarnings());
        this.updateCounter = this.globalRowCount.get(0);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiExecute.txt", System.nanoTime() - entryTime, logger);
        }
        if (!this.isUsedByRowSet) {
            this.globalResultSet = null;
            if (this.isQueryStatement) {
                this.globalResultSet = new FSResultSet(this.statementWrapper, this, this.numberOfColumnsInResultSet, this.isUsingBookmarks);
            }
        }
        return this.isQueryStatement;
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "execute()");
        return false;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "execute()");
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "execute()");
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "execute()");
        return false;
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        String method = "executeQuery";
        this.closedCheck();
        if (!this.isQueryStatement) {
            String ei = "TKTSStatement.notAQueryError.fmt";
            String em = thisClassName + "." + "executeQuery";
            this.throwException("TKTSStatement.notAQueryError.fmt", logger, em);
        }
        this.execute();
        return this.globalResultSet;
    }

    @Override
    public synchronized ResultSet executeQuery(String query) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "executeQuery()");
        return null;
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        String method = "executeUpdate";
        this.closedCheck();
        if (this.isQueryStatement) {
            String ei = "TKTSStatement.notAnUpdateError.fmt";
            String em = thisClassName + "." + "executeUpdate";
            this.throwException("TKTSStatement.notAnUpdateError.fmt", logger, em);
        }
        this.execute();
        if (this.updateCounter == -1) {
            this.updateCounter = this.getUpdateCount();
        }
        return this.updateCounter;
    }

    @Override
    public synchronized int executeUpdate(String sqlStmt) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "executeUpdate(sqlStmt)");
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "executeUpdate(sql, autoGenKey)");
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "executeUpdate(sql, colIndexes)");
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.throwException(DISABLE_METHOD, logger, "executeUpdate(sql, colNames)");
        return 0;
    }

    public void handleBatchException(Exception e) throws SQLException, BatchUpdateException {
        if (AbstractLogger.isTrace) {
            logger.trace("Exception during executeBatch  " + e.getMessage());
        }
        VendorSpecificErrorCode vendorCode = LocalizedErrorHandler.getVendorSpecificErrorCode(this.statementWrapper);
        int[] outRowCount = this.isParameterArraySupported ? (this.currentBatchSize == this.previousBatchSize ? UtilityFunctions.extractIntArrayFromIntegerVector(this.globalRowCount) : new int[]{}) : UtilityFunctions.extractIntArrayFromIntegerVector(this.globalRowCount);
        if (vendorCode != null) {
            String[] messageTexts = vendorCode.getMessageText();
            String[] sqlStates = vendorCode.getSqlState();
            int[] errorCodes = vendorCode.getErrorCode();
            if (messageTexts != null && sqlStates != null && outRowCount != null) {
                throw new BatchUpdateException(messageTexts[0], sqlStates[0], errorCodes[0], outRowCount);
            }
        }
        String ei = "TKTSStatement.batchUpdateError.fmt";
        String lem = this.getLocalizedError("TKTSStatement.batchUpdateError.fmt", e.toString());
        throw new BatchUpdateException(lem, outRowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        long entryTime;
        block10: {
            String ei;
            entryTime = 0L;
            String method = "executeBatch";
            if (AbstractLogger.isInfo) {
                ei = "FSPreparedStatement.executeBatch.fmt";
                LocalizedMessageHandler.logInfoMessage("executeBatch", "FSPreparedStatement.executeBatch.fmt", logger);
            }
            if (AbstractLogger.isMeasurements) {
                entryTime = System.nanoTime();
            }
            this.closedCheck();
            this.clearWarnings();
            this.globalRowCount = new Vector();
            this.lastBatchIndex = 0;
            try {
                if (this.isQueryStatement) {
                    ei = "TKTSStatement.notAnUpdateError.fmt";
                    this.throwException("TKTSStatement.notAnUpdateError.fmt", logger, this.lastSqlStatement);
                }
                if (this.currentBatchSize <= 0) break block10;
                this.processBatchExecution(this.currentBatchSize);
            }
            catch (Exception e) {
                this.handleBatchException(e);
            }
            finally {
                this.currentBatchSize = 0;
                for (int i = 0; i < this._PIA.length; ++i) {
                    this._PIA[i].clearParamSetArray();
                }
            }
        }
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiExecuteBatch.txt", System.nanoTime() - entryTime, logger);
        }
        return UtilityFunctions.extractIntArrayFromIntegerVector(this.globalRowCount);
    }

    private void clearVectorElements() {
        this.globalRowCount.clear();
    }

    public void setRowSetUsage(boolean booleanValue) {
        this.isUsedByRowSet = booleanValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bindParameters() throws SQLException {
        String method = "bindParameters";
        int needBindCounter = 0;
        int bindx = 0;
        for (int x = 0; x < this._PIA.length; ++x) {
            if (!this._PIA[x].isBindRequired()) continue;
            ++needBindCounter;
        }
        if (needBindCounter > 0) {
            long entryTime = System.nanoTime();
            int[] parameterNumbers = new int[needBindCounter];
            int[] paramCDataTypes = new int[needBindCounter];
            int[] paramSQLDataTypes = new int[needBindCounter];
            int[] parameterSizes = new int[needBindCounter];
            int[] decimalDigits = new int[needBindCounter];
            int[] bindDirections = new int[needBindCounter];
            int[] encodings = new int[needBindCounter];
            int[] buffersLength = new int[needBindCounter];
            IntHolder bindMgrStatus = new IntHolder();
            for (int pindx = 0; pindx < this._PIA.length; ++pindx) {
                ParameterInfo pi = this._PIA[pindx];
                if (!pi.isBindRequired()) continue;
                parameterNumbers[bindx] = pindx + 1;
                paramSQLDataTypes[bindx] = pi.getSQLType();
                int displaySize = (int)pi.getDisplaySize();
                parameterSizes[bindx] = displaySize == -2 && paramSQLDataTypes[bindx] != -4 && paramSQLDataTypes[bindx] != -1 ? pi.getBufferLength() : (displaySize < 0 ? 0 : displaySize);
                paramCDataTypes[bindx] = pi.getCType();
                decimalDigits[bindx] = pi.getDecimalDigits();
                bindDirections[bindx] = pi.getBindDirection();
                buffersLength[bindx] = 0;
                encodings[bindx] = CharSetUtil.getToServerEncoding();
                this._PIA[bindx].setBindRequired(false);
                if (AbstractLogger.isTrace) {
                    int t_sqlType = paramSQLDataTypes[bindx];
                    int t_cType = paramCDataTypes[bindx];
                    int t_bd = bindDirections[bindx];
                    logger.trace("BindingParameters[" + bindx + "] Number=" + parameterNumbers[bindx] + " SQLType=" + CommonLogger.getSQLTypeString(t_sqlType) + ":" + t_sqlType + " CType=" + CommonLogger.getCTypeString(t_cType) + ":" + t_cType + " Size=" + parameterSizes[bindx] + " decimalDigits=" + decimalDigits[bindx] + " bindDirections=" + CommonLogger.bindDirection(t_bd) + ":" + t_bd);
                }
                ++bindx;
            }
            try {
                this.statementWrapper.BindParameters2(parameterNumbers, paramCDataTypes, paramSQLDataTypes, parameterSizes, decimalDigits, bindDirections, encodings, buffersLength, bindMgrStatus);
                if (bindMgrStatus.value != -2130708479) return;
                this.createWarnings();
                return;
            }
            catch (Exception exception) {
                LocalizedErrorHandler.handleExceptionsInFunction("bindParameters", exception, this.statementWrapper, logger);
                return;
            }
            finally {
                if (AbstractLogger.isMeasurements) {
                    LocalizedMessageHandler.logStatisticMessage("FSPreparedStatement.apiBindParameters.txt", System.nanoTime() - entryTime, logger);
                }
            }
        } else {
            if (!AbstractLogger.isTrace) return;
            logger.trace("No Parameters to bind!!!");
        }
    }

    protected OctetSeqHolder invokeExecute2(boolean isRealBatchOperation, int inRowCount) throws SQLException {
        String method = "invokeExecute2";
        if (AbstractLogger.isTrace) {
            logger.entry("invokeExecute2");
        }
        int updateCount = 0;
        byte[] packedBuffer = null;
        byte[] paramOperations = null;
        IntHolder paramsProcessed = new IntHolder();
        IntHolder status = new IntHolder();
        OctetSeqHolder paramStatus = new OctetSeqHolder();
        OctetSeqHolder outParams = new OctetSeqHolder();
        LongHolder rowCountHolder = new LongHolder();
        long startTime = System.nanoTime();
        paramOperations = new byte[inRowCount];
        packedBuffer = this.packedData.buildPackedBuffer();
        if (this.fsConnection.getCompression()) {
            boolean BEST_SPEED = this.fsConnection.getCompressionSpeed();
            packedBuffer = this.packedData.buildCompressedBuffer(packedBuffer, BEST_SPEED);
        }
        long delta = System.nanoTime() - startTime;
        StatementWrapper.apiPackData(delta, inRowCount, packedBuffer.length);
        try {
            this.wasExecuted = true;
            if (true) {
                IntHolder ih = new IntHolder();
                this.statementWrapper.Cancel(ih);
                this.statementWrapper.FreeStmt(0, this.statusIntHolder);
            }
            this.wasExecuted = true;
            this.statementWrapper.Execute2(packedBuffer, paramOperations, paramsProcessed, outParams, paramStatus, rowCountHolder, status);
        }
        catch (Exception exception) {
            this.wasExecuted = false;
            this.clearAllParamSetArrays();
            this.clearPackedData();
            LocalizedErrorHandler.handleExceptionsInFunction("invokeExecute2", exception, this.statementWrapper, logger);
        }
        if (status.value == -2130708479) {
            this.createWarnings();
        } else if (status.value == -2130708475) {
            this.executePutDataWithPutQuery(isRealBatchOperation);
        }
        updateCount = rowCountHolder.value >= 0L ? (int)rowCountHolder.value : this.getUpdateCount();
        if (isRealBatchOperation) {
            this.updateGlobalRowCount(updateCount, inRowCount, paramStatus);
        } else {
            this.globalRowCount.add(new Integer(updateCount));
        }
        paramStatus = null;
        if (AbstractLogger.isTrace) {
            logger.trace("Number of rows updated=[" + updateCount + "] Packed Buffer size=[" + packedBuffer.length + "]");
        }
        return outParams;
    }

    protected Any[] populateIOMInputParameterArray(int[][] lenOrInd, int numberOfInputParameters) throws SQLException {
        String method = "populateIOMInputParameterArray";
        if (AbstractLogger.isTrace) {
            logger.entry("populateIOMInputParameterArray");
        }
        this.isDataAtExecution = false;
        Any[] executionParameterArray = new Any[numberOfInputParameters];
        for (int pindx = 0; pindx < numberOfInputParameters; ++pindx) {
            executionParameterArray[pindx] = this.orbHandle.create_any();
            boolean result = ParameterInfoHelper.populateIOMParameterArrayBasedOnDataType(executionParameterArray[pindx], this._PIA[pindx], pindx, lenOrInd, this.orbHandle, false);
            this.isDataAtExecution = this.isDataAtExecution || result;
        }
        return executionParameterArray;
    }

    protected void executePutDataWithPutQuery(boolean isBatchOperation) throws SQLException {
        String method = "executePutDataWithPutQuery";
        Object currentParameterData = null;
        boolean isPutData = true;
        IntHolder rowNumber = new IntHolder();
        IntHolder ordinal = new IntHolder();
        IntHolder bindType = new IntHolder();
        IntHolder status = new IntHolder();
        int rowIndex = 0;
        int colIndex = -1;
        while (isPutData) {
            try {
                this.statementWrapper.PutQuery(rowNumber, ordinal, bindType, status);
                if (AbstractLogger.isTrace) {
                    logger.trace("RowNumber=[" + rowNumber.value + "] Ordinal=[" + ordinal.value + "] Status=[" + status.value + "]");
                }
                if (status.value == -2130708479) {
                    this.createWarnings();
                }
            }
            catch (Exception exception) {
                LocalizedErrorHandler.handleExceptionsInFunction("executePutDataWithPutQuery", exception, this.statementWrapper, logger);
            }
            if (ordinal.value <= colIndex) {
                ++rowIndex;
            }
            colIndex = ordinal.value;
            if (status.value == -2130708475 && ordinal.value > 0) {
                ParameterInfo pi = this._PIA[ordinal.value - 1];
                currentParameterData = pi.getValue(rowIndex - 1);
                this.invokePutData(currentParameterData);
                continue;
            }
            isPutData = false;
        }
    }

    protected ParameterInfo validateParameterIndex(int index) throws SQLException {
        ParameterInfo pi = null;
        if (index < 1 || index > this._PIA.length) {
            String ei = "Generic.InvalidIndex.fmt";
            String intStr = Integer.toString(index);
            this.throwException("Generic.InvalidIndex.fmt", logger, intStr);
        } else {
            pi = this._PIA[index - 1];
        }
        return pi;
    }

    protected int validateParameterName(String parameterName) throws SQLException {
        if (parameterName == null) {
            String ei = "TKTSPreparedStatement.parameterNameNull.txt";
            this.throwException("TKTSPreparedStatement.parameterNameNull.txt", logger);
        }
        int maxParameters = this._PIA.length;
        boolean supportsNamedParameters = false;
        for (int i = 0; i < maxParameters; ++i) {
            ParameterInfo pi = this._PIA[i];
            String piName = pi.getName();
            if (piName == null || piName.length() <= 0) continue;
            supportsNamedParameters = true;
            if (!piName.equalsIgnoreCase(parameterName)) continue;
            return i + 1;
        }
        if (supportsNamedParameters) {
            String ei = "TKTSResultSet.parameterNameUnsupported.txt";
            this.throwException("TKTSResultSet.parameterNameUnsupported.txt", logger, parameterName);
        } else {
            String ei = "TKTSResultSet.parameterNameUnsupported.txt";
            this.throwException("TKTSResultSet.parameterNameUnsupported.txt", logger);
        }
        return -1;
    }

    private ParameterInfo[] describeParameters(int bindDirection) throws SQLException {
        String method = "describeParameters(" + bindDirection + ")";
        StringSeqHolder columnNames = new StringSeqHolder();
        LongSeqHolder sqlDataTypes = new LongSeqHolder();
        LongLongSeqHolder paramSizes = new LongLongSeqHolder();
        LongSeqHolder decimalDigits = new LongSeqHolder();
        LongSeqHolder nullableIndicators = new LongSeqHolder();
        LongSeqHolder status = new LongSeqHolder();
        try {
            this.statementWrapper.DescribeParams(new int[0], sqlDataTypes, paramSizes, decimalDigits, nullableIndicators, status);
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction(method, exception, this.statementWrapper, logger);
        }
        return this.createParameterInfoBasedOnDescribedData(bindDirection, columnNames, sqlDataTypes, paramSizes, decimalDigits, nullableIndicators);
    }

    private ParameterInfo[] createParameterInfoBasedOnDescribedData(int bindDirection, StringSeqHolder columnNames, LongSeqHolder sqlDataTypes, LongLongSeqHolder paramSizes, LongSeqHolder decimalDigits, LongSeqHolder nullableIndicators) throws SQLException {
        int parameterCount = sqlDataTypes.value.length;
        ParameterInfo[] parameterInfoArray = new ParameterInfo[parameterCount];
        int encoding = CharSetUtil.getToServerEncoding();
        for (int i = 0; i < parameterCount; ++i) {
            ParameterInfo pi;
            parameterInfoArray[i] = pi = new ParameterInfo();
            pi.setNativeEncoding(encoding);
            pi.setOrdinal(i + 1);
            pi.setBindDirection(bindDirection);
            pi.setDecimalDigits(decimalDigits.value[i]);
            if (this.fsConnection.getRealDescribeParameter()) {
                pi.setIsRealDescribeParm(true);
                pi.setDisplaySize(paramSizes.value[i]);
            } else {
                pi.setDisplaySize(64L);
            }
            pi.setDataStreamLength(0);
            pi.setNullableIndicator(nullableIndicators.value[i]);
            if (bindDirection == 0) {
                pi.setBindRequired(false);
            } else {
                pi.setBindRequired(true);
            }
            if (columnNames.value != null && columnNames.value.length > 0) {
                pi.setName(columnNames.value[i]);
            } else {
                pi.setName("");
            }
            int tSqlType = sqlDataTypes.value[i];
            UtilityFunctions.mapSQLType2CType(pi, tSqlType);
            pi.defaultNativeCType();
        }
        return parameterInfoArray;
    }

    private int prepareWithNumberOfResultColumns(String sqlStmt) throws SQLException {
        String method = "prepareWithNumberOfResultColumns";
        int numberOfColumns = 0;
        IntHolder status = new IntHolder();
        try {
            this.statementWrapper.Prepare(sqlStmt, status);
            if (status.value == -2130708479) {
                this.createWarnings();
            }
            if ((numberOfColumns = this.statementWrapper.NumResultCols(status)) > 0) {
                this.isQueryStatement = true;
            }
        }
        catch (Exception exception) {
            SQLException outSE = FSPreparedStatement.createFunctionException("prepareWithNumberOfResultColumns", exception, this.statementWrapper, logger);
            this.tearDownStatement();
            this.fsConnection.deleteStatement(this);
            throw outSE;
        }
        if (AbstractLogger.isInfo) {
            String ei = "FSPreparedStatement.prepareStmt.fmt";
            this.logInfoMessage("prepareWithNumberOfResultColumns", "FSPreparedStatement.prepareStmt.fmt", logger, sqlStmt);
        }
        return numberOfColumns;
    }

    private void addBatchValues(int rows) {
        this.clearPackedData();
        this.resizePackedData(rows);
        this.packedData.addColumnNumbers(this._PIA);
        int arrayMax = this._PIA.length;
        for (int ri = 0; ri < rows; ++ri) {
            for (int ci = 0; ci < arrayMax; ++ci) {
                ParameterInfo pi = this._PIA[ci];
                pi.addValueToPackedData(ri, this.packedData);
            }
        }
    }

    private void processBatchExecution(int rowCount) throws SQLException {
        boolean successPSS;
        String method = "processBatchExecution";
        if (AbstractLogger.isTrace) {
            logger.entry("processBatchExecution");
        }
        if (!(successPSS = this.setParameterSetSize(rowCount))) {
            this.recoverParameterSetFailure();
        }
        if (this.isParameterArraySupported && this.noLongParameters) {
            int batchSize = this.previousBatchSize;
            int trips = rowCount / batchSize;
            if (rowCount % batchSize > 0) {
                ++trips;
            }
            int rowsLeft = rowCount;
            for (int si = 1; si <= trips; ++si) {
                int rowsToDelete;
                if (si == trips) {
                    successPSS = this.setParameterSetSize(rowsLeft);
                    if (successPSS) {
                        this.addBatchValues(rowsLeft);
                        this.processStatementExecution(rowsLeft, true);
                    } else {
                        this.recoverParameterSetFailure();
                        this.executeFakeBatch();
                    }
                    rowsToDelete = rowsLeft;
                } else {
                    this.addBatchValues(batchSize);
                    this.processStatementExecution(batchSize, true);
                    rowsToDelete = batchSize;
                    rowsLeft -= batchSize;
                }
                for (int i = 0; i < this._PIA.length; ++i) {
                    this._PIA[i].removeRows(rowsToDelete);
                }
            }
        } else {
            this.executeFakeBatch();
        }
    }

    protected void processStatementExecution(int rowCount, boolean isRealBatchOperation) throws SQLException {
        String method = "processStatementExecution";
        if (AbstractLogger.isTrace) {
            logger.entry("processStatementExecution");
        }
        this.bindParameters();
        this.invokeExecute2(isRealBatchOperation, rowCount);
    }

    private void executeFakeBatch() throws SQLException {
        String method = "executeFakeBatch";
        if (AbstractLogger.isTrace) {
            logger.entry("executeFakeBatch");
        }
        this.bindParameters();
        this.setParameterSetSize(1);
        int maxParms = this._PIA.length;
        for (int bi = 0; bi < this.currentBatchSize; ++bi) {
            this.clearPackedData();
            this.packedData.addColumnNumbers(this._PIA);
            for (int i = 0; i < maxParms; ++i) {
                ParameterInfo pi = this._PIA[i];
                pi.addValueToPackedData(bi, this.packedData);
            }
            OctetSeqHolder executeOut = this.invokeExecute2(false, 1);
        }
        this.currentBatchSize = 0;
        this.clearAllParamSetArrays();
        this.clearPackedData();
    }

    private void invokePutData(Object currentParameterData) throws SQLException {
        String method = "invokePutData";
        if (AbstractLogger.isTrace) {
            logger.entry("invokePutData");
        }
        IntHolder status = new IntHolder();
        Any parameterData = this.orbHandle.create_any();
        int lenOrInd = -1;
        if (currentParameterData != null) {
            byte[] sequence = null;
            if (currentParameterData instanceof String) {
                sequence = ((String)currentParameterData).getBytes();
                OctetSeqHelper.insert((Any)parameterData, (byte[])sequence);
                lenOrInd = sequence.length;
            } else if (currentParameterData instanceof BlobFedSrv) {
                BlobFedSrv tBlob = (BlobFedSrv)currentParameterData;
                int blobBytes = (int)tBlob.length();
                sequence = tBlob.getBytes(1L, blobBytes);
                OctetSeqHelper.insert((Any)parameterData, (byte[])sequence);
                lenOrInd = sequence.length;
            } else {
                sequence = (byte[])currentParameterData;
                OctetSeqHelper.insert((Any)parameterData, (byte[])sequence);
                lenOrInd = sequence.length;
            }
        }
        try {
            this.statementWrapper.PutData(parameterData, lenOrInd, status);
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("invokePutData", exception, this.statementWrapper, logger);
        }
    }

    private void checkParametersNullity() throws SQLException {
        for (int x = 0; x < this._PIA.length; ++x) {
            if (this._PIA[x].getValue() != null || this._PIA[x].getNullableIndicator() != 0) continue;
            String ei = "TKTSPreparedStatement.unsetParmError.txt";
            this.throwException("TKTSPreparedStatement.unsetParmError.txt", logger);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        String method = "setNCharacterStream(parameterIndex, reader)";
        this.genFeatureNotSupportedException("setNCharacterStream(parameterIndex, reader)");
        throw this.nsEx;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        String method = "setNCharacterStream(parameterIndex, reader, length)";
        this.genFeatureNotSupportedException("setNCharacterStream(parameterIndex, reader, length)");
        throw this.nsEx;
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException, SQLFeatureNotSupportedException {
        String method = "setNClob(parameterIndex, nclob)";
        this.genFeatureNotSupportedException("setNClob(parameterIndex, nclob)");
        throw this.nsEx;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        String method = "setNClob(parameterIndex, reader)";
        this.genFeatureNotSupportedException("setNClob(parameterIndex, reader)");
        throw this.nsEx;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        String method = "setNClob(parameterIndex, reader, length)";
        this.genFeatureNotSupportedException("setNClob(parameterIndex, reader, length)");
        throw this.nsEx;
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        String method = " setNString(parameterIndex, value)";
        this.genFeatureNotSupportedException(" setNString(parameterIndex, value)");
        throw this.nsEx;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String method = "setSQLXML(parameterIndex, value)";
        this.genFeatureNotSupportedException("setSQLXML(parameterIndex, value)");
        throw this.nsEx;
    }

    @Override
    public void setRowId(int parameterIndex, RowId rowid) throws SQLException, SQLFeatureNotSupportedException {
        String method = "setRowId(parameterIndex, rowid)";
        this.genFeatureNotSupportedException("setRowId(parameterIndex, rowid)");
        throw this.nsEx;
    }

    public synchronized int getParams() {
        int outParams = 0;
        if (this._PIA != null) {
            return this._PIA.length;
        }
        return outParams;
    }

    public synchronized int getOutParams() {
        int outParams = 0;
        if (this._PIA != null) {
            for (int x = 0; x < this._PIA.length; ++x) {
                int bindDirection = this._PIA[x].getBindDirection();
                if (bindDirection != 2 && bindDirection != 4) continue;
                ++outParams;
            }
        }
        return outParams;
    }

    protected void recoverParameterSetFailure() throws SQLException {
        try {
            this.statementWrapper.FreeStmt(101, this.statusIntHolder);
            AbstractIOMWrapper.setIntegerAttribute(this.statementWrapper, 22, 1, false);
            this.prepareWithNumberOfResultColumns(this.lastSqlStatement);
            this.fsConnection.setParameterSetBehavior(false);
            this.fsConnection.setParameterSetSizeSupported(false);
            this.isParameterArraySupported = false;
        }
        catch (Exception e) {
            if (AbstractLogger.isTrace) {
                logger.trace("recoverParameterSetFailure: ");
                logger.trace(e);
            }
            String ei = "TKTSPreparedStatement.paramArraySizeError.txt";
            this.throwException("TKTSPreparedStatement.paramArraySizeError.txt", logger);
        }
    }

    protected void updateGlobalRowCount(int updateCount, int rowCount, OctetSeqHolder paramStatus) throws SQLException {
        int pm;
        ByteExtractor byteExtractor = null;
        int errorIndex = -1;
        boolean hasInsertInto = UtilityFunctions.hasInsertInto(this.lastSqlStatement);
        int newValue = hasInsertInto ? 1 : -2;
        if (paramStatus != null && (pm = paramStatus.value.length) > 0) {
            byteExtractor = new ByteExtractor(paramStatus.value);
            for (int pi = 0; pi < pm; ++pi) {
                byte outStatus = byteExtractor.getByte();
                if (outStatus == 5 && errorIndex == -1) {
                    errorIndex = pi;
                    break;
                }
                if (this.validParameterStatusInformation(outStatus)) {
                    this.globalRowCount.add(new Integer(newValue));
                    continue;
                }
                this.globalRowCount.add(new Integer(-2));
            }
        }
        if (errorIndex >= 0) {
            SQLException se = new SQLException();
            throw se;
        }
    }

    protected boolean validParameterStatusInformation(int inValue) {
        boolean out = false;
        if (inValue == 0 || inValue == 6 || inValue == 5 || inValue == 7) {
            out = true;
        }
        return out;
    }
}

