/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSCallableStatement;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.util.SafeStore;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class FSPooledConnection
implements PooledConnection {
    private static String thisClassName = FSCallableStatement.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private static boolean DRIVER_LOADED;
    private transient List<ConnectionEventListener> _CONNECTION_EVENT_LISTENERS;
    private transient String dataSourceName;
    private transient SafeStore pooledURL;
    private transient Properties pooledProperties;
    private transient FSConnection tktsConnection;

    public static void loadDriver() {
        block3: {
            if (!DRIVER_LOADED) {
                try {
                    Class.forName("jdbc:sastkts://");
                    DRIVER_LOADED = true;
                }
                catch (ClassNotFoundException e) {
                    if (logger == null) break block3;
                    logger.error("Exception loading Driver");
                    logger.error(e);
                }
            }
        }
    }

    protected FSPooledConnection() {
    }

    protected FSPooledConnection(String dsName, SafeStore safeURL, Properties properties) {
        this.dataSourceName = dsName;
        this.pooledURL = safeURL;
        this.pooledProperties = properties;
        this._CONNECTION_EVENT_LISTENERS = new ArrayList<ConnectionEventListener>();
        FSPooledConnection.loadDriver();
    }

    @Override
    public Connection getConnection() throws SQLException {
        String method = "getConnection";
        if (AbstractLogger.isTrace && logger != null) {
            logger.entry(method);
        }
        if (this.tktsConnection == null) {
            this.tktsConnection = (FSConnection)DriverManager.getConnection(this.pooledURL.getValue(), this.pooledProperties);
            this.tktsConnection.setParentPooledConnection(this);
        }
        if (AbstractLogger.isTrace && logger != null) {
            logger.exit(method);
        }
        return this.tktsConnection;
    }

    @Override
    public synchronized void close() throws SQLException {
        String method = "close";
        if (AbstractLogger.isTrace && logger != null) {
            logger.entry(method);
        }
        if (this.tktsConnection != null) {
            this.tktsConnection.hardClose();
        }
        if (AbstractLogger.isTrace && logger != null) {
            logger.exit(method);
        }
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        String method = "addConnectionEventListener";
        if (AbstractLogger.isTrace && logger != null) {
            logger.entry(method);
        }
        this._CONNECTION_EVENT_LISTENERS.add(listener);
        if (AbstractLogger.isTrace && logger != null) {
            logger.exit(method);
        }
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        String method = "removeConnectionEventListener";
        if (AbstractLogger.isTrace && logger != null) {
            logger.entry(method);
        }
        this._CONNECTION_EVENT_LISTENERS.remove(listener);
        if (AbstractLogger.isTrace && logger != null) {
            logger.exit(method);
        }
    }

    public synchronized void notifyConnectionEventListeners() {
        String method = "notifyConnectionEventListeners";
        if (AbstractLogger.isTrace && logger != null) {
            logger.entry(method);
        }
        ConnectionEvent event = new ConnectionEvent(this);
        for (ConnectionEventListener listener : this._CONNECTION_EVENT_LISTENERS) {
            listener.connectionClosed(event);
        }
        if (AbstractLogger.isTrace && logger != null) {
            logger.exit(method);
        }
    }

    public synchronized void notifyConnectionEventListenersErrorOccurred(SQLException sqlException) {
        String method = "notifyConnectionEventListenersErrorOccurred";
        if (AbstractLogger.isTrace && logger != null) {
            logger.entry(method);
        }
        ConnectionEvent event = new ConnectionEvent(this, sqlException);
        for (ConnectionEventListener listener : this._CONNECTION_EVENT_LISTENERS) {
            listener.connectionErrorOccurred(event);
        }
        if (AbstractLogger.isTrace && logger != null) {
            logger.exit(method);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }

    public String toString() {
        String fmt0 = "name:%s %s";
        String connDesc = "no Connection";
        if (this.tktsConnection != null) {
            connDesc = this.tktsConnection.toString();
        }
        String out = String.format("name:%s %s", this.dataSourceName, connDesc);
        return out;
    }
}

