/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.info.ServerDataTypeInfo;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.util.TypesHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

public class FSParameterMetaData
implements ParameterMetaData {
    private static String thisClassName = FSParameterMetaData.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient Hashtable<Integer, ServerDataTypeInfo> srvDataTypeInfo;
    private transient ParameterInfo[] paraInfoArray;
    private transient int parameterCounter;

    protected FSParameterMetaData(ParameterInfo[] inParmeterInfoArray, Hashtable<Integer, ServerDataTypeInfo> inSrvDataTypeInfo) throws SQLException {
        this.paraInfoArray = inParmeterInfoArray;
        this.parameterCounter = inParmeterInfoArray.length;
        this.srvDataTypeInfo = inSrvDataTypeInfo;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        this.validateParameterIndex(param);
        return UtilityFunctions.getJavaTypeClassName(this.paraInfoArray[param - 1].getSQLType());
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCounter;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.validateParameterIndex(param);
        int result = 0;
        switch (this.paraInfoArray[param - 1].getBindDirection()) {
            case 0: {
                result = 0;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            case 2: {
                result = 2;
                break;
            }
            case 4: {
                result = 4;
                break;
            }
        }
        return result;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        this.validateParameterIndex(param);
        return this.paraInfoArray[param - 1].getSQLType();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        this.validateParameterIndex(param);
        return this.paraInfoArray[param - 1].getDecimalDigits();
    }

    @Override
    public int getScale(int param) throws SQLException {
        this.validateParameterIndex(param);
        return this.paraInfoArray[param - 1].getDecimalDigits();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        this.validateParameterIndex(param);
        int result = 0;
        switch (this.paraInfoArray[param - 1].getNullableIndicator()) {
            case 0: {
                result = 0;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            case 2: {
                result = 2;
                break;
            }
            default: {
                result = 2;
            }
        }
        return result;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        boolean isSigned = false;
        this.validateParameterIndex(param);
        ServerDataTypeInfo typeInfo = this.srvDataTypeInfo.get(new Integer(this.paraInfoArray[param - 1].getSQLType()));
        if (typeInfo != null) {
            isSigned = !typeInfo.isUnsigned();
        }
        return isSigned;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        String result = "";
        this.validateParameterIndex(param);
        ServerDataTypeInfo typeInfo = this.srvDataTypeInfo.get(new Integer(this.paraInfoArray[param - 1].getSQLType()));
        if (typeInfo != null) {
            result = typeInfo.getDataTypeName();
        }
        return result;
    }

    private void validateParameterIndex(int index) throws SQLException {
        if (index < 1 || index > this.parameterCounter) {
            LocalizedErrorHandler.throwLocalizedException("TKTSPreparedStatement.badParmIndex.fmt", new Object[]{index, this.parameterCounter}, logger);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String toString() {
        String outString;
        block5: {
            String colStrings = "\n Mode, TypeName:Type, Precision:Scale, Nullable, Signed, ClassName \n";
            outString = null;
            try {
                for (int i = 1; i <= this.parameterCounter; ++i) {
                    String pcn = this.getParameterClassName(i);
                    int mode = this.getParameterMode(i);
                    String modeStr = TypesHelper.getParameterMode(mode);
                    int type = this.getParameterType(i);
                    String typeName = this.getParameterTypeName(i);
                    int precision = this.getPrecision(i);
                    int scale = this.getScale(i);
                    int isNullable = this.isNullable(i);
                    String nullableStr = TypesHelper.getParameterNullable(isNullable);
                    boolean isSigned = this.isSigned(i);
                    String signedStr = TypesHelper.getSignText(isSigned);
                    outString = new String("\n Mode, TypeName:Type, Precision:Scale, Nullable, Signed, ClassName \n\n[" + i + "]" + modeStr + typeName + ":" + type + " " + precision + ":" + scale + nullableStr + signedStr + pcn);
                }
            }
            catch (SQLException sqlEx) {
                if (AbstractLogger.isError) {
                    logger.error("FSParameterMetaData.toString: ");
                    logger.error(sqlEx);
                }
            }
            catch (Exception ex) {
                if (!AbstractLogger.isError) break block5;
                logger.error("FSParameterMetaData.toString: ");
                logger.error(ex);
            }
        }
        return outString;
    }
}

