/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.sql;

import com.sas.SASTableServer.DriverCompletionOptions;
import com.sas.SASTableServer.IEnvironment;
import com.sas.SASTableServer.IServer;
import com.sas.SASTableServer.IServerHelper;
import com.sas.SASTableServer.ISession;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.net.crypto.SealedString;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.Server;
import com.sas.tkts.FSEnums;
import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.TrackResource;
import com.sas.tkts.info.ServerDataTypeInfo;
import com.sas.tkts.iom.AbstractIOMWrapper;
import com.sas.tkts.iom.ConnectionWrapper;
import com.sas.tkts.iom.ServerInformation;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.Constants;
import com.sas.tkts.sql.FSCallableStatement;
import com.sas.tkts.sql.FSDatabaseMetaData;
import com.sas.tkts.sql.FSPooledConnection;
import com.sas.tkts.sql.FSPreparedStatement;
import com.sas.tkts.sql.FSResultSet;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.sql.StatementPoolManager;
import com.sas.tkts.sql.StatementPoolManagerFactory;
import com.sas.tkts.types.BlobFedSrv;
import com.sas.tkts.util.CharSetUtil;
import com.sas.tkts.util.SafeStore;
import com.sas.tkts.util.TypesHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

public class FSConnection
extends FedSrvJDBC
implements Connection {
    private static final String INVALID_PROP = "TKTSDriver.invalidPropertyValueError.fmt";
    private static final String GEN_NOT_CONNECTED = "Generic.NotConnected.txt";
    private static final String DEFAULT_SQL_STATE = "HY000";
    private static final int CONN_BITS_IS_CLOSED = 1;
    private static final int CONN_BITS_IS_AUTO_COMMIT = 2;
    private static final int CONN_BITS_GENERATE_EXCEPTION = 3;
    private static final int CONN_BITS_REAL_DESCRIBE_PARAMETER = 4;
    private static final int CONN_BITS_PARAMETER_SET_BEHAVIOR = 5;
    private static final int CONN_BITS_PARAMETER_SET_SIZE = 6;
    private static final int CONN_BITS_SUPPORTS_XXX2 = 7;
    private static final int CONN_BITS_CATALOG_ALL = 8;
    private static final int CONN_BITS_CATALOG_PVA = 9;
    private static final int CONN_BITS_CATALOG_CASE = 10;
    private static final int CONN_BITS_SCHEMA_CASE = 11;
    private static final int CONN_BITS_COMPRESS = 12;
    private static final int CONN_BITS_COMPRESS_SPEED = 13;
    private static final int CONN_BITS_OTP = 14;
    private static final int CONN_BITS_PREFETCH = 15;
    private static final int CONN_BITS_LAST = 15;
    private static String thisClassName;
    private static AbstractLogger logger;
    protected static boolean trackConnections;
    protected static TrackResource myResources;
    protected transient ConnectionWrapper connectionWrapper;
    protected transient StatementPoolManager statementPoolManager;
    protected transient SQLWarning sqlWarnings;
    protected transient int sqlWarningCount;
    private transient ORB orbHandle;
    private transient FSPooledConnection parentPooledConnection;
    private transient ConnectionInterface iomConnection;
    private transient Map _TYPE_MAP;
    private transient String connectionURL;
    private transient Properties connectionProp;
    private transient SafeStore safeC;
    private transient SafeStore safeU;
    private transient SafeStore safeP;
    private transient String fsServer;
    private transient String fsPort;
    private transient ISession sessionHandle;
    private transient IEnvironment environmentHandle;
    private transient ServerInformation serverInformation;
    private transient int defaultFetchSize;
    private transient int jdbcSideResultSetHoldability;
    private transient int serverSideResultSetHoldability;
    private transient int concurrencyLevel;
    protected transient int nullBehavior;
    private transient Hashtable<Integer, ServerDataTypeInfo> SERVER_DATA_TYPE_INFORMATION_MAP;
    private transient FSDatabaseMetaData dbMetaData;
    private transient FSEnums.BdRoundingMode bdRoundingMode;
    private transient FSEnums.BdTransportMode bdTransportMode;
    private transient FSEnums.BdWriteTrunc bdWriteTrunc;
    protected transient BitSet controlBits;
    protected transient SQLFeatureNotSupportedException nsEx;
    protected transient int myServerVersion;
    protected transient int serverTimeout;
    protected transient int cursorType;
    protected transient int cursorTypeStatus;
    protected transient int packType;
    protected transient Map<Integer, String> attrMap;
    static String GENPW_DOMAIN;
    protected static transient int GENPW_DOMAIN_L;
    protected static transient long debugID;
    protected transient long rtt;
    boolean sspiEnabled;
    String sspiSecurityList;

    private void logWarnings() {
        block4: {
            String method = "logWarnings";
            String logMessage = "Warnings: ";
            try {
                for (SQLWarning warning = this.sqlWarnings; warning != null; warning = warning.getNextWarning()) {
                    logger.warn(warning.toString());
                    logMessage = logMessage + warning;
                }
                if (logger != null) {
                    logger.warn("logWarnings", logMessage);
                }
            }
            catch (Exception ex) {
                if (!AbstractLogger.isTrace) break block4;
                logger.trace("logWarnings Exception");
                logger.trace(ex);
            }
        }
    }

    public FSConnection(String url, Properties properties, FSPooledConnection pooledConnection) throws SQLException {
        this(url, properties);
        String method = "FSConnection(url, properties, pooledConnection)";
        if (AbstractLogger.isTrace) {
            logger.entry("FSConnection(url, properties, pooledConnection)");
        }
        this.parentPooledConnection = pooledConnection;
    }

    public FSConnection(String url, Properties properties) throws SQLException {
        SealedString ss;
        String method = "FSConnection (url, properties)";
        this.cursorType = -1;
        this.attrMap = new HashMap<Integer, String>();
        this.bdRoundingMode = FSEnums.BdRoundingMode.HALF_EVEN;
        this.bdTransportMode = FSEnums.BdTransportMode.TARGET;
        this.bdWriteTrunc = FSEnums.BdWriteTrunc.WARNING;
        this.controlBits = new BitSet(15);
        this.myServerVersion = 440;
        if (properties.containsKey("sconstr")) {
            ss = (SealedString)properties.remove("sconstr");
            this.safeC = new SafeStore(ss);
        } else {
            this.safeC = new SafeStore("");
        }
        if (properties.containsKey("spassword")) {
            ss = (SealedString)properties.remove("spassword");
            this.safeP = new SafeStore(ss);
        } else {
            this.safeP = new SafeStore("");
        }
        if (properties.containsKey("suser")) {
            ss = (SealedString)properties.remove("suser");
            this.safeU = new SafeStore(ss);
        } else {
            this.safeU = new SafeStore("");
        }
        if (properties.containsKey("OTP")) {
            properties.remove("OTP");
            this.setOTP(true);
        }
        if (AbstractLogger.isInfo) {
            String tStr = UtilityFunctions.logProperties(properties);
            logger.info("FSConnection (url, properties)", tStr);
        }
        this.setIsClosed(false);
        this.setThrowException(true);
        this.setRealDescribeParameter(false);
        this.setParameterSetBehavior(false);
        this.setParameterSetSizeSupported(false);
        this.setCatalogAll(true);
        this.initialize(url, properties);
        if (trackConnections) {
            long tID = this.getMyID();
            String tStr = "CONN_ID:" + tID + ":URL:" + this.connectionURL;
            if (debugID == tID) {
                logger.trace("Match on Connection");
            }
            myResources.track(this, tStr);
        }
    }

    protected void setParentPooledConnection(FSPooledConnection pc) {
        this.parentPooledConnection = pc;
    }

    protected void connect(Properties properties) throws SQLException {
        String propValue;
        String method = "connect(properties)";
        boolean exceptionFeatureNotSupported = true;
        if (AbstractLogger.isTrace) {
            logger.entry("connect(properties)");
        }
        if ((propValue = System.getProperty("dfsJDBCExceptionFeatureNotSupported")) != null && propValue.equalsIgnoreCase("true")) {
            exceptionFeatureNotSupported = true;
            if (AbstractLogger.isTrace) {
                logger.trace("connect(properties)", "dfsJDBCExceptionFeatureNotSupported=true");
            }
        } else if (propValue != null && propValue.equalsIgnoreCase("false")) {
            exceptionFeatureNotSupported = false;
            if (AbstractLogger.isTrace) {
                logger.trace("connect(properties)", "dfsJDBCExceptionFeatureNotSupported=false");
            }
        } else if (propValue != null) {
            if (AbstractLogger.isTrace) {
                logger.trace("connect(properties)", "dfsJDBCExceptionFeatureNotSupported incorrect value '" + propValue + "' ");
            }
        } else if (AbstractLogger.isTrace) {
            logger.trace("connect(properties)", "dfsJDBCExceptionFeatureNotSupported defaults to 'true'");
        }
        this.setThrowException(exceptionFeatureNotSupported);
        this.setDefaultFetchSize(this.getDefaultFetchSize(properties));
        this.setCursorTypeAttribute(this.getCursorTypeProperty(properties));
        int tNullBehavior = this.getNullBehavior(properties);
        this.setNullBehavior(tNullBehavior);
        this.initCatalogScope(properties);
        this.setIsAutoCommit(this.getAutoCommit());
        if (!this.isAutoCommit()) {
            this.setAutoCommit(true);
        }
        this.invokeDriverConnect(properties);
    }

    protected int getAttribute(ConnectionWrapper iomWrapper, int attrNum) throws SQLException {
        int outValue = AbstractIOMWrapper.getIntegerAttribute(iomWrapper, attrNum);
        String attrStr = TypesHelper.getGetConnAttrAsStr(attrNum, outValue);
        if (AbstractLogger.isTrace) {
            logger.trace(attrStr);
        }
        return outValue;
    }

    protected int setAttribute(ConnectionWrapper iomWrapper, int attrNum, int attrVal) throws SQLException {
        int outStatus = AbstractIOMWrapper.setIntegerAttribute(iomWrapper, attrNum, attrVal, true);
        String attrStr = TypesHelper.getGetConnAttrAsStr(attrNum, attrVal);
        attrStr = attrStr + " " + TypesHelper.getTktsStatus(outStatus);
        this.attrMap.put(attrNum, attrStr);
        if (AbstractLogger.isTrace) {
            logger.trace(attrStr);
        }
        return outStatus;
    }

    protected int setAttribute(StatementWrapper iomWrapper, int attrNum, int attrVal) throws SQLException {
        int outStatus = AbstractIOMWrapper.setIntegerAttribute(iomWrapper, attrNum, attrVal, true);
        TypesHelper th = TypesHelper.getGetStmtAttrAsStr(attrNum, attrVal);
        String attrStr = th.pair + " " + TypesHelper.getTktsStatus(outStatus);
        this.attrMap.put(attrNum, attrStr);
        if (AbstractLogger.isTrace) {
            logger.trace(attrStr);
        }
        return outStatus;
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    public IEnvironment getEnvironmentHandle() {
        return this.environmentHandle;
    }

    public ORB getORBHandle() {
        return this.orbHandle;
    }

    public void addWarning(SQLWarning warning) {
        this.createWarnings(warning);
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        this.sqlWarnings = null;
        this.sqlWarningCount = 0;
    }

    @Override
    public void close() throws SQLException {
        String method = "close()";
        if (AbstractLogger.isTrace) {
            logger.entry("close()");
        }
        if (!this.isClosed()) {
            boolean logIt = LocalizedMessageHandler.getLogStatisticsOnConnectionClose();
            if (logIt) {
                ConnectionWrapper.logOverallStatistics();
            }
            if (this.parentPooledConnection != null) {
                this.softClose();
                this.parentPooledConnection.notifyConnectionEventListeners();
            } else {
                if (trackConnections) {
                    myResources.untrack(this);
                }
                this.hardClose();
                this.releaseOutgoingResources();
            }
        }
        if (AbstractLogger.isInfo) {
            String ei = "FSConnection.close.txt";
            this.logInfoMessage("close()", "FSConnection.close.txt", logger, new java.lang.Object[0]);
        }
    }

    protected void releaseOutgoingResources() {
        if (this.connectionProp != null) {
            this.connectionProp.clear();
            this.connectionProp = null;
        }
        this._TYPE_MAP = null;
        this.serverInformation = null;
        this.sqlWarnings = null;
        this.sqlWarningCount = 0;
        this.orbHandle = null;
        this.parentPooledConnection = null;
        this.sessionHandle = null;
        this.iomConnection = null;
        if (this.SERVER_DATA_TYPE_INFORMATION_MAP != null) {
            this.SERVER_DATA_TYPE_INFORMATION_MAP.clear();
            this.SERVER_DATA_TYPE_INFORMATION_MAP = null;
        }
        this.connectionURL = null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        int value;
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return (value = AbstractIOMWrapper.getIntegerAttribute(this.connectionWrapper, 102)) == 1;
    }

    @Override
    public void setAutoCommit(boolean newAutoCommit) throws SQLException {
        String ei;
        String method = "setAutoCommit(boolean)";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.setAutoCommit.fmt";
            this.logInfoMessage("setAutoCommit(boolean)", "FSConnection.setAutoCommit.fmt", logger, String.valueOf(newAutoCommit));
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        if (this.isAutoCommit() != newAutoCommit) {
            this.forcedCommit("setAutoCommit(boolean)");
            int nAC = newAutoCommit ? 1 : 0;
            this.setAttribute(this.connectionWrapper, 102, nAC);
            this.setIsAutoCommit(newAutoCommit);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return AbstractIOMWrapper.getStringAttribute(this.connectionWrapper, 109);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String ei;
        String method = "setCatalog";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.setCatalog.fmt";
            this.logInfoMessage(method, "FSConnection.setCatalog.fmt", logger, catalog);
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        AbstractIOMWrapper.setStringAttribute(this.connectionWrapper, 109, catalog, "TKTS_ATTR_CURRENT_CATALOG");
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.jdbcSideResultSetHoldability;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        String ei;
        String method = "setHoldability(holdability)";
        if (AbstractLogger.isTrace) {
            logger.entry("setHoldability(holdability)", holdability);
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        if (holdability != 1 && holdability != 2) {
            ei = "General.HoldabilityError.fmt";
            String[] args = new String[]{"" + holdability};
            this.throwException("General.HoldabilityError.fmt", args, logger);
        } else if (this.serverSideResultSetHoldability == 2 && holdability != 2) {
            ei = "General.HoldabilityChangeNotAllowedError.txt";
            this.throwException("General.HoldabilityChangeNotAllowedError.txt", logger);
        } else {
            this.jdbcSideResultSetHoldability = holdability;
        }
        if (AbstractLogger.isTrace) {
            logger.exit("setHoldability(holdability)", "JDBC=[" + this.jdbcSideResultSetHoldability + "] Server=[" + this.serverSideResultSetHoldability + "]");
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        String ei;
        String method = "getMetaData";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.getMetaData.txt";
            this.logInfoMessage("getMetaData", "FSConnection.getMetaData.txt", logger, new java.lang.Object[0]);
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        if (this.dbMetaData == null) {
            ei = "TKTSConnection.NoMetaData.txt";
            this.throwException("TKTSConnection.NoMetaData.txt", logger);
        }
        return this.dbMetaData;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return AbstractIOMWrapper.getIntegerAttribute(this.connectionWrapper, 108);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String ei;
        String method = "setTransactionIsolation(level)";
        if (AbstractLogger.isTrace) {
            logger.entry("setTransactionIsolation(level)", "Level=[" + level + "]");
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.setAttribute(this.connectionWrapper, 108, level);
                break;
            }
            default: {
                ei = "TKTSConnection.invalidIsolationLevel.txt";
                this.throwException("TKTSConnection.invalidIsolationLevel.txt", logger);
            }
        }
    }

    public Map getTypeMap() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        if (this._TYPE_MAP == null) {
            this._TYPE_MAP = new HashMap();
        }
        return this._TYPE_MAP;
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        this._TYPE_MAP = map;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.sqlWarnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean outVal = this.controlBits.get(1);
        return outVal;
    }

    private void setIsClosed(boolean newValue) {
        this.controlBits.set(1, newValue);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        String method = "isReadOnly()";
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        int value = AbstractIOMWrapper.getIntegerAttribute(this.connectionWrapper, 101);
        if (AbstractLogger.isTrace) {
            logger.exit("isReadOnly()", value);
        }
        return value == 1;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        String method = "setReadOnly(readOnly)";
        if (AbstractLogger.isTrace) {
            logger.entry("setReadOnly(readOnly)", readOnly);
        }
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        int ro = readOnly ? 1 : 0;
        this.setAttribute(this.connectionWrapper, 101, ro);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        String method = "setSavepoint()";
        this.genFeatureNotSupportedException("setSavepoint()");
        throw this.nsEx;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        String method = "setSavepoint (" + name + ")";
        this.genFeatureNotSupportedException(method);
        throw this.nsEx;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String method = "releaseSavepoint(savepoint)";
        this.genFeatureNotSupportedException("releaseSavepoint(savepoint)");
        throw this.nsEx;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return sql;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.createStatement(1003, 1007);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String ei;
        String method = "createStatement(resultSetType,resultSetConcurrency,resultSetHoldability)";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.createStatement.fmt";
            this.logInfoMessage("createStatement(resultSetType,resultSetConcurrency,resultSetHoldability)", "FSConnection.createStatement.fmt", logger, TypesHelper.getResultSetTypeU(resultSetType), TypesHelper.getResultSetConcurrencyU(resultSetConcurrency), TypesHelper.getResultSetHoldabilityU(resultSetHoldability));
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        this.setHoldability(resultSetHoldability);
        Statement statement = this.createStatement(resultSetType, resultSetConcurrency);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String ei;
        String method = "createStatement(resultSetType,resultSetConcurrency)";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.createStatementOne.fmt";
            this.logInfoMessage("createStatement(resultSetType,resultSetConcurrency)", "FSConnection.createStatementOne.fmt", logger, TypesHelper.getResultSetTypeU(resultSetType), TypesHelper.getResultSetConcurrencyU(resultSetConcurrency));
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        resultSetType = this.validateResultSetType(this.dbMetaData, resultSetType);
        resultSetConcurrency = this.validateResultSetConcurrency(this.dbMetaData, resultSetType, resultSetConcurrency);
        FSStatement statement = this.statementPoolManager.getStatement(resultSetType, resultSetConcurrency);
        if (AbstractLogger.isTrace) {
            logger.exit("createStatement(resultSetType,resultSetConcurrency)", "RSType=[" + TypesHelper.getResultSetTypeU(resultSetType) + "] Concur=[" + TypesHelper.getResultSetConcurrencyU(resultSetConcurrency) + "]");
        }
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sqlStmt) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.prepareCall(sqlStmt, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sqlStmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        CallableStatement outCS = null;
        int oldHoldability = this.jdbcSideResultSetHoldability;
        this.setHoldability(resultSetHoldability);
        outCS = this.prepareCall(sqlStmt, resultSetType, resultSetConcurrency);
        this.setHoldability(oldHoldability);
        return outCS;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String ei;
        String method = "prepareCall(sql,resultSetType,resultSetConcurrency)";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.prepareCall.fmt";
            this.logInfoMessage("prepareCall(sql,resultSetType,resultSetConcurrency)", "FSConnection.prepareCall.fmt", logger, sql, TypesHelper.getResultSetTypeU(resultSetType), TypesHelper.getResultSetConcurrencyU(resultSetConcurrency));
        }
        if (this.isClosed()) {
            ei = "TKTSConnection.callableStmtError.txt";
            this.throwException("TKTSConnection.callableStmtError.txt", logger);
        }
        resultSetType = this.validateResultSetType(this.dbMetaData, resultSetType);
        resultSetConcurrency = this.validateResultSetConcurrency(this.dbMetaData, resultSetType, resultSetConcurrency);
        FSCallableStatement statement = this.statementPoolManager.getCallableStatement(sql, resultSetType, resultSetConcurrency);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sqlStatement) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.prepareStatement(sqlStatement, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String ei;
        String method = "prepareStatement(sql,resultSetType,resultSetConcurrency,resultSetHoldability)";
        int oldHoldability = resultSetHoldability;
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.prepareStatement.fmt";
            this.logInfoMessage("prepareStatement(sql,resultSetType,resultSetConcurrency,resultSetHoldability)", "FSConnection.prepareStatement.fmt", logger, sql, TypesHelper.getResultSetTypeU(resultSetType), TypesHelper.getResultSetConcurrencyU(resultSetConcurrency), TypesHelper.getResultSetHoldabilityU(resultSetHoldability));
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        this.setHoldability(resultSetHoldability);
        PreparedStatement prepStmt = this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.setHoldability(oldHoldability);
        return prepStmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String method = "prepareStatement(sql,autoGeneratedKeys)";
        this.genFeatureNotSupportedException("prepareStatement(sql,autoGeneratedKeys)");
        throw this.nsEx;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String method = "prepareStatement(sql, columnIndexes[])";
        this.genFeatureNotSupportedException("prepareStatement(sql, columnIndexes[])");
        throw this.nsEx;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String method = "prepareStatement(sql, columnNames[])";
        this.genFeatureNotSupportedException("prepareStatement(sql, columnNames[])");
        throw this.nsEx;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String ei;
        long entryTime = System.nanoTime();
        String method = "prepareStatement(sql,resultSetType,resultSetConcurrency)";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.prepareStatementOne.fmt";
            this.logInfoMessage("prepareStatement(sql,resultSetType,resultSetConcurrency)", "FSConnection.prepareStatementOne.fmt", logger, sql, TypesHelper.getResultSetTypeU(resultSetType), TypesHelper.getResultSetConcurrencyU(resultSetConcurrency));
        }
        if (this.isClosed()) {
            ei = "TKTSConnection.prepStmtError.txt";
            this.throwException("TKTSConnection.prepStmtError.txt", logger);
        }
        resultSetType = this.validateResultSetType(this.dbMetaData, resultSetType);
        resultSetConcurrency = this.validateResultSetConcurrency(this.dbMetaData, resultSetType, resultSetConcurrency);
        FSPreparedStatement statement = this.statementPoolManager.getPreparedStatement(sql, resultSetType, resultSetConcurrency);
        if (AbstractLogger.isMeasurements) {
            LocalizedMessageHandler.logStatisticMessage("FSConnection.prepareStatement.txt", System.nanoTime() - entryTime, logger);
        }
        return statement;
    }

    @Override
    public void commit() throws SQLException {
        String ei;
        String method = "commit()";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.commit.txt";
            this.logInfoMessage("commit()", "FSConnection.commit.txt", logger, new java.lang.Object[0]);
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        if (!this.isAutoCommit()) {
            this.forcedCommit("commit()");
            this.handleResultSetHoldabilityAfterCommitRollback();
        } else {
            ei = "TKTSConnection.autoCommitError.txt";
            this.throwException("TKTSConnection.autoCommitError.txt", logger);
        }
    }

    @Override
    public void rollback() throws SQLException {
        String ei;
        String method = "rollback()";
        if (AbstractLogger.isInfo) {
            ei = "FSConnection.rollback.txt";
            this.logInfoMessage("rollback()", "FSConnection.rollback.txt", logger, new java.lang.Object[0]);
        }
        if (this.isClosed()) {
            ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        if (!this.isAutoCommit()) {
            this.forcedRollback("rollback()");
            this.handleResultSetHoldabilityAfterCommitRollback();
        } else {
            ei = "TKTSConnection.autoCommitError.txt";
            this.throwException("TKTSConnection.autoCommitError.txt", logger);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        String method = "rollback(savepoint)";
        this.genFeatureNotSupportedException("rollback(savepoint)");
        throw this.nsEx;
    }

    protected ServerInformation getServerInformation() {
        return this.serverInformation;
    }

    public int getServerVersion() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.serverInformation.getProductVersionNumber();
    }

    protected String getConnectionURL() {
        return this.connectionURL;
    }

    protected Properties getConnectionProp() {
        Properties outProps = this.connectionProp == null ? new Properties() : (Properties)this.connectionProp.clone();
        if (this.safeC != null) {
            outProps.put("sconstr", this.safeC.getSealedString());
        }
        if (this.safeP != null) {
            outProps.put("spassword", this.safeP.getSealedString());
        }
        if (this.safeU != null) {
            outProps.put("suser", this.safeU.getSealedString());
        }
        return outProps;
    }

    protected int getLoginTimeout() throws SQLException {
        int timeout = AbstractIOMWrapper.getIntegerAttribute(this.connectionWrapper, 103);
        return timeout;
    }

    protected void setLoginTimeout(int timeout) throws SQLException {
        this.setAttribute(this.connectionWrapper, 103, timeout);
    }

    protected int getPacketSize() throws SQLException {
        return AbstractIOMWrapper.getIntegerAttribute(this.connectionWrapper, 112);
    }

    protected int getConnectionTimeout() throws SQLException {
        return AbstractIOMWrapper.getIntegerAttribute(this.connectionWrapper, 113);
    }

    protected void setConnectionTimeout(int seconds) throws SQLException {
        this.setAttribute(this.connectionWrapper, 113, seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLException hardCloseCatch() {
        SQLException firstEx;
        block39: {
            firstEx = null;
            IntHolder disconnectStatus = new IntHolder();
            try {
                if (this.connectionWrapper != null) {
                    this.connectionWrapper.Disconnect(disconnectStatus);
                }
            }
            catch (Exception ex) {
                if (AbstractLogger.isTrace) {
                    logger.trace("hardCloseCatch connectionWrapper.Disconnect Exception");
                    logger.trace(ex);
                }
                if (firstEx != null) break block39;
                String m = "Connection.close";
                try {
                    firstEx = FSConnection.createFunctionException("Connection.close", ex, this.connectionWrapper, logger);
                }
                catch (SQLException se) {
                    if (AbstractLogger.isTrace) {
                        logger.trace("hardCloseCatch Second Exception ");
                        logger.trace(se);
                    }
                    firstEx = new SQLException(ex.getLocalizedMessage());
                }
            }
        }
        try {
            if (this.connectionWrapper != null) {
                this.connectionWrapper.Close();
            }
        }
        catch (Exception ex) {
            if (AbstractLogger.isTrace) {
                logger.trace("hardCloseCatch connectionWrapper.Close() Exception");
                logger.trace(ex);
            }
            if (firstEx == null) {
                firstEx = new SQLException(ex.getLocalizedMessage());
            }
        }
        finally {
            this.connectionWrapper = null;
        }
        try {
            if (this.environmentHandle != null) {
                this.environmentHandle.Close();
            }
        }
        catch (Exception ex) {
            if (AbstractLogger.isTrace) {
                logger.trace("hardCloseCatch environmentHandle.Close() Exception");
                logger.trace(ex);
            }
            if (firstEx == null) {
                firstEx = new SQLException(ex.getLocalizedMessage());
            }
        }
        finally {
            this.environmentHandle = null;
        }
        try {
            if (this.sessionHandle != null) {
                this.sessionHandle.Close();
            }
        }
        catch (Exception ex) {
            if (AbstractLogger.isTrace) {
                logger.trace("hardCloseCatch sessionHandle.Close() Exception");
                logger.trace(ex);
            }
            if (firstEx == null) {
                firstEx = new SQLException(ex.getLocalizedMessage());
            }
        }
        finally {
            this.sessionHandle = null;
        }
        try {
            if (this.iomConnection != null) {
                this.iomConnection.close();
            }
        }
        catch (Exception ex) {
            if (AbstractLogger.isTrace) {
                logger.trace("hardCloseCatch  iomConnection.close() Exception");
                logger.trace(ex);
            }
            if (firstEx == null) {
                firstEx = new SQLException(ex.getLocalizedMessage());
            }
        }
        finally {
            this.iomConnection = null;
        }
        return firstEx;
    }

    protected void hardClose() throws SQLException {
        String method = "hardClose()";
        if (AbstractLogger.isTrace) {
            logger.trace("hardClose()", "Execute hard close.");
        }
        if (this.statementPoolManager != null) {
            this.statementPoolManager.tearDownStatementPoolManager();
            this.statementPoolManager = null;
        }
        if (this.dbMetaData != null) {
            this.dbMetaData.releaseOutgoingResources();
            this.dbMetaData = null;
        }
        this.setIsClosed(true);
        SQLException firstEx = this.hardCloseCatch();
        if (firstEx != null) {
            throw firstEx;
        }
    }

    protected void softClose() throws SQLException {
        String method = "softClose()";
        if (AbstractLogger.isTrace) {
            logger.trace("softClose()", "Disconnecting connection.");
        }
        this.statementPoolManager.tearDownStatementPoolManager();
    }

    protected void deleteStatement(FSStatement stmt) {
        String method = "deleteStatement";
        if (AbstractLogger.isTrace) {
            logger.trace("deleteStatement", "Delete a statement.");
        }
        this.statementPoolManager.removeStatement(stmt);
    }

    protected String getUserName() {
        if (this.safeU == null) {
            return "";
        }
        return this.safeU.getValue();
    }

    protected void setDefaultFetchSize(int newDefaultFetchSize) {
        String method = "setDefaultFetchSize(defaultFetchSize)";
        if (AbstractLogger.isTrace) {
            logger.entry("setDefaultFetchSize(defaultFetchSize)", "Set default fetch size to: " + newDefaultFetchSize);
        }
        this.defaultFetchSize = newDefaultFetchSize;
    }

    protected void setNullBehavior(int nullBehavior) {
        String method = "setNullBehavior(nullBehavior)";
        if (AbstractLogger.isTrace) {
            logger.entry("setNullBehavior(nullBehavior)", "Set null behavior to: " + nullBehavior);
        }
        this.nullBehavior = nullBehavior;
    }

    protected int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    protected void createWarnings() {
        SQLWarning warning = LocalizedErrorHandler.createLocalizedWarnnigs(this.connectionWrapper);
        this.createWarnings(warning);
    }

    protected void createWarnings(java.lang.Object objectWrapper) {
        SQLWarning warning = LocalizedErrorHandler.createLocalizedWarnnigs(objectWrapper);
        this.createWarnings(warning);
    }

    protected void createWarnings(SQLWarning warning) {
        if (warning != null) {
            if (this.sqlWarnings == null) {
                this.sqlWarnings = warning;
            } else {
                this.sqlWarnings.setNextWarning(warning);
            }
            ++this.sqlWarningCount;
            if (AbstractLogger.isTrace) {
                logger.warn(warning.getMessage());
            }
        }
    }

    protected int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public boolean getThrowException() {
        return this.controlBits.get(3);
    }

    public void setThrowException(boolean newValue) {
        this.controlBits.set(3, newValue);
    }

    private void initialize(String url, Properties properties) throws SQLException {
        String packValueStr;
        boolean ok;
        SQLWarning sw;
        String method = "initialize(url,properties)";
        String tHost = null;
        String tPortNumber = null;
        if (properties == null) {
            String ei = "TKTSConnection.connectFailedNullProperty.txt";
            this.throwException("TKTSConnection.connectFailedNullProperty.txt", logger);
        }
        this.connectionURL = UtilityFunctions.safeToLog(url, "");
        this.connectionProp = properties;
        tHost = properties.getProperty("server");
        if (tHost == null) {
            properties.put("host", "");
        } else {
            properties.put("host", tHost);
        }
        this.fsServer = tHost;
        tPortNumber = properties.getProperty("port");
        if (tPortNumber != null) {
            properties.put("port", tPortNumber);
            this.fsPort = tPortNumber;
        }
        this.sspiEnabled = false;
        this.sspiSecurityList = null;
        String sspiValueStr = properties.getProperty("sspi");
        if (sspiValueStr != null) {
            String warningStr;
            java.lang.Object[] tParms;
            if (sspiValueStr.compareToIgnoreCase("on") == 0) {
                this.sspiEnabled = true;
            } else if (sspiValueStr.compareToIgnoreCase("off") == 0) {
                this.sspiEnabled = false;
            } else {
                tParms = new String[]{"sspi", sspiValueStr};
                warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, tParms);
                sw = new SQLWarning(warningStr, "01S00");
                this.addWarning(sw);
                if (logger != null) {
                    logger.warn("initialize(url,properties)", warningStr);
                }
            }
            if (this.sspiEnabled) {
                this.sspiSecurityList = properties.getProperty("secpackagelist");
                if (this.sspiSecurityList == null || this.sspiSecurityList.length() == 0) {
                    tParms = new String[]{"sspi", sspiValueStr};
                    warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, tParms);
                    sw = new SQLWarning(warningStr, "01S00");
                    this.addWarning(sw);
                    if (logger != null) {
                        logger.warn("initialize(url,properties)", warningStr);
                    }
                }
            }
        }
        IServer iServer = this.getIServer(properties);
        this.sessionHandle = this.getISession(iServer);
        this.environmentHandle = this.createEnvironmentHandle(this.sessionHandle);
        this.connectionWrapper = new ConnectionWrapper(this);
        this.connect(properties);
        if (AbstractLogger.isTrace) {
            logger.exit("initialize(url,properties)");
        }
        this.dbMetaData = (ok = this.createServerDataTypeInfo()) ? new FSDatabaseMetaData(this) : null;
        int holdability = AbstractIOMWrapper.getIntegerConnectionInformation(this.connectionWrapper, 23, -5, "initialize(url,properties)");
        if (holdability == 2) {
            this.serverSideResultSetHoldability = 1;
        } else if (holdability == 1 || holdability == 0) {
            this.serverSideResultSetHoldability = 2;
        }
        this.jdbcSideResultSetHoldability = this.serverSideResultSetHoldability;
        StatementPoolManagerFactory factory = StatementPoolManagerFactory.getInstance();
        this.statementPoolManager = factory.createStatementPoolManager(this, properties);
        String describeParameterValue = AbstractIOMWrapper.getStringConnectionInformation(this.connectionWrapper, 10002, -3, "initialize(url,properties)");
        if (describeParameterValue.compareToIgnoreCase("Y") == 0) {
            this.setRealDescribeParameter(true);
        } else {
            this.setRealDescribeParameter(false);
        }
        String compressValue = properties.getProperty("compress");
        boolean compRequested = false;
        boolean compFast = true;
        if (compressValue != null && compressValue.compareToIgnoreCase("none") != 0) {
            if (compressValue.compareToIgnoreCase("best") == 0) {
                compRequested = true;
                compFast = false;
            } else if (compressValue.compareToIgnoreCase("fast") == 0) {
                compRequested = true;
                compFast = true;
            } else {
                java.lang.Object[] tParms = new String[]{"compress", compressValue};
                String warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, tParms);
                sw = new SQLWarning(warningStr, "01S00");
                this.addWarning(sw);
                if (logger != null) {
                    logger.warn("initialize(url,properties)", warningStr);
                }
            }
        }
        this.setCompression(compRequested);
        this.setCompressionSpeed(compFast);
        if (compRequested) {
            int compressionType = compFast ? 1 : 2;
            this.setAttribute(this.connectionWrapper, 20025, compressionType);
        }
        String prefetchValueStr = properties.getProperty("prefetch");
        boolean prefetchValue = true;
        if (prefetchValueStr != null) {
            if (prefetchValueStr.compareToIgnoreCase("on") == 0) {
                prefetchValue = true;
            } else if (prefetchValueStr.compareToIgnoreCase("off") == 0) {
                prefetchValue = false;
            } else {
                java.lang.Object[] tParms = new String[]{"prefetch", prefetchValueStr};
                String warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, tParms);
                sw = new SQLWarning(warningStr, "01S00");
                this.addWarning(sw);
                if (logger != null) {
                    logger.warn("initialize(url,properties)", warningStr);
                }
            }
            if (prefetchValue) {
                try {
                    this.setAttribute(this.connectionWrapper, 20400, 4);
                }
                catch (SQLException se) {
                    if (AbstractLogger.isTrace) {
                        logger.trace("setAttribute(connectionWrapper, TKTS_ATTR_SERVER_PREFETCH, 4)");
                        logger.trace(se);
                    }
                    sw = this.createAndLogWarning("TKTSPrefetch.OldServer.txt", null, "01S00", logger);
                    this.addWarning(sw);
                    prefetchValue = false;
                }
            }
            this.setPrefetch(prefetchValue);
        }
        if ((packValueStr = properties.getProperty("pack")) != null) {
            if (packValueStr.compareToIgnoreCase("0") == 0) {
                this.packType = 0;
            } else if (packValueStr.compareToIgnoreCase("1") == 0) {
                int currentVersion = this.getServerVersion();
                this.packType = currentVersion < 450 ? 0 : 1;
            } else {
                java.lang.Object[] tParms = new String[]{"pack", packValueStr};
                String warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, tParms);
                sw = new SQLWarning(warningStr, "01S00");
                this.addWarning(sw);
                if (logger != null) {
                    logger.warn("initialize(url,properties)", warningStr);
                }
            }
            if (this.packType == 1 && prefetchValue) {
                String ei = "TKTSPrefetch.IgnorePackType.txt";
                String le = LocalizedErrorHandler.getString("TKTSPrefetch.IgnorePackType.txt");
                SQLWarning w = new SQLWarning(le);
                this.addWarning(w);
                this.packType = 1;
            }
            if (this.packType == 1) {
                try {
                    this.setAttribute(this.connectionWrapper, 20407, this.packType);
                }
                catch (SQLException se) {
                    if (AbstractLogger.isTrace) {
                        logger.trace("Exception: setAttribute(connectionWrapper,PACK_TYPE(20407)");
                        logger.trace(se);
                    }
                    sw = this.createAndLogWarning("TKTSPrefetch.OldServer.txt", null, "01S00", logger);
                    this.addWarning(sw);
                    this.packType = 0;
                }
            }
        }
    }

    private int validateResultSetType(FSDatabaseMetaData metaData, int type) throws SQLException {
        String ei;
        String method = "validateResultSetType(metaData,type)";
        int oldType = type;
        if (AbstractLogger.isTrace) {
            logger.entry("validateResultSetType(metaData,type)oldType= " + type);
        }
        if (metaData == null) {
            return 1003;
        }
        if (!metaData.supportsResultSetType(type)) {
            SQLWarning sqw;
            String le;
            java.lang.Object[] args;
            ei = "TKTSStatement.cursorWarning.fmt";
            if (type == 1005) {
                args = new String[]{"ResultSet.TYPE_SCROLL_INSENSITIVE"};
                le = LocalizedErrorHandler.getLocalizedError("TKTSStatement.cursorWarning.fmt", args);
                sqw = new SQLWarning(le);
                this.createWarnings(sqw);
                type = 1004;
                if (!metaData.supportsResultSetType(type)) {
                    type = 1003;
                }
            } else if (type == 1004) {
                args = new String[]{"ResultSet.TYPE_FORWARD_ONLY"};
                le = LocalizedErrorHandler.getLocalizedError("TKTSStatement.cursorWarning.fmt", args);
                sqw = new SQLWarning(le);
                this.createWarnings(sqw);
                type = 1003;
            }
            if (AbstractLogger.isTrace) {
                String oldTypeString = TypesHelper.getResultSetTypeU(oldType);
                String newTypeString = TypesHelper.getResultSetTypeU(type);
                logger.trace("validateResultSetType(metaData,type) oldType:" + oldTypeString + " newType:" + newTypeString);
            }
        }
        if (oldType != type && this.getThrowException()) {
            ei = "TKTSConnection.cursorException.fmt";
            String[] args = new String[]{"" + oldType};
            this.throwException("TKTSConnection.cursorException.fmt", args, logger);
        }
        if (AbstractLogger.isTrace) {
            logger.exit("validateResultSetType(metaData,type)", "newType= " + type);
        }
        return type;
    }

    private int validateResultSetConcurrency(FSDatabaseMetaData metaData, int type, int concurrency) throws SQLException {
        String ei;
        int oldConcurrency = concurrency;
        String method = "validateResultSetConcurrency(metaData,type,concurrency)";
        if (metaData == null) {
            return 1007;
        }
        this.concurrencyLevel = metaData.getSupportedConcurrency(type, concurrency);
        if (this.concurrencyLevel < 1 && concurrency == 1008) {
            ei = "TKTSStatement.concurWarning.fmt";
            java.lang.Object[] tArgs = new String[]{"ResultSet.CONCUR_READ_ONLY"};
            String li = LocalizedErrorHandler.getLocalizedError("TKTSStatement.concurWarning.fmt", tArgs);
            SQLWarning sqw = new SQLWarning(li);
            this.createWarnings(sqw);
            concurrency = this.validateResultSetConcurrency(metaData, type, 1007);
        }
        if (oldConcurrency != concurrency && this.getThrowException()) {
            ei = "TKTSConnection.concurException.fmt";
            String[] args = new String[]{"" + oldConcurrency};
            this.throwException("TKTSConnection.concurException.fmt", args, logger);
        }
        if (AbstractLogger.isTrace && oldConcurrency != concurrency) {
            logger.trace("validateResultSetConcurrency(metaData,type,concurrency) Type=[" + TypesHelper.getResultSetTypeU(type) + "] " + TypesHelper.getResultSetConcurrencyU(oldConcurrency) + " to " + TypesHelper.getResultSetConcurrencyU(concurrency));
        }
        return concurrency;
    }

    private IEnvironment createEnvironmentHandle(ISession iSsession) throws SQLException {
        String method = "createEnvironmentHandle(iSsession)";
        if (AbstractLogger.isTrace) {
            logger.trace("createEnvironmentHandle(iSsession)", "Creating an environment handle.");
        }
        IEnvironment iEnvironment = null;
        try {
            IntHolder status = new IntHolder();
            iEnvironment = iSsession.CreateEnvironment(status);
            if (status.value == -2130708479) {
                String ei = "TKTSConnection.environmentHandleWarning.fmt";
                java.lang.Object[] tParams = new String[]{"" + this.sessionHandle.Id()};
                SQLWarning sqw = LocalizedErrorHandler.createLocalizedWarning("TKTSConnection.environmentHandleWarning.fmt", tParams, null, null, logger);
                this.createWarnings(sqw);
            }
        }
        catch (Exception e) {
            if (AbstractLogger.isTrace) {
                logger.trace("Exception createEnvironmentHandle");
                logger.trace(e);
            }
            String ei = "TKTSConnection.environmentHandleError.fmt";
            java.lang.Object[] tParams = new String[]{e.getMessage()};
            LocalizedErrorHandler.throwLocalizedException("TKTSConnection.environmentHandleError.fmt", tParams, e, logger);
        }
        return iEnvironment;
    }

    private void forcedCommit(String exMethod) throws SQLException {
        String method = "forcedCommit()";
        if (AbstractLogger.isTrace) {
            logger.trace("forcedCommit()", "Commit is forced.");
        }
        try {
            IntHolder status = new IntHolder();
            this.connectionWrapper.EndTran(0, status);
            if (status.value == -2130708479) {
                this.createWarnings();
            }
        }
        catch (Exception e) {
            if (AbstractLogger.isTrace) {
                logger.trace("Exception forcedCommit");
                logger.trace(e);
            }
            FSConnection.throwFunctionException(exMethod, e, this.connectionWrapper, logger);
        }
    }

    private void forcedRollback(String exMethod) throws SQLException {
        try {
            IntHolder status = new IntHolder();
            this.connectionWrapper.EndTran(1, status);
            if (status.value == -2130708479) {
                this.createWarnings();
            }
        }
        catch (Exception e) {
            if (AbstractLogger.isTrace) {
                logger.trace("Exception forcedRollback");
                logger.trace(e);
            }
            FSConnection.throwFunctionException(exMethod, e, this.connectionWrapper, logger);
        }
    }

    private void handleResultSetHoldabilityAfterCommitRollback() throws SQLException {
        this.statementPoolManager.handleResultSetHoldabilityAfterCommitRollback(this.jdbcSideResultSetHoldability);
    }

    private int getDefaultFetchSize(Properties properties) {
        String method = "getDefaultFetchSize(properties)";
        int fetchSize = 0;
        String fetchProp = properties.getProperty("defaultFetchSize");
        if (fetchProp != null) {
            try {
                fetchSize = Integer.parseInt(fetchProp);
                if (fetchSize < 0) {
                    fetchSize = 0;
                }
            }
            catch (NumberFormatException n) {
                if (AbstractLogger.isTrace) {
                    logger.trace("Exception getDefaultFetchSize");
                    logger.trace(n);
                }
                if (AbstractLogger.isWarn) {
                    logger.warn("defaultFetchSize improperly specified: " + n.getMessage() + ". Defaulting to dynamic fetch size behavior.");
                    logger.warn(n);
                }
                fetchSize = 0;
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("getDefaultFetchSize(properties)", "Default Fetch Size has been set to " + fetchSize);
        }
        return fetchSize;
    }

    private int getCursorTypeProperty(Properties properties) throws SQLException {
        String cursorTypeProp = properties.getProperty("cursorType");
        int inCursorType = -1;
        String badValue = null;
        if (cursorTypeProp != null) {
            if (cursorTypeProp.length() > 0) {
                if (cursorTypeProp.equalsIgnoreCase("TKTS_CUR_USE_IF_NEEDED")) {
                    inCursorType = 0;
                } else if (cursorTypeProp.equalsIgnoreCase("TKTS_CUR_USE_TKTS")) {
                    inCursorType = 1;
                } else if (cursorTypeProp.equalsIgnoreCase("TKTS_CUR_USE_DRIVER")) {
                    inCursorType = 2;
                } else {
                    badValue = cursorTypeProp;
                }
            } else {
                badValue = "";
            }
        }
        if (badValue != null) {
            String ei = INVALID_PROP;
            String[] args = new String[]{"cursorType", badValue};
            SQLWarning sw = this.createAndLogWarning(INVALID_PROP, args, "01S00", logger);
            this.addWarning(sw);
        }
        if (inCursorType == -1) {
            inCursorType = 2;
        }
        return inCursorType;
    }

    private void setCursorTypeAttribute(int inCursorType) throws SQLException {
        if (this.cursorType != inCursorType) {
            this.cursorTypeStatus = this.setAttribute(this.connectionWrapper, 110, inCursorType);
            this.cursorType = inCursorType;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean invokeDriverConnect(Properties properties) throws SQLException {
        String method = "invokeDriverConnect(properties)";
        if (AbstractLogger.isTrace) {
            logger.trace("invokeDriverConnect(properties)", "Invoking driver connect with properties.");
        }
        if (this.safeC != null) {
            try {
                IntHolder status = new IntHolder();
                this.connectionWrapper.DriverConnect(this.safeC.getValue(), DriverCompletionOptions.DriverCompletionOptionsTKTS_DRIVER_NOPROMPT, 0, status);
                if (status.value != -2130708479) return true;
                this.createWarnings(this.connectionWrapper);
                if (!AbstractLogger.isTrace) return true;
                this.logWarnings();
                return true;
            }
            catch (Exception ex) {
                if (AbstractLogger.isTrace) {
                    logger.trace("Exception invokeDriverConnect");
                    logger.trace(ex);
                }
                SQLException outEx = null;
                outEx = FSConnection.createFunctionException("invokeDriverConnect(properties)", ex, this.connectionWrapper, logger);
                this.hardCloseCatch();
                throw outEx;
            }
        } else {
            this.hardCloseCatch();
            String ei = "TKTSConnection.noConnInfoError.txt";
            this.throwException("TKTSConnection.noConnInfoError.txt", logger);
        }
        return true;
    }

    private IServer getIServer(Properties properties) throws SQLException {
        String method = "getIServer(properties)";
        BridgeServer bridgeServer = null;
        if (AbstractLogger.isTrace) {
            logger.trace("getIServer(properties)", "Get IServer with properties.");
        }
        boolean useSSPI = false;
        IServer iserver = null;
        String portNumberStr = properties.getProperty("port");
        int portNumber = 0;
        try {
            portNumber = Integer.parseInt(portNumberStr);
        }
        catch (NumberFormatException e) {
            if (AbstractLogger.isTrace) {
                logger.trace("Exception getIServer");
                logger.trace(e);
            }
            String ei = "TKTSConnection.invalidPortError.fmt";
            String[] args = new String[]{portNumberStr};
            this.throwException("TKTSConnection.invalidPortError.fmt", args, logger);
        }
        String tHost = properties.getProperty("host");
        String tProxyList = properties.getProperty("proxylist");
        if (tProxyList == null) {
            bridgeServer = new BridgeServer("E803E04B-AAF0-4C74-86A6-F7008AA702DC", tHost, portNumber);
        } else {
            bridgeServer = new BridgeServer("e803e04b-aaf0-4c74-86a6-f7008aa702dc", tHost, portNumber);
            bridgeServer.setOption("proxylist", tProxyList);
        }
        String applName = properties.getProperty("APPLICATION_NAME");
        if (applName != null) {
            bridgeServer.setOption("applicationname", applName);
        }
        String encryptionPolicy = properties.getProperty("encryptionPolicy");
        String encryptionContent = properties.getProperty("encryptionContent");
        String encryptionAlgorithms = properties.getProperty("encryptionAlgorithms");
        if (AbstractLogger.isTrace) {
            logger.trace("getIServer(properties)", "BridgeServer:" + bridgeServer);
        }
        if (encryptionPolicy != null && encryptionPolicy.length() > 0) {
            bridgeServer.setEncryptionPolicy(encryptionPolicy);
        }
        if (encryptionContent != null && encryptionContent.length() > 0) {
            bridgeServer.setEncryptionContent(encryptionContent);
        }
        if (encryptionAlgorithms != null && encryptionAlgorithms.length() > 0) {
            bridgeServer.setEncryptionAlgorithms(encryptionAlgorithms);
        }
        if (this.sspiEnabled && this.sspiSecurityList != null && this.sspiSecurityList.length() > 0) {
            useSSPI = true;
            bridgeServer.setSecurityPackage("Negotiate");
            bridgeServer.setSecurityPackageList(this.sspiSecurityList);
        }
        try {
            ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)bridgeServer);
            ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
            ConnectionFactoryInterface cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
            if (useSSPI) {
                SecurityPackageCredential credentials = SecurityPackageCredential.getInstance();
                this.iomConnection = cxf.getConnection((Credential)credentials);
            } else {
                this.iomConnection = cxf.getConnection(this.safeU.getValue(), this.safeP.getValue());
            }
            Object corbaObject = this.iomConnection.getObject();
            iserver = IServerHelper.narrow(corbaObject);
            this.serverInformation = new ServerInformation(corbaObject);
            this.myServerVersion = this.getServerVersion();
        }
        catch (Exception cfe) {
            if (AbstractLogger.isTrace) {
                logger.trace("Exception getIServer");
                logger.trace(cfe);
            }
            if (this.iomConnection != null) {
                this.iomConnection.close();
                this.iomConnection = null;
            }
            FSConnection.throwFunctionException("getIServer(properties)", cfe, null, logger);
        }
        if (iserver != null) {
            this.orbHandle = ((ObjectImpl)iserver)._orb();
        }
        if (AbstractLogger.isTrace) {
            logger.trace("getIServer(properties)", "Connected to " + this.serverInformation.getProductName() + " Version " + this.serverInformation.getProductVersion());
            logger.trace("getIServer(properties)", "Server state is \"" + this.serverInformation.getState() + "\"");
            logger.trace("getIServer(properties)", "AuthServer URI -> [" + this.serverInformation.getAuthServerURI() + "]");
        }
        return iserver;
    }

    private ISession getISession(IServer iserver) throws SQLException {
        String method = "getISession(iserver)";
        ISession session = null;
        if (iserver != null) {
            try {
                if (AbstractLogger.isTrace) {
                    logger.trace("getISession(iserver)", "Invoking Server.createSession().");
                }
                session = iserver.CreateSession("");
            }
            catch (Exception e2) {
                if (AbstractLogger.isTrace) {
                    logger.trace("Exception getISession");
                    logger.trace(e2);
                }
                String ei = "TKTSConnection.sessionHandleError.txt";
                LocalizedErrorHandler.throwLocalizedException("TKTSConnection.sessionHandleError.txt", null, e2, logger);
            }
        }
        return session;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return false;
    }

    @Override
    public Clob createClob() throws SQLException {
        String method = "createClob()";
        this.genFeatureNotSupportedException("createClob()");
        throw this.nsEx;
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        BlobFedSrv blob = new BlobFedSrv(null);
        return blob;
    }

    @Override
    public NClob createNClob() throws SQLException {
        String method = "createNClob()";
        this.genFeatureNotSupportedException("createNClob()");
        throw this.nsEx;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        String method = "createSQLXML()";
        this.genFeatureNotSupportedException("createSQLXML()");
        throw this.nsEx;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean outValid;
        block3: {
            outValid = false;
            if (!this.isClosed()) {
                try {
                    this.serverTimeout = AbstractIOMWrapper.getIntegerAttribute(this.connectionWrapper, 102);
                    outValid = true;
                }
                catch (SQLException se) {
                    if (!AbstractLogger.isTrace) break block3;
                    logger.trace("Exception isValid");
                    logger.trace(se);
                }
            }
        }
        return outValid;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        String method = "setClientInfo(name, value)";
        SQLClientInfoException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setClientInfo(name, value)"});
        ex = new SQLClientInfoException(lMsg, DEFAULT_SQL_STATE, null, null);
        throw ex;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        String method = "setClientInfo(Properties)";
        SQLClientInfoException ex = null;
        String lMsg = null;
        lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{"setClientInfo(Properties)"});
        ex = new SQLClientInfoException(lMsg, DEFAULT_SQL_STATE, null, null);
        throw ex;
    }

    @Override
    public String getClientInfo(String name) throws SQLClientInfoException {
        DriverPropertyInfo[] DPI = UtilityFunctions.getDriverPropertyInfo();
        DriverPropertyInfo dpi = DPI[0];
        String outString = name.equalsIgnoreCase(dpi.name) ? UtilityFunctions.getDriverPropertyValue(name, this.connectionProp, DPI) : null;
        return outString;
    }

    @Override
    public Properties getClientInfo() throws SQLClientInfoException {
        Properties outProps = new Properties();
        DriverPropertyInfo[] DPI = UtilityFunctions.getDriverPropertyInfo();
        DriverPropertyInfo dpi = DPI[0];
        String value = UtilityFunctions.getDriverPropertyValue(dpi.name, this.connectionProp, DPI);
        outProps.put(dpi.name, value);
        return outProps;
    }

    @Override
    public Array createArrayOf(String typeName, java.lang.Object[] elements) throws SQLException {
        String method = "createArrayOf(typeName, elements)";
        this.genFeatureNotSupportedException("createArrayOf(typeName, elements)");
        throw this.nsEx;
    }

    @Override
    public Struct createStruct(String typeName, java.lang.Object[] attributes) throws SQLException {
        String method = "createArrayOf(typeName, attributes)";
        this.genFeatureNotSupportedException("createArrayOf(typeName, attributes)");
        throw this.nsEx;
    }

    protected boolean createServerDataTypeInfo() throws SQLException {
        SQLException outSE;
        boolean out;
        block15: {
            StatementWrapper sw;
            block14: {
                out = true;
                String method = "createServerDataTypeInfo()";
                outSE = null;
                sw = this.getCatalogWrapper();
                this.initCatalogPVA(sw);
                this.initIdentifierCase();
                try {
                    this.setAttribute(sw, 22, 100);
                    this.setAttribute(sw, 22, 1);
                    this.setParameterSetBehavior(true);
                    if (this.getServerVersion() >= 410) {
                        this.setParameterSetSizeSupported(true);
                    }
                }
                catch (Exception e) {
                    if (!AbstractLogger.isTrace) break block14;
                    logger.trace("createServerDataTypeInfo()", "Cannot update TKTS_ATTR_PARAMSET_SIZE. Will use default batch size instead.");
                    logger.trace(e);
                }
            }
            if (this.SERVER_DATA_TYPE_INFORMATION_MAP == null) {
                this.SERVER_DATA_TYPE_INFORMATION_MAP = new Hashtable();
                try {
                    IntHolder status = new IntHolder();
                    LongSeqHolder lsHolder = new LongSeqHolder();
                    sw.FreeStmtArray(Constants.freeStatementOptionsAll, lsHolder);
                    sw.CloseCursor(status);
                    sw.GetTypeInformation(0, status);
                    FSResultSet rSet = new FSResultSet(Constants.mdTypes.TYPEINFO, sw);
                    while (rSet.next()) {
                        int sdt = rSet.getInt(2);
                        Integer sdtObj = new Integer(sdt);
                        if (this.SERVER_DATA_TYPE_INFORMATION_MAP.containsKey(sdtObj)) continue;
                        ServerDataTypeInfo dataTypeInfo = new ServerDataTypeInfo();
                        dataTypeInfo.setDataTypeName(rSet.getString(1));
                        dataTypeInfo.setDataType(sdt);
                        dataTypeInfo.setPrecision(rSet.getInt(3));
                        dataTypeInfo.setLiteralPrefix(rSet.getString(4));
                        dataTypeInfo.setLiteralSuffix(rSet.getString(5));
                        dataTypeInfo.setCreateParms(rSet.getString(6));
                        dataTypeInfo.setNullable(rSet.getShort(7));
                        dataTypeInfo.setCaseSensitive(rSet.getBoolean(8));
                        dataTypeInfo.setSearchable(rSet.getShort(9));
                        dataTypeInfo.setUnsigned(rSet.getBoolean(10));
                        dataTypeInfo.setFixedPreScale(rSet.getBoolean(11));
                        dataTypeInfo.setAutoIncrement(rSet.getBoolean(12));
                        dataTypeInfo.setLocalTypeName(rSet.getString(13));
                        dataTypeInfo.setMinimumScale(rSet.getShort(14));
                        dataTypeInfo.setMaximumScale(rSet.getShort(15));
                        dataTypeInfo.setSqlDataType(rSet.getInt(16));
                        dataTypeInfo.setSqlDateTimeSub(rSet.getInt(17));
                        dataTypeInfo.setNumPrecRadix(rSet.getInt(18));
                        this.SERVER_DATA_TYPE_INFORMATION_MAP.put(sdtObj, dataTypeInfo);
                    }
                    rSet.close();
                }
                catch (SQLException se) {
                    String sqlState;
                    if (AbstractLogger.isTrace) {
                        logger.trace("Exception GetTypeInformation");
                        logger.trace(se);
                    }
                    outSE = (sqlState = se.getSQLState()).equalsIgnoreCase("08003") ? null : se;
                    out = false;
                }
                catch (Exception exception) {
                    if (AbstractLogger.isTrace) {
                        logger.trace("Exception GetTypeInformation");
                        logger.trace(exception);
                    }
                    out = false;
                }
            }
            try {
                sw.Close();
            }
            catch (Exception e) {
                if (AbstractLogger.isTrace) {
                    logger.trace("Exception sw.Close()");
                    logger.trace(e);
                }
                if (!AbstractLogger.isTrace) break block15;
                logger.trace("createServerDataTypeInfo()", "createServerDataTypeInfo Statement Wrapper Close exception" + e);
            }
        }
        if (outSE != null) {
            throw outSE;
        }
        return out;
    }

    protected Hashtable<Integer, ServerDataTypeInfo> getServerDataTypeInfo() throws SQLException {
        return this.SERVER_DATA_TYPE_INFORMATION_MAP;
    }

    private int getNullBehavior(Properties properties) {
        String method = "getNullBehavior(properties)";
        int nullBehavior = -2;
        String nullBehaviorProp = properties.getProperty("NULL_BEHAVIOR");
        if (nullBehaviorProp != null) {
            if (nullBehaviorProp.equalsIgnoreCase("ansi")) {
                nullBehavior = 0;
            } else if (nullBehaviorProp.equalsIgnoreCase("missing")) {
                nullBehavior = 1;
            } else if (nullBehaviorProp.equalsIgnoreCase("default")) {
                nullBehavior = -2;
            } else {
                if (AbstractLogger.isWarn) {
                    logger.warn("getNullBehavior(properties)", "NULL_BEHAVIOR property improperly specified. Not setting NULL_BEHAVIOR attribute.");
                }
                java.lang.Object[] tParms = new String[]{"NULL_BEHAVIOR", nullBehaviorProp};
                String ws = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, tParms);
                SQLWarning sw = new SQLWarning(ws, "01S00");
                this.addWarning(sw);
            }
        }
        if (AbstractLogger.isTrace) {
            logger.trace("getNullBehavior(properties)", "nullBehavior=" + CommonLogger.getNullBehavior(nullBehavior));
        }
        return nullBehavior;
    }

    private void initBigDecimalConversion(Properties properties) {
        SQLWarning sw;
        String warningStr;
        String keyWord = FSEnums.BdRoundingMode.getKeyName();
        String keyValue = properties.getProperty(keyWord);
        if (keyValue != null) {
            FSEnums.BdRoundingMode roundingMode = FSEnums.BdRoundingMode.getByString(keyValue);
            if (roundingMode == null) {
                warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, new java.lang.Object[]{keyWord, keyValue});
                sw = new SQLWarning(warningStr, "01S00");
                this.addWarning(sw);
                logger.warn(sw);
            } else {
                this.bdRoundingMode = roundingMode;
            }
        }
        if ((keyValue = properties.getProperty(keyWord = FSEnums.BdTransportMode.getKeyName())) != null) {
            FSEnums.BdTransportMode transportMode = FSEnums.BdTransportMode.getByString(keyValue);
            if (transportMode == null) {
                warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, new java.lang.Object[]{keyWord, keyValue});
                sw = new SQLWarning(warningStr, "01S00");
                this.addWarning(sw);
                logger.warn(sw);
            } else {
                this.bdTransportMode = transportMode;
            }
        }
        if ((keyValue = properties.getProperty(keyWord = FSEnums.BdWriteTrunc.getKeyName())) != null) {
            FSEnums.BdWriteTrunc writeTrunc = FSEnums.BdWriteTrunc.getByString(keyValue);
            if (writeTrunc == null) {
                warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, new java.lang.Object[]{keyWord, keyValue});
                sw = new SQLWarning(warningStr, "01S00");
                this.addWarning(sw);
                logger.warn(sw);
            } else {
                this.bdWriteTrunc = writeTrunc;
            }
        }
    }

    private void initCatalogScope(Properties properties) {
        boolean catalogScopeAll = true;
        String key = "SCHEMA_SCOPE";
        String catalogScopeVal = properties.getProperty(key);
        if (catalogScopeVal != null) {
            if (catalogScopeVal.equalsIgnoreCase("all")) {
                catalogScopeAll = true;
            } else if (catalogScopeVal.equalsIgnoreCase("default")) {
                catalogScopeAll = false;
            } else {
                String warningStr = LocalizedErrorHandler.getLocalizedError(INVALID_PROP, new java.lang.Object[]{key, catalogScopeVal});
                SQLWarning sw = new SQLWarning(warningStr, "01S00");
                this.addWarning(sw);
                logger.warn(sw);
            }
        }
        this.setCatalogAll(catalogScopeAll);
    }

    private void initCatalogPVA(StatementWrapper sw) {
        boolean value;
        block2: {
            String method = "initCatalogPVA";
            value = false;
            try {
                int intAttr = AbstractIOMWrapper.getIntegerAttribute(sw, 10014);
                value = intAttr != 1;
            }
            catch (SQLException ex) {
                if (!AbstractLogger.isError) break block2;
                logger.trace("initCatalogPVA", ex.getMessage());
                logger.trace(ex);
            }
        }
        this.setCatalogPVA(value);
    }

    private void initIdentifierCase() {
        boolean value;
        block7: {
            long attrVal;
            Any result;
            block6: {
                value = false;
                String method = "initIdentifierCase";
                try {
                    result = AbstractIOMWrapper.getServerConnectionInformation(this.connectionWrapper, 20017, -5, "initIdentifierCase");
                    attrVal = result.extract_long();
                    if (attrVal == 3L) {
                        value = true;
                    }
                }
                catch (SQLException ex) {
                    if (!AbstractLogger.isTrace) break block6;
                    logger.trace("Exception getServerConnectionInformation(TKTS_CATALOG_IDENTIFIER_CASE)");
                    logger.trace(ex);
                }
            }
            this.setCatalogCaseSensitive(value);
            value = false;
            try {
                result = AbstractIOMWrapper.getServerConnectionInformation(this.connectionWrapper, 20018, -5, "initIdentifierCase");
                attrVal = result.extract_long();
                if (attrVal == 3L) {
                    value = true;
                }
            }
            catch (SQLException ex) {
                if (!AbstractLogger.isTrace) break block7;
                logger.trace("Exception  getServerConnectionInformation(TKTS_SCHEMA_IDENTIFIER_CASE)");
                logger.trace(ex);
            }
        }
        this.setSchemaCaseSensitive(value);
    }

    protected int getNullBehavior() {
        return this.nullBehavior;
    }

    protected boolean isMissingMode() {
        return this.getNullBehavior() == 1;
    }

    public boolean isANSINullMode() {
        return this.getNullBehavior() == 0;
    }

    public boolean isDefaultNullMode() {
        return this.getNullBehavior() == -2;
    }

    private boolean isAutoCommit() {
        return this.controlBits.get(2);
    }

    private void setIsAutoCommit(boolean newValue) {
        this.controlBits.set(2, newValue);
    }

    protected boolean getRealDescribeParameter() {
        return this.controlBits.get(4);
    }

    protected void setRealDescribeParameter(boolean newValue) {
        this.controlBits.set(4, newValue);
    }

    protected boolean getParameterSetBehavior() {
        return this.controlBits.get(5);
    }

    protected void setParameterSetBehavior(boolean newValue) {
        this.controlBits.set(5, newValue);
    }

    protected boolean getParameterSetSizeSupported() {
        return this.controlBits.get(6);
    }

    protected void setParameterSetSizeSupported(boolean newValue) {
        this.controlBits.set(6, newValue);
    }

    protected void setExecute2Supported(boolean newValue) {
        this.controlBits.set(7, newValue);
    }

    protected boolean getCatalogAll() {
        return this.controlBits.get(8);
    }

    protected void setCatalogAll(boolean newValue) {
        this.controlBits.set(8, newValue);
    }

    protected boolean getCatalogCaseSensitive() {
        return this.controlBits.get(10);
    }

    protected void setCatalogCaseSensitive(boolean newValue) {
        this.controlBits.set(10, newValue);
    }

    protected boolean getCatalogPVA() {
        return this.controlBits.get(9);
    }

    protected void setCatalogPVA(boolean newValue) {
        this.controlBits.set(9, newValue);
    }

    protected boolean getSchemaCaseSensitive() {
        return this.controlBits.get(11);
    }

    protected void setSchemaCaseSensitive(boolean newValue) {
        this.controlBits.set(11, newValue);
    }

    protected boolean getCompression() {
        return this.controlBits.get(12);
    }

    protected void setCompression(boolean newValue) {
        this.controlBits.set(12, newValue);
    }

    protected boolean getCompressionSpeed() {
        return this.controlBits.get(13);
    }

    protected void setCompressionSpeed(boolean newValue) {
        this.controlBits.set(13, newValue);
    }

    protected boolean getOTP() {
        return this.controlBits.get(14);
    }

    protected void setOTP(boolean newValue) {
        this.controlBits.set(14, newValue);
    }

    public boolean getPrefetch() {
        return this.controlBits.get(15);
    }

    protected void setPrefetch(boolean newValue) {
        this.controlBits.set(15, newValue);
    }

    protected StatementWrapper getCatalogWrapper() throws SQLException {
        StatementWrapper outSW;
        block9: {
            String method;
            block8: {
                block7: {
                    method = "getCatalogWrapper()";
                    outSW = new StatementWrapper(this.connectionWrapper);
                    try {
                        LongSeqHolder lsHolder = new LongSeqHolder();
                        outSW.FreeStmtArray(Constants.freeStatementOptionsAll, lsHolder);
                    }
                    catch (Exception e) {
                        if (!AbstractLogger.isTrace) break block7;
                        logger.trace(method, "Exception getCatalogWrapper.FreeStmtArray " + e);
                        logger.trace(e);
                    }
                }
                try {
                    IntHolder status = new IntHolder();
                    outSW.CloseCursor(status);
                }
                catch (Exception e) {
                    if (!AbstractLogger.isTrace) break block8;
                    logger.trace(method, "Exception getCatalogWrapper.CloseCursor " + e);
                    logger.trace(e);
                }
            }
            try {
                long startTime = System.nanoTime();
                int status = this.setAttribute(outSW, 27, 100);
                this.rtt = (System.nanoTime() - startTime) / 1000L;
                if (AbstractLogger.isTrace && status != 0) {
                    logger.trace(method, "setting TKTS_ATTR_ROW_ARRAY_SIZE failed status: " + status);
                }
            }
            catch (Exception e) {
                if (!AbstractLogger.isTrace) break block9;
                logger.trace(method, "Exception setting TKTS_ATTR_ROW_ARRAY_SIZE " + e);
                logger.trace(e);
            }
        }
        return outSW;
    }

    protected String getServerDataTypeName(int inSqlType) {
        String out = null;
        ServerDataTypeInfo typeInfo = null;
        if (this.SERVER_DATA_TYPE_INFORMATION_MAP != null) {
            typeInfo = this.SERVER_DATA_TYPE_INFORMATION_MAP.get(new Integer(inSqlType));
        }
        if (typeInfo != null) {
            out = typeInfo.getDataTypeName();
        }
        return out;
    }

    public void logStatistics(boolean reset) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        if (AbstractLogger.isMeasurements) {
            ConnectionWrapper.logOverallStatistics();
            if (reset) {
                LocalizedMessageHandler.resetStatistics();
            }
        }
    }

    public void setLogStatisticsOnConnectionClose(boolean inValue) throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        LocalizedMessageHandler.setLogStatisticsOnConnectionClose(inValue);
    }

    public boolean getLogStatisticsOnConnectionClose() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return LocalizedMessageHandler.getLogStatisticsOnConnectionClose();
    }

    public long getPackedBytes() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return LocalizedMessageHandler.getPackedBytes(logger);
    }

    public long getUnpackedBytes() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return LocalizedMessageHandler.getUnpackedBytes(logger);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        String method = "setSchema(schema)";
        this.genFeatureNotSupportedException("setSchema(schema)");
        throw this.nsEx;
    }

    @Override
    public String getSchema() throws SQLException {
        String method = "getSchema";
        this.genFeatureNotSupportedException("getSchema");
        throw this.nsEx;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        String method = "abort(executor)";
        this.genFeatureNotSupportedException("abort(executor)");
        throw this.nsEx;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        String method = "setNetworkTimeout(executor, milliseconds)";
        this.genFeatureNotSupportedException("setNetworkTimeout(executor, milliseconds)");
        throw this.nsEx;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        String method = "getNetworkTimeout";
        this.genFeatureNotSupportedException("getNetworkTimeout");
        throw this.nsEx;
    }

    protected void genFeatureNotSupportedException(String methodName) {
        this.nsEx = null;
        String lMsg = LocalizedErrorHandler.getLocalizedError("General.methodNotImplemented.fmt", new String[]{methodName});
        this.nsEx = new SQLFeatureNotSupportedException(lMsg, DEFAULT_SQL_STATE);
    }

    public FSEnums.BdRoundingMode getBdRoundingMode() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.bdRoundingMode;
    }

    public FSEnums.BdTransportMode getBdTransportMode() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.bdTransportMode;
    }

    public FSEnums.BdWriteTrunc getBdWriteTrunc() throws SQLException {
        if (this.isClosed()) {
            String ei = GEN_NOT_CONNECTED;
            this.throwException(GEN_NOT_CONNECTED, logger);
        }
        return this.bdWriteTrunc;
    }

    public String toStringDetails() {
        String outStr;
        block19: {
            outStr = "Class: + " + thisClassName + " ID:" + this.myID;
            outStr = outStr + "\n " + this.fsServer + ":" + this.fsPort;
            outStr = outStr + "\n ControlBits: ";
            boolean tBool = this.controlBits.get(1);
            if (tBool) {
                outStr = outStr + "\n   Closed ";
            }
            if (this.isAutoCommit()) {
                outStr = outStr + "\n   AutoCommit ";
            }
            if (this.getThrowException()) {
                outStr = outStr + "\n   ThrowException ";
            }
            if (this.getRealDescribeParameter()) {
                outStr = outStr + "\n   RealDescribeParameter ";
            }
            if (this.getParameterSetBehavior()) {
                outStr = outStr + "\n   ParameterSetBehavior ";
            }
            if (this.getParameterSetSizeSupported()) {
                outStr = outStr + "\n   ParameterSetSize: ";
            }
            if (this.getCatalogAll()) {
                outStr = outStr + "\n   CatalogAll ";
            }
            if (this.getCatalogCaseSensitive()) {
                outStr = outStr + "\n   CatalogCaseSensitive ";
            }
            if (this.getSchemaCaseSensitive()) {
                outStr = outStr + "\n   SchemaCaseSensitive ";
            }
            if (this.getCatalogPVA()) {
                outStr = outStr + "\n   PatternValueArguments  ";
            }
            if (!this.getCatalogPVA()) {
                outStr = outStr + "\n   IdentifierArguments  ";
            }
            outStr = outStr + "\n connectionURL: " + this.connectionURL;
            outStr = outStr + "\n connectionProp: " + this.connectionProp;
            Enumeration<java.lang.Object> b = this.connectionProp.keys();
            while (b.hasMoreElements()) {
                String key = (String)b.nextElement();
                String value = (String)this.connectionProp.get(key);
                outStr = outStr + "\n   " + key + "=" + value;
            }
            outStr = outStr + "\n defaultFetchSize: " + this.defaultFetchSize;
            if (this.getCompression()) {
                outStr = this.getCompressionSpeed() ? outStr + "\n Compress:Speed " : outStr + "\n Compress:Best ";
            }
            outStr = this.SERVER_DATA_TYPE_INFORMATION_MAP == null ? outStr + "\n Server Data Type Information:null " : outStr + "\n Server Data Type Information:" + this.SERVER_DATA_TYPE_INFORMATION_MAP.size();
            outStr = outStr + "\n BigDecimal: ";
            if (this.bdRoundingMode != null) {
                outStr = outStr + (java.lang.Object)((java.lang.Object)this.bdRoundingMode) + " ";
            }
            if (this.bdTransportMode != null) {
                outStr = outStr + (java.lang.Object)((java.lang.Object)this.bdTransportMode) + " ";
            }
            if (this.bdWriteTrunc != null) {
                outStr = outStr + (java.lang.Object)((java.lang.Object)this.bdWriteTrunc) + " ";
            }
            if (this.serverTimeout != 0) {
                outStr = outStr + " timeout: " + this.serverTimeout;
            }
            outStr = outStr + "\n Connection Attributes";
            outStr = outStr + TypesHelper.getGetConnAttrAsStr(110, this.cursorType);
            try {
                String tStr = UtilityFunctions.sqlWarnings(this.getWarnings());
                outStr = outStr + tStr;
            }
            catch (SQLException sql) {
                if (!AbstractLogger.isTrace) break block19;
                logger.trace("Exception UtilityFunctions.sqlWarnings");
                logger.trace(sql);
            }
        }
        return outStr;
    }

    public String toStringBrief() {
        String outStr = "  ID:" + this.myID + " URL: " + this.connectionURL;
        return outStr;
    }

    public String propertiesToString() {
        String outStr = "";
        outStr = outStr + "\n connectionProp: ";
        Enumeration<java.lang.Object> b = this.connectionProp.keys();
        while (b.hasMoreElements()) {
            String key = (String)b.nextElement();
            String value = (String)this.connectionProp.get(key);
            outStr = outStr + "\n   " + key + "=" + value;
        }
        return outStr;
    }

    public String toString() {
        String outStr = "  ID:" + this.myID;
        outStr = this.controlBits.get(1) ? outStr + " Closed" : outStr + " Open";
        outStr = outStr + " URL: " + this.connectionURL;
        return outStr;
    }

    public static boolean isOtpUser(String uid) {
        int endIndex;
        String domain;
        if (uid == null) {
            return false;
        }
        int uidLen = uid.length();
        if (uidLen < GENPW_DOMAIN_L + 2) {
            return false;
        }
        int index = uid.lastIndexOf(64);
        if (index == -1) {
            return false;
        }
        if (uidLen - index - 1 != GENPW_DOMAIN_L) {
            return false;
        }
        return (domain = uid.substring(++index, endIndex = index + GENPW_DOMAIN_L)).compareTo(GENPW_DOMAIN) == 0;
    }

    public int hashCode() {
        long modValue = Integer.MAX_VALUE;
        long longOut = this.myID % modValue;
        int Intout = (int)longOut;
        return Intout;
    }

    public static void trackingDisplay() {
        myResources.display();
    }

    public static void trackingDisplaySummary() {
        myResources.displaySummary();
    }

    public static long trackingCount() {
        return myResources.count();
    }

    public static void trackingEnabled(boolean newValue, boolean details) {
        trackConnections = newValue;
        myResources.setLogDetails(details);
    }

    public int getNumberOfWarnings() {
        return this.sqlWarningCount;
    }

    public long getNumberStatements() {
        long outCount = 0L;
        if (this.statementPoolManager != null) {
            outCount = this.statementPoolManager.getCurrentPoolSize();
        }
        return outCount;
    }

    public long getRTT() {
        return this.rtt;
    }

    public int getPackType() {
        return this.packType;
    }

    public boolean equals() {
        return false;
    }

    public int hashcode() {
        return (int)this.myID;
    }

    static {
        String dCharSet;
        trackConnections = false;
        myResources = new TrackResource("Connection");
        GENPW_DOMAIN = "!*(generatedpassworddomain)*!";
        GENPW_DOMAIN_L = GENPW_DOMAIN.length();
        thisClassName = FSConnection.class.getName();
        logger = LoggerFactory.getLogger(thisClassName);
        if (logger != null && AbstractLogger.isTrace && (dCharSet = CharSetUtil.JAVA_DEFAULT_CHARSET) != null) {
            logger.trace("Default Charset:" + dCharSet);
        }
        debugID = -1L;
    }
}

