/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.caching;

import com.sas.tkts.FSEnums;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.util.CharSetUtil;
import java.nio.charset.Charset;

public class UnpackInfo {
    public int cSqlType;
    public int nativeCType;
    public int precision;
    public Charset cs;

    public UnpackInfo(ParameterInfo pi, boolean needCorrection) {
        FSEnums.FsSqlTypes lookupSqlType;
        int sqlType;
        this.cSqlType = sqlType = pi.getSQLType();
        int cType = pi.getCType();
        this.nativeCType = pi.getNativeCType();
        this.precision = pi.getPrecision();
        this.cs = CharSetUtil.getToServerCharset();
        if (needCorrection && cType != this.nativeCType && sqlType != 1 && sqlType != 12 && sqlType != -2 && sqlType != -3 && (sqlType < 91 || sqlType > 93) && (lookupSqlType = FSEnums.FsSqlTypes.getByCType(this.nativeCType)) != null) {
            int nSqlType = lookupSqlType.getValue();
            String name = pi.getName();
            if (name == null | name.length() == 0) {
                name = Integer.toString(pi.getOrdinal());
            }
            this.cSqlType = nSqlType;
        }
    }

    public String toString() {
        String out = String.format("SQLType=[%s] nativeCType=[%s] Precision=[%d]", CommonLogger.getSQLTypeStringAndNumber(this.cSqlType), CommonLogger.getCTypeStringAndNumber(this.nativeCType), this.precision);
        return out;
    }

    public Charset getCharset() {
        return this.cs;
    }

    public void setNativeCType(int cType) {
        this.nativeCType = cType;
    }
}

